/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import org.apache.flink.table.runtime.typeutils.TypeCheckUtils;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;

public final class FlinkTypeSystem$ {
    public static FlinkTypeSystem$ MODULE$;
    private final DecimalType DECIMAL_SYSTEM_DEFAULT;

    static {
        new FlinkTypeSystem$();
    }

    public LogicalType deriveAvgAggType(LogicalType argType) {
        LogicalType logicalType;
        LogicalType logicalType2 = argType;
        if (logicalType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)logicalType2;
            DecimalType result = this.inferAggAvgType(decimalType.getScale());
            logicalType = new DecimalType(result.getPrecision(), result.getScale());
        } else if (TypeCheckUtils.isNumeric((LogicalType)logicalType2)) {
            logicalType = logicalType2;
        } else {
            throw new RuntimeException(new StringBuilder(31).append("Unsupported argType for AVG(): ").append(argType).toString());
        }
        return logicalType;
    }

    public LogicalType deriveSumType(LogicalType argType) {
        LogicalType logicalType;
        LogicalType logicalType2 = argType;
        if (logicalType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)logicalType2;
            DecimalType result = this.inferAggSumType(decimalType.getScale());
            logicalType = new DecimalType(result.getPrecision(), result.getScale());
        } else if (TypeCheckUtils.isNumeric((LogicalType)logicalType2)) {
            logicalType = argType;
        } else {
            throw new RuntimeException(new StringBuilder(31).append("Unsupported argType for SUM(): ").append(argType).toString());
        }
        return logicalType;
    }

    public DecimalType inferIntDivType(int precision1, int scale1, int scale2) {
        int p = Math.min(38, precision1 - scale1 + scale2);
        return new DecimalType(p, 0);
    }

    public DecimalType inferAggSumType(int scale) {
        return new DecimalType(38, scale);
    }

    public DecimalType inferAggAvgType(int scale) {
        return LogicalTypeMerging.findDivisionDecimalType((int)38, (int)scale, (int)20, (int)0);
    }

    public DecimalType DECIMAL_SYSTEM_DEFAULT() {
        return this.DECIMAL_SYSTEM_DEFAULT;
    }

    private FlinkTypeSystem$() {
        MODULE$ = this;
        this.DECIMAL_SYSTEM_DEFAULT = new DecimalType(38, 18);
    }
}

