/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import java.util.Collections;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.flink.table.planner.calcite.CalciteParser;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.SqlExprToRexConverter;
import org.apache.flink.table.planner.plan.FlinkCalciteCatalogReader;

public class SqlExprToRexConverterImpl
implements SqlExprToRexConverter {
    private final FlinkPlannerImpl planner;
    private final RelDataType tableRowType;

    public SqlExprToRexConverterImpl(FrameworkConfig config, FlinkTypeFactory typeFactory, RelOptCluster cluster, RelDataType tableRowType) {
        this.planner = new FlinkPlannerImpl(config, isLenient -> SqlExprToRexConverterImpl.createEmptyCatalogReader(typeFactory), typeFactory, cluster);
        this.tableRowType = tableRowType;
    }

    @Override
    public RexNode convertToRexNode(String expr) {
        return this.convertToRexNodes(new String[]{expr})[0];
    }

    @Override
    public RexNode[] convertToRexNodes(String[] exprs) {
        CalciteParser parser = this.planner.parser();
        return (RexNode[])Stream.of(exprs).map(parser::parseExpression).map(node -> this.planner.rex((SqlNode)node, this.tableRowType)).toArray(RexNode[]::new);
    }

    private static CalciteCatalogReader createEmptyCatalogReader(FlinkTypeFactory typeFactory) {
        return new FlinkCalciteCatalogReader(CalciteSchema.createRootSchema(false), Collections.emptyList(), (RelDataTypeFactory)typeFactory, (CalciteConnectionConfig)new CalciteConnectionConfigImpl(new Properties()));
    }
}

