/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.planner.functions.aggfunctions.InternalAggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.DataTypeUtils;

@Internal
public final class CollectAggFunction<T>
extends InternalAggregateFunction<MapData, CollectAccumulator<T>> {
    private static final long serialVersionUID = -5860934997657147836L;
    private transient DataType elementDataType;

    public CollectAggFunction(LogicalType elementType) {
        this.elementDataType = DataTypeUtils.toInternalDataType((LogicalType)elementType);
    }

    @Override
    public DataType[] getInputDataTypes() {
        return new DataType[]{this.elementDataType};
    }

    @Override
    public DataType getAccumulatorDataType() {
        return DataTypes.STRUCTURED(CollectAccumulator.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"map", (DataType)MapView.newMapViewDataType((DataType)((DataType)this.elementDataType.notNull()), (DataType)DataTypes.INT()))});
    }

    @Override
    public DataType getOutputDataType() {
        return (DataType)DataTypes.MULTISET((DataType)this.elementDataType).bridgedTo(MapData.class);
    }

    public CollectAccumulator<T> createAccumulator() {
        CollectAccumulator acc = new CollectAccumulator();
        acc.map = new MapView();
        return acc;
    }

    public void resetAccumulator(CollectAccumulator<T> accumulator) {
        accumulator.map.clear();
    }

    public void accumulate(CollectAccumulator<T> accumulator, T value) throws Exception {
        if (value != null) {
            Integer count = (Integer)accumulator.map.get(value);
            if (count != null) {
                accumulator.map.put(value, (Object)(count + 1));
            } else {
                accumulator.map.put(value, (Object)1);
            }
        }
    }

    public void retract(CollectAccumulator<T> accumulator, T value) throws Exception {
        if (value != null) {
            Integer count = (Integer)accumulator.map.get(value);
            if (count != null) {
                if (count == 1) {
                    accumulator.map.remove(value);
                } else {
                    accumulator.map.put(value, (Object)(count - 1));
                }
            } else {
                accumulator.map.put(value, (Object)-1);
            }
        }
    }

    public void merge(CollectAccumulator<T> accumulator, Iterable<CollectAccumulator<T>> others) throws Exception {
        for (CollectAccumulator<T> other : others) {
            for (Map.Entry entry : other.map.entries()) {
                Object key = entry.getKey();
                Integer newCount = (Integer)entry.getValue();
                Integer oldCount = (Integer)accumulator.map.get(key);
                if (oldCount == null) {
                    accumulator.map.put(key, (Object)newCount);
                    continue;
                }
                accumulator.map.put(key, (Object)(oldCount + newCount));
            }
        }
    }

    public MapData getValue(CollectAccumulator<T> accumulator) {
        return new GenericMapData(accumulator.map.getMap());
    }

    public static class CollectAccumulator<T> {
        public MapView<T, Integer> map;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CollectAccumulator that = (CollectAccumulator)o;
            return Objects.equals(this.map, that.map);
        }
    }
}

