/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.planner.functions.aggfunctions.InternalAggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.DataTypeUtils;

@Internal
public final class MaxWithRetractAggFunction<T extends Comparable<T>>
extends InternalAggregateFunction<T, MaxWithRetractAccumulator<T>> {
    private static final long serialVersionUID = -5860934997657147836L;
    private transient DataType valueDataType;

    public MaxWithRetractAggFunction(LogicalType valueType) {
        this.valueDataType = DataTypeUtils.toInternalDataType((LogicalType)valueType);
    }

    @Override
    public DataType[] getInputDataTypes() {
        return new DataType[]{this.valueDataType};
    }

    @Override
    public DataType getAccumulatorDataType() {
        return DataTypes.STRUCTURED(MaxWithRetractAccumulator.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"max", (DataType)((DataType)this.valueDataType.nullable())), DataTypes.FIELD((String)"mapSize", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"map", (DataType)MapView.newMapViewDataType((DataType)((DataType)this.valueDataType.notNull()), (DataType)DataTypes.BIGINT()))});
    }

    @Override
    public DataType getOutputDataType() {
        return this.valueDataType;
    }

    public MaxWithRetractAccumulator<T> createAccumulator() {
        MaxWithRetractAccumulator acc = new MaxWithRetractAccumulator();
        acc.max = null;
        acc.mapSize = 0L;
        acc.map = new MapView();
        return acc;
    }

    public void accumulate(MaxWithRetractAccumulator<T> acc, T value) throws Exception {
        if (value != null) {
            Long count;
            if (acc.mapSize == 0L || ((Comparable)acc.max).compareTo(value) < 0) {
                acc.max = value;
            }
            if ((count = (Long)acc.map.get(value)) == null) {
                count = 0L;
            }
            if ((count = Long.valueOf(count + 1L)) == 0L) {
                acc.map.remove(value);
            } else {
                acc.map.put(value, (Object)count);
            }
            if (count == 1L) {
                MaxWithRetractAccumulator<T> maxWithRetractAccumulator = acc;
                maxWithRetractAccumulator.mapSize = maxWithRetractAccumulator.mapSize + 1L;
            }
        }
    }

    public void retract(MaxWithRetractAccumulator<T> acc, T value) throws Exception {
        if (value != null) {
            Long count = (Long)acc.map.get(value);
            if (count == null) {
                count = 0L;
            }
            if ((count = Long.valueOf(count - 1L)) == 0L) {
                acc.map.remove(value);
                MaxWithRetractAccumulator<T> maxWithRetractAccumulator = acc;
                maxWithRetractAccumulator.mapSize = maxWithRetractAccumulator.mapSize - 1L;
                if (acc.mapSize == 0L) {
                    acc.max = null;
                    return;
                }
                if (value.equals(acc.max)) {
                    this.updateMax(acc);
                }
            } else {
                acc.map.put(value, (Object)count);
            }
        }
    }

    private void updateMax(MaxWithRetractAccumulator<T> acc) throws Exception {
        boolean hasMax = false;
        for (Comparable key : acc.map.keys()) {
            if (hasMax && ((Comparable)acc.max).compareTo(key) >= 0) continue;
            acc.max = key;
            hasMax = true;
        }
        if (!hasMax) {
            acc.mapSize = 0L;
            acc.max = null;
        }
    }

    public void merge(MaxWithRetractAccumulator<T> acc, Iterable<MaxWithRetractAccumulator<T>> its) throws Exception {
        boolean needUpdateMax = false;
        for (MaxWithRetractAccumulator<T> a : its) {
            if (acc.mapSize == 0L || a.mapSize > 0L && a.max != null && ((Comparable)acc.max).compareTo(a.max) < 0) {
                acc.max = a.max;
            }
            for (Map.Entry entry : a.map.entries()) {
                MaxWithRetractAccumulator<T> maxWithRetractAccumulator;
                long mergedCount;
                Comparable key = (Comparable)entry.getKey();
                Long otherCount = (Long)entry.getValue();
                Long thisCount = (Long)acc.map.get((Object)key);
                if (thisCount == null) {
                    thisCount = 0L;
                }
                if ((mergedCount = otherCount + thisCount) == 0L) {
                    acc.map.remove((Object)key);
                    if (thisCount <= 0L) continue;
                    maxWithRetractAccumulator = acc;
                    Long.valueOf(maxWithRetractAccumulator.mapSize - 1L);
                    maxWithRetractAccumulator.mapSize = maxWithRetractAccumulator.mapSize;
                    if (!key.equals(acc.max)) continue;
                    needUpdateMax = true;
                    continue;
                }
                if (mergedCount < 0L) {
                    acc.map.put((Object)key, (Object)mergedCount);
                    if (thisCount <= 0L) continue;
                    maxWithRetractAccumulator = acc;
                    Long.valueOf(maxWithRetractAccumulator.mapSize - 1L);
                    maxWithRetractAccumulator.mapSize = maxWithRetractAccumulator.mapSize;
                    if (!key.equals(acc.max)) continue;
                    needUpdateMax = true;
                    continue;
                }
                acc.map.put((Object)key, (Object)mergedCount);
                if (thisCount > 0L) continue;
                maxWithRetractAccumulator = acc;
                Long.valueOf(maxWithRetractAccumulator.mapSize + 1L);
                maxWithRetractAccumulator.mapSize = maxWithRetractAccumulator.mapSize;
            }
        }
        if (needUpdateMax) {
            this.updateMax(acc);
        }
    }

    public void resetAccumulator(MaxWithRetractAccumulator<T> acc) {
        acc.max = null;
        acc.mapSize = 0L;
        acc.map.clear();
    }

    public T getValue(MaxWithRetractAccumulator<T> acc) {
        if (acc.mapSize > 0L) {
            return (T)((Comparable)acc.max);
        }
        return null;
    }

    public static class MaxWithRetractAccumulator<T> {
        public T max;
        public Long mapSize;
        public MapView<T, Long> map;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MaxWithRetractAccumulator)) {
                return false;
            }
            MaxWithRetractAccumulator that = (MaxWithRetractAccumulator)o;
            return Objects.equals(this.max, that.max) && Objects.equals(this.mapSize, that.mapSize) && Objects.equals(this.map, that.map);
        }

        public int hashCode() {
            return Objects.hash(this.max, this.mapSize, this.map);
        }
    }
}

