/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.batch;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalCalc;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalCorrelate;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableFunctionScan;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchExecPythonCorrelate;
import org.apache.flink.table.planner.plan.utils.PythonUtil;
import scala.Option;
import scala.Some;

public class BatchExecPythonCorrelateRule
extends ConverterRule {
    public static final RelOptRule INSTANCE = new BatchExecPythonCorrelateRule();

    private BatchExecPythonCorrelateRule() {
        super(FlinkLogicalCorrelate.class, FlinkConventions.LOGICAL(), FlinkConventions.BATCH_PHYSICAL(), "BatchExecPythonCorrelateRule");
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkLogicalCalc calc;
        RelNode input;
        FlinkLogicalCorrelate join = (FlinkLogicalCorrelate)call.rel(0);
        RelNode right = ((RelSubset)join.getRight()).getOriginal();
        if (right instanceof FlinkLogicalTableFunctionScan) {
            FlinkLogicalTableFunctionScan scan = (FlinkLogicalTableFunctionScan)right;
            return PythonUtil.isPythonCall(scan.getCall(), null);
        }
        if (right instanceof FlinkLogicalCalc && (input = ((RelSubset)(calc = (FlinkLogicalCalc)right).getInput()).getOriginal()) instanceof FlinkLogicalTableFunctionScan) {
            FlinkLogicalTableFunctionScan scan = (FlinkLogicalTableFunctionScan)input;
            return PythonUtil.isPythonCall(scan.getCall(), null);
        }
        return false;
    }

    @Override
    public RelNode convert(RelNode relNode) {
        BatchExecPythonCorrelateFactory factory = new BatchExecPythonCorrelateFactory(relNode);
        return factory.convertToCorrelate();
    }

    private static class BatchExecPythonCorrelateFactory {
        private final FlinkLogicalCorrelate correlate;
        private final RelTraitSet traitSet;
        private final RelNode convInput;
        private final RelNode right;

        BatchExecPythonCorrelateFactory(RelNode rel) {
            this.correlate = (FlinkLogicalCorrelate)rel;
            this.traitSet = rel.getTraitSet().replace(FlinkConventions.BATCH_PHYSICAL());
            this.convInput = RelOptRule.convert(this.correlate.getInput(0), FlinkConventions.BATCH_PHYSICAL());
            this.right = this.correlate.getInput(1);
        }

        BatchExecPythonCorrelate convertToCorrelate() {
            return this.convertToCorrelate(this.right, (Option<RexNode>)Option.empty());
        }

        private BatchExecPythonCorrelate convertToCorrelate(RelNode relNode, Option<RexNode> condition) {
            if (relNode instanceof RelSubset) {
                RelSubset rel = (RelSubset)relNode;
                return this.convertToCorrelate(rel.getRelList().get(0), condition);
            }
            if (relNode instanceof FlinkLogicalCalc) {
                FlinkLogicalCalc calc = (FlinkLogicalCalc)relNode;
                return this.convertToCorrelate(((RelSubset)calc.getInput()).getOriginal(), (Option<RexNode>)Some.apply((Object)calc.getProgram().expandLocalRef(calc.getProgram().getCondition())));
            }
            FlinkLogicalTableFunctionScan scan = (FlinkLogicalTableFunctionScan)relNode;
            return new BatchExecPythonCorrelate(this.correlate.getCluster(), this.traitSet, this.convInput, scan, condition, null, this.correlate.getRowType(), this.correlate.getJoinType());
        }
    }
}

