/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.stream;

import java.util.Collection;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalJoin;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalRel;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalSnapshot;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamExecTemporalJoin;
import org.apache.flink.table.planner.plan.rules.physical.stream.StreamExecTemporalJoinRule$;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.plan.utils.IntervalJoinUtil;
import org.apache.flink.table.planner.plan.utils.IntervalJoinUtil$;
import org.apache.flink.table.planner.plan.utils.TemporalJoinUtil$;
import org.apache.flink.util.Preconditions;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]3A!\u0001\u0002\u0001+\tQ2\u000b\u001e:fC6,\u00050Z2UK6\u0004xN]1m\u0015>LgNU;mK*\u00111\u0001B\u0001\u0007gR\u0014X-Y7\u000b\u0005\u00151\u0011\u0001\u00039isNL7-\u00197\u000b\u0005\u001dA\u0011!\u0002:vY\u0016\u001c(BA\u0005\u000b\u0003\u0011\u0001H.\u00198\u000b\u0005-a\u0011a\u00029mC:tWM\u001d\u0006\u0003\u001b9\tQ\u0001^1cY\u0016T!a\u0004\t\u0002\u000b\u0019d\u0017N\\6\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001875\t\u0001D\u0003\u0002\n3)\u0011!\u0004E\u0001\bG\u0006d7-\u001b;f\u0013\ta\u0002D\u0001\u0006SK2|\u0005\u000f\u001e*vY\u0016DQA\b\u0001\u0005\u0002}\ta\u0001P5oSRtD#\u0001\u0011\u0011\u0005\u0005\u0002Q\"\u0001\u0002\t\u000b\r\u0002A\u0011\t\u0013\u0002\u000f5\fGo\u00195fgR\u0011Qe\u000b\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\b\u0005>|G.Z1o\u0011\u0015a#\u00051\u0001.\u0003\u0011\u0019\u0017\r\u001c7\u0011\u0005]q\u0013BA\u0018\u0019\u00059\u0011V\r\\(qiJ+H.Z\"bY2DQ!\r\u0001\u0005\nI\n\u0001$\\1uG\",7\u000fV3na>\u0014\u0018\r\u001c+bE2,'j\\5o)\t)3\u0007C\u00035a\u0001\u0007Q'\u0001\u0003k_&t\u0007C\u0001\u001c<\u001b\u00059$B\u0001\u001d:\u0003\u001dawnZ5dC2T!A\u000f\u0005\u0002\u000b9|G-Z:\n\u0005q:$\u0001\u0005$mS:\\Gj\\4jG\u0006d'j\\5o\u0011\u0015q\u0004\u0001\"\u0003@\u0003\u0001j\u0017\r^2iKN$V-\u001c9pe\u0006dG+\u00192mK\u001a+hn\u0019;j_:Tu.\u001b8\u0015\u0005\u0015\u0002\u0005\"\u0002\u001b>\u0001\u0004)\u0004\"\u0002\"\u0001\t\u0003\u001a\u0015aB8o\u001b\u0006$8\r\u001b\u000b\u0003\t\u001e\u0003\"AJ#\n\u0005\u0019;#\u0001B+oSRDQ\u0001L!A\u00025:Q!\u0013\u0002\t\u0002)\u000b!d\u0015;sK\u0006lW\t_3d)\u0016l\u0007o\u001c:bY*{\u0017N\u001c*vY\u0016\u0004\"!I&\u0007\u000b\u0005\u0011\u0001\u0012\u0001'\u0014\u0005-k\u0005C\u0001\u0014O\u0013\tyuE\u0001\u0004B]f\u0014VM\u001a\u0005\u0006=-#\t!\u0015\u000b\u0002\u0015\"91k\u0013b\u0001\n\u0003!\u0016\u0001C%O'R\u000bejQ#\u0016\u0003YAaAV&!\u0002\u00131\u0012!C%O'R\u000bejQ#!\u0001")
public class StreamExecTemporalJoinRule
extends RelOptRule {
    public static RelOptRule INSTANCE() {
        return StreamExecTemporalJoinRule$.MODULE$.INSTANCE();
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkLogicalJoin join = (FlinkLogicalJoin)call.rel(0);
        if (!TemporalJoinUtil$.MODULE$.containsTemporalJoinCondition(join.getCondition())) {
            return false;
        }
        Preconditions.checkState((!TemporalJoinUtil$.MODULE$.containsInitialTemporalJoinCondition(join.getCondition()) ? 1 : 0) != 0);
        return this.matchesTemporalTableJoin(join) || this.matchesTemporalTableFunctionJoin(join);
    }

    private boolean matchesTemporalTableJoin(FlinkLogicalJoin join) {
        Seq supportedJoinTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JoinRelType[]{JoinRelType.INNER, JoinRelType.LEFT}));
        return supportedJoinTypes.contains((Object)join.getJoinType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean matchesTemporalTableFunctionJoin(FlinkLogicalJoin join) {
        Option windowBounds;
        JoinInfo joinInfo = join.analyzeCondition();
        TableConfig tableConfig = FlinkRelOptUtil$.MODULE$.getTableConfigFromContext(join);
        Tuple2<Option<IntervalJoinUtil.WindowBounds>, Option<RexNode>> tuple2 = IntervalJoinUtil$.MODULE$.extractWindowBoundsFromPredicate(joinInfo.getRemaining(join.getCluster().getRexBuilder()), join.getLeft().getRowType().getFieldCount(), join.getRowType(), join.getCluster().getRexBuilder(), tableConfig);
        if (tuple2 == null) throw new MatchError(tuple2);
        Option option = windowBounds = (Option)tuple2._1();
        Option windowBounds2 = option;
        if (!windowBounds2.isEmpty()) return false;
        JoinRelType joinRelType = join.getJoinType();
        JoinRelType joinRelType2 = JoinRelType.INNER;
        if (joinRelType != null) {
            if (!((Object)((Object)joinRelType)).equals((Object)joinRelType2)) return false;
            return true;
        }
        if (joinRelType2 == null) return true;
        return false;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode relNode;
        FlinkLogicalJoin join = (FlinkLogicalJoin)call.rel(0);
        FlinkLogicalRel left = (FlinkLogicalRel)call.rel(1);
        FlinkLogicalRel right = (FlinkLogicalRel)call.rel(2);
        FlinkLogicalRel flinkLogicalRel = right;
        if (flinkLogicalRel instanceof FlinkLogicalSnapshot) {
            FlinkLogicalSnapshot flinkLogicalSnapshot = (FlinkLogicalSnapshot)flinkLogicalRel;
            relNode = flinkLogicalSnapshot.getInput();
        } else if (flinkLogicalRel != null) {
            FlinkLogicalRel flinkLogicalRel2 = flinkLogicalRel;
            relNode = flinkLogicalRel2;
        } else {
            throw new MatchError((Object)flinkLogicalRel);
        }
        RelNode newRight = relNode;
        JoinInfo joinInfo = join.analyzeCondition();
        Tuple2 tuple2 = new Tuple2((Object)StreamExecTemporalJoinRule.toHashTraitByColumns$1(joinInfo.leftKeys, left.getTraitSet()), (Object)StreamExecTemporalJoinRule.toHashTraitByColumns$1(joinInfo.rightKeys, newRight.getTraitSet()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RelTraitSet leftRequiredTrait = (RelTraitSet)tuple2._1();
        RelTraitSet rightRequiredTrait = (RelTraitSet)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)leftRequiredTrait, (Object)rightRequiredTrait);
        Tuple2 tuple23 = tuple22;
        RelTraitSet leftRequiredTrait2 = (RelTraitSet)tuple23._1();
        RelTraitSet rightRequiredTrait2 = (RelTraitSet)tuple23._2();
        RelNode convLeft = RelOptRule.convert((RelNode)left, leftRequiredTrait2);
        RelNode convRight = RelOptRule.convert(newRight, rightRequiredTrait2);
        RelTraitSet providedTraitSet = join.getTraitSet().replace(FlinkConventions$.MODULE$.STREAM_PHYSICAL());
        StreamExecTemporalJoin temporalJoin = new StreamExecTemporalJoin(join.getCluster(), providedTraitSet, convLeft, convRight, join.getCondition(), join.getJoinType());
        call.transformTo(temporalJoin);
    }

    private static final RelTraitSet toHashTraitByColumns$1(Collection columns, RelTraitSet inputTraitSets) {
        FlinkRelDistribution distribution = columns.size() == 0 ? FlinkRelDistribution$.MODULE$.SINGLETON() : FlinkRelDistribution$.MODULE$.hash(columns, FlinkRelDistribution$.MODULE$.hash$default$2());
        return inputTraitSets.replace(FlinkConventions$.MODULE$.STREAM_PHYSICAL()).replace(distribution);
    }

    public StreamExecTemporalJoinRule() {
        super(RelOptRule.operand(FlinkLogicalJoin.class, RelOptRule.operand(FlinkLogicalRel.class, RelOptRule.any()), RelOptRule.operand(FlinkLogicalRel.class, RelOptRule.any())), "StreamExecTemporalJoinRule");
    }
}

