/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext$;
import org.apache.flink.table.planner.codegen.ExprCodeGenerator;
import org.apache.flink.table.planner.codegen.FunctionCodeGenerator$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.types.logical.LogicalType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class JoinUtil$ {
    public static JoinUtil$ MODULE$;

    static {
        new JoinUtil$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<int[], int[]> checkAndGetJoinKeys(List<IntPair> keyPairs, RelNode left, RelNode right, boolean allowEmptyKey) {
        Tuple2 tuple2;
        ArrayBuffer leftKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer rightKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        if (keyPairs.isEmpty()) {
            if (!allowEmptyKey) throw new TableException(new StringBuilder(136).append("Joins should have at least one equality condition.\n").append(new StringBuilder(17).append("\tleft: ").append(left.toString()).append("\n\tright: ").append(right.toString()).append("\n").toString()).append("please re-check the join statement and make sure there's ").append("equality condition for join.").toString());
            tuple2 = new Tuple2(leftKeys.toArray(ClassTag$.MODULE$.Int()), rightKeys.toArray(ClassTag$.MODULE$.Int()));
            return tuple2;
        } else {
            java.util.List<RelDataTypeField> leftFields = left.getRowType().getFieldList();
            java.util.List<RelDataTypeField> rightFields = right.getRowType().getFieldList();
            keyPairs.foreach((Function1 & Serializable & scala.Serializable)pair -> {
                SqlTypeName leftKeyType = ((RelDataTypeField)leftFields.get(pair.source)).getType().getSqlTypeName();
                SqlTypeName rightKeyType = ((RelDataTypeField)rightFields.get(pair.target)).getType().getSqlTypeName();
                SqlTypeName sqlTypeName = leftKeyType;
                SqlTypeName sqlTypeName2 = rightKeyType;
                if (sqlTypeName != null ? !((Object)((Object)sqlTypeName)).equals((Object)sqlTypeName2) : sqlTypeName2 != null) {
                    throw new TableException(new StringBuilder(88).append("Join: Equality join predicate on incompatible types. ").append(new StringBuilder(17).append("\tLeft: ").append(left.toString()).append("\n\tright: ").append(right.toString()).append("\n").toString()).append("please re-check the join statement.").toString());
                }
                leftKeys.$plus$eq((Object)BoxesRunTime.boxToInteger((int)pair.source));
                return rightKeys.$plus$eq((Object)BoxesRunTime.boxToInteger((int)pair.target));
            });
            tuple2 = new Tuple2(leftKeys.toArray(ClassTag$.MODULE$.Int()), rightKeys.toArray(ClassTag$.MODULE$.Int()));
        }
        return tuple2;
    }

    public boolean checkAndGetJoinKeys$default$4() {
        return false;
    }

    public JoinInfo createJoinInfo(RelNode left, RelNode right, RexNode condition, java.util.List<Boolean> filterNulls) {
        ArrayList<Integer> leftKeys = new ArrayList<Integer>();
        ArrayList<Integer> rightKeys = new ArrayList<Integer>();
        RexNode remaining = RelOptUtil.splitJoinCondition(left, right, condition, leftKeys, rightKeys, filterNulls);
        return remaining.isAlwaysTrue() ? JoinInfo.of(ImmutableIntList.copyOf(leftKeys), ImmutableIntList.copyOf(rightKeys)) : JoinInfo.of(left, right, condition);
    }

    public GeneratedJoinCondition generateConditionFunction(TableConfig config, RexBuilder rexBuilder, JoinInfo joinInfo, LogicalType leftType, LogicalType rightType) {
        String string;
        CodeGeneratorContext ctx = CodeGeneratorContext$.MODULE$.apply(config);
        ExprCodeGenerator qual$1 = new ExprCodeGenerator(ctx, false);
        LogicalType x$1 = leftType;
        String x$2 = qual$1.bindInput$default$2();
        Option<int[]> x$3 = qual$1.bindInput$default$3();
        ExprCodeGenerator qual$2 = qual$1.bindInput(x$1, x$2, x$3);
        LogicalType x$4 = rightType;
        String x$5 = qual$2.bindSecondInput$default$2();
        Option<int[]> x$6 = qual$2.bindSecondInput$default$3();
        ExprCodeGenerator exprGenerator = qual$2.bindSecondInput(x$4, x$5, x$6);
        if (joinInfo.isEqui()) {
            string = "return true;";
        } else {
            RexNode nonEquiPredicates = joinInfo.getRemaining(rexBuilder);
            GeneratedExpression condition = exprGenerator.generateExpression(nonEquiPredicates);
            string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(41).append("\n         |").append(condition.code()).append("\n         |return ").append(condition.resultTerm()).append(";\n         |").toString())).stripMargin();
        }
        String body = string;
        return FunctionCodeGenerator$.MODULE$.generateJoinCondition(ctx, "ConditionFunction", body, FunctionCodeGenerator$.MODULE$.generateJoinCondition$default$4(), FunctionCodeGenerator$.MODULE$.generateJoinCondition$default$5());
    }

    private JoinUtil$() {
        MODULE$ = this;
    }
}

