/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.tools;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.calcite.interpreter.Bindables;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelHomogeneousShuttle;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.tools.RelRunner;

public class RelRunners {
    private RelRunners() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PreparedStatement run(RelNode rel) {
        RelHomogeneousShuttle shuttle = new RelHomogeneousShuttle(){

            @Override
            public RelNode visit(TableScan scan) {
                RelOptTable table = scan.getTable();
                if (scan instanceof LogicalTableScan && Bindables.BindableTableScan.canHandle(table)) {
                    return Bindables.BindableTableScan.create(scan.getCluster(), table);
                }
                return super.visit(scan);
            }
        };
        rel = rel.accept(shuttle);
        try (Connection connection = DriverManager.getConnection("jdbc:calcite:");){
            RelRunner runner = connection.unwrap(RelRunner.class);
            PreparedStatement preparedStatement = runner.prepare(rel);
            return preparedStatement;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

