/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.abilities.sink;

import java.util.Map;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.abilities.SupportsPartitioning;
import org.apache.flink.table.planner.plan.abilities.sink.SinkAbilitySpec;
import org.apache.flink.util.Preconditions;

@JsonTypeName(value="Partitioning")
public class PartitioningSpec
implements SinkAbilitySpec {
    public static final String FIELD_NAME_PARTITION = "partition";
    @JsonProperty(value="partition")
    private final Map<String, String> partition;

    @JsonCreator
    public PartitioningSpec(@JsonProperty(value="partition") Map<String, String> partition) {
        this.partition = (Map)Preconditions.checkNotNull(partition);
    }

    @Override
    public void apply(DynamicTableSink tableSink) {
        if (!(tableSink instanceof SupportsPartitioning)) {
            throw new TableException(String.format("%s does not support SupportsPartitioning.", tableSink.getClass().getName()));
        }
        ((SupportsPartitioning)tableSink).applyStaticPartition(this.partition);
    }
}

