/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.stream;

import java.util.Collections;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalCalc;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalChangelogNormalize;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalExchange;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalWatermarkAssigner;
import org.apache.flink.util.Preconditions;

public class WatermarkAssignerChangelogNormalizeTransposeRule
extends RelRule<Config> {
    public static final RelOptRule WITH_CALC = Config.EMPTY.withDescription("WatermarkAssignerChangelogNormalizeTransposeRuleWithCalc").as(Config.class).withCalc().toRule();
    public static final RelOptRule WITHOUT_CALC = Config.EMPTY.withDescription("WatermarkAssignerChangelogNormalizeTransposeRuleWithoutCalc").as(Config.class).withoutCalc().toRule();

    public WatermarkAssignerChangelogNormalizeTransposeRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        StreamPhysicalWatermarkAssigner watermark = (StreamPhysicalWatermarkAssigner)call.rel(0);
        Object node = call.rel(1);
        if (node instanceof StreamPhysicalCalc) {
            StreamPhysicalCalc calc = (StreamPhysicalCalc)call.rel(1);
            StreamPhysicalChangelogNormalize changelogNormalize = (StreamPhysicalChangelogNormalize)call.rel(2);
            StreamPhysicalExchange exchange = (StreamPhysicalExchange)call.rel(3);
            RelNode newTree = this.buildTreeInOrder(changelogNormalize, exchange, watermark, calc, exchange.getInput());
            call.transformTo(newTree);
        } else if (node instanceof StreamPhysicalChangelogNormalize) {
            StreamPhysicalChangelogNormalize changelogNormalize = (StreamPhysicalChangelogNormalize)call.rel(1);
            StreamPhysicalExchange exchange = (StreamPhysicalExchange)call.rel(2);
            RelNode newTree = this.buildTreeInOrder(changelogNormalize, exchange, watermark, exchange.getInput());
            call.transformTo(newTree);
        } else {
            throw new IllegalStateException(this.getClass().getName() + " matches a wrong relation tree: " + RelOptUtil.toString(watermark));
        }
    }

    private RelNode buildTreeInOrder(RelNode ... nodes) {
        Preconditions.checkArgument((nodes.length >= 2 ? 1 : 0) != 0);
        RelNode root = nodes[nodes.length - 1];
        for (int i = nodes.length - 2; i >= 0; --i) {
            RelNode node = nodes[i];
            root = node.copy(node.getTraitSet(), Collections.singletonList(root));
        }
        return root;
    }

    public static interface Config
    extends RelRule.Config {
        @Override
        default public WatermarkAssignerChangelogNormalizeTransposeRule toRule() {
            return new WatermarkAssignerChangelogNormalizeTransposeRule(this);
        }

        default public Config withCalc() {
            return this.withOperandSupplier(b0 -> b0.operand(StreamPhysicalWatermarkAssigner.class).oneInput(b1 -> b1.operand(StreamPhysicalCalc.class).oneInput(b2 -> b2.operand(StreamPhysicalChangelogNormalize.class).oneInput(b3 -> b3.operand(StreamPhysicalExchange.class).anyInputs())))).as(Config.class);
        }

        default public Config withoutCalc() {
            return this.withOperandSupplier(b0 -> b0.operand(StreamPhysicalWatermarkAssigner.class).oneInput(b1 -> b1.operand(StreamPhysicalChangelogNormalize.class).oneInput(b2 -> b2.operand(StreamPhysicalExchange.class).anyInputs()))).as(Config.class);
        }
    }
}

