/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.schema;

import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.catalog.CatalogSchemaTable;
import org.apache.flink.table.planner.connectors.DynamicSourceUtils;
import org.apache.flink.table.planner.hint.FlinkHints;
import org.apache.flink.table.planner.plan.schema.FlinkPreparingTableBase;
import org.apache.flink.table.planner.utils.ShortcutUtils;

public final class CatalogSourceTable
extends FlinkPreparingTableBase {
    private final CatalogSchemaTable schemaTable;
    private final ResolvedCatalogTable catalogTable;

    public CatalogSourceTable(RelOptSchema relOptSchema, List<String> names, RelDataType rowType, CatalogSchemaTable schemaTable, ResolvedCatalogTable catalogTable) {
        super(relOptSchema, rowType, names, schemaTable.getStatistic());
        this.schemaTable = schemaTable;
        this.catalogTable = catalogTable;
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext toRelContext) {
        RelOptCluster cluster = toRelContext.getCluster();
        List<RelHint> hints = toRelContext.getTableHints();
        FlinkContext context = ShortcutUtils.unwrapContext(cluster);
        FlinkRelBuilder relBuilder = FlinkRelBuilder.of(cluster, this.relOptSchema);
        Map<String, String> hintedOptions = FlinkHints.getHintedOptions(hints);
        ResolvedCatalogTable catalogTable = this.createFinalCatalogTable(context, hintedOptions);
        DynamicTableSource tableSource = this.createDynamicTableSource(context, catalogTable);
        return DynamicSourceUtils.convertSourceToRel(this.schemaTable.isStreamingMode(), (ReadableConfig)context.getTableConfig().getConfiguration(), relBuilder, this.schemaTable.getTableIdentifier(), catalogTable, this.schemaTable.getStatistic(), hints, tableSource);
    }

    private ResolvedCatalogTable createFinalCatalogTable(FlinkContext context, Map<String, String> hintedOptions) {
        if (hintedOptions.isEmpty()) {
            return this.catalogTable;
        }
        Configuration config = context.getTableConfig().getConfiguration();
        if (!((Boolean)config.get(TableConfigOptions.TABLE_DYNAMIC_TABLE_OPTIONS_ENABLED)).booleanValue()) {
            throw new ValidationException(String.format("The '%s' hint is allowed only when the config option '%s' is set to true.", "OPTIONS", TableConfigOptions.TABLE_DYNAMIC_TABLE_OPTIONS_ENABLED.key()));
        }
        return this.catalogTable.copy(FlinkHints.mergeTableOptions(hintedOptions, this.catalogTable.getOptions()));
    }

    private DynamicTableSource createDynamicTableSource(FlinkContext context, ResolvedCatalogTable catalogTable) {
        Configuration config = context.getTableConfig().getConfiguration();
        return FactoryUtil.createTableSource((Catalog)this.schemaTable.getCatalog().orElse(null), (ObjectIdentifier)this.schemaTable.getTableIdentifier(), (ResolvedCatalogTable)catalogTable, (ReadableConfig)config, (ClassLoader)Thread.currentThread().getContextClassLoader(), (boolean)this.schemaTable.isTemporary());
    }

    public CatalogTable getCatalogTable() {
        return this.catalogTable;
    }
}

