/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.dataset;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.MapPartitionOperator;
import org.apache.flink.api.java.operators.PartitionOperator;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.internal.BatchTableEnvImpl;
import org.apache.flink.table.plan.nodes.CommonSort;
import org.apache.flink.table.plan.nodes.CommonSort$class;
import org.apache.flink.table.plan.nodes.FlinkRelNode$class;
import org.apache.flink.table.plan.nodes.dataset.DataSetRel;
import org.apache.flink.table.runtime.CountPartitionFunction;
import org.apache.flink.table.runtime.LimitFilterFunction;
import org.apache.flink.table.runtime.aggregate.SortUtil$;
import org.apache.flink.types.Row;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ee\u0001B\u0001\u0003\u0001E\u00111\u0002R1uCN+GoU8si*\u00111\u0001B\u0001\bI\u0006$\u0018m]3u\u0015\t)a!A\u0003o_\u0012,7O\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\n\u001b=A\u00111\u0003G\u0007\u0002))\u0011QCF\u0001\u0004e\u0016d'BA\f\r\u0003\u001d\u0019\u0017\r\\2ji\u0016L!!\u0007\u000b\u0003\u0013MKgn\u001a7f%\u0016d\u0007CA\u000e\u001d\u001b\u0005!\u0011BA\u000f\u0005\u0005)\u0019u.\\7p]N{'\u000f\u001e\t\u0003?\u0001j\u0011AA\u0005\u0003C\t\u0011!\u0002R1uCN+GOU3m\u0011!\u0019\u0003A!A!\u0002\u0013!\u0013aB2mkN$XM\u001d\t\u0003K\u001dj\u0011A\n\u0006\u0003\u000fYI!\u0001\u000b\u0014\u0003\u001bI+Gn\u00149u\u00072,8\u000f^3s\u0011!Q\u0003A!A!\u0002\u0013Y\u0013\u0001\u0003;sC&$8+\u001a;\u0011\u0005\u0015b\u0013BA\u0017'\u0005-\u0011V\r\u001c+sC&$8+\u001a;\t\u0011=\u0002!\u0011!Q\u0001\nA\n1!\u001b8q!\t\u0019\u0012'\u0003\u00023)\t9!+\u001a7O_\u0012,\u0007\u0002\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u001b\u0002\u0015\r|G\u000e\\1uS>t7\u000f\u0005\u0002\u0014m%\u0011q\u0007\u0006\u0002\r%\u0016d7i\u001c7mCRLwN\u001c\u0005\ts\u0001\u0011\t\u0011)A\u0005u\u0005q!o\\<SK2$\u0015\r^1UsB,\u0007CA\u001e?\u001b\u0005a$BA\u001f\u0015\u0003\u0011!\u0018\u0010]3\n\u0005}b$a\u0003*fY\u0012\u000bG/\u0019+za\u0016D\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IAQ\u0001\u0007_\u001a47/\u001a;\u0011\u0005\r3U\"\u0001#\u000b\u0005\u00153\u0012a\u0001:fq&\u0011q\t\u0012\u0002\b%\u0016Dhj\u001c3f\u0011!I\u0005A!A!\u0002\u0013\u0011\u0015!\u00024fi\u000eD\u0007\"B&\u0001\t\u0003a\u0015A\u0002\u001fj]&$h\b\u0006\u0005N\u001d>\u0003\u0016KU*U!\ty\u0002\u0001C\u0003$\u0015\u0002\u0007A\u0005C\u0003+\u0015\u0002\u00071\u0006C\u00030\u0015\u0002\u0007\u0001\u0007C\u00035\u0015\u0002\u0007Q\u0007C\u0003:\u0015\u0002\u0007!\bC\u0003B\u0015\u0002\u0007!\tC\u0003J\u0015\u0002\u0007!\tC\u0004W\u0001\t\u0007I\u0011B,\u0002\u00151LW.\u001b;Ti\u0006\u0014H/F\u0001Y!\tIF,D\u0001[\u0015\u0005Y\u0016!B:dC2\f\u0017BA/[\u0005\u0011auN\\4\t\r}\u0003\u0001\u0015!\u0003Y\u0003-a\u0017.\\5u'R\f'\u000f\u001e\u0011\t\u000f\u0005\u0004!\u0019!C\u0005/\u0006AA.[7ji\u0016sG\r\u0003\u0004d\u0001\u0001\u0006I\u0001W\u0001\nY&l\u0017\u000e^#oI\u0002BQ!\u001a\u0001\u0005B\u0019\fQ\u0002Z3sSZ,'k\\<UsB,G#\u0001\u001e\t\u000b!\u0004A\u0011I5\u0002\t\r|\u0007/\u001f\u000b\u0004a)\\\u0007\"\u0002\u0016h\u0001\u0004Y\u0003\"\u00027h\u0001\u0004i\u0017AB5oaV$8\u000fE\u0002ogBj\u0011a\u001c\u0006\u0003aF\fA!\u001e;jY*\t!/\u0001\u0003kCZ\f\u0017B\u0001;p\u0005\u0011a\u0015n\u001d;\t\u000bY\u0004A\u0011I<\u0002!\u0015\u001cH/[7bi\u0016\u0014vn^\"pk:$HC\u0001=|!\tI\u00160\u0003\u0002{5\n1Ai\\;cY\u0016DQ\u0001`;A\u0002u\f\u0001\"\\3uC\u0012\fG/\u0019\t\u0004}\u0006\u0005Q\"A@\u000b\u0005q$\u0012bAA\u0002\u007f\n\u0001\"+\u001a7NKR\fG-\u0019;b#V,'/\u001f\u0005\b\u0003\u000f\u0001A\u0011IA\u0005\u0003=!(/\u00198tY\u0006$X\rV8QY\u0006tG\u0003BA\u0006\u0003K\u0001b!!\u0004\u0002\u0016\u0005eQBAA\b\u0015\r\u0011\u0018\u0011\u0003\u0006\u0004\u0003'Q\u0011aA1qS&!\u0011qCA\b\u0005\u001d!\u0015\r^1TKR\u0004B!a\u0007\u0002\"5\u0011\u0011Q\u0004\u0006\u0004\u0003?Q\u0011!\u0002;za\u0016\u001c\u0018\u0002BA\u0012\u0003;\u00111AU8x\u0011!\t9#!\u0002A\u0002\u0005%\u0012\u0001\u0003;bE2,WI\u001c<\u0011\t\u0005-\u00121G\u0007\u0003\u0003[QA!a\f\u00022\u0005A\u0011N\u001c;fe:\fGNC\u0002\u0002\u0014!IA!!\u000e\u0002.\t\t\")\u0019;dQR\u000b'\r\\3F]ZLU\u000e\u001d7\t\u0013\u0005e\u0002A1A\u0005\n\u0005m\u0012a\u00044jK2$7i\u001c7mCRLwN\\:\u0016\u0005\u0005u\u0002CBA \u0003\u0013\ni%\u0004\u0002\u0002B)!\u00111IA#\u0003\u001diW\u000f^1cY\u0016T1!a\u0012[\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0017\n\tE\u0001\u0004Ck\u001a4WM\u001d\t\b3\u0006=\u00131KA-\u0013\r\t\tF\u0017\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007e\u000b)&C\u0002\u0002Xi\u00131!\u00138u!\u0011\tY&!\u001a\u000e\u0005\u0005u#\u0002BA0\u0003C\n\u0011b\u001c9fe\u0006$xN]:\u000b\t\u0005\r\u0014\u0011C\u0001\u0007G>lWn\u001c8\n\t\u0005\u001d\u0014Q\f\u0002\u0006\u001fJ$WM\u001d\u0005\t\u0003W\u0002\u0001\u0015!\u0003\u0002>\u0005\u0001b-[3mI\u000e{G\u000e\\1uS>t7\u000f\t\u0005\b\u0003_\u0002A\u0011IA9\u0003!!xn\u0015;sS:<GCAA:!\u0011\t)(a\u001f\u000f\u0007e\u000b9(C\u0002\u0002zi\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA?\u0003\u007f\u0012aa\u0015;sS:<'bAA=5\"9\u00111\u0011\u0001\u0005B\u0005\u0015\u0015\u0001D3ya2\f\u0017N\u001c+fe6\u001cH\u0003BAD\u0003\u001b\u00032aEAE\u0013\r\tY\t\u0006\u0002\n%\u0016dwK]5uKJD\u0001\"a$\u0002\u0002\u0002\u0007\u0011qQ\u0001\u0003a^\u0004")
public class DataSetSort
extends SingleRel
implements CommonSort,
DataSetRel {
    private final RelOptCluster cluster;
    private final RelNode inp;
    private final RelCollation collations;
    private final RelDataType rowRelDataType;
    private final RexNode offset;
    private final RexNode fetch;
    private final long limitStart;
    private final long limitEnd;
    private final Buffer<Tuple2<Object, Order>> fieldCollations;

    @Override
    public String getExpressionString(RexNode expr, Seq<String> inFields, Option<Seq<RexNode>> localExprsTable) {
        return FlinkRelNode$class.getExpressionString(this, expr, inFields, localExprsTable);
    }

    @Override
    public double estimateRowSize(RelDataType rowType) {
        return FlinkRelNode$class.estimateRowSize(this, rowType);
    }

    @Override
    public double estimateDataTypeSize(RelDataType t) {
        return FlinkRelNode$class.estimateDataTypeSize(this, t);
    }

    @Override
    public long getFetchLimitEnd(RexNode fetch, RexNode offset) {
        return CommonSort$class.getFetchLimitEnd(this, fetch, offset);
    }

    @Override
    public long getFetchLimitStart(RexNode offset) {
        return CommonSort$class.getFetchLimitStart(this, offset);
    }

    @Override
    public String sortToString(RelDataType rowRelDataType, RelCollation sortCollation, RexNode sortOffset, RexNode sortFetch) {
        return CommonSort$class.sortToString(this, rowRelDataType, sortCollation, sortOffset, sortFetch);
    }

    @Override
    public RelWriter sortExplainTerms(RelWriter pw, RelDataType rowRelDataType, RelCollation sortCollation, RexNode sortOffset, RexNode sortFetch) {
        return CommonSort$class.sortExplainTerms(this, pw, rowRelDataType, sortCollation, sortOffset, sortFetch);
    }

    private long limitStart() {
        return this.limitStart;
    }

    private long limitEnd() {
        return this.limitEnd;
    }

    @Override
    public RelDataType deriveRowType() {
        return this.rowRelDataType;
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DataSetSort(this.cluster, traitSet, inputs.get(0), this.collations, this.getRowType(), this.offset, this.fetch);
    }

    @Override
    public double estimateRowCount(RelMetadataQuery metadata) {
        double d;
        Double inputRowCnt = metadata.getRowCount(this.getInput());
        if (inputRowCnt == null) {
            d = Predef$.MODULE$.Double2double(inputRowCnt);
        } else {
            double rowCount = RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(Predef$.MODULE$.Double2double(inputRowCnt) - (double)this.limitStart()), 1.0);
            if (this.fetch == null) {
                d = rowCount;
            } else {
                int limit = RexLiteral.intValue(this.fetch);
                d = RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(rowCount), (double)limit);
            }
        }
        return d;
    }

    @Override
    public DataSet<Row> translateToPlan(BatchTableEnvImpl tableEnv) {
        DataSet dataSet;
        if (this.fieldCollations().isEmpty()) {
            throw new TableException("Limiting the result without sorting is not allowed as it could lead to arbitrary results.");
        }
        TableConfig config = tableEnv.getConfig();
        PartitionOperator inputDs = ((DataSetRel)this.inp).translateToPlan(tableEnv);
        int currentParallelism = inputDs.getExecutionEnvironment().getParallelism();
        ObjectRef partitionedDs = ObjectRef.create(currentParallelism == 1 ? inputDs : inputDs.partitionByRange((int[])((TraversableOnce)this.fieldCollations().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Object, Order> x$1) {
                return x$1._1$mcI$sp();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int())).withOrders((Order[])((TraversableOnce)this.fieldCollations().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Order apply(Tuple2<Object, Order> x$2) {
                return (Order)x$2._2();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Order.class))));
        this.fieldCollations().foreach((Function1)new Serializable(this, partitionedDs){
            public static final long serialVersionUID = 0L;
            private final ObjectRef partitionedDs$1;

            public final void apply(Tuple2<Object, Order> fieldCollation) {
                this.partitionedDs$1.elem = ((DataSet)this.partitionedDs$1.elem).sortPartition(fieldCollation._1$mcI$sp(), (Order)fieldCollation._2());
            }
            {
                this.partitionedDs$1 = partitionedDs$1;
            }
        });
        if (this.offset == null && this.fetch == null) {
            dataSet = (DataSet)partitionedDs.elem;
        } else {
            CountPartitionFunction countFunction = new CountPartitionFunction();
            String partitionCountName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prepare offset/fetch"})).s((Seq)Nil$.MODULE$);
            MapPartitionOperator partitionCount = (MapPartitionOperator)((DataSet)partitionedDs.elem).mapPartition(countFunction).name(partitionCountName);
            String broadcastName = "countPartition";
            LimitFilterFunction limitFunction = new LimitFilterFunction(this.limitStart(), this.limitEnd(), broadcastName);
            String limitName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offset: $offsetToString(offset), fetch: $fetchToString(fetch, offset))"})).s((Seq)Nil$.MODULE$);
            dataSet = ((SingleInputUdfOperator)((DataSet)partitionedDs.elem).filter(limitFunction).name(limitName)).withBroadcastSet((DataSet)partitionCount, broadcastName);
        }
        return dataSet;
    }

    private Buffer<Tuple2<Object, Order>> fieldCollations() {
        return this.fieldCollations;
    }

    @Override
    public String toString() {
        return this.sortToString(this.getRowType(), this.collations, this.offset, this.fetch);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return this.sortExplainTerms(super.explainTerms(pw), this.getRowType(), this.collations, this.offset, this.fetch);
    }

    public DataSetSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode inp, RelCollation collations, RelDataType rowRelDataType, RexNode offset, RexNode fetch) {
        this.cluster = cluster;
        this.inp = inp;
        this.collations = collations;
        this.rowRelDataType = rowRelDataType;
        this.offset = offset;
        this.fetch = fetch;
        super(cluster, traitSet, inp);
        CommonSort$class.$init$(this);
        FlinkRelNode$class.$init$(this);
        this.limitStart = this.getFetchLimitStart(offset);
        this.limitEnd = this.getFetchLimitEnd(fetch, offset);
        this.fieldCollations = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(collations.getFieldCollations()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Order> apply(RelFieldCollation c) {
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)c.getFieldIndex()), (Object)SortUtil$.MODULE$.directionToOrder(c.getDirection()));
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }
}

