/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.JsonWriter;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.StringUtils;

final class JsonStringWriter
extends JsonWriter {
    private StringBuilder m_jsonString = new StringBuilder();
    private AttributeStreamOfInt32 m_functionStack = new AttributeStreamOfInt32(0);

    @Override
    Object getJson() {
        this.next_(0);
        return this.m_jsonString.toString();
    }

    @Override
    void startObject() {
        this.next_(1);
        this.m_jsonString.append('{');
        this.m_functionStack.add(2);
    }

    @Override
    void startArray() {
        this.next_(2);
        this.m_jsonString.append('[');
        this.m_functionStack.add(3);
    }

    @Override
    void endObject() {
        this.next_(4);
        this.m_jsonString.append('}');
    }

    @Override
    void endArray() {
        this.next_(8);
        this.m_jsonString.append(']');
    }

    @Override
    void addFieldName(String fieldName) {
        this.next_(16);
        this.appendQuote_(fieldName);
    }

    @Override
    void addPairObject(String fieldName) {
        this.next_(64);
        this.appendQuote_(fieldName);
        this.m_jsonString.append(":");
        this.addValueObject_();
    }

    @Override
    void addPairArray(String fieldName) {
        this.next_(64);
        this.appendQuote_(fieldName);
        this.m_jsonString.append(":");
        this.addValueArray_();
    }

    @Override
    void addPairString(String fieldName, String v) {
        this.next_(64);
        this.appendQuote_(fieldName);
        this.m_jsonString.append(":");
        this.addValueString_(v);
    }

    @Override
    void addPairDouble(String fieldName, double v) {
        this.next_(64);
        this.appendQuote_(fieldName);
        this.m_jsonString.append(":");
        this.addValueDouble_(v);
    }

    @Override
    void addPairDouble(String fieldName, double v, int precision, boolean bFixedPoint) {
        this.next_(64);
        this.appendQuote_(fieldName);
        this.m_jsonString.append(":");
        this.addValueDouble_(v, precision, bFixedPoint);
    }

    @Override
    void addPairInt(String fieldName, int v) {
        this.next_(64);
        this.appendQuote_(fieldName);
        this.m_jsonString.append(":");
        this.addValueInt_(v);
    }

    @Override
    void addPairBoolean(String fieldName, boolean v) {
        this.next_(64);
        this.appendQuote_(fieldName);
        this.m_jsonString.append(":");
        this.addValueBoolean_(v);
    }

    @Override
    void addPairNull(String fieldName) {
        this.next_(64);
        this.appendQuote_(fieldName);
        this.m_jsonString.append(":");
        this.addValueNull_();
    }

    @Override
    void addValueObject() {
        this.next_(1);
        this.addValueObject_();
    }

    @Override
    void addValueArray() {
        this.next_(2);
        this.addValueArray_();
    }

    @Override
    void addValueString(String v) {
        this.next_(32);
        this.addValueString_(v);
    }

    @Override
    void addValueDouble(double v) {
        this.next_(32);
        this.addValueDouble_(v);
    }

    @Override
    void addValueDouble(double v, int precision, boolean bFixedPoint) {
        this.next_(32);
        this.addValueDouble_(v, precision, bFixedPoint);
    }

    @Override
    void addValueInt(int v) {
        this.next_(32);
        this.addValueInt_(v);
    }

    @Override
    void addValueBoolean(boolean v) {
        this.next_(32);
        this.addValueBoolean_(v);
    }

    @Override
    void addValueNull() {
        this.next_(32);
        this.addValueNull_();
    }

    JsonStringWriter() {
        this.m_functionStack.add(0);
        this.m_functionStack.add(1);
    }

    private void addValueObject_() {
        this.m_jsonString.append('{');
        this.m_functionStack.add(2);
    }

    private void addValueArray_() {
        this.m_jsonString.append('[');
        this.m_functionStack.add(3);
    }

    private void addValueString_(String v) {
        this.appendQuote_(v);
    }

    private void addValueDouble_(double v) {
        if (NumberUtils.isNaN(v)) {
            this.addValueNull_();
            return;
        }
        StringUtils.appendDouble(v, 17, this.m_jsonString);
    }

    private void addValueDouble_(double v, int precision, boolean bFixedPoint) {
        if (NumberUtils.isNaN(v)) {
            this.addValueNull_();
            return;
        }
        if (bFixedPoint) {
            StringUtils.appendDoubleF(v, precision, this.m_jsonString);
        } else {
            StringUtils.appendDouble(v, precision, this.m_jsonString);
        }
    }

    private void addValueInt_(int v) {
        this.m_jsonString.append(v);
    }

    private void addValueBoolean_(boolean v) {
        if (v) {
            this.m_jsonString.append("true");
        } else {
            this.m_jsonString.append("false");
        }
    }

    private void addValueNull_() {
        this.m_jsonString.append("null");
    }

    private void next_(int action) {
        switch (this.m_functionStack.getLast()) {
            case 0: {
                this.accept_(action);
                break;
            }
            case 1: {
                this.start_(action);
                break;
            }
            case 2: {
                this.objectStart_(action);
                break;
            }
            case 3: {
                this.arrayStart_(action);
                break;
            }
            case 4: {
                this.pairEnd_(action);
                break;
            }
            case 5: {
                this.elementEnd_(action);
                break;
            }
            case 6: {
                this.fieldNameEnd_(action);
                break;
            }
            default: {
                throw new GeometryException("internal error");
            }
        }
    }

    private void accept_(int action) {
        if (action != 0) {
            throw new GeometryException("invalid call");
        }
    }

    private void start_(int action) {
        if ((action & 3) == 0) {
            throw new GeometryException("invalid call");
        }
        this.m_functionStack.removeLast();
    }

    private void objectStart_(int action) {
        if (action != 4 && action != 64 && action != 16) {
            throw new GeometryException("invalid call");
        }
        this.m_functionStack.removeLast();
        if (action == 64) {
            this.m_functionStack.add(4);
        } else if (action == 16) {
            this.m_functionStack.add(4);
            this.m_functionStack.add(6);
        }
    }

    private void pairEnd_(int action) {
        if (action == 64) {
            this.m_jsonString.append(',');
        } else if (action == 16) {
            this.m_jsonString.append(',');
            this.m_functionStack.add(6);
        } else if (action == 4) {
            this.m_functionStack.removeLast();
        } else {
            throw new GeometryException("invalid call");
        }
    }

    private void arrayStart_(int action) {
        if ((action & 0x23) == 0 && action != 8) {
            throw new GeometryException("invalid call");
        }
        this.m_functionStack.removeLast();
        if ((action & 0x23) != 0) {
            this.m_functionStack.add(5);
        }
    }

    private void elementEnd_(int action) {
        if ((action & 0x23) != 0) {
            this.m_jsonString.append(',');
        } else if (action == 8) {
            this.m_functionStack.removeLast();
        } else {
            throw new GeometryException("invalid call");
        }
    }

    private void fieldNameEnd_(int action) {
        if ((action & 0x23) == 0) {
            throw new GeometryException("invalid call");
        }
        this.m_functionStack.removeLast();
        this.m_jsonString.append(':');
    }

    private void appendQuote_(String string2) {
        int count = 0;
        int start = 0;
        int end = string2.length();
        this.m_jsonString.append('\"');
        block10: for (int i = 0; i < end; ++i) {
            switch (string2.charAt(i)) {
                case '\"': {
                    if (count > 0) {
                        this.m_jsonString.append(string2, start, start + count);
                        count = 0;
                    }
                    this.m_jsonString.append("\\\"");
                    start = i + 1;
                    continue block10;
                }
                case '\\': {
                    if (count > 0) {
                        this.m_jsonString.append(string2, start, start + count);
                        count = 0;
                    }
                    this.m_jsonString.append("\\\\");
                    start = i + 1;
                    continue block10;
                }
                case '/': {
                    if (i > 0 && string2.charAt(i - 1) == '<') {
                        if (count > 0) {
                            this.m_jsonString.append(string2, start, start + count);
                            count = 0;
                        }
                        this.m_jsonString.append("\\/");
                        start = i + 1;
                        continue block10;
                    }
                    ++count;
                    continue block10;
                }
                case '\b': {
                    if (count > 0) {
                        this.m_jsonString.append(string2, start, start + count);
                        count = 0;
                    }
                    this.m_jsonString.append("\\b");
                    start = i + 1;
                    continue block10;
                }
                case '\f': {
                    if (count > 0) {
                        this.m_jsonString.append(string2, start, start + count);
                        count = 0;
                    }
                    this.m_jsonString.append("\\f");
                    start = i + 1;
                    continue block10;
                }
                case '\n': {
                    if (count > 0) {
                        this.m_jsonString.append(string2, start, start + count);
                        count = 0;
                    }
                    this.m_jsonString.append("\\n");
                    start = i + 1;
                    continue block10;
                }
                case '\r': {
                    if (count > 0) {
                        this.m_jsonString.append(string2, start, start + count);
                        count = 0;
                    }
                    this.m_jsonString.append("\\r");
                    start = i + 1;
                    continue block10;
                }
                case '\t': {
                    if (count > 0) {
                        this.m_jsonString.append(string2, start, start + count);
                        count = 0;
                    }
                    this.m_jsonString.append("\\t");
                    start = i + 1;
                    continue block10;
                }
                default: {
                    ++count;
                }
            }
        }
        if (count > 0) {
            this.m_jsonString.append(string2, start, start + count);
        }
        this.m_jsonString.append('\"');
    }
}

