/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.AttributeStreamOfInt8;
import com.esri.core.geometry.Clipper;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryAccelerators;
import com.esri.core.geometry.InternalUtils;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiPointImpl;
import com.esri.core.geometry.MultiVertexGeometryImpl;
import com.esri.core.geometry.PairwiseIntersectorImpl;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.PointInPolygonHelper;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.PolygonUtils;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.QuadTreeImpl;
import com.esri.core.geometry.RasterizedGeometry2D;
import com.esri.core.geometry.RelationalOperationsMatrix;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentIterator;
import com.esri.core.geometry.SegmentIteratorImpl;
import com.esri.core.geometry.SpatialReference;
import java.util.ArrayList;

class RelationalOperations {
    ArrayList<OverlapEvent> m_overlap_events = new ArrayList();

    static boolean relate(Geometry geometry_a, Geometry geometry_b, SpatialReference sr, int relation, ProgressTracker progress_tracker) {
        Geometry _geometry_b;
        Geometry _geometry_a;
        int type_a = geometry_a.getType().value();
        int type_b = geometry_b.getType().value();
        if (type_a == 197) {
            if (type_b == 197) {
                return RelationalOperations.relate((Envelope)geometry_a, (Envelope)geometry_b, sr, relation, progress_tracker);
            }
            if (type_b == 33) {
                if (relation == 2) {
                    relation = 1;
                } else if (relation == 1) {
                    relation = 2;
                }
                return RelationalOperations.relate((Point)geometry_b, (Envelope)geometry_a, sr, relation, progress_tracker);
            }
        } else if (type_a == 33) {
            if (type_b == 197) {
                return RelationalOperations.relate((Point)geometry_a, (Envelope)geometry_b, sr, relation, progress_tracker);
            }
            if (type_b == 33) {
                return RelationalOperations.relate((Point)geometry_a, (Point)geometry_b, sr, relation, progress_tracker);
            }
        }
        if (geometry_a.isEmpty() || geometry_b.isEmpty()) {
            return relation == 4;
        }
        Envelope2D env1 = new Envelope2D();
        geometry_a.queryEnvelope2D(env1);
        Envelope2D env2 = new Envelope2D();
        geometry_b.queryEnvelope2D(env2);
        Envelope2D envMerged = new Envelope2D();
        envMerged.setCoords(env1);
        envMerged.merge(env2);
        double tolerance = InternalUtils.calculateToleranceFromGeometry(sr, envMerged, false);
        if (RelationalOperations.envelopeDisjointEnvelope_(env1, env2, tolerance, progress_tracker)) {
            return relation == 4;
        }
        boolean bRelation = false;
        if (MultiPath.isSegment(type_a)) {
            Polyline polyline_a = new Polyline(geometry_a.getDescription());
            polyline_a.addSegment((Segment)geometry_a, true);
            _geometry_a = polyline_a;
            type_a = 1607;
        } else {
            _geometry_a = geometry_a;
        }
        if (MultiPath.isSegment(type_b)) {
            Polyline polyline_b = new Polyline(geometry_b.getDescription());
            polyline_b.addSegment((Segment)geometry_b, true);
            _geometry_b = polyline_b;
            type_b = 1607;
        } else {
            _geometry_b = geometry_b;
        }
        if (type_a != 197 && type_b != 197) {
            if (_geometry_a.getDimension() < _geometry_b.getDimension() || type_a == 33 && type_b == 550) {
                if (relation == 2) {
                    relation = 1;
                } else if (relation == 1) {
                    relation = 2;
                }
            }
        } else if (type_a != 1736 && type_b != 197) {
            if (relation == 2) {
                relation = 1;
            } else if (relation == 1) {
                relation = 2;
            }
        }
        block0 : switch (type_a) {
            case 1736: {
                switch (type_b) {
                    case 1736: {
                        bRelation = RelationalOperations.polygonRelatePolygon_((Polygon)_geometry_a, (Polygon)_geometry_b, tolerance, relation, progress_tracker);
                        break block0;
                    }
                    case 1607: {
                        bRelation = RelationalOperations.polygonRelatePolyline_((Polygon)_geometry_a, (Polyline)_geometry_b, tolerance, relation, progress_tracker);
                        break block0;
                    }
                    case 33: {
                        bRelation = RelationalOperations.polygonRelatePoint_((Polygon)_geometry_a, (Point)_geometry_b, tolerance, relation, progress_tracker);
                        break block0;
                    }
                    case 550: {
                        bRelation = RelationalOperations.polygonRelateMultiPoint_((Polygon)_geometry_a, (MultiPoint)_geometry_b, tolerance, relation, progress_tracker);
                        break block0;
                    }
                    case 197: {
                        bRelation = RelationalOperations.polygonRelateEnvelope_((Polygon)_geometry_a, (Envelope)_geometry_b, tolerance, relation, progress_tracker);
                        break block0;
                    }
                }
                break;
            }
            case 1607: {
                switch (type_b) {
                    case 1736: {
                        bRelation = RelationalOperations.polygonRelatePolyline_((Polygon)_geometry_b, (Polyline)_geometry_a, tolerance, relation, progress_tracker);
                        break block0;
                    }
                    case 1607: {
                        bRelation = RelationalOperations.polylineRelatePolyline_((Polyline)_geometry_a, (Polyline)_geometry_b, tolerance, relation, progress_tracker);
                        break block0;
                    }
                    case 33: {
                        bRelation = RelationalOperations.polylineRelatePoint_((Polyline)_geometry_a, (Point)_geometry_b, tolerance, relation, progress_tracker);
                        break block0;
                    }
                    case 550: {
                        bRelation = RelationalOperations.polylineRelateMultiPoint_((Polyline)_geometry_a, (MultiPoint)_geometry_b, tolerance, relation, progress_tracker);
                        break block0;
                    }
                    case 197: {
                        bRelation = RelationalOperations.polylineRelateEnvelope_((Polyline)_geometry_a, (Envelope)_geometry_b, tolerance, relation, progress_tracker);
                        break block0;
                    }
                }
                break;
            }
            case 33: {
                switch (type_b) {
                    case 1736: {
                        bRelation = RelationalOperations.polygonRelatePoint_((Polygon)_geometry_b, (Point)_geometry_a, tolerance, relation, progress_tracker);
                        break block0;
                    }
                    case 1607: {
                        bRelation = RelationalOperations.polylineRelatePoint_((Polyline)_geometry_b, (Point)_geometry_a, tolerance, relation, progress_tracker);
                        break block0;
                    }
                    case 550: {
                        bRelation = RelationalOperations.multiPointRelatePoint_((MultiPoint)_geometry_b, (Point)_geometry_a, tolerance, relation, progress_tracker);
                        break block0;
                    }
                }
                break;
            }
            case 550: {
                switch (type_b) {
                    case 1736: {
                        bRelation = RelationalOperations.polygonRelateMultiPoint_((Polygon)_geometry_b, (MultiPoint)_geometry_a, tolerance, relation, progress_tracker);
                        break block0;
                    }
                    case 1607: {
                        bRelation = RelationalOperations.polylineRelateMultiPoint_((Polyline)_geometry_b, (MultiPoint)_geometry_a, tolerance, relation, progress_tracker);
                        break block0;
                    }
                    case 550: {
                        bRelation = RelationalOperations.multiPointRelateMultiPoint_((MultiPoint)_geometry_a, (MultiPoint)_geometry_b, tolerance, relation, progress_tracker);
                        break block0;
                    }
                    case 33: {
                        bRelation = RelationalOperations.multiPointRelatePoint_((MultiPoint)_geometry_a, (Point)_geometry_b, tolerance, relation, progress_tracker);
                        break block0;
                    }
                    case 197: {
                        bRelation = RelationalOperations.multiPointRelateEnvelope_((MultiPoint)_geometry_a, (Envelope)_geometry_b, tolerance, relation, progress_tracker);
                        break block0;
                    }
                }
                break;
            }
            case 197: {
                switch (type_b) {
                    case 1736: {
                        bRelation = RelationalOperations.polygonRelateEnvelope_((Polygon)_geometry_b, (Envelope)_geometry_a, tolerance, relation, progress_tracker);
                        break block0;
                    }
                    case 1607: {
                        bRelation = RelationalOperations.polylineRelateEnvelope_((Polyline)_geometry_b, (Envelope)_geometry_a, tolerance, relation, progress_tracker);
                        break block0;
                    }
                    case 550: {
                        bRelation = RelationalOperations.multiPointRelateEnvelope_((MultiPoint)_geometry_b, (Envelope)_geometry_a, tolerance, relation, progress_tracker);
                        break block0;
                    }
                }
                break;
            }
        }
        return bRelation;
    }

    private static boolean relate(Envelope envelope_a, Envelope envelope_b, SpatialReference sr, int relation, ProgressTracker progress_tracker) {
        if (envelope_a.isEmpty() || envelope_b.isEmpty()) {
            return relation == 4;
        }
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        Envelope2D env_merged = new Envelope2D();
        envelope_a.queryEnvelope2D(env_a);
        envelope_b.queryEnvelope2D(env_b);
        env_merged.setCoords(env_a);
        env_merged.merge(env_b);
        double tolerance = InternalUtils.calculateToleranceFromGeometry(sr, env_merged, false);
        switch (relation) {
            case 4: {
                return RelationalOperations.envelopeDisjointEnvelope_(env_a, env_b, tolerance, progress_tracker);
            }
            case 2: {
                return RelationalOperations.envelopeContainsEnvelope_(env_b, env_a, tolerance, progress_tracker);
            }
            case 1: {
                return RelationalOperations.envelopeContainsEnvelope_(env_a, env_b, tolerance, progress_tracker);
            }
            case 3: {
                return RelationalOperations.envelopeEqualsEnvelope_(env_a, env_b, tolerance, progress_tracker);
            }
            case 8: {
                return RelationalOperations.envelopeTouchesEnvelope_(env_a, env_b, tolerance, progress_tracker);
            }
            case 32: {
                return RelationalOperations.envelopeOverlapsEnvelope_(env_a, env_b, tolerance, progress_tracker);
            }
            case 16: {
                return RelationalOperations.envelopeCrossesEnvelope_(env_a, env_b, tolerance, progress_tracker);
            }
        }
        return false;
    }

    private static boolean relate(Point point_a, Envelope envelope_b, SpatialReference sr, int relation, ProgressTracker progress_tracker) {
        if (point_a.isEmpty() || envelope_b.isEmpty()) {
            return relation == 4;
        }
        Point2D pt_a = point_a.getXY();
        Envelope2D env_b = new Envelope2D();
        Envelope2D env_merged = new Envelope2D();
        envelope_b.queryEnvelope2D(env_b);
        env_merged.setCoords(pt_a);
        env_merged.merge(env_b);
        double tolerance = InternalUtils.calculateToleranceFromGeometry(sr, env_merged, false);
        switch (relation) {
            case 4: {
                return RelationalOperations.pointDisjointEnvelope_(pt_a, env_b, tolerance, progress_tracker);
            }
            case 2: {
                return RelationalOperations.pointWithinEnvelope_(pt_a, env_b, tolerance, progress_tracker);
            }
            case 1: {
                return RelationalOperations.pointContainsEnvelope_(pt_a, env_b, tolerance, progress_tracker);
            }
            case 3: {
                return RelationalOperations.pointEqualsEnvelope_(pt_a, env_b, tolerance, progress_tracker);
            }
            case 8: {
                return RelationalOperations.pointTouchesEnvelope_(pt_a, env_b, tolerance, progress_tracker);
            }
        }
        return false;
    }

    private static boolean relate(Point point_a, Point point_b, SpatialReference sr, int relation, ProgressTracker progress_tracker) {
        if (point_a.isEmpty() || point_b.isEmpty()) {
            return relation == 4;
        }
        Point2D pt_a = point_a.getXY();
        Point2D pt_b = point_b.getXY();
        Envelope2D env_merged = new Envelope2D();
        env_merged.setCoords(pt_a);
        env_merged.merge(pt_b);
        double tolerance = InternalUtils.calculateToleranceFromGeometry(sr, env_merged, false);
        switch (relation) {
            case 4: {
                return RelationalOperations.pointDisjointPoint_(pt_a, pt_b, tolerance, progress_tracker);
            }
            case 2: {
                return RelationalOperations.pointContainsPoint_(pt_b, pt_a, tolerance, progress_tracker);
            }
            case 1: {
                return RelationalOperations.pointContainsPoint_(pt_a, pt_b, tolerance, progress_tracker);
            }
            case 3: {
                return RelationalOperations.pointEqualsPoint_(pt_a, pt_b, tolerance, progress_tracker);
            }
        }
        return false;
    }

    private static boolean polygonRelatePolygon_(Polygon polygon_a, Polygon polygon_b, double tolerance, int relation, ProgressTracker progress_tracker) {
        switch (relation) {
            case 4: {
                return RelationalOperations.polygonDisjointPolygon_(polygon_a, polygon_b, tolerance, progress_tracker);
            }
            case 2: {
                return RelationalOperations.polygonContainsPolygon_(polygon_b, polygon_a, tolerance, progress_tracker);
            }
            case 1: {
                return RelationalOperations.polygonContainsPolygon_(polygon_a, polygon_b, tolerance, progress_tracker);
            }
            case 3: {
                return RelationalOperations.polygonEqualsPolygon_(polygon_a, polygon_b, tolerance, progress_tracker);
            }
            case 8: {
                return RelationalOperations.polygonTouchesPolygon_(polygon_a, polygon_b, tolerance, progress_tracker);
            }
            case 32: {
                return RelationalOperations.polygonOverlapsPolygon_(polygon_a, polygon_b, tolerance, progress_tracker);
            }
        }
        return false;
    }

    private static boolean polygonRelatePolyline_(Polygon polygon_a, Polyline polyline_b, double tolerance, int relation, ProgressTracker progress_tracker) {
        switch (relation) {
            case 4: {
                return RelationalOperations.polygonDisjointPolyline_(polygon_a, polyline_b, tolerance, progress_tracker);
            }
            case 1: {
                return RelationalOperations.polygonContainsPolyline_(polygon_a, polyline_b, tolerance, progress_tracker);
            }
            case 8: {
                return RelationalOperations.polygonTouchesPolyline_(polygon_a, polyline_b, tolerance, progress_tracker);
            }
            case 16: {
                return RelationalOperations.polygonCrossesPolyline_(polygon_a, polyline_b, tolerance, progress_tracker);
            }
        }
        return false;
    }

    private static boolean polygonRelatePoint_(Polygon polygon_a, Point point_b, double tolerance, int relation, ProgressTracker progress_tracker) {
        switch (relation) {
            case 4: {
                return RelationalOperations.polygonDisjointPoint_(polygon_a, point_b, tolerance, progress_tracker);
            }
            case 1: {
                return RelationalOperations.polygonContainsPoint_(polygon_a, point_b, tolerance, progress_tracker);
            }
            case 8: {
                return RelationalOperations.polygonTouchesPoint_(polygon_a, point_b, tolerance, progress_tracker);
            }
        }
        return false;
    }

    private static boolean polygonRelateMultiPoint_(Polygon polygon_a, MultiPoint multipoint_b, double tolerance, int relation, ProgressTracker progress_tracker) {
        switch (relation) {
            case 4: {
                return RelationalOperations.polygonDisjointMultiPoint_(polygon_a, multipoint_b, tolerance, true, progress_tracker);
            }
            case 1: {
                return RelationalOperations.polygonContainsMultiPoint_(polygon_a, multipoint_b, tolerance, progress_tracker);
            }
            case 8: {
                return RelationalOperations.polygonTouchesMultiPoint_(polygon_a, multipoint_b, tolerance, progress_tracker);
            }
            case 16: {
                return RelationalOperations.polygonCrossesMultiPoint_(polygon_a, multipoint_b, tolerance, progress_tracker);
            }
        }
        return false;
    }

    private static boolean polygonRelateEnvelope_(Polygon polygon_a, Envelope envelope_b, double tolerance, int relation, ProgressTracker progress_tracker) {
        if (RelationalOperations.polygonDisjointEnvelope_(polygon_a, envelope_b, tolerance, progress_tracker)) {
            return relation == 4;
        }
        if (relation == 4) {
            return false;
        }
        switch (relation) {
            case 2: {
                return RelationalOperations.polygonWithinEnvelope_(polygon_a, envelope_b, tolerance, progress_tracker);
            }
            case 1: {
                return RelationalOperations.polygonContainsEnvelope_(polygon_a, envelope_b, tolerance, progress_tracker);
            }
            case 3: {
                return RelationalOperations.polygonEqualsEnvelope_(polygon_a, envelope_b, tolerance, progress_tracker);
            }
            case 8: {
                return RelationalOperations.polygonTouchesEnvelope_(polygon_a, envelope_b, tolerance, progress_tracker);
            }
            case 32: {
                return RelationalOperations.polygonOverlapsEnvelope_(polygon_a, envelope_b, tolerance, progress_tracker);
            }
            case 16: {
                return RelationalOperations.polygonCrossesEnvelope_(polygon_a, envelope_b, tolerance, progress_tracker);
            }
        }
        return false;
    }

    private static boolean polylineRelatePolyline_(Polyline polyline_a, Polyline polyline_b, double tolerance, int relation, ProgressTracker progress_tracker) {
        switch (relation) {
            case 4: {
                return RelationalOperations.polylineDisjointPolyline_(polyline_a, polyline_b, tolerance, progress_tracker);
            }
            case 2: {
                return RelationalOperations.polylineContainsPolyline_(polyline_b, polyline_a, tolerance, progress_tracker);
            }
            case 1: {
                return RelationalOperations.polylineContainsPolyline_(polyline_a, polyline_b, tolerance, progress_tracker);
            }
            case 3: {
                return RelationalOperations.polylineEqualsPolyline_(polyline_a, polyline_b, tolerance, progress_tracker);
            }
            case 8: {
                return RelationalOperations.polylineTouchesPolyline_(polyline_a, polyline_b, tolerance, progress_tracker);
            }
            case 32: {
                return RelationalOperations.polylineOverlapsPolyline_(polyline_a, polyline_b, tolerance, progress_tracker);
            }
            case 16: {
                return RelationalOperations.polylineCrossesPolyline_(polyline_a, polyline_b, tolerance, progress_tracker);
            }
        }
        return false;
    }

    private static boolean polylineRelatePoint_(Polyline polyline_a, Point point_b, double tolerance, int relation, ProgressTracker progress_tracker) {
        switch (relation) {
            case 4: {
                return RelationalOperations.polylineDisjointPoint_(polyline_a, point_b, tolerance, progress_tracker);
            }
            case 1: {
                return RelationalOperations.polylineContainsPoint_(polyline_a, point_b, tolerance, progress_tracker);
            }
            case 8: {
                return RelationalOperations.polylineTouchesPoint_(polyline_a, point_b, tolerance, progress_tracker);
            }
        }
        return false;
    }

    private static boolean polylineRelateMultiPoint_(Polyline polyline_a, MultiPoint multipoint_b, double tolerance, int relation, ProgressTracker progress_tracker) {
        switch (relation) {
            case 4: {
                return RelationalOperations.polylineDisjointMultiPoint_(polyline_a, multipoint_b, tolerance, progress_tracker);
            }
            case 1: {
                return RelationalOperations.polylineContainsMultiPoint_(polyline_a, multipoint_b, tolerance, progress_tracker);
            }
            case 8: {
                return RelationalOperations.polylineTouchesMultiPoint_(polyline_a, multipoint_b, tolerance, progress_tracker);
            }
            case 16: {
                return RelationalOperations.polylineCrossesMultiPoint_(polyline_a, multipoint_b, tolerance, progress_tracker);
            }
        }
        return false;
    }

    private static boolean polylineRelateEnvelope_(Polyline polyline_a, Envelope envelope_b, double tolerance, int relation, ProgressTracker progress_tracker) {
        if (RelationalOperations.polylineDisjointEnvelope_(polyline_a, envelope_b, tolerance, progress_tracker)) {
            return relation == 4;
        }
        if (relation == 4) {
            return false;
        }
        switch (relation) {
            case 2: {
                return RelationalOperations.polylineWithinEnvelope_(polyline_a, envelope_b, tolerance, progress_tracker);
            }
            case 1: {
                return RelationalOperations.polylineContainsEnvelope_(polyline_a, envelope_b, tolerance, progress_tracker);
            }
            case 3: {
                return RelationalOperations.polylineEqualsEnvelope_(polyline_a, envelope_b, tolerance, progress_tracker);
            }
            case 8: {
                return RelationalOperations.polylineTouchesEnvelope_(polyline_a, envelope_b, tolerance, progress_tracker);
            }
            case 32: {
                return RelationalOperations.polylineOverlapsEnvelope_(polyline_a, envelope_b, tolerance, progress_tracker);
            }
            case 16: {
                return RelationalOperations.polylineCrossesEnvelope_(polyline_a, envelope_b, tolerance, progress_tracker);
            }
        }
        return false;
    }

    private static boolean multiPointRelateMultiPoint_(MultiPoint multipoint_a, MultiPoint multipoint_b, double tolerance, int relation, ProgressTracker progress_tracker) {
        switch (relation) {
            case 4: {
                return RelationalOperations.multiPointDisjointMultiPoint_(multipoint_a, multipoint_b, tolerance, progress_tracker);
            }
            case 2: {
                return RelationalOperations.multiPointContainsMultiPoint_(multipoint_b, multipoint_a, tolerance, progress_tracker);
            }
            case 1: {
                return RelationalOperations.multiPointContainsMultiPoint_(multipoint_a, multipoint_b, tolerance, progress_tracker);
            }
            case 3: {
                return RelationalOperations.multiPointEqualsMultiPoint_(multipoint_a, multipoint_b, tolerance, progress_tracker);
            }
            case 32: {
                return RelationalOperations.multiPointOverlapsMultiPoint_(multipoint_a, multipoint_b, tolerance, progress_tracker);
            }
        }
        return false;
    }

    private static boolean multiPointRelatePoint_(MultiPoint multipoint_a, Point point_b, double tolerance, int relation, ProgressTracker progress_tracker) {
        switch (relation) {
            case 4: {
                return RelationalOperations.multiPointDisjointPoint_(multipoint_a, point_b, tolerance, progress_tracker);
            }
            case 2: {
                return RelationalOperations.multiPointWithinPoint_(multipoint_a, point_b, tolerance, progress_tracker);
            }
            case 1: {
                return RelationalOperations.multiPointContainsPoint_(multipoint_a, point_b, tolerance, progress_tracker);
            }
            case 3: {
                return RelationalOperations.multiPointEqualsPoint_(multipoint_a, point_b, tolerance, progress_tracker);
            }
        }
        return false;
    }

    private static boolean multiPointRelateEnvelope_(MultiPoint multipoint_a, Envelope envelope_b, double tolerance, int relation, ProgressTracker progress_tracker) {
        switch (relation) {
            case 4: {
                return RelationalOperations.multiPointDisjointEnvelope_(multipoint_a, envelope_b, tolerance, progress_tracker);
            }
            case 2: {
                return RelationalOperations.multiPointWithinEnvelope_(multipoint_a, envelope_b, tolerance, progress_tracker);
            }
            case 1: {
                return RelationalOperations.multiPointContainsEnvelope_(multipoint_a, envelope_b, tolerance, progress_tracker);
            }
            case 3: {
                return RelationalOperations.multiPointEqualsEnvelope_(multipoint_a, envelope_b, tolerance, progress_tracker);
            }
            case 8: {
                return RelationalOperations.multiPointTouchesEnvelope_(multipoint_a, envelope_b, tolerance, progress_tracker);
            }
            case 16: {
                return RelationalOperations.multiPointCrossesEnvelope_(multipoint_a, envelope_b, tolerance, progress_tracker);
            }
        }
        return false;
    }

    private static boolean polygonEqualsPolygon_(Polygon polygon_a, Polygon polygon_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polygon_a.queryEnvelope2D(env_a);
        polygon_b.queryEnvelope2D(env_b);
        if (!RelationalOperations.envelopeEqualsEnvelope_(env_a, env_b, tolerance, progress_tracker)) {
            return false;
        }
        int relation = RelationalOperations.tryRasterizedContainsOrDisjoint_(polygon_a, polygon_b, tolerance, false);
        if (relation == 4 || relation == 1 || relation == 2) {
            return false;
        }
        if (RelationalOperations.multiPathExactlyEqualsMultiPath_(polygon_a, polygon_b, tolerance, progress_tracker)) {
            return true;
        }
        double length_a = polygon_a.calculateLength2D();
        double length_b = polygon_b.calculateLength2D();
        int max_vertices = Math.max(polygon_a.getPointCount(), polygon_b.getPointCount());
        if (Math.abs(length_a - length_b) > (double)max_vertices * 4.0 * tolerance) {
            return false;
        }
        return RelationalOperations.linearPathEqualsLinearPath_(polygon_a, polygon_b, tolerance, true);
    }

    private static boolean polygonDisjointPolygon_(Polygon polygon_a, Polygon polygon_b, double tolerance, ProgressTracker progress_tracker) {
        int relation = RelationalOperations.tryRasterizedContainsOrDisjoint_(polygon_a, polygon_b, tolerance, true);
        if (relation == 4) {
            return true;
        }
        if (relation == 1 || relation == 2 || relation == 0x40000000) {
            return false;
        }
        return RelationalOperations.polygonDisjointMultiPath_(polygon_a, polygon_b, tolerance, progress_tracker);
    }

    private static boolean polygonTouchesPolygon_(Polygon polygon_a, Polygon polygon_b, double tolerance, ProgressTracker progress_tracker) {
        int relation = RelationalOperations.tryRasterizedContainsOrDisjoint_(polygon_a, polygon_b, tolerance, false);
        if (relation == 4 || relation == 1 || relation == 2) {
            return false;
        }
        return RelationalOperations.polygonTouchesPolygonImpl_(polygon_a, polygon_b, tolerance, null);
    }

    private static boolean polygonOverlapsPolygon_(Polygon polygon_a, Polygon polygon_b, double tolerance, ProgressTracker progress_tracker) {
        int relation = RelationalOperations.tryRasterizedContainsOrDisjoint_(polygon_a, polygon_b, tolerance, false);
        if (relation == 4 || relation == 1 || relation == 2) {
            return false;
        }
        return RelationalOperations.polygonOverlapsPolygonImpl_(polygon_a, polygon_b, tolerance, progress_tracker);
    }

    private static boolean polygonContainsPolygon_(Polygon polygon_a, Polygon polygon_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polygon_a.queryEnvelope2D(env_a);
        polygon_b.queryEnvelope2D(env_b);
        if (!RelationalOperations.envelopeInfContainsEnvelope_(env_a, env_b, tolerance)) {
            return false;
        }
        int relation = RelationalOperations.tryRasterizedContainsOrDisjoint_(polygon_a, polygon_b, tolerance, false);
        if (relation == 4 || relation == 2) {
            return false;
        }
        if (relation == 1) {
            return true;
        }
        return RelationalOperations.polygonContainsPolygonImpl_(polygon_a, polygon_b, tolerance, progress_tracker);
    }

    private static boolean polygonDisjointPolyline_(Polygon polygon_a, Polyline polyline_b, double tolerance, ProgressTracker progress_tracker) {
        int relation = RelationalOperations.tryRasterizedContainsOrDisjoint_(polygon_a, polyline_b, tolerance, true);
        if (relation == 4) {
            return true;
        }
        if (relation == 1 || relation == 0x40000000) {
            return false;
        }
        return RelationalOperations.polygonDisjointMultiPath_(polygon_a, polyline_b, tolerance, progress_tracker);
    }

    private static boolean polygonTouchesPolyline_(Polygon polygon_a, Polyline polyline_b, double tolerance, ProgressTracker progress_tracker) {
        int relation = RelationalOperations.tryRasterizedContainsOrDisjoint_(polygon_a, polyline_b, tolerance, false);
        if (relation == 4 || relation == 1) {
            return false;
        }
        return RelationalOperations.polygonTouchesPolylineImpl_(polygon_a, polyline_b, tolerance, progress_tracker);
    }

    private static boolean polygonCrossesPolyline_(Polygon polygon_a, Polyline polyline_b, double tolerance, ProgressTracker progress_tracker) {
        int relation = RelationalOperations.tryRasterizedContainsOrDisjoint_(polygon_a, polyline_b, tolerance, false);
        if (relation == 4 || relation == 1) {
            return false;
        }
        return RelationalOperations.polygonCrossesPolylineImpl_(polygon_a, polyline_b, tolerance, null);
    }

    private static boolean polygonContainsPolyline_(Polygon polygon_a, Polyline polyline_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polygon_a.queryEnvelope2D(env_a);
        polyline_b.queryEnvelope2D(env_b);
        if (!RelationalOperations.envelopeInfContainsEnvelope_(env_a, env_b, tolerance)) {
            return false;
        }
        int relation = RelationalOperations.tryRasterizedContainsOrDisjoint_(polygon_a, polyline_b, tolerance, false);
        if (relation == 4) {
            return false;
        }
        if (relation == 1) {
            return true;
        }
        return RelationalOperations.polygonContainsPolylineImpl_(polygon_a, polyline_b, tolerance, progress_tracker);
    }

    private static boolean polygonDisjointPoint_(Polygon polygon_a, Point point_b, double tolerance, ProgressTracker progress_tracker) {
        PolygonUtils.PiPResult result = PolygonUtils.isPointInPolygon2D(polygon_a, point_b, tolerance);
        return result == PolygonUtils.PiPResult.PiPOutside;
    }

    private static boolean polygonTouchesPoint_(Polygon polygon_a, Point point_b, double tolerance, ProgressTracker progress_tracker) {
        Point2D pt_b = point_b.getXY();
        return RelationalOperations.polygonTouchesPointImpl_(polygon_a, pt_b, tolerance, null);
    }

    private static boolean polygonContainsPoint_(Polygon polygon_a, Point point_b, double tolerance, ProgressTracker progress_tracker) {
        Point2D pt_b = point_b.getXY();
        return RelationalOperations.polygonContainsPointImpl_(polygon_a, pt_b, tolerance, progress_tracker);
    }

    private static boolean polygonDisjointMultiPoint_(Polygon polygon_a, MultiPoint multipoint_b, double tolerance, boolean bIncludeBoundaryA, ProgressTracker progress_tracker) {
        int relation = RelationalOperations.tryRasterizedContainsOrDisjoint_(polygon_a, multipoint_b, tolerance, false);
        if (relation == 4) {
            return true;
        }
        if (relation == 1) {
            return false;
        }
        Envelope2D env_a_inflated = new Envelope2D();
        polygon_a.queryEnvelope2D(env_a_inflated);
        env_a_inflated.inflate(tolerance, tolerance);
        Point2D ptB = new Point2D();
        for (int i = 0; i < multipoint_b.getPointCount(); ++i) {
            PolygonUtils.PiPResult result;
            multipoint_b.getXY(i, ptB);
            if (!env_a_inflated.contains(ptB) || (result = PolygonUtils.isPointInPolygon2D(polygon_a, ptB, tolerance)) != PolygonUtils.PiPResult.PiPInside && (!bIncludeBoundaryA || result != PolygonUtils.PiPResult.PiPBoundary)) continue;
            return false;
        }
        return true;
    }

    private static boolean polygonTouchesMultiPoint_(Polygon polygon_a, MultiPoint multipoint_b, double tolerance, ProgressTracker progress_tracker) {
        int relation = RelationalOperations.tryRasterizedContainsOrDisjoint_(polygon_a, multipoint_b, tolerance, false);
        if (relation == 4 || relation == 1) {
            return false;
        }
        Envelope2D env_a_inflated = new Envelope2D();
        polygon_a.queryEnvelope2D(env_a_inflated);
        env_a_inflated.inflate(tolerance, tolerance);
        boolean b_boundary = false;
        MultiPathImpl polygon_a_impl = (MultiPathImpl)polygon_a._getImpl();
        Polygon pa = null;
        Polygon p_polygon_a = polygon_a;
        boolean b_checked_polygon_a_quad_tree = false;
        for (int i = 0; i < multipoint_b.getPointCount(); ++i) {
            Point2D ptB = multipoint_b.getXY(i);
            if (env_a_inflated.contains(ptB)) {
                PolygonUtils.PiPResult result = PolygonUtils.isPointInPolygon2D(p_polygon_a, ptB, tolerance);
                if (result == PolygonUtils.PiPResult.PiPBoundary) {
                    b_boundary = true;
                } else if (result == PolygonUtils.PiPResult.PiPInside) {
                    return false;
                }
            }
            if (b_checked_polygon_a_quad_tree) continue;
            if (PointInPolygonHelper.quadTreeWillHelp(polygon_a, multipoint_b.getPointCount() - 1) && (polygon_a_impl._getAccelerators() == null || polygon_a_impl._getAccelerators().getQuadTree() == null)) {
                pa = new Polygon();
                polygon_a.copyTo(pa);
                ((MultiPathImpl)pa._getImpl())._buildQuadTreeAccelerator(Geometry.GeometryAccelerationDegree.enumMedium);
                p_polygon_a = pa;
            } else {
                p_polygon_a = polygon_a;
            }
            b_checked_polygon_a_quad_tree = true;
        }
        return b_boundary;
    }

    private static boolean polygonCrossesMultiPoint_(Polygon polygon_a, MultiPoint multipoint_b, double tolerance, ProgressTracker progress_tracker) {
        int relation = RelationalOperations.tryRasterizedContainsOrDisjoint_(polygon_a, multipoint_b, tolerance, false);
        if (relation == 4 || relation == 1) {
            return false;
        }
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_a_inflated = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polygon_a.queryEnvelope2D(env_a);
        multipoint_b.queryEnvelope2D(env_b);
        env_a_inflated.setCoords(env_a);
        env_a_inflated.inflate(tolerance, tolerance);
        boolean b_interior = false;
        boolean b_exterior = false;
        MultiPathImpl polygon_a_impl = (MultiPathImpl)polygon_a._getImpl();
        Polygon pa = null;
        Polygon p_polygon_a = polygon_a;
        boolean b_checked_polygon_a_quad_tree = false;
        for (int i = 0; i < multipoint_b.getPointCount(); ++i) {
            Point2D pt_b = multipoint_b.getXY(i);
            if (!env_a_inflated.contains(pt_b)) {
                b_exterior = true;
            } else {
                PolygonUtils.PiPResult result = PolygonUtils.isPointInPolygon2D(p_polygon_a, pt_b, tolerance);
                if (result == PolygonUtils.PiPResult.PiPOutside) {
                    b_exterior = true;
                } else if (result == PolygonUtils.PiPResult.PiPInside) {
                    b_interior = true;
                }
            }
            if (b_interior && b_exterior) {
                return true;
            }
            if (b_checked_polygon_a_quad_tree) continue;
            if (PointInPolygonHelper.quadTreeWillHelp(polygon_a, multipoint_b.getPointCount() - 1) && (polygon_a_impl._getAccelerators() == null || polygon_a_impl._getAccelerators().getQuadTree() == null)) {
                pa = new Polygon();
                polygon_a.copyTo(pa);
                ((MultiPathImpl)pa._getImpl())._buildQuadTreeAccelerator(Geometry.GeometryAccelerationDegree.enumMedium);
                p_polygon_a = pa;
            } else {
                p_polygon_a = polygon_a;
            }
            b_checked_polygon_a_quad_tree = true;
        }
        return false;
    }

    private static boolean polygonContainsMultiPoint_(Polygon polygon_a, MultiPoint multipoint_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polygon_a.queryEnvelope2D(env_a);
        multipoint_b.queryEnvelope2D(env_b);
        if (!RelationalOperations.envelopeInfContainsEnvelope_(env_a, env_b, tolerance)) {
            return false;
        }
        int relation = RelationalOperations.tryRasterizedContainsOrDisjoint_(polygon_a, multipoint_b, tolerance, false);
        if (relation == 4) {
            return false;
        }
        if (relation == 1) {
            return true;
        }
        boolean b_interior = false;
        MultiPathImpl polygon_a_impl = (MultiPathImpl)polygon_a._getImpl();
        Polygon pa = null;
        Polygon p_polygon_a = polygon_a;
        boolean b_checked_polygon_a_quad_tree = false;
        for (int i = 0; i < multipoint_b.getPointCount(); ++i) {
            Point2D ptB = multipoint_b.getXY(i);
            if (!env_a.contains(ptB)) {
                return false;
            }
            PolygonUtils.PiPResult result = PolygonUtils.isPointInPolygon2D(p_polygon_a, ptB, tolerance);
            if (result == PolygonUtils.PiPResult.PiPInside) {
                b_interior = true;
            } else if (result == PolygonUtils.PiPResult.PiPOutside) {
                return false;
            }
            if (b_checked_polygon_a_quad_tree) continue;
            if (PointInPolygonHelper.quadTreeWillHelp(polygon_a, multipoint_b.getPointCount() - 1) && (polygon_a_impl._getAccelerators() == null || polygon_a_impl._getAccelerators().getQuadTree() == null)) {
                pa = new Polygon();
                polygon_a.copyTo(pa);
                ((MultiPathImpl)pa._getImpl())._buildQuadTreeAccelerator(Geometry.GeometryAccelerationDegree.enumMedium);
                p_polygon_a = pa;
            } else {
                p_polygon_a = polygon_a;
            }
            b_checked_polygon_a_quad_tree = true;
        }
        return b_interior;
    }

    private static boolean polygonEqualsEnvelope_(Polygon polygon_a, Envelope envelope_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polygon_a.queryEnvelope2D(env_a);
        envelope_b.queryEnvelope2D(env_b);
        if (!RelationalOperations.envelopeEqualsEnvelope_(env_a, env_b, tolerance, progress_tracker)) {
            return false;
        }
        Polygon polygon_b = new Polygon();
        polygon_b.addEnvelope(envelope_b, false);
        return RelationalOperations.linearPathEqualsLinearPath_(polygon_a, polygon_b, tolerance, true);
    }

    private static boolean polygonDisjointEnvelope_(Polygon polygon_a, Envelope envelope_b, double tolerance, ProgressTracker progress_tracker) {
        int relation = RelationalOperations.tryRasterizedContainsOrDisjoint_(polygon_a, envelope_b, tolerance, false);
        if (relation == 4) {
            return true;
        }
        if (relation == 1 || relation == 2) {
            return false;
        }
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polygon_a.queryEnvelope2D(env_a);
        envelope_b.queryEnvelope2D(env_b);
        if (RelationalOperations.envelopeInfContainsEnvelope_(env_b, env_a, tolerance)) {
            return false;
        }
        Point2D pt_b = new Point2D();
        env_b.queryLowerLeft(pt_b);
        PolygonUtils.PiPResult pipres = PolygonUtils.isPointInPolygon2D(polygon_a, pt_b, tolerance);
        if (pipres != PolygonUtils.PiPResult.PiPOutside) {
            return false;
        }
        env_b.queryLowerRight(pt_b);
        pipres = PolygonUtils.isPointInPolygon2D(polygon_a, pt_b, tolerance);
        if (pipres != PolygonUtils.PiPResult.PiPOutside) {
            return false;
        }
        env_b.queryUpperRight(pt_b);
        pipres = PolygonUtils.isPointInPolygon2D(polygon_a, pt_b, tolerance);
        if (pipres != PolygonUtils.PiPResult.PiPOutside) {
            return false;
        }
        env_b.queryUpperLeft(pt_b);
        pipres = PolygonUtils.isPointInPolygon2D(polygon_a, pt_b, tolerance);
        if (pipres != PolygonUtils.PiPResult.PiPOutside) {
            return false;
        }
        MultiPathImpl mimpl_a = (MultiPathImpl)polygon_a._getImpl();
        AttributeStreamOfDbl pos = (AttributeStreamOfDbl)mimpl_a.getAttributeStreamRef(0);
        Envelope2D env_b_inflated = new Envelope2D();
        env_b_inflated.setCoords(env_b);
        env_b_inflated.inflate(tolerance, tolerance);
        int n = mimpl_a.getPointCount();
        for (int ptIndex = 0; ptIndex < n; ++ptIndex) {
            double y;
            double x = pos.read(2 * ptIndex);
            if (!env_b_inflated.contains(x, y = pos.read(2 * ptIndex + 1))) continue;
            return false;
        }
        return !RelationalOperations.linearPathIntersectsEnvelope_(polygon_a, env_b, tolerance, progress_tracker);
    }

    private static boolean polygonTouchesEnvelope_(Polygon polygon_a, Envelope envelope_b, double tolerance, ProgressTracker progress_tracker) {
        int relation = RelationalOperations.tryRasterizedContainsOrDisjoint_(polygon_a, envelope_b, tolerance, false);
        if (relation == 4 || relation == 1 || relation == 2) {
            return false;
        }
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polygon_a.queryEnvelope2D(env_a);
        envelope_b.queryEnvelope2D(env_b);
        if (RelationalOperations.envelopeInfContainsEnvelope_(env_b, env_a, tolerance)) {
            return false;
        }
        if (env_b.getWidth() <= tolerance && env_b.getHeight() <= tolerance) {
            Point2D pt_b = envelope_b.getCenterXY();
            return RelationalOperations.polygonTouchesPointImpl_(polygon_a, pt_b, tolerance, progress_tracker);
        }
        if (env_b.getWidth() <= tolerance || env_b.getHeight() <= tolerance) {
            Polyline polyline_b = new Polyline();
            Point p = new Point();
            envelope_b.queryCornerByVal(0, p);
            polyline_b.startPath(p);
            envelope_b.queryCornerByVal(2, p);
            polyline_b.lineTo(p);
            return RelationalOperations.polygonTouchesPolylineImpl_(polygon_a, polyline_b, tolerance, progress_tracker);
        }
        Polygon polygon_b = new Polygon();
        polygon_b.addEnvelope(envelope_b, false);
        return RelationalOperations.polygonTouchesPolygonImpl_(polygon_a, polygon_b, tolerance, progress_tracker);
    }

    private static boolean polygonOverlapsEnvelope_(Polygon polygon_a, Envelope envelope_b, double tolerance, ProgressTracker progress_tracker) {
        int relation = RelationalOperations.tryRasterizedContainsOrDisjoint_(polygon_a, envelope_b, tolerance, false);
        if (relation == 4 || relation == 1 || relation == 2) {
            return false;
        }
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polygon_a.queryEnvelope2D(env_a);
        envelope_b.queryEnvelope2D(env_b);
        if (RelationalOperations.envelopeInfContainsEnvelope_(env_b, env_a, tolerance)) {
            return false;
        }
        if (env_b.getWidth() <= tolerance || env_b.getHeight() <= tolerance) {
            return false;
        }
        Polygon polygon_b = new Polygon();
        polygon_b.addEnvelope(envelope_b, false);
        return RelationalOperations.polygonOverlapsPolygonImpl_(polygon_a, polygon_b, tolerance, progress_tracker);
    }

    private static boolean polygonWithinEnvelope_(Polygon polygon_a, Envelope envelope_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polygon_a.queryEnvelope2D(env_a);
        envelope_b.queryEnvelope2D(env_b);
        return RelationalOperations.envelopeInfContainsEnvelope_(env_b, env_a, tolerance);
    }

    private static boolean polygonContainsEnvelope_(Polygon polygon_a, Envelope envelope_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polygon_a.queryEnvelope2D(env_a);
        envelope_b.queryEnvelope2D(env_b);
        if (!RelationalOperations.envelopeInfContainsEnvelope_(env_a, env_b, tolerance)) {
            return false;
        }
        int relation = RelationalOperations.tryRasterizedContainsOrDisjoint_(polygon_a, envelope_b, tolerance, false);
        if (relation == 4 || relation == 2) {
            return false;
        }
        if (relation == 1) {
            return true;
        }
        if (env_b.getWidth() <= tolerance && env_b.getHeight() <= tolerance) {
            Point2D pt_b = envelope_b.getCenterXY();
            return RelationalOperations.polygonContainsPointImpl_(polygon_a, pt_b, tolerance, progress_tracker);
        }
        if (env_b.getWidth() <= tolerance || env_b.getHeight() <= tolerance) {
            Polyline polyline_b = new Polyline();
            Point p = new Point();
            envelope_b.queryCornerByVal(0, p);
            polyline_b.startPath(p);
            envelope_b.queryCornerByVal(2, p);
            polyline_b.lineTo(p);
            return RelationalOperations.polygonContainsPolylineImpl_(polygon_a, polyline_b, tolerance, null);
        }
        Polygon polygon_b = new Polygon();
        polygon_b.addEnvelope(envelope_b, false);
        return RelationalOperations.polygonContainsPolygonImpl_(polygon_a, polygon_b, tolerance, null);
    }

    private static boolean polygonCrossesEnvelope_(Polygon polygon_a, Envelope envelope_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polygon_a.queryEnvelope2D(env_a);
        envelope_b.queryEnvelope2D(env_b);
        if (RelationalOperations.envelopeInfContainsEnvelope_(env_b, env_a, tolerance)) {
            return false;
        }
        if (env_b.getHeight() > tolerance && env_b.getWidth() > tolerance) {
            return false;
        }
        if (env_b.getHeight() <= tolerance && env_b.getWidth() <= tolerance) {
            return false;
        }
        Polyline polyline_b = new Polyline();
        Point p = new Point();
        envelope_b.queryCornerByVal(0, p);
        polyline_b.startPath(p);
        envelope_b.queryCornerByVal(2, p);
        polyline_b.lineTo(p);
        return RelationalOperations.polygonCrossesPolylineImpl_(polygon_a, polyline_b, tolerance, progress_tracker);
    }

    private static boolean polylineEqualsPolyline_(Polyline polyline_a, Polyline polyline_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polyline_a.queryEnvelope2D(env_a);
        polyline_b.queryEnvelope2D(env_b);
        if (!RelationalOperations.envelopeEqualsEnvelope_(env_a, env_b, tolerance, progress_tracker)) {
            return false;
        }
        if (RelationalOperations.tryRasterizedContainsOrDisjoint_(polyline_a, polyline_b, tolerance, false) == 4) {
            return false;
        }
        if (RelationalOperations.multiPathExactlyEqualsMultiPath_(polyline_a, polyline_b, tolerance, progress_tracker)) {
            return true;
        }
        return RelationalOperations.linearPathEqualsLinearPath_(polyline_a, polyline_b, tolerance, false);
    }

    private static boolean polylineDisjointPolyline_(Polyline polyline_a, Polyline polyline_b, double tolerance, ProgressTracker progress_tracker) {
        MultiPathImpl multi_path_impl_b;
        if (RelationalOperations.tryRasterizedContainsOrDisjoint_(polyline_a, polyline_b, tolerance, false) == 4) {
            return true;
        }
        MultiPathImpl multi_path_impl_a = (MultiPathImpl)polyline_a._getImpl();
        PairwiseIntersectorImpl intersector_paths = new PairwiseIntersectorImpl(multi_path_impl_a, multi_path_impl_b = (MultiPathImpl)polyline_b._getImpl(), tolerance, true);
        if (!intersector_paths.next()) {
            return false;
        }
        return !RelationalOperations.linearPathIntersectsLinearPath_(polyline_a, polyline_b, tolerance);
    }

    private static boolean polylineTouchesPolyline_(Polyline polyline_a, Polyline polyline_b, double tolerance, ProgressTracker progress_tracker) {
        if (RelationalOperations.tryRasterizedContainsOrDisjoint_(polyline_a, polyline_b, tolerance, false) == 4) {
            return false;
        }
        AttributeStreamOfDbl intersections = new AttributeStreamOfDbl(0);
        int dim = RelationalOperations.linearPathIntersectsLinearPathMaxDim_(polyline_a, polyline_b, tolerance, intersections);
        if (dim != 0) {
            return false;
        }
        MultiPoint intersection = new MultiPoint();
        for (int i = 0; i < intersections.size(); i += 2) {
            double x = intersections.read(i);
            double y = intersections.read(i + 1);
            intersection.add(x, y);
        }
        MultiPoint boundary_a_b = (MultiPoint)polyline_a.getBoundary();
        MultiPoint boundary_b = (MultiPoint)polyline_b.getBoundary();
        boundary_a_b.add(boundary_b, 0, boundary_b.getPointCount());
        return RelationalOperations.multiPointContainsMultiPointBrute_(boundary_a_b, intersection, tolerance);
    }

    private static boolean polylineCrossesPolyline_(Polyline polyline_a, Polyline polyline_b, double tolerance, ProgressTracker progress_tracker) {
        if (RelationalOperations.tryRasterizedContainsOrDisjoint_(polyline_a, polyline_b, tolerance, false) == 4) {
            return false;
        }
        AttributeStreamOfDbl intersections = new AttributeStreamOfDbl(0);
        int dim = RelationalOperations.linearPathIntersectsLinearPathMaxDim_(polyline_a, polyline_b, tolerance, intersections);
        if (dim != 0) {
            return false;
        }
        MultiPoint intersection = new MultiPoint();
        for (int i = 0; i < intersections.size(); i += 2) {
            double x = intersections.read(i);
            double y = intersections.read(i + 1);
            intersection.add(x, y);
        }
        MultiPoint boundary_a_b = (MultiPoint)polyline_a.getBoundary();
        MultiPoint boundary_b = (MultiPoint)polyline_b.getBoundary();
        boundary_a_b.add(boundary_b, 0, boundary_b.getPointCount());
        return !RelationalOperations.multiPointContainsMultiPointBrute_(boundary_a_b, intersection, tolerance);
    }

    private static boolean polylineOverlapsPolyline_(Polyline polyline_a, Polyline polyline_b, double tolerance, ProgressTracker progress_tracker) {
        if (RelationalOperations.tryRasterizedContainsOrDisjoint_(polyline_a, polyline_b, tolerance, false) == 4) {
            return false;
        }
        return RelationalOperations.linearPathOverlapsLinearPath_(polyline_a, polyline_b, tolerance);
    }

    private static boolean polylineContainsPolyline_(Polyline polyline_a, Polyline polyline_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polyline_a.queryEnvelope2D(env_a);
        polyline_b.queryEnvelope2D(env_b);
        if (!RelationalOperations.envelopeInfContainsEnvelope_(env_a, env_b, tolerance)) {
            return false;
        }
        if (RelationalOperations.tryRasterizedContainsOrDisjoint_(polyline_a, polyline_b, tolerance, false) == 4) {
            return false;
        }
        return RelationalOperations.linearPathWithinLinearPath_(polyline_b, polyline_a, tolerance, false);
    }

    private static boolean polylineDisjointPoint_(Polyline polyline_a, Point point_b, double tolerance, ProgressTracker progress_tracker) {
        if (RelationalOperations.tryRasterizedContainsOrDisjoint_(polyline_a, point_b, tolerance, false) == 4) {
            return true;
        }
        Point2D pt_b = point_b.getXY();
        return !RelationalOperations.linearPathIntersectsPoint_(polyline_a, pt_b, tolerance);
    }

    private static boolean polylineTouchesPoint_(Polyline polyline_a, Point point_b, double tolerance, ProgressTracker progress_tracker) {
        if (RelationalOperations.tryRasterizedContainsOrDisjoint_(polyline_a, point_b, tolerance, false) == 4) {
            return false;
        }
        Point2D pt_b = point_b.getXY();
        return RelationalOperations.linearPathTouchesPointImpl_(polyline_a, pt_b, tolerance);
    }

    private static boolean polylineContainsPoint_(Polyline polyline_a, Point point_b, double tolerance, ProgressTracker progress_tracker) {
        if (RelationalOperations.tryRasterizedContainsOrDisjoint_(polyline_a, point_b, tolerance, false) == 4) {
            return false;
        }
        Point2D pt_b = point_b.getXY();
        return RelationalOperations.linearPathContainsPoint_(polyline_a, pt_b, tolerance);
    }

    private static boolean polylineDisjointMultiPoint_(Polyline polyline_a, MultiPoint multipoint_b, double tolerance, ProgressTracker progress_tracker) {
        if (RelationalOperations.tryRasterizedContainsOrDisjoint_(polyline_a, multipoint_b, tolerance, false) == 4) {
            return true;
        }
        return !RelationalOperations.linearPathIntersectsMultiPoint_(polyline_a, multipoint_b, tolerance, false);
    }

    private static boolean polylineTouchesMultiPoint_(Polyline polyline_a, MultiPoint multipoint_b, double tolerance, ProgressTracker progress_tracker) {
        int i;
        if (RelationalOperations.tryRasterizedContainsOrDisjoint_(polyline_a, multipoint_b, tolerance, false) == 4) {
            return false;
        }
        SegmentIteratorImpl segIterA = ((MultiPathImpl)polyline_a._getImpl()).querySegmentIterator();
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        Envelope2D envInter = new Envelope2D();
        polyline_a.queryEnvelope2D(env_a);
        multipoint_b.queryEnvelope2D(env_b);
        env_a.inflate(tolerance, tolerance);
        env_b.inflate(tolerance, tolerance);
        envInter.setCoords(env_a);
        envInter.intersect(env_b);
        QuadTreeImpl qtA = null;
        QuadTreeImpl quadTreeA = null;
        QuadTreeImpl quadTreePathsA = null;
        GeometryAccelerators accel = ((MultiPathImpl)polyline_a._getImpl())._getAccelerators();
        if (accel != null) {
            quadTreeA = accel.getQuadTree();
            quadTreePathsA = accel.getQuadTreeForPaths();
            if (quadTreeA == null) {
                quadTreeA = qtA = InternalUtils.buildQuadTree((MultiPathImpl)polyline_a._getImpl(), envInter);
            }
        } else {
            quadTreeA = qtA = InternalUtils.buildQuadTree((MultiPathImpl)polyline_a._getImpl(), envInter);
        }
        QuadTreeImpl.QuadTreeIteratorImpl qtIterA = quadTreeA.getIterator();
        QuadTreeImpl.QuadTreeIteratorImpl qtIterPathsA = null;
        if (quadTreePathsA != null) {
            qtIterPathsA = quadTreePathsA.getIterator();
        }
        Point2D ptB = new Point2D();
        Point2D closest = new Point2D();
        boolean b_intersects = false;
        double toleranceSq = tolerance * tolerance;
        AttributeStreamOfInt8 intersects = new AttributeStreamOfInt8(multipoint_b.getPointCount());
        for (i = 0; i < multipoint_b.getPointCount(); ++i) {
            intersects.write(i, (byte)0);
        }
        block1: for (i = 0; i < multipoint_b.getPointCount(); ++i) {
            multipoint_b.getXY(i, ptB);
            if (!envInter.contains(ptB)) continue;
            env_b.setCoords(ptB.x, ptB.y, ptB.x, ptB.y);
            if (qtIterPathsA != null) {
                qtIterPathsA.resetIterator(env_b, tolerance);
                if (qtIterPathsA.next() == -1) continue;
            }
            qtIterA.resetIterator(env_b, tolerance);
            int elementHandleA = qtIterA.next();
            while (elementHandleA != -1) {
                int vertex_a = quadTreeA.getElement(elementHandleA);
                segIterA.resetToVertex(vertex_a);
                Segment segmentA = segIterA.nextSegment();
                double t = segmentA.getClosestCoordinate(ptB, false);
                segmentA.getCoord2D(t, closest);
                if (Point2D.sqrDistance(ptB, closest) <= toleranceSq) {
                    intersects.write(i, (byte)1);
                    b_intersects = true;
                    continue block1;
                }
                elementHandleA = qtIterA.next();
            }
        }
        if (!b_intersects) {
            return false;
        }
        MultiPoint boundary_a = (MultiPoint)polyline_a.getBoundary();
        MultiPoint multipoint_b_inter = new MultiPoint();
        Point2D pt = new Point2D();
        for (int i2 = 0; i2 < multipoint_b.getPointCount(); ++i2) {
            if (intersects.read(i2) == 0) continue;
            multipoint_b.getXY(i2, pt);
            multipoint_b_inter.add(pt.x, pt.y);
        }
        return RelationalOperations.multiPointContainsMultiPointBrute_(boundary_a, multipoint_b_inter, tolerance);
    }

    private static boolean polylineCrossesMultiPoint_(Polyline polyline_a, MultiPoint multipoint_b, double tolerance, ProgressTracker progress_tracker) {
        int i;
        if (RelationalOperations.tryRasterizedContainsOrDisjoint_(polyline_a, multipoint_b, tolerance, false) == 4) {
            return false;
        }
        SegmentIteratorImpl segIterA = ((MultiPathImpl)polyline_a._getImpl()).querySegmentIterator();
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        Envelope2D envInter = new Envelope2D();
        polyline_a.queryEnvelope2D(env_a);
        multipoint_b.queryEnvelope2D(env_b);
        env_a.inflate(tolerance, tolerance);
        env_b.inflate(tolerance, tolerance);
        envInter.setCoords(env_a);
        envInter.intersect(env_b);
        QuadTreeImpl qtA = null;
        QuadTreeImpl quadTreeA = null;
        QuadTreeImpl quadTreePathsA = null;
        GeometryAccelerators accel = ((MultiPathImpl)polyline_a._getImpl())._getAccelerators();
        if (accel != null) {
            quadTreeA = accel.getQuadTree();
            quadTreePathsA = accel.getQuadTreeForPaths();
            if (quadTreeA == null) {
                quadTreeA = qtA = InternalUtils.buildQuadTree((MultiPathImpl)polyline_a._getImpl(), envInter);
            }
        } else {
            quadTreeA = qtA = InternalUtils.buildQuadTree((MultiPathImpl)polyline_a._getImpl(), envInter);
        }
        QuadTreeImpl.QuadTreeIteratorImpl qtIterA = quadTreeA.getIterator();
        QuadTreeImpl.QuadTreeIteratorImpl qtIterPathsA = null;
        if (quadTreePathsA != null) {
            qtIterPathsA = quadTreePathsA.getIterator();
        }
        Point2D ptB = new Point2D();
        Point2D closest = new Point2D();
        boolean b_intersects = false;
        boolean b_exterior_found = false;
        double toleranceSq = tolerance * tolerance;
        AttributeStreamOfInt8 intersects = new AttributeStreamOfInt8(multipoint_b.getPointCount());
        for (i = 0; i < multipoint_b.getPointCount(); ++i) {
            intersects.write(i, (byte)0);
        }
        for (i = 0; i < multipoint_b.getPointCount(); ++i) {
            multipoint_b.getXY(i, ptB);
            if (!envInter.contains(ptB)) {
                b_exterior_found = true;
                continue;
            }
            env_b.setCoords(ptB.x, ptB.y, ptB.x, ptB.y);
            if (qtIterPathsA != null) {
                qtIterPathsA.resetIterator(env_b, tolerance);
                if (qtIterPathsA.next() == -1) {
                    b_exterior_found = true;
                    continue;
                }
            }
            qtIterA.resetIterator(env_b, tolerance);
            boolean b_covered = false;
            int elementHandleA = qtIterA.next();
            while (elementHandleA != -1) {
                int vertex_a = quadTreeA.getElement(elementHandleA);
                segIterA.resetToVertex(vertex_a);
                Segment segmentA = segIterA.nextSegment();
                double t = segmentA.getClosestCoordinate(ptB, false);
                segmentA.getCoord2D(t, closest);
                if (Point2D.sqrDistance(ptB, closest) <= toleranceSq) {
                    intersects.write(i, (byte)1);
                    b_intersects = true;
                    b_covered = true;
                    break;
                }
                elementHandleA = qtIterA.next();
            }
            if (b_covered) continue;
            b_exterior_found = true;
        }
        if (!b_intersects || !b_exterior_found) {
            return false;
        }
        MultiPoint boundary_a = (MultiPoint)polyline_a.getBoundary();
        MultiPoint multipoint_b_inter = new MultiPoint();
        Point2D pt = new Point2D();
        for (int i2 = 0; i2 < multipoint_b.getPointCount(); ++i2) {
            if (intersects.read(i2) == 0) continue;
            multipoint_b.getXY(i2, pt);
            multipoint_b_inter.add(pt.x, pt.y);
        }
        return !RelationalOperations.multiPointContainsMultiPointBrute_(boundary_a, multipoint_b_inter, tolerance);
    }

    private static boolean polylineContainsMultiPoint_(Polyline polyline_a, MultiPoint multipoint_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polyline_a.queryEnvelope2D(env_a);
        multipoint_b.queryEnvelope2D(env_b);
        if (!RelationalOperations.envelopeInfContainsEnvelope_(env_a, env_b, tolerance)) {
            return false;
        }
        if (RelationalOperations.tryRasterizedContainsOrDisjoint_(polyline_a, multipoint_b, tolerance, false) == 4) {
            return false;
        }
        if (!RelationalOperations.linearPathIntersectsMultiPoint_(polyline_a, multipoint_b, tolerance, true)) {
            return false;
        }
        MultiPoint boundary_a = (MultiPoint)polyline_a.getBoundary();
        return !RelationalOperations.multiPointIntersectsMultiPoint_(boundary_a, multipoint_b, tolerance, progress_tracker);
    }

    private static boolean polylineEqualsEnvelope_(Polyline polyline_a, Envelope envelope_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polyline_a.queryEnvelope2D(env_a);
        envelope_b.queryEnvelope2D(env_b);
        if (env_b.getHeight() > tolerance && env_b.getWidth() > tolerance) {
            return false;
        }
        return RelationalOperations.envelopeEqualsEnvelope_(env_a, env_b, tolerance, progress_tracker);
    }

    private static boolean polylineDisjointEnvelope_(Polyline polyline_a, Envelope envelope_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polyline_a.queryEnvelope2D(env_a);
        envelope_b.queryEnvelope2D(env_b);
        if (RelationalOperations.envelopeInfContainsEnvelope_(env_b, env_a, tolerance)) {
            return false;
        }
        return !RelationalOperations.linearPathIntersectsEnvelope_(polyline_a, env_b, tolerance, progress_tracker);
    }

    private static boolean polylineTouchesEnvelope_(Polyline polyline_a, Envelope envelope_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polyline_a.queryEnvelope2D(env_a);
        envelope_b.queryEnvelope2D(env_b);
        if (env_b.getHeight() <= tolerance && env_b.getWidth() <= tolerance) {
            Point2D pt_b = envelope_b.getCenterXY();
            return RelationalOperations.linearPathTouchesPointImpl_(polyline_a, pt_b, tolerance);
        }
        if (env_b.getHeight() <= tolerance || env_b.getWidth() <= tolerance) {
            Polyline polyline_b = new Polyline();
            Point p = new Point();
            envelope_b.queryCornerByVal(0, p);
            polyline_b.startPath(p);
            envelope_b.queryCornerByVal(2, p);
            polyline_b.lineTo(p);
            return RelationalOperations.polylineTouchesPolyline_(polyline_a, polyline_b, tolerance, progress_tracker);
        }
        SegmentIterator seg_iter_a = polyline_a.querySegmentIterator();
        Envelope2D env_b_deflated = new Envelope2D();
        Envelope2D env_b_inflated = new Envelope2D();
        env_b_deflated.setCoords(env_b);
        env_b_inflated.setCoords(env_b);
        env_b_deflated.inflate(-tolerance, -tolerance);
        env_b_inflated.inflate(tolerance, tolerance);
        boolean b_boundary = false;
        Envelope2D env_segment_a = new Envelope2D();
        Envelope2D env_inter = new Envelope2D();
        while (seg_iter_a.nextPath()) {
            while (seg_iter_a.hasNextSegment()) {
                Segment segment_a = seg_iter_a.nextSegment();
                segment_a.queryEnvelope2D(env_segment_a);
                env_inter.setCoords(env_b_deflated);
                env_inter.intersect(env_segment_a);
                if (!env_inter.isEmpty() && (env_inter.getHeight() > tolerance || env_inter.getWidth() > tolerance)) {
                    return false;
                }
                env_inter.setCoords(env_b_inflated);
                env_inter.intersect(env_segment_a);
                if (env_inter.isEmpty()) continue;
                b_boundary = true;
            }
        }
        return b_boundary;
    }

    private static boolean polylineOverlapsEnvelope_(Polyline polyline_a, Envelope envelope_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polyline_a.queryEnvelope2D(env_a);
        envelope_b.queryEnvelope2D(env_b);
        if (RelationalOperations.envelopeInfContainsEnvelope_(env_a, env_b, tolerance) || RelationalOperations.envelopeInfContainsEnvelope_(env_b, env_a, tolerance)) {
            return false;
        }
        if (RelationalOperations.envelopeInfContainsEnvelope_(env_b, env_a, tolerance)) {
            return false;
        }
        if (env_b.getHeight() > tolerance && env_b.getWidth() > tolerance) {
            return false;
        }
        if (env_b.getHeight() <= tolerance && env_b.getWidth() <= tolerance) {
            return false;
        }
        Polyline polyline_b = new Polyline();
        Point p = new Point();
        envelope_b.queryCornerByVal(0, p);
        polyline_b.startPath(p);
        envelope_b.queryCornerByVal(2, p);
        polyline_b.lineTo(p);
        return RelationalOperations.linearPathOverlapsLinearPath_(polyline_a, polyline_b, tolerance);
    }

    private static boolean polylineWithinEnvelope_(Polyline polyline_a, Envelope envelope_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polyline_a.queryEnvelope2D(env_a);
        envelope_b.queryEnvelope2D(env_b);
        if (!RelationalOperations.envelopeInfContainsEnvelope_(env_b, env_a, tolerance)) {
            return false;
        }
        if (env_b.getHeight() <= tolerance && env_b.getWidth() <= tolerance) {
            return false;
        }
        if (env_b.getHeight() <= tolerance || env_b.getWidth() <= tolerance) {
            return RelationalOperations.envelopeInfContainsEnvelope_(env_b, env_a, tolerance);
        }
        SegmentIterator seg_iter_a = polyline_a.querySegmentIterator();
        Envelope2D env_b_deflated = new Envelope2D();
        env_b_deflated.setCoords(env_b);
        env_b_deflated.inflate(-tolerance, -tolerance);
        boolean b_interior = false;
        Envelope2D env_segment_a = new Envelope2D();
        Envelope2D env_inter = new Envelope2D();
        while (seg_iter_a.nextPath()) {
            while (seg_iter_a.hasNextSegment()) {
                Segment segment_a = seg_iter_a.nextSegment();
                segment_a.queryEnvelope2D(env_segment_a);
                if (env_b_deflated.containsExclusive(env_segment_a)) {
                    b_interior = true;
                    continue;
                }
                env_inter.setCoords(env_b_deflated);
                env_inter.intersect(env_segment_a);
                if (env_inter.isEmpty() || !(env_inter.getHeight() > tolerance) && !(env_inter.getWidth() > tolerance)) continue;
                b_interior = true;
            }
        }
        return b_interior;
    }

    private static boolean polylineContainsEnvelope_(Polyline polyline_a, Envelope envelope_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        envelope_b.queryEnvelope2D(env_b);
        polyline_a.queryEnvelope2D(env_a);
        if (!RelationalOperations.envelopeInfContainsEnvelope_(env_a, env_b, tolerance)) {
            return false;
        }
        if (env_b.getHeight() > tolerance && env_b.getWidth() > tolerance) {
            return false;
        }
        if (env_b.getHeight() <= tolerance && env_b.getWidth() <= tolerance) {
            Point2D pt_b = envelope_b.getCenterXY();
            return RelationalOperations.linearPathContainsPoint_(polyline_a, pt_b, tolerance);
        }
        Polyline polyline_b = new Polyline();
        Point p = new Point();
        envelope_b.queryCornerByVal(0, p);
        polyline_b.startPath(p);
        envelope_b.queryCornerByVal(2, p);
        polyline_b.lineTo(p);
        return RelationalOperations.linearPathWithinLinearPath_(polyline_b, polyline_a, tolerance, false);
    }

    private static boolean polylineCrossesEnvelope_(Polyline polyline_a, Envelope envelope_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        polyline_a.queryEnvelope2D(env_a);
        envelope_b.queryEnvelope2D(env_b);
        if (RelationalOperations.envelopeInfContainsEnvelope_(env_b, env_a, tolerance)) {
            return false;
        }
        if (env_b.getHeight() <= tolerance && env_b.getWidth() <= tolerance) {
            return false;
        }
        if (env_b.getHeight() <= tolerance || env_b.getWidth() <= tolerance) {
            Polyline polyline_b = new Polyline();
            Point p = new Point();
            envelope_b.queryCornerByVal(0, p);
            polyline_b.startPath(p);
            envelope_b.queryCornerByVal(2, p);
            polyline_b.lineTo(p);
            return RelationalOperations.polylineCrossesPolyline_(polyline_a, polyline_b, tolerance, progress_tracker);
        }
        SegmentIterator seg_iter_a = polyline_a.querySegmentIterator();
        Envelope2D env_b_inflated = new Envelope2D();
        Envelope2D env_b_deflated = new Envelope2D();
        env_b_deflated.setCoords(env_b);
        env_b_inflated.setCoords(env_b);
        env_b_deflated.inflate(-tolerance, -tolerance);
        env_b_inflated.inflate(tolerance, tolerance);
        boolean b_interior = false;
        boolean b_exterior = false;
        Envelope2D env_segment_a = new Envelope2D();
        Envelope2D env_inter = new Envelope2D();
        while (seg_iter_a.nextPath()) {
            while (seg_iter_a.hasNextSegment()) {
                Segment segment_a = seg_iter_a.nextSegment();
                segment_a.queryEnvelope2D(env_segment_a);
                if (!b_exterior && !env_b_inflated.contains(env_segment_a)) {
                    b_exterior = true;
                }
                if (!b_interior) {
                    env_inter.setCoords(env_b_deflated);
                    env_inter.intersect(env_segment_a);
                    if (!env_inter.isEmpty() && (env_inter.getHeight() > tolerance || env_inter.getWidth() > tolerance)) {
                        b_interior = true;
                    }
                }
                if (!b_interior || !b_exterior) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean multiPointEqualsMultiPoint_(MultiPoint multipoint_a, MultiPoint multipoint_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        multipoint_a.queryEnvelope2D(env_a);
        multipoint_b.queryEnvelope2D(env_b);
        if (!RelationalOperations.envelopeEqualsEnvelope_(env_a, env_b, tolerance, progress_tracker)) {
            return false;
        }
        if (RelationalOperations.multiPointExactlyEqualsMultiPoint_(multipoint_a, multipoint_b, tolerance, progress_tracker)) {
            return true;
        }
        return RelationalOperations.multiPointCoverageMultiPoint_(multipoint_a, multipoint_b, tolerance, false, true, false, progress_tracker);
    }

    private static boolean multiPointDisjointMultiPoint_(MultiPoint multipoint_a, MultiPoint multipoint_b, double tolerance, ProgressTracker progress_tracker) {
        return !RelationalOperations.multiPointIntersectsMultiPoint_(multipoint_a, multipoint_b, tolerance, progress_tracker);
    }

    private static boolean multiPointOverlapsMultiPoint_(MultiPoint multipoint_a, MultiPoint multipoint_b, double tolerance, ProgressTracker progress_tracker) {
        return RelationalOperations.multiPointCoverageMultiPoint_(multipoint_a, multipoint_b, tolerance, false, false, true, progress_tracker);
    }

    private static boolean multiPointContainsMultiPoint_(MultiPoint multipoint_a, MultiPoint multipoint_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        multipoint_a.queryEnvelope2D(env_a);
        multipoint_b.queryEnvelope2D(env_b);
        if (!RelationalOperations.envelopeInfContainsEnvelope_(env_a, env_b, tolerance)) {
            return false;
        }
        return RelationalOperations.multiPointCoverageMultiPoint_(multipoint_b, multipoint_a, tolerance, true, false, false, progress_tracker);
    }

    private static boolean multiPointContainsMultiPointBrute_(MultiPoint multipoint_a, MultiPoint multipoint_b, double tolerance) {
        double tolerance_sq = tolerance * tolerance;
        Point2D pt_a = new Point2D();
        Point2D pt_b = new Point2D();
        for (int i = 0; i < multipoint_b.getPointCount(); ++i) {
            multipoint_b.getXY(i, pt_b);
            boolean b_contained = false;
            for (int j2 = 0; j2 < multipoint_a.getPointCount(); ++j2) {
                multipoint_a.getXY(j2, pt_a);
                if (!(Point2D.sqrDistance(pt_a, pt_b) <= tolerance_sq)) continue;
                b_contained = true;
                break;
            }
            if (b_contained) continue;
            return false;
        }
        return true;
    }

    static boolean multiPointEqualsPoint_(MultiPoint multipoint_a, Point point_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        multipoint_a.queryEnvelope2D(env_a);
        point_b.queryEnvelope2D(env_b);
        return RelationalOperations.envelopeEqualsEnvelope_(env_a, env_b, tolerance, progress_tracker);
    }

    private static boolean multiPointDisjointPoint_(MultiPoint multipoint_a, Point point_b, double tolerance, ProgressTracker progress_tracker) {
        Point2D pt_b = point_b.getXY();
        return RelationalOperations.multiPointDisjointPointImpl_(multipoint_a, pt_b, tolerance, progress_tracker);
    }

    private static boolean multiPointWithinPoint_(MultiPoint multipoint_a, Point point_b, double tolerance, ProgressTracker progress_tracker) {
        return RelationalOperations.multiPointEqualsPoint_(multipoint_a, point_b, tolerance, progress_tracker);
    }

    private static boolean multiPointContainsPoint_(MultiPoint multipoint_a, Point point_b, double tolerance, ProgressTracker progress_tracker) {
        return !RelationalOperations.multiPointDisjointPoint_(multipoint_a, point_b, tolerance, progress_tracker);
    }

    private static boolean multiPointEqualsEnvelope_(MultiPoint multipoint_a, Envelope envelope_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        multipoint_a.queryEnvelope2D(env_a);
        envelope_b.queryEnvelope2D(env_b);
        if (env_b.getHeight() > tolerance || env_b.getWidth() > tolerance) {
            return false;
        }
        return RelationalOperations.envelopeEqualsEnvelope_(env_a, env_b, tolerance, progress_tracker);
    }

    private static boolean multiPointDisjointEnvelope_(MultiPoint multipoint_a, Envelope envelope_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        multipoint_a.queryEnvelope2D(env_a);
        envelope_b.queryEnvelope2D(env_b);
        if (RelationalOperations.envelopeInfContainsEnvelope_(env_b, env_a, tolerance)) {
            return false;
        }
        Envelope2D env_b_inflated = new Envelope2D();
        env_b_inflated.setCoords(env_b);
        env_b_inflated.inflate(tolerance, tolerance);
        Point2D pt_a = new Point2D();
        for (int i = 0; i < multipoint_a.getPointCount(); ++i) {
            multipoint_a.getXY(i, pt_a);
            if (!env_b_inflated.contains(pt_a)) continue;
            return false;
        }
        return true;
    }

    private static boolean multiPointTouchesEnvelope_(MultiPoint multipoint_a, Envelope envelope_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_b = new Envelope2D();
        Envelope2D env_b_inflated = new Envelope2D();
        Envelope2D env_b_deflated = new Envelope2D();
        envelope_b.queryEnvelope2D(env_b);
        if (env_b.getHeight() <= tolerance && env_b.getWidth() <= tolerance) {
            return false;
        }
        if (env_b.getHeight() <= tolerance || env_b.getWidth() <= tolerance) {
            Point2D pt_a = new Point2D();
            boolean b_boundary = false;
            env_b_inflated.setCoords(env_b);
            env_b_deflated.setCoords(env_b);
            env_b_inflated.inflate(tolerance, tolerance);
            if (env_b.getHeight() > tolerance) {
                env_b_deflated.inflate(0.0, -tolerance);
            } else {
                env_b_deflated.inflate(-tolerance, 0.0);
            }
            for (int i = 0; i < multipoint_a.getPointCount(); ++i) {
                multipoint_a.getXY(i, pt_a);
                if (!env_b_inflated.contains(pt_a)) continue;
                if (env_b.getHeight() > tolerance) {
                    if (pt_a.y > env_b_deflated.ymin && pt_a.y < env_b_deflated.ymax) {
                        return false;
                    }
                    b_boundary = true;
                    continue;
                }
                if (pt_a.x > env_b_deflated.xmin && pt_a.x < env_b_deflated.xmax) {
                    return false;
                }
                b_boundary = true;
            }
            return b_boundary;
        }
        env_b_inflated.setCoords(env_b);
        env_b_deflated.setCoords(env_b);
        env_b_inflated.inflate(tolerance, tolerance);
        env_b_deflated.inflate(-tolerance, -tolerance);
        Point2D pt_a = new Point2D();
        boolean b_boundary = false;
        for (int i = 0; i < multipoint_a.getPointCount(); ++i) {
            multipoint_a.getXY(i, pt_a);
            if (!env_b_inflated.contains(pt_a)) continue;
            if (env_b_deflated.containsExclusive(pt_a)) {
                return false;
            }
            b_boundary = true;
        }
        return b_boundary;
    }

    private static boolean multiPointWithinEnvelope_(MultiPoint multipoint_a, Envelope envelope_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        multipoint_a.queryEnvelope2D(env_a);
        envelope_b.queryEnvelope2D(env_b);
        if (!RelationalOperations.envelopeInfContainsEnvelope_(env_b, env_a, tolerance)) {
            return false;
        }
        if (env_b.getHeight() <= tolerance && env_b.getWidth() <= tolerance) {
            return RelationalOperations.envelopeEqualsEnvelope_(env_a, env_b, tolerance, progress_tracker);
        }
        if (env_b.getHeight() <= tolerance || env_b.getWidth() <= tolerance) {
            boolean b_interior = false;
            Envelope2D env_b_deflated = new Envelope2D();
            Envelope2D env_b_inflated = new Envelope2D();
            env_b_deflated.setCoords(env_b);
            env_b_inflated.setCoords(env_b);
            if (env_b.getHeight() > tolerance) {
                env_b_deflated.inflate(0.0, -tolerance);
            } else {
                env_b_deflated.inflate(-tolerance, 0.0);
            }
            env_b_inflated.inflate(tolerance, tolerance);
            Point2D pt_a = new Point2D();
            for (int i = 0; i < multipoint_a.getPointCount(); ++i) {
                multipoint_a.getXY(i, pt_a);
                if (!env_b_inflated.contains(pt_a)) {
                    return false;
                }
                if (env_b.getHeight() > tolerance) {
                    if (!(pt_a.y > env_b_deflated.ymin) || !(pt_a.y < env_b_deflated.ymax)) continue;
                    b_interior = true;
                    continue;
                }
                if (!(pt_a.x > env_b_deflated.xmin) || !(pt_a.x < env_b_deflated.xmax)) continue;
                b_interior = true;
            }
            return b_interior;
        }
        boolean b_interior = false;
        Envelope2D env_b_deflated = new Envelope2D();
        Envelope2D env_b_inflated = new Envelope2D();
        env_b_deflated.setCoords(env_b);
        env_b_inflated.setCoords(env_b);
        env_b_deflated.inflate(-tolerance, -tolerance);
        env_b_inflated.inflate(tolerance, tolerance);
        Point2D pt_a = new Point2D();
        for (int i = 0; i < multipoint_a.getPointCount(); ++i) {
            multipoint_a.getXY(i, pt_a);
            if (!env_b_inflated.contains(pt_a)) {
                return false;
            }
            if (!env_b_deflated.containsExclusive(pt_a)) continue;
            b_interior = true;
        }
        return b_interior;
    }

    private static boolean multiPointContainsEnvelope_(MultiPoint multipoint_a, Envelope envelope_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        multipoint_a.queryEnvelope2D(env_a);
        envelope_b.queryEnvelope2D(env_b);
        if (!RelationalOperations.envelopeInfContainsEnvelope_(env_a, env_b, tolerance)) {
            return false;
        }
        if (env_b.getHeight() > tolerance || env_b.getWidth() > tolerance) {
            return false;
        }
        Point2D pt_b = envelope_b.getCenterXY();
        return !RelationalOperations.multiPointDisjointPointImpl_(multipoint_a, pt_b, tolerance, progress_tracker);
    }

    static boolean multiPointCrossesEnvelope_(MultiPoint multipoint_a, Envelope envelope_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        multipoint_a.queryEnvelope2D(env_a);
        envelope_b.queryEnvelope2D(env_b);
        if (RelationalOperations.envelopeInfContainsEnvelope_(env_b, env_a, tolerance)) {
            return false;
        }
        if (env_b.getHeight() <= tolerance && env_b.getWidth() <= tolerance) {
            return false;
        }
        if (env_b.getHeight() <= tolerance || env_b.getWidth() <= tolerance) {
            Envelope2D env_b_deflated = new Envelope2D();
            Envelope2D env_b_inflated = new Envelope2D();
            env_b_deflated.setCoords(env_b);
            if (env_b.getHeight() > tolerance) {
                env_b_deflated.inflate(0.0, -tolerance);
            } else {
                env_b_deflated.inflate(-tolerance, 0.0);
            }
            env_b_inflated.setCoords(env_b);
            env_b_inflated.inflate(tolerance, tolerance);
            Point2D pt_a = new Point2D();
            boolean b_interior = false;
            boolean b_exterior = false;
            for (int i = 0; i < multipoint_a.getPointCount(); ++i) {
                multipoint_a.getXY(i, pt_a);
                if (!b_interior) {
                    if (env_b.getHeight() > tolerance) {
                        if (pt_a.y > env_b_deflated.ymin && pt_a.y < env_b_deflated.ymax) {
                            b_interior = true;
                        }
                    } else if (pt_a.x > env_b_deflated.xmin && pt_a.x < env_b_deflated.xmax) {
                        b_interior = true;
                    }
                }
                if (!b_exterior && !env_b_inflated.contains(pt_a)) {
                    b_exterior = true;
                }
                if (!b_interior || !b_exterior) continue;
                return true;
            }
            return false;
        }
        Envelope2D env_b_deflated = new Envelope2D();
        Envelope2D env_b_inflated = new Envelope2D();
        env_b_deflated.setCoords(env_b);
        env_b_deflated.inflate(-tolerance, -tolerance);
        assert (!env_b_deflated.isEmpty());
        env_b_inflated.setCoords(env_b);
        env_b_inflated.inflate(tolerance, tolerance);
        Point2D pt_a = new Point2D();
        boolean b_interior = false;
        boolean b_exterior = false;
        for (int i = 0; i < multipoint_a.getPointCount(); ++i) {
            multipoint_a.getXY(i, pt_a);
            if (!b_interior && env_b_deflated.containsExclusive(pt_a)) {
                b_interior = true;
            }
            if (!b_exterior && !env_b_inflated.contains(pt_a)) {
                b_exterior = true;
            }
            if (!b_interior || !b_exterior) continue;
            return true;
        }
        return false;
    }

    private static boolean pointEqualsPoint_(Point2D pt_a, Point2D pt_b, double tolerance, ProgressTracker progress_tracker) {
        return Point2D.sqrDistance(pt_a, pt_b) <= tolerance * tolerance;
    }

    private static boolean pointDisjointPoint_(Point2D pt_a, Point2D pt_b, double tolerance, ProgressTracker progress_tracker) {
        return Point2D.sqrDistance(pt_a, pt_b) > tolerance * tolerance;
    }

    private static boolean pointContainsPoint_(Point2D pt_a, Point2D pt_b, double tolerance, ProgressTracker progress_tracker) {
        return RelationalOperations.pointEqualsPoint_(pt_a, pt_b, tolerance, progress_tracker);
    }

    private static boolean pointEqualsEnvelope_(Point2D pt_a, Envelope2D env_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_a = new Envelope2D();
        env_a.setCoords(pt_a);
        return RelationalOperations.envelopeEqualsEnvelope_(env_a, env_b, tolerance, progress_tracker);
    }

    static boolean pointDisjointEnvelope_(Point2D pt_a, Envelope2D env_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_b_inflated = new Envelope2D();
        env_b_inflated.setCoords(env_b);
        env_b_inflated.inflate(tolerance, tolerance);
        return !env_b_inflated.contains(pt_a);
    }

    private static boolean pointTouchesEnvelope_(Point2D pt_a, Envelope2D env_b, double tolerance, ProgressTracker progress_tracker) {
        if (env_b.getHeight() <= tolerance && env_b.getWidth() <= tolerance) {
            return false;
        }
        Envelope2D env_b_inflated = new Envelope2D();
        Envelope2D env_b_deflated = new Envelope2D();
        env_b_inflated.setCoords(env_b);
        env_b_inflated.inflate(tolerance, tolerance);
        if (!env_b_inflated.contains(pt_a)) {
            return false;
        }
        if (env_b.getHeight() <= tolerance || env_b.getWidth() <= tolerance) {
            env_b_deflated.setCoords(env_b);
            if (env_b.getHeight() > tolerance) {
                env_b_deflated.inflate(0.0, -tolerance);
            } else {
                env_b_deflated.inflate(-tolerance, 0.0);
            }
            return !(env_b.getHeight() > tolerance ? pt_a.y > env_b_deflated.ymin && pt_a.y < env_b_deflated.ymax : pt_a.x > env_b_deflated.xmin && pt_a.x < env_b_deflated.xmax);
        }
        env_b_deflated.setCoords(env_b);
        env_b_deflated.inflate(-tolerance, -tolerance);
        return !env_b_deflated.containsExclusive(pt_a);
    }

    private static boolean pointWithinEnvelope_(Point2D pt_a, Envelope2D env_b, double tolerance, ProgressTracker progress_tracker) {
        if (env_b.getHeight() <= tolerance && env_b.getWidth() <= tolerance) {
            return true;
        }
        if (env_b.getHeight() <= tolerance || env_b.getWidth() <= tolerance) {
            Envelope2D env_b_deflated = new Envelope2D();
            env_b_deflated.setCoords(env_b);
            if (env_b.getHeight() > tolerance) {
                env_b_deflated.inflate(0.0, -tolerance);
            } else {
                env_b_deflated.inflate(-tolerance, 0.0);
            }
            boolean b_interior = false;
            if (env_b.getHeight() > tolerance) {
                if (pt_a.y > env_b_deflated.ymin && pt_a.y < env_b_deflated.ymax) {
                    b_interior = true;
                }
            } else if (pt_a.x > env_b_deflated.xmin && pt_a.x < env_b_deflated.xmax) {
                b_interior = true;
            }
            return b_interior;
        }
        Envelope2D env_b_deflated = new Envelope2D();
        env_b_deflated.setCoords(env_b);
        env_b_deflated.inflate(-tolerance, -tolerance);
        return env_b_deflated.containsExclusive(pt_a);
    }

    private static boolean pointContainsEnvelope_(Point2D pt_a, Envelope2D env_b, double tolerance, ProgressTracker progress_tracker) {
        return RelationalOperations.pointEqualsEnvelope_(pt_a, env_b, tolerance, progress_tracker);
    }

    private static boolean envelopeEqualsEnvelope_(Envelope2D env_a, Envelope2D env_b, double tolerance, ProgressTracker progress_tracker) {
        return RelationalOperations.envelopeInfContainsEnvelope_(env_a, env_b, tolerance) && RelationalOperations.envelopeInfContainsEnvelope_(env_b, env_a, tolerance);
    }

    static boolean envelopeDisjointEnvelope_(Envelope2D env_a, Envelope2D env_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env_b_inflated = new Envelope2D();
        env_b_inflated.setCoords(env_b);
        env_b_inflated.inflate(tolerance, tolerance);
        return !env_a.isIntersecting(env_b_inflated);
    }

    private static boolean envelopeTouchesEnvelope_(Envelope2D env_a, Envelope2D env_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D _env_b;
        Envelope2D _env_a;
        if (env_a.getHeight() <= tolerance && env_a.getWidth() <= tolerance) {
            Point2D pt_a = env_a.getCenter();
            return RelationalOperations.pointTouchesEnvelope_(pt_a, env_b, tolerance, progress_tracker);
        }
        if (env_b.getHeight() <= tolerance && env_b.getWidth() <= tolerance) {
            Point2D pt_b = env_b.getCenter();
            return RelationalOperations.pointTouchesEnvelope_(pt_b, env_a, tolerance, progress_tracker);
        }
        if (env_a.getHeight() > tolerance && env_a.getWidth() > tolerance && (env_b.getHeight() <= tolerance || env_b.getWidth() <= tolerance)) {
            _env_a = env_b;
            _env_b = env_a;
        } else {
            _env_a = env_a;
            _env_b = env_b;
        }
        if (_env_a.getHeight() <= tolerance || _env_a.getWidth() <= tolerance) {
            if (_env_b.getHeight() <= tolerance || _env_b.getWidth() <= tolerance) {
                Line line_a = new Line();
                Line line_b = new Line();
                double[] scalars_a = new double[2];
                double[] scalars_b = new double[2];
                Point2D pt = new Point2D();
                _env_a.queryLowerLeft(pt);
                line_a.setStartXY(pt);
                _env_a.queryUpperRight(pt);
                line_a.setEndXY(pt);
                _env_b.queryLowerLeft(pt);
                line_b.setStartXY(pt);
                _env_b.queryUpperRight(pt);
                line_b.setEndXY(pt);
                line_a.intersect(line_b, null, scalars_a, scalars_b, tolerance);
                int count = line_a.intersect(line_b, null, null, null, tolerance);
                if (count != 1) {
                    return false;
                }
                return scalars_a[0] == 0.0 || scalars_a[1] == 1.0 || scalars_b[0] == 0.0 || scalars_b[1] == 1.0;
            }
            Envelope2D env_b_deflated = new Envelope2D();
            Envelope2D env_inter = new Envelope2D();
            env_b_deflated.setCoords(_env_b);
            env_b_deflated.inflate(-tolerance, -tolerance);
            env_inter.setCoords(env_b_deflated);
            env_inter.intersect(_env_a);
            if (!env_inter.isEmpty() && (env_inter.getHeight() > tolerance || env_inter.getWidth() > tolerance)) {
                return false;
            }
            assert (!RelationalOperations.envelopeDisjointEnvelope_(_env_a, _env_b, tolerance, progress_tracker));
            return true;
        }
        Envelope2D env_inter = new Envelope2D();
        env_inter.setCoords(_env_a);
        env_inter.intersect(_env_b);
        return env_inter.isEmpty() || !(env_inter.getHeight() > tolerance) || !(env_inter.getWidth() > tolerance);
    }

    private static boolean envelopeOverlapsEnvelope_(Envelope2D env_a, Envelope2D env_b, double tolerance, ProgressTracker progress_tracker) {
        if (RelationalOperations.envelopeInfContainsEnvelope_(env_a, env_b, tolerance) || RelationalOperations.envelopeInfContainsEnvelope_(env_b, env_a, tolerance)) {
            return false;
        }
        if (env_a.getHeight() <= tolerance && env_a.getWidth() <= tolerance) {
            return false;
        }
        if (env_b.getHeight() <= tolerance && env_b.getWidth() <= tolerance) {
            return false;
        }
        if (env_a.getHeight() <= tolerance || env_a.getWidth() <= tolerance) {
            if (env_b.getHeight() > tolerance && env_b.getWidth() > tolerance) {
                return false;
            }
            Line line_a = new Line();
            Line line_b = new Line();
            double[] scalars_a = new double[2];
            double[] scalars_b = new double[2];
            Point2D pt = new Point2D();
            env_a.queryLowerLeft(pt);
            line_a.setStartXY(pt);
            env_a.queryUpperRight(pt);
            line_a.setEndXY(pt);
            env_b.queryLowerLeft(pt);
            line_b.setStartXY(pt);
            env_b.queryUpperRight(pt);
            line_b.setEndXY(pt);
            line_a.intersect(line_b, null, scalars_a, scalars_b, tolerance);
            int count = line_a.intersect(line_b, null, null, null, tolerance);
            if (count != 2) {
                return false;
            }
            return (scalars_a[0] > 0.0 || scalars_a[1] < 1.0) && (scalars_b[0] > 0.0 || scalars_b[1] < 1.0);
        }
        if (env_b.getHeight() <= tolerance || env_b.getWidth() <= tolerance) {
            return false;
        }
        Envelope2D env_inter = new Envelope2D();
        env_inter.setCoords(env_a);
        env_inter.intersect(env_b);
        if (env_inter.isEmpty()) {
            return false;
        }
        if (env_inter.getHeight() <= tolerance || env_inter.getWidth() <= tolerance) {
            return false;
        }
        assert (!RelationalOperations.envelopeInfContainsEnvelope_(env_inter, env_a, tolerance) && !RelationalOperations.envelopeInfContainsEnvelope_(env_inter, env_b, tolerance));
        return true;
    }

    private static boolean envelopeContainsEnvelope_(Envelope2D env_a, Envelope2D env_b, double tolerance, ProgressTracker progress_tracker) {
        if (!RelationalOperations.envelopeInfContainsEnvelope_(env_a, env_b, tolerance)) {
            return false;
        }
        if (env_a.getHeight() <= tolerance && env_a.getWidth() <= tolerance) {
            Point2D pt_a = env_a.getCenter();
            return RelationalOperations.pointWithinEnvelope_(pt_a, env_b, tolerance, progress_tracker);
        }
        if (env_b.getHeight() <= tolerance && env_b.getWidth() <= tolerance) {
            Point2D pt_b = env_b.getCenter();
            return RelationalOperations.pointWithinEnvelope_(pt_b, env_a, tolerance, progress_tracker);
        }
        if (env_a.getHeight() <= tolerance || env_a.getWidth() <= tolerance) {
            return RelationalOperations.envelopeInfContainsEnvelope_(env_a, env_b, tolerance);
        }
        if (env_b.getHeight() <= tolerance || env_b.getWidth() <= tolerance) {
            Envelope2D env_a_deflated = new Envelope2D();
            env_a_deflated.setCoords(env_a);
            env_a_deflated.inflate(-tolerance, -tolerance);
            if (env_a_deflated.containsExclusive(env_b)) {
                return true;
            }
            Envelope2D env_inter = new Envelope2D();
            env_inter.setCoords(env_a_deflated);
            env_inter.intersect(env_b);
            return !env_inter.isEmpty() && (!(env_inter.getHeight() <= tolerance) || !(env_inter.getWidth() <= tolerance));
        }
        return RelationalOperations.envelopeInfContainsEnvelope_(env_a, env_b, tolerance);
    }

    private static boolean envelopeCrossesEnvelope_(Envelope2D env_a, Envelope2D env_b, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D _env_b;
        Envelope2D _env_a;
        if (RelationalOperations.envelopeInfContainsEnvelope_(env_a, env_b, tolerance) || RelationalOperations.envelopeInfContainsEnvelope_(env_b, env_a, tolerance)) {
            return false;
        }
        if (env_a.getHeight() <= tolerance && env_a.getWidth() <= tolerance) {
            return false;
        }
        if (env_b.getHeight() <= tolerance && env_b.getWidth() <= tolerance) {
            return false;
        }
        if (env_b.getHeight() > tolerance && env_b.getWidth() > tolerance && env_a.getHeight() > tolerance && env_a.getWidth() > tolerance) {
            return false;
        }
        if (env_a.getHeight() > tolerance && env_a.getWidth() > tolerance) {
            _env_a = env_b;
            _env_b = env_a;
        } else {
            _env_a = env_a;
            _env_b = env_b;
        }
        if (_env_b.getHeight() > tolerance && _env_b.getWidth() > tolerance) {
            Envelope2D env_inter = new Envelope2D();
            Envelope2D env_b_deflated = new Envelope2D();
            env_b_deflated.setCoords(_env_b);
            env_b_deflated.inflate(-tolerance, -tolerance);
            env_inter.setCoords(env_b_deflated);
            env_inter.intersect(_env_a);
            if (env_inter.isEmpty()) {
                return false;
            }
            if (env_inter.getHeight() <= tolerance && env_inter.getWidth() <= tolerance) {
                return false;
            }
            assert (!RelationalOperations.envelopeInfContainsEnvelope_(env_inter, _env_a, tolerance));
            return true;
        }
        Line line_a = new Line();
        Line line_b = new Line();
        double[] scalars_a = new double[2];
        double[] scalars_b = new double[2];
        Point2D pt = new Point2D();
        _env_a.queryLowerLeft(pt);
        line_a.setStartXY(pt);
        _env_a.queryUpperRight(pt);
        line_a.setEndXY(pt);
        _env_b.queryLowerLeft(pt);
        line_b.setStartXY(pt);
        _env_b.queryUpperRight(pt);
        line_b.setEndXY(pt);
        line_a.intersect(line_b, null, scalars_a, scalars_b, tolerance);
        int count = line_a.intersect(line_b, null, null, null, tolerance);
        if (count != 1) {
            return false;
        }
        return scalars_a[0] > 0.0 && scalars_a[1] < 1.0 && scalars_b[0] > 0.0 && scalars_b[1] < 1.0;
    }

    private static boolean polygonDisjointMultiPath_(Polygon polygon_a, MultiPath multipath_b, double tolerance, ProgressTracker progress_tracker) {
        MultiPathImpl multi_path_impl_b;
        Envelope2D env_a_inf = new Envelope2D();
        Envelope2D env_b_inf = new Envelope2D();
        MultiPathImpl multi_path_impl_a = (MultiPathImpl)polygon_a._getImpl();
        PairwiseIntersectorImpl intersector = new PairwiseIntersectorImpl(multi_path_impl_a, multi_path_impl_b = (MultiPathImpl)multipath_b._getImpl(), tolerance, true);
        if (!intersector.next()) {
            return true;
        }
        boolean b_intersects = RelationalOperations.linearPathIntersectsLinearPath_(polygon_a, multipath_b, tolerance);
        if (b_intersects) {
            return false;
        }
        Polygon pa = null;
        Polygon p_polygon_a = polygon_a;
        Polygon pb = null;
        Polygon p_polygon_b = null;
        if (multipath_b.getType().value() == 1736) {
            p_polygon_b = (Polygon)multipath_b;
        }
        boolean b_checked_polygon_a_quad_tree = false;
        boolean b_checked_polygon_b_quad_tree = false;
        do {
            PolygonUtils.PiPResult result;
            int path_a = intersector.getRedElement();
            int path_b = intersector.getBlueElement();
            Point2D pt_b = multipath_b.getXY(multipath_b.getPathStart(path_b));
            env_a_inf.setCoords(intersector.getRedEnvelope());
            env_a_inf.inflate(tolerance, tolerance);
            if (env_a_inf.contains(pt_b) && (result = PolygonUtils.isPointInPolygon2D(p_polygon_a, pt_b, 0.0)) != PolygonUtils.PiPResult.PiPOutside) {
                return false;
            }
            if (multipath_b.getType().value() == 1736) {
                Point2D pt_a = polygon_a.getXY(polygon_a.getPathStart(path_a));
                env_b_inf.setCoords(intersector.getBlueEnvelope());
                env_b_inf.inflate(tolerance, tolerance);
                if (env_b_inf.contains(pt_a) && (result = PolygonUtils.isPointInPolygon2D(p_polygon_b, pt_a, 0.0)) != PolygonUtils.PiPResult.PiPOutside) {
                    return false;
                }
            }
            if (!b_checked_polygon_a_quad_tree) {
                if (PointInPolygonHelper.quadTreeWillHelp(polygon_a, multipath_b.getPathCount() - 1) && (multi_path_impl_a._getAccelerators() == null || multi_path_impl_a._getAccelerators().getQuadTree() == null)) {
                    pa = new Polygon();
                    polygon_a.copyTo(pa);
                    ((MultiPathImpl)pa._getImpl())._buildQuadTreeAccelerator(Geometry.GeometryAccelerationDegree.enumMedium);
                    p_polygon_a = pa;
                } else {
                    p_polygon_a = polygon_a;
                }
                b_checked_polygon_a_quad_tree = true;
            }
            if (multipath_b.getType().value() != 1736 || b_checked_polygon_b_quad_tree) continue;
            Polygon polygon_b = (Polygon)multipath_b;
            if (PointInPolygonHelper.quadTreeWillHelp(polygon_b, polygon_a.getPathCount() - 1) && (multi_path_impl_b._getAccelerators() == null || multi_path_impl_b._getAccelerators().getQuadTree() == null)) {
                pb = new Polygon();
                polygon_b.copyTo(pb);
                ((MultiPathImpl)pb._getImpl())._buildQuadTreeAccelerator(Geometry.GeometryAccelerationDegree.enumMedium);
                p_polygon_b = pb;
            } else {
                p_polygon_b = (Polygon)multipath_b;
            }
            b_checked_polygon_b_quad_tree = true;
        } while (intersector.next());
        return true;
    }

    private static boolean envelopeInfContainsEnvelope_(Envelope2D env_a, Envelope2D env_b, double tolerance) {
        Envelope2D env_a_inflated = new Envelope2D();
        env_a_inflated.setCoords(env_a);
        env_a_inflated.inflate(tolerance, tolerance);
        return env_a_inflated.contains(env_b);
    }

    private static boolean interiorEnvExteriorEnv_(Envelope2D env_a, Envelope2D env_b, double tolerance) {
        Envelope2D envBInflated = new Envelope2D();
        envBInflated.setCoords(env_b);
        envBInflated.inflate(tolerance, tolerance);
        Point2D pt = new Point2D();
        env_a.queryLowerLeft(pt);
        if (!envBInflated.contains(pt)) {
            return true;
        }
        env_a.queryLowerRight(pt);
        if (!envBInflated.contains(pt)) {
            return true;
        }
        env_a.queryUpperLeft(pt);
        if (!envBInflated.contains(pt)) {
            return true;
        }
        env_a.queryUpperRight(pt);
        if (!envBInflated.contains(pt)) {
            return true;
        }
        assert (envBInflated.contains(env_a));
        return false;
    }

    private static boolean multiPathExactlyEqualsMultiPath_(MultiPath multipathA, MultiPath multipathB, double tolerance, ProgressTracker progress_tracker) {
        if (multipathA.getPathCount() != multipathB.getPathCount() || multipathA.getPointCount() != multipathB.getPointCount()) {
            return false;
        }
        Point2D ptA = new Point2D();
        Point2D ptB = new Point2D();
        boolean bAllPointsEqual = true;
        double tolerance_sq = tolerance * tolerance;
        for (int ipath = 0; ipath < multipathA.getPathCount(); ++ipath) {
            if (multipathA.getPathEnd(ipath) != multipathB.getPathEnd(ipath)) {
                bAllPointsEqual = false;
                break;
            }
            for (int i = multipathA.getPathStart(ipath); i < multipathB.getPathEnd(ipath); ++i) {
                multipathA.getXY(i, ptA);
                multipathB.getXY(i, ptB);
                if (!(Point2D.sqrDistance(ptA, ptB) > tolerance_sq)) continue;
                bAllPointsEqual = false;
                break;
            }
            if (!bAllPointsEqual) break;
        }
        return bAllPointsEqual;
    }

    private static boolean multiPointExactlyEqualsMultiPoint_(MultiPoint multipoint_a, MultiPoint multipoint_b, double tolerance, ProgressTracker progress_tracker) {
        if (multipoint_a.getPointCount() != multipoint_b.getPointCount()) {
            return false;
        }
        Point2D ptA = new Point2D();
        Point2D ptB = new Point2D();
        boolean bAllPointsEqual = true;
        double tolerance_sq = tolerance * tolerance;
        for (int i = 0; i < multipoint_a.getPointCount(); ++i) {
            multipoint_a.getXY(i, ptA);
            multipoint_b.getXY(i, ptB);
            if (!(Point2D.sqrDistance(ptA, ptB) > tolerance_sq)) continue;
            bAllPointsEqual = false;
            break;
        }
        return bAllPointsEqual;
    }

    private static boolean multiPointCoverageMultiPoint_(MultiPoint _multipointA, MultiPoint _multipointB, double tolerance, boolean bPerformWithin, boolean bPerformEquals, boolean bPerformOverlaps, ProgressTracker progress_tracker) {
        MultiPoint multipoint_b;
        MultiPoint multipoint_a;
        boolean bPerformContains = false;
        if (_multipointA.getPointCount() > _multipointB.getPointCount()) {
            if (bPerformWithin) {
                bPerformWithin = false;
                bPerformContains = true;
            }
            multipoint_a = _multipointB;
            multipoint_b = _multipointA;
        } else {
            multipoint_a = _multipointA;
            multipoint_b = _multipointB;
        }
        AttributeStreamOfInt8 contained = null;
        if (bPerformEquals || bPerformOverlaps || bPerformContains) {
            contained = new AttributeStreamOfInt8(multipoint_b.getPointCount());
            for (int i = 0; i < multipoint_b.getPointCount(); ++i) {
                contained.write(i, (byte)0);
            }
        }
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        Envelope2D envInter = new Envelope2D();
        multipoint_a.queryEnvelope2D(env_a);
        multipoint_b.queryEnvelope2D(env_b);
        env_a.inflate(tolerance, tolerance);
        env_b.inflate(tolerance, tolerance);
        envInter.setCoords(env_a);
        envInter.intersect(env_b);
        Point2D ptA = new Point2D();
        Point2D ptB = new Point2D();
        boolean bWithin = true;
        QuadTreeImpl quadTreeB = InternalUtils.buildQuadTree((MultiPointImpl)multipoint_b._getImpl(), envInter);
        QuadTreeImpl.QuadTreeIteratorImpl qtIterB = quadTreeB.getIterator();
        double tolerance_sq = tolerance * tolerance;
        for (int vertex_a = 0; vertex_a < multipoint_a.getPointCount(); ++vertex_a) {
            multipoint_a.getXY(vertex_a, ptA);
            if (!envInter.contains(ptA)) {
                if (bPerformEquals || bPerformWithin) {
                    return false;
                }
                bWithin = false;
                continue;
            }
            boolean bPtACovered = false;
            env_a.setCoords(ptA.x, ptA.y, ptA.x, ptA.y);
            qtIterB.resetIterator(env_a, tolerance);
            int elementHandleB = qtIterB.next();
            while (elementHandleB != -1) {
                int vertex_b = quadTreeB.getElement(elementHandleB);
                multipoint_b.getXY(vertex_b, ptB);
                if (Point2D.sqrDistance(ptA, ptB) <= tolerance_sq) {
                    if (bPerformEquals || bPerformOverlaps || bPerformContains) {
                        contained.write(vertex_b, (byte)1);
                    }
                    bPtACovered = true;
                    if (bPerformWithin) break;
                }
                elementHandleB = qtIterB.next();
            }
            if (bPtACovered) continue;
            bWithin = false;
            if (!bPerformEquals && !bPerformWithin) continue;
            return false;
        }
        if (bPerformOverlaps && bWithin) {
            return false;
        }
        if (bPerformWithin) {
            return true;
        }
        for (int i = 0; i < multipoint_b.getPointCount(); ++i) {
            if (contained.read(i) == 1) {
                if (!bPerformOverlaps) continue;
                return true;
            }
            if (!bPerformEquals && !bPerformContains) continue;
            return false;
        }
        return !bPerformOverlaps;
    }

    private static boolean multiPointIntersectsMultiPoint_(MultiPoint _multipointA, MultiPoint _multipointB, double tolerance, ProgressTracker progress_tracker) {
        MultiPoint multipoint_b;
        MultiPoint multipoint_a;
        if (_multipointA.getPointCount() > _multipointB.getPointCount()) {
            multipoint_a = _multipointB;
            multipoint_b = _multipointA;
        } else {
            multipoint_a = _multipointA;
            multipoint_b = _multipointB;
        }
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        Envelope2D envInter = new Envelope2D();
        multipoint_a.queryEnvelope2D(env_a);
        multipoint_b.queryEnvelope2D(env_b);
        env_a.inflate(tolerance, tolerance);
        env_b.inflate(tolerance, tolerance);
        envInter.setCoords(env_a);
        envInter.intersect(env_b);
        Point2D ptA = new Point2D();
        Point2D ptB = new Point2D();
        double tolerance_sq = tolerance * tolerance;
        QuadTreeImpl quadTreeB = InternalUtils.buildQuadTree((MultiPointImpl)multipoint_b._getImpl(), envInter);
        QuadTreeImpl.QuadTreeIteratorImpl qtIterB = quadTreeB.getIterator();
        for (int vertex_a = 0; vertex_a < multipoint_a.getPointCount(); ++vertex_a) {
            multipoint_a.getXY(vertex_a, ptA);
            if (!envInter.contains(ptA)) continue;
            env_a.setCoords(ptA.x, ptA.y, ptA.x, ptA.y);
            qtIterB.resetIterator(env_a, tolerance);
            int elementHandleB = qtIterB.next();
            while (elementHandleB != -1) {
                int vertex_b = quadTreeB.getElement(elementHandleB);
                multipoint_b.getXY(vertex_b, ptB);
                if (Point2D.sqrDistance(ptA, ptB) <= tolerance_sq) {
                    return true;
                }
                elementHandleB = qtIterB.next();
            }
        }
        return false;
    }

    private static boolean linearPathEqualsLinearPath_(MultiPath multipathA, MultiPath multipathB, double tolerance, boolean bEnforceOrientation) {
        return RelationalOperations.linearPathWithinLinearPath_(multipathA, multipathB, tolerance, bEnforceOrientation) && RelationalOperations.linearPathWithinLinearPath_(multipathB, multipathA, tolerance, bEnforceOrientation);
    }

    private static boolean linearPathWithinLinearPath_(MultiPath multipathA, MultiPath multipathB, double tolerance, boolean bEnforceOrientation) {
        boolean bWithin = true;
        double[] scalarsA = new double[2];
        double[] scalarsB = new double[2];
        int ievent = 0;
        AttributeStreamOfInt32 eventIndices = new AttributeStreamOfInt32(0);
        RelationalOperations relOps = new RelationalOperations();
        OverlapComparer overlapComparer = new OverlapComparer(relOps);
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        Envelope2D envInter = new Envelope2D();
        multipathA.queryEnvelope2D(env_a);
        multipathB.queryEnvelope2D(env_b);
        env_a.inflate(tolerance, tolerance);
        env_b.inflate(tolerance, tolerance);
        envInter.setCoords(env_a);
        envInter.intersect(env_b);
        SegmentIteratorImpl segIterA = ((MultiPathImpl)multipathA._getImpl()).querySegmentIterator();
        SegmentIteratorImpl segIterB = ((MultiPathImpl)multipathB._getImpl()).querySegmentIterator();
        QuadTreeImpl qtB = null;
        QuadTreeImpl quadTreeB = null;
        QuadTreeImpl quadTreePathsB = null;
        GeometryAccelerators accel = ((MultiPathImpl)multipathB._getImpl())._getAccelerators();
        if (accel != null) {
            quadTreeB = accel.getQuadTree();
            quadTreePathsB = accel.getQuadTreeForPaths();
            if (quadTreeB == null) {
                quadTreeB = qtB = InternalUtils.buildQuadTree((MultiPathImpl)multipathB._getImpl(), envInter);
            }
        } else {
            quadTreeB = qtB = InternalUtils.buildQuadTree((MultiPathImpl)multipathB._getImpl(), envInter);
        }
        QuadTreeImpl.QuadTreeIteratorImpl qtIterB = quadTreeB.getIterator();
        QuadTreeImpl.QuadTreeIteratorImpl qtIterPathsB = null;
        if (quadTreePathsB != null) {
            qtIterPathsB = quadTreePathsB.getIterator();
        }
        while (segIterA.nextPath()) {
            while (segIterA.hasNextSegment()) {
                OverlapEvent overlapEvent;
                boolean bStringOfSegmentAsCovered = false;
                Segment segmentA = segIterA.nextSegment();
                segmentA.queryEnvelope2D(env_a);
                if (!env_a.isIntersecting(envInter)) {
                    return false;
                }
                if (qtIterPathsB != null) {
                    qtIterPathsB.resetIterator(env_a, tolerance);
                    if (qtIterPathsB.next() == -1) {
                        bWithin = false;
                        return false;
                    }
                }
                double lengthA = segmentA.calculateLength2D();
                qtIterB.resetIterator(segmentA, tolerance);
                int elementHandleB = qtIterB.next();
                while (elementHandleB != -1) {
                    int vertex_b = quadTreeB.getElement(elementHandleB);
                    segIterB.resetToVertex(vertex_b);
                    Segment segmentB = segIterB.nextSegment();
                    int result = segmentA.intersect(segmentB, null, scalarsA, scalarsB, tolerance);
                    if (result == 2 && (!bEnforceOrientation || scalarsB[0] <= scalarsB[1])) {
                        int ivertex_a;
                        double scalar_a_0 = scalarsA[0];
                        double scalar_a_1 = scalarsA[1];
                        double scalar_b_0 = scalarsB[0];
                        double scalar_b_1 = scalarsB[1];
                        if (scalar_a_0 * lengthA <= tolerance && (1.0 - scalar_a_1) * lengthA <= tolerance) {
                            bStringOfSegmentAsCovered = true;
                            ievent = 0;
                            eventIndices.resize(0);
                            relOps.m_overlap_events.clear();
                            ivertex_a = segIterA.getStartPointIndex();
                            boolean bSegmentACovered = true;
                            while (bSegmentACovered) {
                                if (segIterA.hasNextSegment()) {
                                    segmentA = segIterA.nextSegment();
                                    lengthA = segmentA.calculateLength2D();
                                    result = segmentA.intersect(segmentB, null, scalarsA, scalarsB, tolerance);
                                    if (result == 2 && (!bEnforceOrientation || scalarsB[0] <= scalarsB[1])) {
                                        scalar_a_0 = scalarsA[0];
                                        scalar_a_1 = scalarsA[1];
                                        if (scalar_a_0 * lengthA <= tolerance && (1.0 - scalar_a_1) * lengthA <= tolerance) {
                                            ivertex_a = segIterA.getStartPointIndex();
                                            continue;
                                        }
                                    }
                                    if (segIterB.hasNextSegment() && (result = segmentA.intersect(segmentB = segIterB.nextSegment(), null, scalarsA, scalarsB, tolerance)) == 2 && (!bEnforceOrientation || scalarsB[0] <= scalarsB[1])) {
                                        scalar_a_0 = scalarsA[0];
                                        scalar_a_1 = scalarsA[1];
                                        if (scalar_a_0 * lengthA <= tolerance && (1.0 - scalar_a_1) * lengthA <= tolerance) {
                                            ivertex_a = segIterA.getStartPointIndex();
                                            continue;
                                        }
                                    }
                                }
                                bSegmentACovered = false;
                            }
                            if (ivertex_a == segIterA.getStartPointIndex()) break;
                            segIterA.resetToVertex(ivertex_a);
                            segIterA.nextSegment();
                            break;
                        }
                        ivertex_a = segIterA.getStartPointIndex();
                        int ipath_a = segIterA.getPathIndex();
                        int ivertex_b = segIterB.getStartPointIndex();
                        int ipath_b = segIterB.getPathIndex();
                        overlapEvent = OverlapEvent.construct(ivertex_a, ipath_a, scalar_a_0, scalar_a_1, ivertex_b, ipath_b, scalar_b_0, scalar_b_1);
                        relOps.m_overlap_events.add(overlapEvent);
                        eventIndices.add(eventIndices.size());
                    }
                    elementHandleB = qtIterB.next();
                }
                if (bStringOfSegmentAsCovered) continue;
                if (ievent == relOps.m_overlap_events.size()) {
                    return false;
                }
                if (eventIndices.size() - ievent > 1) {
                    eventIndices.Sort(ievent, eventIndices.size(), overlapComparer);
                }
                double lastScalar = 0.0;
                for (int i = ievent; i < relOps.m_overlap_events.size(); ++i) {
                    overlapEvent = relOps.m_overlap_events.get(eventIndices.get(i));
                    if (overlapEvent.m_scalar_a_0 < lastScalar && overlapEvent.m_scalar_a_1 < lastScalar) continue;
                    if (lengthA * (overlapEvent.m_scalar_a_0 - lastScalar) > tolerance) {
                        return false;
                    }
                    lastScalar = overlapEvent.m_scalar_a_1;
                    if (lengthA * (1.0 - lastScalar) <= tolerance || lastScalar == 1.0) break;
                }
                if (lengthA * (1.0 - lastScalar) > tolerance) {
                    return false;
                }
                ievent = 0;
                eventIndices.resize(0);
                relOps.m_overlap_events.clear();
            }
        }
        return bWithin;
    }

    private static boolean linearPathOverlapsLinearPath_(MultiPath multipathA, MultiPath multipathB, double tolerance) {
        int dim = RelationalOperations.linearPathIntersectsLinearPathMaxDim_(multipathA, multipathB, tolerance, null);
        if (dim < 1) {
            return false;
        }
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        multipathA.queryEnvelope2D(env_a);
        multipathB.queryEnvelope2D(env_b);
        boolean bIntAExtB = RelationalOperations.interiorEnvExteriorEnv_(env_a, env_b, tolerance);
        boolean bIntBExtA = RelationalOperations.interiorEnvExteriorEnv_(env_b, env_a, tolerance);
        if (bIntAExtB && bIntBExtA) {
            return true;
        }
        if (bIntAExtB && !bIntBExtA) {
            return !RelationalOperations.linearPathWithinLinearPath_(multipathB, multipathA, tolerance, false);
        }
        if (bIntBExtA && !bIntAExtB) {
            return !RelationalOperations.linearPathWithinLinearPath_(multipathA, multipathB, tolerance, false);
        }
        return !RelationalOperations.linearPathWithinLinearPath_(multipathA, multipathB, tolerance, false) && !RelationalOperations.linearPathWithinLinearPath_(multipathB, multipathA, tolerance, false);
    }

    static int linearPathIntersectsLinearPathMaxDim_(MultiPath _multipathA, MultiPath _multipathB, double tolerance, AttributeStreamOfDbl intersections) {
        MultiPath multipathB;
        MultiPath multipathA;
        if (_multipathA.getSegmentCount() > _multipathB.getSegmentCount()) {
            multipathA = _multipathB;
            multipathB = _multipathA;
        } else {
            multipathA = _multipathA;
            multipathB = _multipathB;
        }
        SegmentIteratorImpl segIterA = ((MultiPathImpl)multipathA._getImpl()).querySegmentIterator();
        SegmentIteratorImpl segIterB = ((MultiPathImpl)multipathB._getImpl()).querySegmentIterator();
        double[] scalarsA = new double[2];
        double[] scalarsB = new double[2];
        int dim = -1;
        int ievent = 0;
        AttributeStreamOfInt32 eventIndices = new AttributeStreamOfInt32(0);
        RelationalOperations relOps = new RelationalOperations();
        OverlapComparer overlapComparer = new OverlapComparer(relOps);
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        Envelope2D envInter = new Envelope2D();
        multipathA.queryEnvelope2D(env_a);
        multipathB.queryEnvelope2D(env_b);
        env_a.inflate(tolerance, tolerance);
        env_b.inflate(tolerance, tolerance);
        envInter.setCoords(env_a);
        envInter.intersect(env_b);
        Point2D int_point = null;
        if (intersections != null) {
            int_point = new Point2D();
        }
        QuadTreeImpl qtB = null;
        QuadTreeImpl quadTreeB = null;
        QuadTreeImpl quadTreePathsB = null;
        GeometryAccelerators accel = ((MultiPathImpl)multipathB._getImpl())._getAccelerators();
        if (accel != null) {
            quadTreeB = accel.getQuadTree();
            quadTreePathsB = accel.getQuadTreeForPaths();
            if (quadTreeB == null) {
                quadTreeB = qtB = InternalUtils.buildQuadTree((MultiPathImpl)multipathB._getImpl(), envInter);
            }
        } else {
            quadTreeB = qtB = InternalUtils.buildQuadTree((MultiPathImpl)multipathB._getImpl(), envInter);
        }
        QuadTreeImpl.QuadTreeIteratorImpl qtIterB = quadTreeB.getIterator();
        QuadTreeImpl.QuadTreeIteratorImpl qtIterPathsB = null;
        if (quadTreePathsB != null) {
            qtIterPathsB = quadTreePathsB.getIterator();
        }
        while (segIterA.nextPath()) {
            double overlapLength = 0.0;
            while (segIterA.hasNextSegment()) {
                OverlapEvent overlapEvent;
                Segment segmentA = segIterA.nextSegment();
                segmentA.queryEnvelope2D(env_a);
                if (!env_a.isIntersecting(envInter)) continue;
                if (qtIterPathsB != null) {
                    qtIterPathsB.resetIterator(env_a, tolerance);
                    if (qtIterPathsB.next() == -1) continue;
                }
                double lengthA = segmentA.calculateLength2D();
                qtIterB.resetIterator(segmentA, tolerance);
                int elementHandleB = qtIterB.next();
                while (elementHandleB != -1) {
                    int vertex_b = quadTreeB.getElement(elementHandleB);
                    segIterB.resetToVertex(vertex_b);
                    Segment segmentB = segIterB.nextSegment();
                    double lengthB = segmentB.calculateLength2D();
                    int result = segmentA.intersect(segmentB, null, scalarsA, scalarsB, tolerance);
                    if (result > 0) {
                        double scalar_b_1;
                        double scalar_a_0 = scalarsA[0];
                        double scalar_b_0 = scalarsB[0];
                        double scalar_a_1 = result == 2 ? scalarsA[1] : Double.NaN;
                        double d = scalar_b_1 = result == 2 ? scalarsB[1] : Double.NaN;
                        if (result == 2) {
                            double nextScalarA0;
                            double nextScalarA1;
                            double nextScalarA02;
                            double nextScalarA12;
                            if (lengthA * (scalar_a_1 - scalar_a_0) > tolerance) {
                                dim = 1;
                                return dim;
                            }
                            double length = lengthA * (scalar_a_1 - scalar_a_0);
                            if (segIterB.hasNextSegment()) {
                                double lengthNext;
                                segmentB = segIterB.nextSegment();
                                result = segmentA.intersect(segmentB, null, scalarsA, null, tolerance);
                                if (result == 2 && length + (lengthNext = lengthA * ((nextScalarA12 = scalarsA[1]) - (nextScalarA02 = scalarsA[0]))) > tolerance) {
                                    dim = 1;
                                    return dim;
                                }
                                segIterB.resetToVertex(vertex_b);
                                segIterB.nextSegment();
                            }
                            if (!segIterB.isFirstSegmentInPath()) {
                                double lengthPrevious;
                                segIterB.previousSegment();
                                segmentB = segIterB.previousSegment();
                                result = segmentA.intersect(segmentB, null, scalarsA, null, tolerance);
                                if (result == 2 && length + (lengthPrevious = lengthA * ((nextScalarA12 = scalarsA[1]) - (nextScalarA02 = scalarsA[0]))) > tolerance) {
                                    dim = 1;
                                    return dim;
                                }
                                segIterB.resetToVertex(vertex_b);
                                segIterB.nextSegment();
                            }
                            if (segIterA.hasNextSegment()) {
                                double lengthNext;
                                int vertex_a = segIterA.getStartPointIndex();
                                segmentA = segIterA.nextSegment();
                                result = segmentA.intersect(segmentB, null, scalarsA, null, tolerance);
                                if (result == 2 && length + (lengthNext = lengthA * ((nextScalarA1 = scalarsA[1]) - (nextScalarA0 = scalarsA[0]))) > tolerance) {
                                    dim = 1;
                                    return dim;
                                }
                                segIterA.resetToVertex(vertex_a);
                                segIterA.nextSegment();
                            }
                            if (!segIterA.isFirstSegmentInPath()) {
                                double lengthPrevious;
                                int vertex_a = segIterA.getStartPointIndex();
                                segIterA.previousSegment();
                                segmentA = segIterA.previousSegment();
                                result = segmentA.intersect(segmentB, null, scalarsA, null, tolerance);
                                if (result == 2 && length + (lengthPrevious = lengthB * ((nextScalarA1 = scalarsA[1]) - (nextScalarA0 = scalarsA[0]))) > tolerance) {
                                    dim = 1;
                                    return dim;
                                }
                                segIterA.resetToVertex(vertex_a);
                                segIterA.nextSegment();
                            }
                            int ivertex_a = segIterA.getStartPointIndex();
                            int ipath_a = segIterA.getPathIndex();
                            int ivertex_b = segIterB.getStartPointIndex();
                            int ipath_b = segIterB.getPathIndex();
                            overlapEvent = OverlapEvent.construct(ivertex_a, ipath_a, scalar_a_0, scalar_a_1, ivertex_b, ipath_b, scalar_b_0, scalar_b_1);
                            relOps.m_overlap_events.add(overlapEvent);
                            eventIndices.add(eventIndices.size());
                        }
                        dim = 0;
                        if (intersections != null) {
                            segmentA.getCoord2D(scalar_a_0, int_point);
                            intersections.add(int_point.x);
                            intersections.add(int_point.y);
                        }
                    }
                    elementHandleB = qtIterB.next();
                }
                if (ievent >= relOps.m_overlap_events.size()) continue;
                eventIndices.Sort(ievent, eventIndices.size(), overlapComparer);
                double lastScalar = 0.0;
                int lastPath = relOps.m_overlap_events.get((int)eventIndices.get((int)ievent)).m_ipath_a;
                for (int i = ievent; i < relOps.m_overlap_events.size(); ++i) {
                    overlapEvent = relOps.m_overlap_events.get(eventIndices.get(i));
                    if (overlapEvent.m_scalar_a_0 < lastScalar && overlapEvent.m_scalar_a_1 < lastScalar) continue;
                    if (lengthA * (overlapEvent.m_scalar_a_0 - lastScalar) > tolerance) {
                        overlapLength = lengthA * (overlapEvent.m_scalar_a_1 - overlapEvent.m_scalar_a_0);
                        lastScalar = overlapEvent.m_scalar_a_1;
                        lastPath = overlapEvent.m_ipath_a;
                        continue;
                    }
                    if (overlapEvent.m_ipath_a != lastPath) {
                        overlapLength = lengthA * (overlapEvent.m_scalar_a_1 - overlapEvent.m_scalar_a_0);
                        lastPath = overlapEvent.m_ipath_a;
                    } else {
                        overlapLength += lengthA * (overlapEvent.m_scalar_a_1 - overlapEvent.m_scalar_a_0);
                    }
                    if (overlapLength > tolerance) {
                        dim = 1;
                        return dim;
                    }
                    lastScalar = overlapEvent.m_scalar_a_1;
                    if (lastScalar == 1.0) break;
                }
                if (lengthA * (1.0 - lastScalar) > tolerance) {
                    overlapLength = 0.0;
                }
                ievent = 0;
                eventIndices.resize(0);
                relOps.m_overlap_events.clear();
            }
        }
        return dim;
    }

    private static boolean linearPathIntersectsLinearPath_(MultiPath multipathA, MultiPath multipathB, double tolerance) {
        MultiPathImpl multi_path_impl_a = (MultiPathImpl)multipathA._getImpl();
        MultiPathImpl multi_path_impl_b = (MultiPathImpl)multipathB._getImpl();
        SegmentIteratorImpl segIterA = multi_path_impl_a.querySegmentIterator();
        SegmentIteratorImpl segIterB = multi_path_impl_b.querySegmentIterator();
        PairwiseIntersectorImpl intersector = new PairwiseIntersectorImpl(multi_path_impl_a, multi_path_impl_b, tolerance, false);
        while (intersector.next()) {
            int vertex_a = intersector.getRedElement();
            int vertex_b = intersector.getBlueElement();
            segIterA.resetToVertex(vertex_a);
            segIterB.resetToVertex(vertex_b);
            Segment segmentA = segIterA.nextSegment();
            Segment segmentB = segIterB.nextSegment();
            int result = segmentB.intersect(segmentA, null, null, null, tolerance);
            if (result <= 0) continue;
            return true;
        }
        return false;
    }

    private static boolean linearPathIntersectsMultiPoint_(MultiPath multipathA, MultiPoint multipoint_b, double tolerance, boolean b_intersects_all) {
        SegmentIteratorImpl segIterA = ((MultiPathImpl)multipathA._getImpl()).querySegmentIterator();
        boolean bContained = true;
        boolean bInteriorHitFound = false;
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        Envelope2D envInter = new Envelope2D();
        multipathA.queryEnvelope2D(env_a);
        multipoint_b.queryEnvelope2D(env_b);
        env_a.inflate(tolerance, tolerance);
        if (!env_a.contains(env_b)) {
            bContained = false;
        }
        env_b.inflate(tolerance, tolerance);
        envInter.setCoords(env_a);
        envInter.intersect(env_b);
        QuadTreeImpl qtA = null;
        QuadTreeImpl quadTreeA = null;
        QuadTreeImpl quadTreePathsA = null;
        GeometryAccelerators accel = ((MultiPathImpl)multipathA._getImpl())._getAccelerators();
        if (accel != null) {
            quadTreeA = accel.getQuadTree();
            if (quadTreeA == null) {
                quadTreeA = qtA = InternalUtils.buildQuadTree((MultiPathImpl)multipathA._getImpl(), envInter);
            }
        } else {
            quadTreeA = qtA = InternalUtils.buildQuadTree((MultiPathImpl)multipathA._getImpl(), envInter);
        }
        QuadTreeImpl.QuadTreeIteratorImpl qtIterA = quadTreeA.getIterator();
        QuadTreeImpl.QuadTreeIteratorImpl qtIterPathsA = null;
        if (quadTreePathsA != null) {
            qtIterPathsA = quadTreePathsA.getIterator();
        }
        Point2D ptB = new Point2D();
        Point2D closest = new Point2D();
        boolean b_intersects = false;
        double toleranceSq = tolerance * tolerance;
        for (int i = 0; i < multipoint_b.getPointCount(); ++i) {
            multipoint_b.getXY(i, ptB);
            if (!envInter.contains(ptB)) continue;
            env_b.setCoords(ptB.x, ptB.y, ptB.x, ptB.y);
            if (qtIterPathsA != null) {
                qtIterPathsA.resetIterator(env_b, tolerance);
                if (qtIterPathsA.next() == -1) continue;
            }
            qtIterA.resetIterator(env_b, tolerance);
            boolean b_covered = false;
            int elementHandleA = qtIterA.next();
            while (elementHandleA != -1) {
                int vertex_a = quadTreeA.getElement(elementHandleA);
                segIterA.resetToVertex(vertex_a);
                Segment segmentA = segIterA.nextSegment();
                double t = segmentA.getClosestCoordinate(ptB, false);
                segmentA.getCoord2D(t, closest);
                if (Point2D.sqrDistance(closest, ptB) <= toleranceSq) {
                    b_covered = true;
                    break;
                }
                elementHandleA = qtIterA.next();
            }
            if (b_intersects_all) {
                if (b_covered) continue;
                return false;
            }
            if (!b_covered) continue;
            return true;
        }
        return b_intersects_all;
    }

    static boolean linearPathIntersectsPoint_(MultiPath multipathA, Point2D ptB, double tolerance) {
        QuadTreeImpl quadTreeA;
        Point2D closest = new Point2D();
        double toleranceSq = tolerance * tolerance;
        SegmentIteratorImpl segIterA = ((MultiPathImpl)multipathA._getImpl()).querySegmentIterator();
        GeometryAccelerators accel = ((MultiPathImpl)multipathA._getImpl())._getAccelerators();
        if (accel != null && (quadTreeA = accel.getQuadTree()) != null) {
            Envelope2D env_b = new Envelope2D();
            env_b.setCoords(ptB);
            QuadTreeImpl.QuadTreeIteratorImpl qt_iter = quadTreeA.getIterator(env_b, tolerance);
            int e = qt_iter.next();
            while (e != -1) {
                segIterA.resetToVertex(quadTreeA.getElement(e));
                if (segIterA.hasNextSegment()) {
                    Segment segmentA = segIterA.nextSegment();
                    double t = segmentA.getClosestCoordinate(ptB, false);
                    segmentA.getCoord2D(t, closest);
                    if (Point2D.sqrDistance(ptB, closest) <= toleranceSq) {
                        return true;
                    }
                }
                e = qt_iter.next();
            }
            return false;
        }
        Envelope2D env_a = new Envelope2D();
        while (segIterA.nextPath()) {
            while (segIterA.hasNextSegment()) {
                Segment segmentA = segIterA.nextSegment();
                segmentA.queryEnvelope2D(env_a);
                env_a.inflate(tolerance, tolerance);
                if (!env_a.contains(ptB)) continue;
                double t = segmentA.getClosestCoordinate(ptB, false);
                segmentA.getCoord2D(t, closest);
                if (!(Point2D.sqrDistance(ptB, closest) <= toleranceSq)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean linearPathContainsPoint_(MultiPath multipathA, Point2D pt_b, double tolerance) {
        return RelationalOperations.linearPathIntersectsPoint_(multipathA, pt_b, tolerance) && !RelationalOperations.linearPathTouchesPointImpl_(multipathA, pt_b, tolerance);
    }

    private static boolean linearPathTouchesPointImpl_(MultiPath multipathA, Point2D ptB, double tolerance) {
        MultiPoint boundary = (MultiPoint)multipathA.getBoundary();
        return !RelationalOperations.multiPointDisjointPointImpl_(boundary, ptB, tolerance, null);
    }

    private static boolean linearPathIntersectsEnvelope_(MultiPath multipath_a, Envelope2D env_b, double tolerance, ProgressTracker progress_tracker) {
        if (!multipath_a.hasNonLinearSegments()) {
            Envelope2D env_b_inflated = new Envelope2D();
            env_b_inflated.setCoords(env_b);
            env_b_inflated.inflate(tolerance, tolerance);
            MultiPathImpl mimpl_a = (MultiPathImpl)multipath_a._getImpl();
            AttributeStreamOfDbl xy = (AttributeStreamOfDbl)mimpl_a.getAttributeStreamRef(0);
            Point2D pt = new Point2D();
            Point2D pt_prev = new Point2D();
            Point2D pt_1 = new Point2D();
            Point2D pt_2 = new Point2D();
            int npath = mimpl_a.getPathCount();
            for (int ipath = 0; ipath < npath; ++ipath) {
                boolean b_first = true;
                int n = mimpl_a.getPathEnd(ipath);
                for (int i = mimpl_a.getPathStart(ipath); i < n; ++i) {
                    if (b_first) {
                        xy.read(2 * i, pt_prev);
                        b_first = false;
                        continue;
                    }
                    xy.read(2 * i, pt);
                    pt_1.setCoords(pt_prev);
                    pt_2.setCoords(pt);
                    if (env_b_inflated.clipLine(pt_1, pt_2) != 0) {
                        return true;
                    }
                    pt_prev.setCoords(pt);
                }
            }
        } else {
            Line line_1 = new Line(env_b.xmin, env_b.ymin, env_b.xmin, env_b.ymax);
            Line line_2 = new Line(env_b.xmin, env_b.ymax, env_b.xmax, env_b.ymax);
            Line line3 = new Line(env_b.xmax, env_b.ymax, env_b.xmax, env_b.ymin);
            Line line4 = new Line(env_b.xmax, env_b.ymin, env_b.xmin, env_b.ymin);
            SegmentIterator iter = multipath_a.querySegmentIterator();
            while (iter.nextPath()) {
                while (iter.hasNextSegment()) {
                    Segment polySeg = iter.nextSegment();
                    if (polySeg.isIntersecting(line_1, tolerance)) {
                        return true;
                    }
                    if (polySeg.isIntersecting(line_2, tolerance)) {
                        return true;
                    }
                    if (polySeg.isIntersecting(line3, tolerance)) {
                        return true;
                    }
                    if (!polySeg.isIntersecting(line4, tolerance)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static int tryRasterizedContainsOrDisjoint_(Geometry geom_a, Geometry geom_b, double tolerance, boolean bExtraTestForIntersects) {
        RasterizedGeometry2D.HitType hit;
        RasterizedGeometry2D rgeom;
        MultiVertexGeometryImpl impl;
        GeometryAccelerators accel;
        int gtA = geom_a.getType().value();
        int gtB = geom_b.getType().value();
        if (Geometry.isMultiVertex(gtA) && (accel = (impl = (MultiVertexGeometryImpl)geom_a._getImpl())._getAccelerators()) != null && (rgeom = accel.getRasterizedGeometry()) != null) {
            if (gtB == 33) {
                Point2D ptB = ((Point)geom_b).getXY();
                hit = rgeom.queryPointInGeometry(ptB.x, ptB.y);
                if (hit == RasterizedGeometry2D.HitType.Inside) {
                    return 1;
                }
                if (hit == RasterizedGeometry2D.HitType.Outside) {
                    return 4;
                }
            } else {
                Envelope2D env_b = new Envelope2D();
                geom_b.queryEnvelope2D(env_b);
                hit = rgeom.queryEnvelopeInGeometry(env_b);
                if (hit == RasterizedGeometry2D.HitType.Inside) {
                    return 1;
                }
                if (hit == RasterizedGeometry2D.HitType.Outside) {
                    return 4;
                }
                if (bExtraTestForIntersects && Geometry.isMultiVertex(gtB) && RelationalOperations.checkVerticesForIntersection_((MultiVertexGeometryImpl)geom_b._getImpl(), rgeom)) {
                    return 0x40000000;
                }
            }
        }
        if (Geometry.isMultiVertex(gtB) && (accel = (impl = (MultiVertexGeometryImpl)geom_b._getImpl())._getAccelerators()) != null && (rgeom = accel.getRasterizedGeometry()) != null) {
            if (gtA == 33) {
                Point2D ptA = ((Point)geom_a).getXY();
                hit = rgeom.queryPointInGeometry(ptA.x, ptA.y);
                if (hit == RasterizedGeometry2D.HitType.Inside) {
                    return 2;
                }
                if (hit == RasterizedGeometry2D.HitType.Outside) {
                    return 4;
                }
            } else {
                Envelope2D env_a = new Envelope2D();
                geom_a.queryEnvelope2D(env_a);
                hit = rgeom.queryEnvelopeInGeometry(env_a);
                if (hit == RasterizedGeometry2D.HitType.Inside) {
                    return 2;
                }
                if (hit == RasterizedGeometry2D.HitType.Outside) {
                    return 4;
                }
                if (bExtraTestForIntersects && Geometry.isMultiVertex(gtA) && RelationalOperations.checkVerticesForIntersection_((MultiVertexGeometryImpl)geom_a._getImpl(), rgeom)) {
                    return 0x40000000;
                }
            }
        }
        return 0;
    }

    private static boolean checkVerticesForIntersection_(MultiVertexGeometryImpl geom, RasterizedGeometry2D rgeom) {
        int pointCount = geom.getPointCount();
        Point2D pt = new Point2D();
        for (int ipoint = 0; ipoint < pointCount; ++ipoint) {
            geom.getXY(ipoint, pt);
            RasterizedGeometry2D.HitType hit = rgeom.queryPointInGeometry(pt.x, pt.y);
            if (hit != RasterizedGeometry2D.HitType.Inside) continue;
            return true;
        }
        return false;
    }

    private static boolean polygonTouchesPolygonImpl_(Polygon polygon_a, Polygon polygon_b, double tolerance, ProgressTracker progressTracker) {
        Polygon _polygonB;
        Polygon _polygonA;
        MultiPathImpl polygon_impl_a = (MultiPathImpl)polygon_a._getImpl();
        MultiPathImpl polygon_impl_b = (MultiPathImpl)polygon_b._getImpl();
        boolean b_geometries_simple = polygon_impl_a.getIsSimple(0.0) >= 1 && polygon_impl_b.getIsSimple(0.0) >= 1;
        SegmentIteratorImpl segIterA = polygon_impl_a.querySegmentIterator();
        SegmentIteratorImpl segIterB = polygon_impl_b.querySegmentIterator();
        double[] scalarsA = new double[2];
        double[] scalarsB = new double[2];
        PairwiseIntersectorImpl intersector = new PairwiseIntersectorImpl(polygon_impl_a, polygon_impl_b, tolerance, false);
        boolean b_boundaries_intersect = false;
        while (intersector.next()) {
            double scalar_a_0;
            int vertex_a = intersector.getRedElement();
            int vertex_b = intersector.getBlueElement();
            segIterA.resetToVertex(vertex_a);
            segIterB.resetToVertex(vertex_b);
            Segment segmentA = segIterA.nextSegment();
            Segment segmentB = segIterB.nextSegment();
            int result = segmentB.intersect(segmentA, null, scalarsB, scalarsA, tolerance);
            if (result == 2) {
                scalar_a_0 = scalarsA[0];
                double scalar_a_1 = scalarsA[1];
                double length_a = segmentA.calculateLength2D();
                if (b_geometries_simple && (scalar_a_1 - scalar_a_0) * length_a > tolerance) {
                    return false;
                }
                b_boundaries_intersect = true;
                continue;
            }
            if (result == 0) continue;
            scalar_a_0 = scalarsA[0];
            double scalar_b_0 = scalarsB[0];
            if (scalar_a_0 > 0.0 && scalar_a_0 < 1.0 && scalar_b_0 > 0.0 && scalar_b_0 < 1.0) {
                return false;
            }
            b_boundaries_intersect = true;
        }
        if (!b_boundaries_intersect) {
            return false;
        }
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        Envelope2D envInter = new Envelope2D();
        polygon_a.queryEnvelope2D(env_a);
        polygon_b.queryEnvelope2D(env_b);
        env_a.inflate(1000.0 * tolerance, 1000.0 * tolerance);
        env_b.inflate(1000.0 * tolerance, 1000.0 * tolerance);
        envInter.setCoords(env_a);
        envInter.intersect(env_b);
        if (polygon_a.getPointCount() > 10) {
            _polygonA = (Polygon)Clipper.clip(polygon_a, envInter, tolerance, 0.0);
            if (_polygonA.isEmpty()) {
                return false;
            }
        } else {
            _polygonA = polygon_a;
        }
        if (polygon_b.getPointCount() > 10) {
            _polygonB = (Polygon)Clipper.clip(polygon_b, envInter, tolerance, 0.0);
            if (_polygonB.isEmpty()) {
                return false;
            }
        } else {
            _polygonB = polygon_b;
        }
        String scl = "F********";
        boolean bRelation = RelationalOperationsMatrix.polygonRelatePolygon_(_polygonA, _polygonB, tolerance, scl, progressTracker);
        return bRelation;
    }

    private static boolean polygonOverlapsPolygonImpl_(Polygon polygon_a, Polygon polygon_b, double tolerance, ProgressTracker progressTracker) {
        Polygon _polygonA;
        Polygon _polygonB;
        MultiPathImpl polygon_impl_a = (MultiPathImpl)polygon_a._getImpl();
        MultiPathImpl polygon_impl_b = (MultiPathImpl)polygon_b._getImpl();
        boolean b_geometries_simple = polygon_impl_a.getIsSimple(0.0) >= 1 && polygon_impl_b.getIsSimple(0.0) >= 1;
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        Envelope2D envInter = new Envelope2D();
        polygon_a.queryEnvelope2D(env_a);
        polygon_b.queryEnvelope2D(env_b);
        boolean bInteriorIntersectionKnown = false;
        boolean bIntAExtB = RelationalOperations.interiorEnvExteriorEnv_(env_a, env_b, tolerance);
        boolean bExtAIntB = RelationalOperations.interiorEnvExteriorEnv_(env_b, env_a, tolerance);
        SegmentIteratorImpl segIterA = polygon_impl_a.querySegmentIterator();
        SegmentIteratorImpl segIterB = polygon_impl_b.querySegmentIterator();
        double[] scalarsA = new double[2];
        double[] scalarsB = new double[2];
        PairwiseIntersectorImpl intersector = new PairwiseIntersectorImpl(polygon_impl_a, polygon_impl_b, tolerance, false);
        while (intersector.next()) {
            double scalar_a_0;
            int vertex_a = intersector.getRedElement();
            int vertex_b = intersector.getBlueElement();
            segIterA.resetToVertex(vertex_a);
            segIterB.resetToVertex(vertex_b);
            Segment segmentA = segIterA.nextSegment();
            Segment segmentB = segIterB.nextSegment();
            int result = segmentB.intersect(segmentA, null, scalarsB, scalarsA, tolerance);
            if (result == 2) {
                scalar_a_0 = scalarsA[0];
                double scalar_a_1 = scalarsA[1];
                double length_a = segmentA.calculateLength2D();
                if (!b_geometries_simple || !((scalar_a_1 - scalar_a_0) * length_a > tolerance)) continue;
                bInteriorIntersectionKnown = true;
                if (!bIntAExtB || !bExtAIntB) continue;
                return true;
            }
            if (result == 0) continue;
            scalar_a_0 = scalarsA[0];
            double scalar_b_0 = scalarsB[0];
            if (!(scalar_a_0 > 0.0) || !(scalar_a_0 < 1.0) || !(scalar_b_0 > 0.0) || !(scalar_b_0 < 1.0)) continue;
            return true;
        }
        Envelope2D envAInflated = new Envelope2D();
        Envelope2D envBInflated = new Envelope2D();
        envAInflated.setCoords(env_a);
        envAInflated.inflate(1000.0 * tolerance, 1000.0 * tolerance);
        envBInflated.setCoords(env_b);
        envBInflated.inflate(1000.0 * tolerance, 1000.0 * tolerance);
        envInter.setCoords(envAInflated);
        envInter.intersect(envBInflated);
        StringBuilder scl = new StringBuilder();
        if (!bInteriorIntersectionKnown) {
            scl.append("T*");
        } else {
            scl.append("**");
        }
        if (bIntAExtB) {
            if (polygon_b.getPointCount() > 10) {
                _polygonB = (Polygon)Clipper.clip(polygon_b, envInter, tolerance, 0.0);
                if (_polygonB.isEmpty()) {
                    return false;
                }
            } else {
                _polygonB = polygon_b;
            }
            scl.append("****");
        } else {
            _polygonB = polygon_b;
            scl.append("T***");
        }
        if (bExtAIntB) {
            if (polygon_a.getPointCount() > 10) {
                _polygonA = (Polygon)Clipper.clip(polygon_a, envInter, tolerance, 0.0);
                if (_polygonA.isEmpty()) {
                    return false;
                }
            } else {
                _polygonA = polygon_a;
            }
            scl.append("***");
        } else {
            _polygonA = polygon_a;
            scl.append("T**");
        }
        boolean bRelation = RelationalOperationsMatrix.polygonRelatePolygon_(_polygonA, _polygonB, tolerance, scl.toString(), progressTracker);
        return bRelation;
    }

    private static boolean polygonContainsPolygonImpl_(Polygon polygon_a, Polygon polygon_b, double tolerance, ProgressTracker progressTracker) {
        boolean[] b_result_known = new boolean[]{false};
        boolean res = RelationalOperations.polygonContainsMultiPath_(polygon_a, polygon_b, tolerance, b_result_known, progressTracker);
        if (b_result_known[0]) {
            return res;
        }
        Envelope2D envBInflated = new Envelope2D();
        polygon_b.queryEnvelope2D(envBInflated);
        envBInflated.inflate(1000.0 * tolerance, 1000.0 * tolerance);
        Polygon _polygonA = null;
        if (polygon_a.getPointCount() > 10) {
            _polygonA = (Polygon)Clipper.clip(polygon_a, envBInflated, tolerance, 0.0);
            if (_polygonA.isEmpty()) {
                return false;
            }
        } else {
            _polygonA = polygon_a;
        }
        boolean bContains = RelationalOperationsMatrix.polygonContainsPolygon_(_polygonA, polygon_b, tolerance, progressTracker);
        return bContains;
    }

    private static boolean polygonContainsMultiPath_(Polygon polygon_a, MultiPath multi_path_b, double tolerance, boolean[] b_result_known, ProgressTracker progress_tracker) {
        b_result_known[0] = false;
        MultiPathImpl polygon_impl_a = (MultiPathImpl)polygon_a._getImpl();
        MultiPathImpl multi_path_impl_b = (MultiPathImpl)multi_path_b._getImpl();
        SegmentIteratorImpl segIterA = polygon_impl_a.querySegmentIterator();
        SegmentIteratorImpl segIterB = multi_path_impl_b.querySegmentIterator();
        double[] scalarsA = new double[2];
        double[] scalarsB = new double[2];
        PairwiseIntersectorImpl intersector = new PairwiseIntersectorImpl(polygon_impl_a, multi_path_impl_b, tolerance, false);
        boolean b_boundaries_intersect = false;
        while (intersector.next()) {
            int vertex_a = intersector.getRedElement();
            int vertex_b = intersector.getBlueElement();
            segIterA.resetToVertex(vertex_a, -1);
            segIterB.resetToVertex(vertex_b, -1);
            Segment segmentA = segIterA.nextSegment();
            Segment segmentB = segIterB.nextSegment();
            int result = segmentB.intersect(segmentA, null, scalarsB, scalarsA, tolerance);
            if (result == 0) continue;
            b_boundaries_intersect = true;
            if (result != 1) continue;
            double scalar_a_0 = scalarsA[0];
            double scalar_b_0 = scalarsB[0];
            if (!(scalar_a_0 > 0.0) || !(scalar_a_0 < 1.0) || !(scalar_b_0 > 0.0) || !(scalar_b_0 < 1.0)) continue;
            b_result_known[0] = true;
            return false;
        }
        if (!b_boundaries_intersect) {
            b_result_known[0] = true;
            Envelope2D env_a_inflated = new Envelope2D();
            polygon_a.queryEnvelope2D(env_a_inflated);
            env_a_inflated.inflate(tolerance, tolerance);
            Polygon pa = null;
            Polygon p_polygon_a = polygon_a;
            boolean b_checked_polygon_a_quad_tree = false;
            Envelope2D path_env_b = new Envelope2D();
            int npath = multi_path_b.getPathCount();
            for (int ipath = 0; ipath < npath; ++ipath) {
                if (multi_path_b.getPathSize(ipath) <= 0) continue;
                multi_path_b.queryPathEnvelope2D(ipath, path_env_b);
                if (env_a_inflated.isIntersecting(path_env_b)) {
                    Point2D anyPoint = multi_path_b.getXY(multi_path_b.getPathStart(ipath));
                    int res = PointInPolygonHelper.isPointInPolygon(p_polygon_a, anyPoint, 0.0);
                    if (res == 0) {
                        return false;
                    }
                } else {
                    return false;
                }
                if (b_checked_polygon_a_quad_tree) continue;
                if (PointInPolygonHelper.quadTreeWillHelp(polygon_a, multi_path_b.getPathCount() - 1) && (polygon_impl_a._getAccelerators() == null || polygon_impl_a._getAccelerators().getQuadTree() == null)) {
                    pa = new Polygon();
                    polygon_a.copyTo(pa);
                    ((MultiPathImpl)pa._getImpl())._buildQuadTreeAccelerator(Geometry.GeometryAccelerationDegree.enumMedium);
                    p_polygon_a = pa;
                } else {
                    p_polygon_a = polygon_a;
                }
                b_checked_polygon_a_quad_tree = true;
            }
            if (polygon_a.getPathCount() == 1 || multi_path_b.getType().value() == 1607) {
                return true;
            }
            Polygon polygon_b = (Polygon)multi_path_b;
            Envelope2D env_b_inflated = new Envelope2D();
            polygon_b.queryEnvelope2D(env_b_inflated);
            env_b_inflated.inflate(tolerance, tolerance);
            Polygon pb = null;
            Polygon p_polygon_b = polygon_b;
            boolean b_checked_polygon_b_quad_tree = false;
            Envelope2D path_env_a = new Envelope2D();
            int npath2 = polygon_a.getPathCount();
            for (int ipath = 0; ipath < npath2; ++ipath) {
                Point2D anyPoint;
                int res;
                if (polygon_a.getPathSize(ipath) <= 0) continue;
                polygon_a.queryPathEnvelope2D(ipath, path_env_a);
                if (env_b_inflated.isIntersecting(path_env_a) && (res = PointInPolygonHelper.isPointInPolygon(p_polygon_b, anyPoint = polygon_a.getXY(polygon_a.getPathStart(ipath)), 0.0)) == 1) {
                    return false;
                }
                if (b_checked_polygon_b_quad_tree) continue;
                if (PointInPolygonHelper.quadTreeWillHelp(polygon_b, polygon_a.getPathCount() - 1) && (multi_path_impl_b._getAccelerators() == null || multi_path_impl_b._getAccelerators().getQuadTree() == null)) {
                    pb = new Polygon();
                    polygon_b.copyTo(pb);
                    ((MultiPathImpl)pb._getImpl())._buildQuadTreeAccelerator(Geometry.GeometryAccelerationDegree.enumMedium);
                    p_polygon_b = pb;
                } else {
                    p_polygon_b = polygon_b;
                }
                b_checked_polygon_b_quad_tree = true;
            }
            return true;
        }
        return false;
    }

    private static boolean polygonTouchesPolylineImpl_(Polygon polygon_a, Polyline polyline_b, double tolerance, ProgressTracker progressTracker) {
        Polyline _polylineB;
        Polygon _polygonA;
        MultiPathImpl polygon_impl_a = (MultiPathImpl)polygon_a._getImpl();
        MultiPathImpl polyline_impl_b = (MultiPathImpl)polyline_b._getImpl();
        SegmentIteratorImpl segIterA = polygon_impl_a.querySegmentIterator();
        SegmentIteratorImpl segIterB = polyline_impl_b.querySegmentIterator();
        double[] scalarsA = new double[2];
        double[] scalarsB = new double[2];
        PairwiseIntersectorImpl intersector = new PairwiseIntersectorImpl(polygon_impl_a, polyline_impl_b, tolerance, false);
        boolean b_boundaries_intersect = false;
        while (intersector.next()) {
            int vertex_a = intersector.getRedElement();
            int vertex_b = intersector.getBlueElement();
            segIterA.resetToVertex(vertex_a);
            segIterB.resetToVertex(vertex_b);
            Segment segmentA = segIterA.nextSegment();
            Segment segmentB = segIterB.nextSegment();
            int result = segmentB.intersect(segmentA, null, scalarsB, scalarsA, tolerance);
            if (result == 2) {
                b_boundaries_intersect = true;
                continue;
            }
            if (result == 0) continue;
            double scalar_a_0 = scalarsA[0];
            double scalar_b_0 = scalarsB[0];
            if (scalar_a_0 > 0.0 && scalar_a_0 < 1.0 && scalar_b_0 > 0.0 && scalar_b_0 < 1.0) {
                return false;
            }
            b_boundaries_intersect = true;
        }
        if (!b_boundaries_intersect) {
            return false;
        }
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        Envelope2D envInter = new Envelope2D();
        polygon_a.queryEnvelope2D(env_a);
        polyline_b.queryEnvelope2D(env_b);
        env_a.inflate(1000.0 * tolerance, 1000.0 * tolerance);
        env_b.inflate(1000.0 * tolerance, 1000.0 * tolerance);
        envInter.setCoords(env_a);
        envInter.intersect(env_b);
        if (polygon_a.getPointCount() > 10) {
            _polygonA = (Polygon)Clipper.clip(polygon_a, envInter, tolerance, 0.0);
            if (_polygonA.isEmpty()) {
                return false;
            }
        } else {
            _polygonA = polygon_a;
        }
        if (polyline_b.getPointCount() > 10) {
            _polylineB = (Polyline)Clipper.clip(polyline_b, envInter, tolerance, 0.0);
            if (_polylineB.isEmpty()) {
                return false;
            }
        } else {
            _polylineB = polyline_b;
        }
        String scl = "F********";
        boolean bRelation = RelationalOperationsMatrix.polygonRelatePolyline_(_polygonA, _polylineB, tolerance, scl, progressTracker);
        return bRelation;
    }

    private static boolean polygonCrossesPolylineImpl_(Polygon polygon_a, Polyline polyline_b, double tolerance, ProgressTracker progressTracker) {
        MultiPathImpl polygon_impl_a = (MultiPathImpl)polygon_a._getImpl();
        MultiPathImpl polyline_impl_b = (MultiPathImpl)polyline_b._getImpl();
        SegmentIteratorImpl segIterA = polygon_impl_a.querySegmentIterator();
        SegmentIteratorImpl segIterB = polyline_impl_b.querySegmentIterator();
        double[] scalarsA = new double[2];
        double[] scalarsB = new double[2];
        PairwiseIntersectorImpl intersector = new PairwiseIntersectorImpl(polygon_impl_a, polyline_impl_b, tolerance, false);
        boolean b_boundaries_intersect = false;
        while (intersector.next()) {
            int vertex_a = intersector.getRedElement();
            int vertex_b = intersector.getBlueElement();
            segIterA.resetToVertex(vertex_a);
            segIterB.resetToVertex(vertex_b);
            Segment segmentA = segIterA.nextSegment();
            Segment segmentB = segIterB.nextSegment();
            int result = segmentB.intersect(segmentA, null, scalarsB, scalarsA, tolerance);
            if (result == 2) {
                b_boundaries_intersect = true;
                continue;
            }
            if (result == 0) continue;
            double scalar_a_0 = scalarsA[0];
            double scalar_b_0 = scalarsB[0];
            if (scalar_a_0 > 0.0 && scalar_a_0 < 1.0 && scalar_b_0 > 0.0 && scalar_b_0 < 1.0) {
                return true;
            }
            b_boundaries_intersect = true;
        }
        if (!b_boundaries_intersect) {
            return false;
        }
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        Envelope2D envAInflated = new Envelope2D();
        Envelope2D envBInflated = new Envelope2D();
        Envelope2D envInter = new Envelope2D();
        polygon_a.queryEnvelope2D(env_a);
        polyline_b.queryEnvelope2D(env_b);
        if (RelationalOperations.interiorEnvExteriorEnv_(env_b, env_a, tolerance)) {
            Polyline _polylineB;
            Polygon _polygonA;
            envAInflated.setCoords(env_a);
            envAInflated.inflate(1000.0 * tolerance, 1000.0 * tolerance);
            envBInflated.setCoords(env_b);
            envBInflated.inflate(1000.0 * tolerance, 1000.0 * tolerance);
            envInter.setCoords(envAInflated);
            envInter.intersect(envBInflated);
            if (polygon_a.getPointCount() > 10) {
                _polygonA = (Polygon)Clipper.clip(polygon_a, envInter, tolerance, 0.0);
                if (_polygonA.isEmpty()) {
                    return false;
                }
            } else {
                _polygonA = polygon_a;
            }
            if (polyline_b.getPointCount() > 10) {
                _polylineB = (Polyline)Clipper.clip(polyline_b, envInter, tolerance, 0.0);
                if (_polylineB.isEmpty()) {
                    return false;
                }
            } else {
                _polylineB = polyline_b;
            }
            String scl = "T********";
            boolean bRelation = RelationalOperationsMatrix.polygonRelatePolyline_(_polygonA, _polylineB, tolerance, scl, progressTracker);
            return bRelation;
        }
        String scl = "T*****T**";
        boolean bRelation = RelationalOperationsMatrix.polygonRelatePolyline_(polygon_a, polyline_b, tolerance, scl, progressTracker);
        return bRelation;
    }

    private static boolean polygonContainsPolylineImpl_(Polygon polygon_a, Polyline polyline_b, double tolerance, ProgressTracker progress_tracker) {
        boolean[] b_result_known = new boolean[]{false};
        boolean res = RelationalOperations.polygonContainsMultiPath_(polygon_a, polyline_b, tolerance, b_result_known, progress_tracker);
        if (b_result_known[0]) {
            return res;
        }
        Envelope2D envBInflated = new Envelope2D();
        polyline_b.queryEnvelope2D(envBInflated);
        envBInflated.inflate(1000.0 * tolerance, 1000.0 * tolerance);
        Polygon _polygonA = null;
        if (polygon_a.getPointCount() > 10) {
            _polygonA = (Polygon)Clipper.clip(polygon_a, envBInflated, tolerance, 0.0);
            if (_polygonA.isEmpty()) {
                return false;
            }
        } else {
            _polygonA = polygon_a;
        }
        boolean bContains = RelationalOperationsMatrix.polygonContainsPolyline_(_polygonA, polyline_b, tolerance, progress_tracker);
        return bContains;
    }

    private static boolean polygonContainsPointImpl_(Polygon polygon_a, Point2D pt_b, double tolerance, ProgressTracker progressTracker) {
        PolygonUtils.PiPResult result = PolygonUtils.isPointInPolygon2D(polygon_a, pt_b, tolerance);
        return result == PolygonUtils.PiPResult.PiPInside;
    }

    private static boolean polygonTouchesPointImpl_(Polygon polygon_a, Point2D pt_b, double tolerance, ProgressTracker progressTracker) {
        PolygonUtils.PiPResult result = PolygonUtils.isPointInPolygon2D(polygon_a, pt_b, tolerance);
        return result == PolygonUtils.PiPResult.PiPBoundary;
    }

    static boolean multiPointDisjointPointImpl_(MultiPoint multipoint_a, Point2D pt_b, double tolerance, ProgressTracker progressTracker) {
        Point2D pt_a = new Point2D();
        double tolerance_sq = tolerance * tolerance;
        for (int i = 0; i < multipoint_a.getPointCount(); ++i) {
            multipoint_a.getXY(i, pt_a);
            if (!(Point2D.sqrDistance(pt_a, pt_b) <= tolerance_sq)) continue;
            return false;
        }
        return true;
    }

    private RelationalOperations() {
    }

    int compareOverlapEvents_(int o_1, int o_2) {
        OverlapEvent overlapEvent1 = this.m_overlap_events.get(o_1);
        OverlapEvent overlapEvent2 = this.m_overlap_events.get(o_2);
        if (overlapEvent1.m_ipath_a < overlapEvent2.m_ipath_a) {
            return -1;
        }
        if (overlapEvent1.m_ipath_a == overlapEvent2.m_ipath_a) {
            if (overlapEvent1.m_ivertex_a < overlapEvent2.m_ivertex_a) {
                return -1;
            }
            if (overlapEvent1.m_ivertex_a == overlapEvent2.m_ivertex_a) {
                if (overlapEvent1.m_scalar_a_0 < overlapEvent2.m_scalar_a_0) {
                    return -1;
                }
                if (overlapEvent1.m_scalar_a_0 == overlapEvent2.m_scalar_a_0) {
                    if (overlapEvent1.m_scalar_a_1 < overlapEvent2.m_scalar_a_1) {
                        return -1;
                    }
                    if (overlapEvent1.m_scalar_a_1 == overlapEvent2.m_scalar_a_1 && overlapEvent1.m_ivertex_b < overlapEvent2.m_ivertex_b) {
                        return -1;
                    }
                }
            }
        }
        return 1;
    }

    static final class Accelerate_helper {
        Accelerate_helper() {
        }

        static boolean accelerate_geometry(Geometry geometry, SpatialReference sr, Geometry.GeometryAccelerationDegree accel_degree) {
            Geometry.Type type;
            if (!Accelerate_helper.can_accelerate_geometry(geometry)) {
                return false;
            }
            double tol = InternalUtils.calculateToleranceFromGeometry(sr, geometry, false);
            boolean bAccelerated = false;
            if (GeometryAccelerators.canUseRasterizedGeometry(geometry)) {
                bAccelerated |= ((MultiVertexGeometryImpl)geometry._getImpl())._buildRasterizedGeometryAccelerator(tol, accel_degree);
            }
            if (((type = geometry.getType()) == Geometry.Type.Polygon || type == Geometry.Type.Polyline) && GeometryAccelerators.canUseQuadTree(geometry) && accel_degree != Geometry.GeometryAccelerationDegree.enumMild) {
                bAccelerated |= ((MultiVertexGeometryImpl)geometry._getImpl())._buildQuadTreeAccelerator(accel_degree);
            }
            if ((type == Geometry.Type.Polygon || type == Geometry.Type.Polyline) && GeometryAccelerators.canUseQuadTreeForPaths(geometry) && accel_degree != Geometry.GeometryAccelerationDegree.enumMild) {
                bAccelerated |= ((MultiPathImpl)geometry._getImpl())._buildQuadTreeForPathsAccelerator(accel_degree);
            }
            return bAccelerated;
        }

        static boolean can_accelerate_geometry(Geometry geometry) {
            return GeometryAccelerators.canUseRasterizedGeometry(geometry) || GeometryAccelerators.canUseQuadTree(geometry) || GeometryAccelerators.canUseQuadTreeForPaths(geometry);
        }
    }

    private static class OverlapComparer
    extends AttributeStreamOfInt32.IntComparator {
        private RelationalOperations m_rel_ops;

        OverlapComparer(RelationalOperations rel_ops) {
            this.m_rel_ops = rel_ops;
        }

        @Override
        public int compare(int o_1, int o_2) {
            return this.m_rel_ops.compareOverlapEvents_(o_1, o_2);
        }
    }

    private static final class OverlapEvent {
        int m_ivertex_a;
        int m_ipath_a;
        double m_scalar_a_0;
        double m_scalar_a_1;
        int m_ivertex_b;
        int m_ipath_b;
        double m_scalar_b_0;
        double m_scalar_b_1;

        private OverlapEvent() {
        }

        static OverlapEvent construct(int ivertex_a, int ipath_a, double scalar_a_0, double scalar_a_1, int ivertex_b, int ipath_b, double scalar_b_0, double scalar_b_1) {
            OverlapEvent overlapEvent = new OverlapEvent();
            overlapEvent.m_ivertex_a = ivertex_a;
            overlapEvent.m_ipath_a = ipath_a;
            overlapEvent.m_scalar_a_0 = scalar_a_0;
            overlapEvent.m_scalar_a_1 = scalar_a_1;
            overlapEvent.m_ivertex_b = ivertex_b;
            overlapEvent.m_ipath_b = ipath_b;
            overlapEvent.m_scalar_b_0 = scalar_b_0;
            overlapEvent.m_scalar_b_1 = scalar_b_1;
            return overlapEvent;
        }
    }

    static interface Relation {
        public static final int contains = 1;
        public static final int within = 2;
        public static final int equals = 3;
        public static final int disjoint = 4;
        public static final int touches = 8;
        public static final int crosses = 16;
        public static final int overlaps = 32;
        public static final int unknown = 0;
        public static final int intersects = 0x40000000;
    }
}

