/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j;

import org.apache.flink.calcite.shaded.com.google.common.base.Preconditions;

class ModularInteger {
    private final int value;
    private final int modulus;

    ModularInteger(int value2, int modulus) {
        Preconditions.checkArgument(value2 >= 0 && value2 < modulus);
        this.value = value2;
        this.modulus = modulus;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ModularInteger && this.value == ((ModularInteger)obj).value && this.modulus == ((ModularInteger)obj).modulus;
    }

    public int hashCode() {
        return this.value + 8191 * this.modulus;
    }

    public int get() {
        return this.value;
    }

    public ModularInteger plus(int operand) {
        if (operand < 0) {
            return this.minus(Math.abs(operand));
        }
        return new ModularInteger((this.value + operand) % this.modulus, this.modulus);
    }

    public ModularInteger minus(int operand) {
        int r;
        assert (operand >= 0);
        for (r = this.value - operand; r < 0; r += this.modulus) {
        }
        return new ModularInteger(r, this.modulus);
    }

    public String toString() {
        return this.value + " mod " + this.modulus;
    }
}

