/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules.materialize;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.AggregateProjectPullUpConstantsRule;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.rules.FilterAggregateTransposeRule;
import org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import org.apache.calcite.rel.rules.ProjectMergeRule;
import org.apache.calcite.rel.rules.materialize.MaterializedViewRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBeans;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.flink.calcite.shaded.com.google.common.base.Preconditions;
import org.apache.flink.calcite.shaded.com.google.common.collect.ArrayListMultimap;
import org.apache.flink.calcite.shaded.com.google.common.collect.BiMap;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableCollection;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMultimap;
import org.apache.flink.calcite.shaded.com.google.common.collect.Iterables;
import org.apache.flink.calcite.shaded.com.google.common.collect.Multimap;

public abstract class MaterializedViewAggregateRule<C extends Config>
extends MaterializedViewRule<C> {
    protected static final ImmutableList<TimeUnitRange> SUPPORTED_DATE_TIME_ROLLUP_UNITS = ImmutableList.of(TimeUnitRange.YEAR, TimeUnitRange.QUARTER, TimeUnitRange.MONTH, TimeUnitRange.DAY, TimeUnitRange.HOUR, TimeUnitRange.MINUTE, TimeUnitRange.SECOND, TimeUnitRange.MILLISECOND, TimeUnitRange.MICROSECOND);

    MaterializedViewAggregateRule(C config) {
        super(config);
    }

    @Override
    protected boolean isValidPlan(Project topProject, RelNode node, RelMetadataQuery mq) {
        if (!(node instanceof Aggregate)) {
            return false;
        }
        Aggregate aggregate = (Aggregate)node;
        if (aggregate.getGroupType() != Aggregate.Group.SIMPLE) {
            return false;
        }
        return this.isValidRelNodePlan(aggregate.getInput(), mq);
    }

    @Override
    protected MaterializedViewRule.ViewPartialRewriting compensateViewPartial(RelBuilder relBuilder, RexBuilder rexBuilder, RelMetadataQuery mq, RelNode input, Project topProject, RelNode node, Set<RexTableInputRef.RelTableRef> queryTableRefs, MaterializedViewRule.EquivalenceClasses queryEC, Project topViewProject, RelNode viewNode, Set<RexTableInputRef.RelTableRef> viewTableRefs) {
        HashSet<RexTableInputRef.RelTableRef> extraTableRefs = new HashSet<RexTableInputRef.RelTableRef>();
        for (RexTableInputRef.RelTableRef tRef : queryTableRefs) {
            if (viewTableRefs.contains(tRef)) continue;
            extraTableRefs.add(tRef);
        }
        Collection<RelNode> tableScanNodes = mq.getNodeTypes(node).get(TableScan.class);
        ArrayList<RelNode> newRels = new ArrayList<RelNode>();
        block1: for (RexTableInputRef.RelTableRef tRef : extraTableRefs) {
            int i = 0;
            for (RelNode relNode : tableScanNodes) {
                if (!tRef.getQualifiedName().equals(relNode.getTable().getQualifiedName()) || tRef.getEntityNumber() != i++) continue;
                newRels.add(relNode);
                continue block1;
            }
        }
        assert (extraTableRefs.size() == newRels.size());
        relBuilder.push(input);
        for (RelNode newRel : newRels) {
            relBuilder.push(newRel);
            relBuilder.join(JoinRelType.INNER, rexBuilder.makeLiteral(true));
        }
        RelNode newView = relBuilder.build();
        Aggregate aggregateViewNode = (Aggregate)viewNode;
        relBuilder.push(aggregateViewNode.getInput());
        int offset = 0;
        for (RelNode newRel : newRels) {
            relBuilder.push(newRel);
            relBuilder.join(JoinRelType.INNER, rexBuilder.makeLiteral(true));
            offset += newRel.getRowType().getFieldCount();
        }
        ImmutableBitSet.Builder groupSet = ImmutableBitSet.builder();
        groupSet.addAll(aggregateViewNode.getGroupSet());
        groupSet.addAll(ImmutableBitSet.range(aggregateViewNode.getInput().getRowType().getFieldCount(), aggregateViewNode.getInput().getRowType().getFieldCount() + offset));
        Aggregate newViewNode = aggregateViewNode.copy(aggregateViewNode.getTraitSet(), relBuilder.build(), groupSet.build(), null, aggregateViewNode.getAggCallList());
        relBuilder.push(newViewNode);
        ArrayList<RexNode> nodes = new ArrayList<RexNode>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        if (topViewProject != null) {
            int i;
            Mappings.TargetMapping shiftMapping = Mappings.createShiftMapping(newViewNode.getRowType().getFieldCount(), 0, 0, aggregateViewNode.getGroupCount(), newViewNode.getGroupCount(), aggregateViewNode.getGroupCount(), aggregateViewNode.getAggCallList().size());
            for (i = 0; i < topViewProject.getProjects().size(); ++i) {
                nodes.add(topViewProject.getProjects().get(i).accept(new RexPermuteInputsShuttle(shiftMapping, newViewNode)));
                fieldNames.add(topViewProject.getRowType().getFieldNames().get(i));
            }
            for (i = aggregateViewNode.getRowType().getFieldCount(); i < newViewNode.getRowType().getFieldCount(); ++i) {
                int idx = i - aggregateViewNode.getAggCallList().size();
                nodes.add(rexBuilder.makeInputRef(newViewNode, idx));
                fieldNames.add(newViewNode.getRowType().getFieldNames().get(idx));
            }
        } else {
            for (int i = 0; i < newViewNode.getRowType().getFieldCount(); ++i) {
                int idx = i < aggregateViewNode.getGroupCount() ? i : (i < aggregateViewNode.getRowType().getFieldCount() ? i + offset : i - aggregateViewNode.getAggCallList().size());
                nodes.add(rexBuilder.makeInputRef(newViewNode, idx));
                fieldNames.add(newViewNode.getRowType().getFieldNames().get(idx));
            }
        }
        relBuilder.project(nodes, fieldNames, true);
        Project newTopViewProject = (Project)relBuilder.build();
        return MaterializedViewRule.ViewPartialRewriting.of(newView, newTopViewProject, newViewNode);
    }

    @Override
    protected RelNode rewriteQuery(RelBuilder relBuilder, RexBuilder rexBuilder, RexSimplify simplify, RelMetadataQuery mq, RexNode compensationColumnsEquiPred, RexNode otherCompensationPred, Project topProject, RelNode node, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> queryToViewTableMapping, MaterializedViewRule.EquivalenceClasses viewEC, MaterializedViewRule.EquivalenceClasses queryEC) {
        Aggregate aggregate = (Aggregate)node;
        RelNode newAggregateInput = aggregate.getInput(0);
        RelNode target = aggregate.getInput(0);
        if (((Config)this.config).unionRewritingPullProgram() != null) {
            HepPlanner tmpPlanner = new HepPlanner(((Config)this.config).unionRewritingPullProgram());
            tmpPlanner.setRoot(newAggregateInput);
            newAggregateInput = tmpPlanner.findBestExp();
            target = newAggregateInput.getInput(0);
        }
        List<RexNode> queryExprs = this.extractReferences(rexBuilder, target);
        if (!compensationColumnsEquiPred.isAlwaysTrue() && (compensationColumnsEquiPred = this.rewriteExpression(rexBuilder, mq, target, target, queryExprs, queryToViewTableMapping, queryEC, false, compensationColumnsEquiPred)) == null) {
            return null;
        }
        if (!otherCompensationPred.isAlwaysTrue() && (otherCompensationPred = this.rewriteExpression(rexBuilder, mq, target, target, queryExprs, queryToViewTableMapping, viewEC, true, otherCompensationPred)) == null) {
            return null;
        }
        RexNode queryCompensationPred = RexUtil.not(RexUtil.composeConjunction(rexBuilder, ImmutableList.of(compensationColumnsEquiPred, otherCompensationPred)));
        RelNode rewrittenPlan = relBuilder.push(target).filter(simplify.simplifyUnknownAsFalse(queryCompensationPred)).build();
        if (((Config)this.config).unionRewritingPullProgram() != null) {
            return aggregate.copy(aggregate.getTraitSet(), ImmutableList.of(newAggregateInput.copy(newAggregateInput.getTraitSet(), ImmutableList.of(rewrittenPlan))));
        }
        return aggregate.copy(aggregate.getTraitSet(), ImmutableList.of(rewrittenPlan));
    }

    @Override
    protected RelNode createUnion(RelBuilder relBuilder, RexBuilder rexBuilder, RelNode topProject, RelNode unionInputQuery, RelNode unionInputView) {
        RelNode result;
        relBuilder.push(unionInputQuery);
        relBuilder.push(unionInputView);
        relBuilder.union(true);
        ArrayList<RexNode> exprList = new ArrayList<RexNode>(relBuilder.peek().getRowType().getFieldCount());
        ArrayList<String> nameList = new ArrayList<String>(relBuilder.peek().getRowType().getFieldCount());
        for (int i = 0; i < relBuilder.peek().getRowType().getFieldCount(); ++i) {
            RelDataTypeField field = unionInputQuery.getRowType().getFieldList().get(i);
            exprList.add(rexBuilder.ensureType(field.getType(), rexBuilder.makeInputRef(relBuilder.peek(), i), true));
            nameList.add(field.getName());
        }
        relBuilder.project(exprList, nameList);
        Aggregate aggregate = (Aggregate)unionInputQuery;
        ImmutableBitSet groupSet = ImmutableBitSet.range(aggregate.getGroupCount());
        ArrayList<RelBuilder.AggCall> aggregateCalls = new ArrayList<RelBuilder.AggCall>();
        for (int i = 0; i < aggregate.getAggCallList().size(); ++i) {
            AggregateCall aggCall = aggregate.getAggCallList().get(i);
            if (aggCall.isDistinct()) {
                return null;
            }
            SqlAggFunction rollupAgg = this.getRollup(aggCall.getAggregation());
            if (rollupAgg == null) {
                return null;
            }
            RexInputRef operand = rexBuilder.makeInputRef(relBuilder.peek(), aggregate.getGroupCount() + i);
            aggregateCalls.add(relBuilder.aggregateCall(rollupAgg, operand).distinct(aggCall.isDistinct()).approximate(aggCall.isApproximate()).as(aggCall.name));
        }
        RelNode prevNode = relBuilder.peek();
        if (prevNode == (result = relBuilder.aggregate(relBuilder.groupKey(groupSet), (Iterable<RelBuilder.AggCall>)aggregateCalls).build()) && groupSet.cardinality() != result.getRowType().getFieldCount()) {
            result = relBuilder.push(result).project(relBuilder.fields(groupSet)).build();
        }
        if (topProject != null) {
            return topProject.copy(topProject.getTraitSet(), ImmutableList.of(result));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected RelNode rewriteView(RelBuilder relBuilder, RexBuilder rexBuilder, RexSimplify simplify, RelMetadataQuery mq, MaterializedViewRule.MatchModality matchModality, boolean unionRewriting, RelNode input, Project topProject, RelNode node, Project topViewProject, RelNode viewNode, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> queryToViewTableMapping, MaterializedViewRule.EquivalenceClasses queryEC) {
        RelDataType topRowType;
        Aggregate queryAggregate = (Aggregate)node;
        Aggregate viewAggregate = (Aggregate)viewNode;
        ImmutableBitSet.Builder indexes = ImmutableBitSet.builder();
        ImmutableBitSet references = null;
        if (topProject != null && !unionRewriting) {
            int i;
            RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(new LinkedHashSet<RelDataTypeField>());
            inputFinder.visitEach(topProject.getProjects());
            references = inputFinder.build();
            for (i = 0; i < queryAggregate.getGroupCount(); ++i) {
                indexes.set(queryAggregate.getGroupSet().nth(i));
            }
            for (i = 0; i < queryAggregate.getAggCallList().size(); ++i) {
                if (!references.get(queryAggregate.getGroupCount() + i)) continue;
                for (int inputIdx : queryAggregate.getAggCallList().get(i).getArgList()) {
                    indexes.set(inputIdx);
                }
            }
        } else {
            for (int i = 0; i < queryAggregate.getGroupCount(); ++i) {
                indexes.set(queryAggregate.getGroupSet().nth(i));
            }
            for (AggregateCall queryAggCall : queryAggregate.getAggCallList()) {
                for (int inputIdx : queryAggCall.getArgList()) {
                    indexes.set(inputIdx);
                }
            }
        }
        ArrayList<RexNode> rollupNodes = new ArrayList<RexNode>();
        Multimap<Integer, Integer> m = this.generateMapping(rexBuilder, simplify, mq, queryAggregate.getInput(), viewAggregate.getInput(), indexes.build(), queryToViewTableMapping, queryEC, rollupNodes);
        if (m == null) {
            return null;
        }
        int viewAggregateAdditionalFieldCount = rollupNodes.size();
        int viewInputFieldCount = viewAggregate.getInput().getRowType().getFieldCount();
        int viewInputDifferenceViewFieldCount = viewAggregate.getRowType().getFieldCount() - viewInputFieldCount;
        int viewAggregateTotalFieldCount = viewAggregate.getRowType().getFieldCount() + rollupNodes.size();
        boolean forceRollup = false;
        Mapping aggregateMapping = Mappings.create(MappingType.FUNCTION, queryAggregate.getRowType().getFieldCount(), viewAggregateTotalFieldCount);
        for (int i = 0; i < queryAggregate.getGroupCount(); ++i) {
            Collection<Integer> c = m.get(queryAggregate.getGroupSet().nth(i));
            for (int j2 : c) {
                if (j2 >= viewAggregate.getInput().getRowType().getFieldCount()) {
                    aggregateMapping.set(i, j2 + viewInputDifferenceViewFieldCount);
                    forceRollup = true;
                    break;
                }
                int targetIdx = viewAggregate.getGroupSet().indexOf(j2);
                if (targetIdx == -1) continue;
                aggregateMapping.set(i, targetIdx);
                break;
            }
            if (aggregateMapping.getTargetOpt(i) != -1) continue;
            return null;
        }
        boolean containsDistinctAgg = false;
        block8: for (int idx = 0; idx < queryAggregate.getAggCallList().size(); ++idx) {
            if (references != null && !references.get(queryAggregate.getGroupCount() + idx)) continue;
            AggregateCall queryAggCall = queryAggregate.getAggCallList().get(idx);
            if (queryAggCall.filterArg >= 0) {
                return null;
            }
            ArrayList<Integer> queryAggCallIndexes = new ArrayList<Integer>();
            for (int aggCallIdx : queryAggCall.getArgList()) {
                queryAggCallIndexes.add(m.get(aggCallIdx).iterator().next());
            }
            for (int j3 = 0; j3 < viewAggregate.getAggCallList().size(); ++j3) {
                AggregateCall viewAggCall = viewAggregate.getAggCallList().get(j3);
                if (queryAggCall.getAggregation().getKind() != viewAggCall.getAggregation().getKind() || queryAggCall.isDistinct() != viewAggCall.isDistinct() || queryAggCall.getArgList().size() != viewAggCall.getArgList().size() || queryAggCall.getType() != viewAggCall.getType() || viewAggCall.filterArg >= 0 || !queryAggCallIndexes.equals(viewAggCall.getArgList())) continue;
                aggregateMapping.set(queryAggregate.getGroupCount() + idx, viewAggregate.getGroupCount() + j3);
                if (!queryAggCall.isDistinct()) continue block8;
                containsDistinctAgg = true;
                continue block8;
            }
        }
        if (topViewProject == null) {
            topViewProject = (Project)relBuilder.push(viewNode).project(relBuilder.fields(), ImmutableList.of(), true).build();
        }
        ArrayList<RexInputRef> additionalViewExprs = new ArrayList<RexInputRef>();
        ImmutableMultimap<Integer, Integer> rewritingMapping = null;
        RelNode result = relBuilder.push(input).build();
        ArrayList<RexNode> inputViewExprs = new ArrayList<RexNode>();
        inputViewExprs.addAll(relBuilder.push(result).fields());
        relBuilder.clear();
        if (forceRollup || queryAggregate.getGroupCount() != viewAggregate.getGroupCount() || matchModality == MaterializedViewRule.MatchModality.VIEW_PARTIAL) {
            if (containsDistinctAgg) {
                return null;
            }
            ImmutableMultimap.Builder<Integer, Integer> rewritingMappingB = ImmutableMultimap.builder();
            ImmutableBitSet.Builder groupSetB = ImmutableBitSet.builder();
            for (int i = 0; i < queryAggregate.getGroupCount(); ++i) {
                int targetIdx = aggregateMapping.getTargetOpt(i);
                if (targetIdx == -1) {
                    return null;
                }
                boolean added = false;
                if (targetIdx >= viewAggregate.getRowType().getFieldCount()) {
                    RexNode rexNode = (RexNode)rollupNodes.get(targetIdx - viewInputFieldCount - viewInputDifferenceViewFieldCount);
                    ArrayListMultimap<RexNode, Integer> exprsLineage = ArrayListMultimap.create();
                    ImmutableBitSet refs = RelOptUtil.InputFinder.bits(rexNode);
                    for (int childTargetIdx : refs) {
                        added = false;
                        for (int k = 0; k < topViewProject.getProjects().size() && !added; ++k) {
                            int ref;
                            RexNode n = topViewProject.getProjects().get(k);
                            if (!n.isA(SqlKind.INPUT_REF) || (ref = ((RexInputRef)n).getIndex()) != childTargetIdx) continue;
                            exprsLineage.put(new RexInputRef(ref, rexNode.getType()), k);
                            added = true;
                        }
                        if (added) continue;
                        return null;
                    }
                    groupSetB.set(inputViewExprs.size());
                    rewritingMappingB.put(inputViewExprs.size(), i);
                    additionalViewExprs.add(new RexInputRef(targetIdx, rexNode.getType()));
                    inputViewExprs.add(this.shuttleReferences(rexBuilder, rexNode, exprsLineage));
                    added = true;
                } else {
                    void var36_57;
                    boolean bl = false;
                    while (var36_57 < topViewProject.getProjects().size() && !added) {
                        int ref;
                        RexNode n = topViewProject.getProjects().get((int)var36_57);
                        if (n.isA(SqlKind.INPUT_REF) && (ref = ((RexInputRef)n).getIndex()) == targetIdx) {
                            groupSetB.set((int)var36_57);
                            rewritingMappingB.put((int)var36_57, i);
                            added = true;
                        }
                        ++var36_57;
                    }
                }
                if (added) continue;
                return null;
            }
            ImmutableBitSet groupSet = groupSetB.build();
            ArrayList<RelBuilder.AggCall> aggregateCalls = new ArrayList<RelBuilder.AggCall>();
            for (int i = 0; i < queryAggregate.getAggCallList().size(); ++i) {
                if (references != null && !references.get(queryAggregate.getGroupCount() + i)) continue;
                int n = queryAggregate.getGroupCount() + i;
                int targetIdx = aggregateMapping.getTargetOpt(n);
                if (targetIdx < 0) {
                    return null;
                }
                AggregateCall queryAggCall = queryAggregate.getAggCallList().get(i);
                boolean added = false;
                for (int k = 0; k < topViewProject.getProjects().size() && !added; ++k) {
                    int ref;
                    RexNode n2 = topViewProject.getProjects().get(k);
                    if (!n2.isA(SqlKind.INPUT_REF) || (ref = ((RexInputRef)n2).getIndex()) != targetIdx) continue;
                    SqlAggFunction rollupAgg = this.getRollup(queryAggCall.getAggregation());
                    if (rollupAgg == null) {
                        return null;
                    }
                    rewritingMappingB.put(k, queryAggregate.getGroupCount() + aggregateCalls.size());
                    RexInputRef operand = rexBuilder.makeInputRef(input, k);
                    aggregateCalls.add(relBuilder.aggregateCall(rollupAgg, operand).approximate(queryAggCall.isApproximate()).distinct(queryAggCall.isDistinct()).as(queryAggCall.name));
                    added = true;
                }
                if (added) continue;
                return null;
            }
            Iterator prevNode = result;
            relBuilder.push(result);
            if (inputViewExprs.size() != result.getRowType().getFieldCount()) {
                relBuilder.project(inputViewExprs);
            }
            if (prevNode == (result = relBuilder.aggregate(relBuilder.groupKey(groupSet), (Iterable<RelBuilder.AggCall>)aggregateCalls).build()) && groupSet.cardinality() != result.getRowType().getFieldCount()) {
                result = relBuilder.push(result).project(relBuilder.fields(groupSet)).build();
            }
            rewritingMapping = rewritingMappingB.build();
            ImmutableMultimap immutableMultimap = rewritingMapping.inverse();
            ArrayList<RexInputRef> projects = new ArrayList<RexInputRef>();
            ImmutableBitSet.Builder addedProjects = ImmutableBitSet.builder();
            for (int i = 0; i < queryAggregate.getGroupCount(); ++i) {
                int pos = groupSet.indexOf((Integer)((ImmutableCollection)immutableMultimap.get((Object)i)).iterator().next());
                addedProjects.set(pos);
                projects.add(rexBuilder.makeInputRef(result, pos));
            }
            ImmutableBitSet projectedCols = addedProjects.build();
            for (int i = 0; i < result.getRowType().getFieldCount(); ++i) {
                if (projectedCols.get(i)) continue;
                projects.add(rexBuilder.makeInputRef(result, i));
            }
            result = relBuilder.push(result).project(projects).build();
        }
        ArrayList<RexNode> topExprs = new ArrayList<RexNode>();
        if (topProject != null && !unionRewriting) {
            topExprs.addAll(topProject.getProjects());
            topRowType = topProject.getRowType();
        } else {
            for (int pos = 0; pos < queryAggregate.getRowType().getFieldCount(); ++pos) {
                topExprs.add(rexBuilder.makeInputRef(queryAggregate, pos));
            }
            topRowType = queryAggregate.getRowType();
        }
        ArrayListMultimap<RexNode, Integer> viewExprs = ArrayListMultimap.create();
        int numberViewExprs = 0;
        for (RexNode rexNode : topViewProject.getProjects()) {
            viewExprs.put(rexNode, numberViewExprs++);
        }
        for (RexNode rexNode : additionalViewExprs) {
            viewExprs.put(rexNode, numberViewExprs++);
        }
        ArrayList<RexNode> rewrittenExprs = new ArrayList<RexNode>(topExprs.size());
        for (RexNode expr : topExprs) {
            RexNode rewrittenExpr = this.shuttleReferences(rexBuilder, expr, aggregateMapping);
            if (rewrittenExpr == null) {
                return null;
            }
            if ((rewrittenExpr = this.shuttleReferences(rexBuilder, rewrittenExpr, viewExprs, result, rewritingMapping)) == null) {
                return null;
            }
            rewrittenExprs.add(rewrittenExpr);
        }
        return relBuilder.push(result).project(rewrittenExprs).convert(topRowType, false).build();
    }

    protected Multimap<Integer, Integer> generateMapping(RexBuilder rexBuilder, RexSimplify simplify, RelMetadataQuery mq, RelNode node, RelNode target, ImmutableBitSet positions, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> tableMapping, MaterializedViewRule.EquivalenceClasses sourceEC, List<RexNode> additionalExprs) {
        Preconditions.checkArgument(additionalExprs.isEmpty());
        ArrayListMultimap<Integer, Integer> m = ArrayListMultimap.create();
        Map<RexTableInputRef, Set<RexTableInputRef>> equivalenceClassesMap = sourceEC.getEquivalenceClassesMap();
        ArrayListMultimap<RexNode, Integer> exprsLineage = ArrayListMultimap.create();
        ArrayList<RexNode> timestampExprs = new ArrayList<RexNode>();
        for (int i = 0; i < target.getRowType().getFieldCount(); ++i) {
            Set<RexNode> s = mq.getExpressionLineage(target, rexBuilder.makeInputRef(target, i));
            if (s == null) continue;
            RexNode e = Iterables.getOnlyElement(s);
            RexNode simplified = simplify.simplifyUnknownAsFalse(e);
            RexNode expr = RexUtil.swapTableColumnReferences(rexBuilder, simplified, tableMapping.inverse(), equivalenceClassesMap);
            exprsLineage.put(expr, i);
            SqlTypeName sqlTypeName = expr.getType().getSqlTypeName();
            if (sqlTypeName != SqlTypeName.TIMESTAMP && sqlTypeName != SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE) continue;
            timestampExprs.add(expr);
        }
        for (RexNode timestampExpr : timestampExprs) {
            for (TimeUnitRange value2 : SUPPORTED_DATE_TIME_ROLLUP_UNITS) {
                RexNode floorExpr;
                Object rewrittenFloorExpr;
                RexNode ceilExpr = rexBuilder.makeCall((SqlOperator)this.getCeilSqlFunction(value2), timestampExpr, rexBuilder.makeFlag(value2));
                RexNode rewrittenCeilExpr = this.shuttleReferences(rexBuilder, ceilExpr, exprsLineage);
                if (rewrittenCeilExpr != null) {
                    additionalExprs.add(rewrittenCeilExpr);
                    RexNode simplified = simplify.simplifyUnknownAsFalse(ceilExpr);
                    exprsLineage.put(simplified, target.getRowType().getFieldCount() + additionalExprs.size() - 1);
                }
                if ((rewrittenFloorExpr = this.shuttleReferences(rexBuilder, floorExpr = rexBuilder.makeCall((SqlOperator)this.getFloorSqlFunction(value2), timestampExpr, rexBuilder.makeFlag(value2)), exprsLineage)) == null) continue;
                additionalExprs.add((RexNode)rewrittenFloorExpr);
                RexNode simplified = simplify.simplifyUnknownAsFalse(floorExpr);
                exprsLineage.put(simplified, target.getRowType().getFieldCount() + additionalExprs.size() - 1);
            }
        }
        Iterator<Object> iterator = positions.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Set<RexNode> s = mq.getExpressionLineage(node, rexBuilder.makeInputRef(node, i));
            if (s == null) {
                return null;
            }
            RexNode e = Iterables.getOnlyElement(s);
            RexNode simplified = simplify.simplifyUnknownAsFalse(e);
            RexNode targetExpr = RexUtil.swapColumnReferences(rexBuilder, simplified, equivalenceClassesMap);
            Collection c = exprsLineage.get(targetExpr);
            if (!c.isEmpty()) {
                for (Integer j2 : c) {
                    m.put(i, j2);
                }
                continue;
            }
            RexNode rewrittenTargetExpr = this.shuttleReferences(rexBuilder, targetExpr, exprsLineage);
            if (rewrittenTargetExpr == null) {
                return null;
            }
            m.put(i, target.getRowType().getFieldCount() + additionalExprs.size());
            additionalExprs.add(rewrittenTargetExpr);
        }
        return m;
    }

    protected SqlFunction getCeilSqlFunction(TimeUnitRange flag) {
        return SqlStdOperatorTable.CEIL;
    }

    protected SqlFunction getFloorSqlFunction(TimeUnitRange flag) {
        return SqlStdOperatorTable.FLOOR;
    }

    protected SqlAggFunction getRollup(SqlAggFunction aggregation) {
        if (aggregation == SqlStdOperatorTable.SUM || aggregation == SqlStdOperatorTable.MIN || aggregation == SqlStdOperatorTable.MAX || aggregation == SqlStdOperatorTable.SUM0 || aggregation == SqlStdOperatorTable.ANY_VALUE) {
            return aggregation;
        }
        if (aggregation == SqlStdOperatorTable.COUNT) {
            return SqlStdOperatorTable.SUM0;
        }
        return null;
    }

    @Override
    public Pair<RelNode, RelNode> pushFilterToOriginalViewPlan(RelBuilder builder, RelNode topViewProject, RelNode viewNode, RexNode cond) {
        HepProgramBuilder pushFiltersProgram = new HepProgramBuilder();
        if (topViewProject != null) {
            pushFiltersProgram.addRuleInstance(((Config)this.config).filterProjectTransposeRule());
        }
        pushFiltersProgram.addRuleInstance(((Config)this.config).filterAggregateTransposeRule()).addRuleInstance(((Config)this.config).aggregateProjectPullUpConstantsRule()).addRuleInstance(((Config)this.config).projectMergeRule());
        HepPlanner tmpPlanner = new HepPlanner(pushFiltersProgram.build());
        RelNode topNode = builder.push(topViewProject != null ? topViewProject : viewNode).filter(cond).build();
        tmpPlanner.setRoot(topNode);
        topNode = tmpPlanner.findBestExp();
        RelNode resultTopViewProject = null;
        RelNode resultViewNode = null;
        while (topNode != null) {
            if (topNode instanceof Project) {
                if (resultTopViewProject != null) {
                    return Pair.of(topViewProject, viewNode);
                }
                resultTopViewProject = topNode;
                topNode = topNode.getInput(0);
                continue;
            }
            if (topNode instanceof Aggregate) {
                resultViewNode = topNode;
                topNode = null;
                continue;
            }
            topNode = topNode.getInput(0);
        }
        return Pair.of(resultTopViewProject, resultViewNode);
    }

    public static interface Config
    extends MaterializedViewRule.Config {
        public static Config create(RelBuilderFactory relBuilderFactory) {
            return EMPTY.as(Config.class).withFilterProjectTransposeRule(((FilterProjectTransposeRule.Config)CoreRules.FILTER_PROJECT_TRANSPOSE.config).withRelBuilderFactory(relBuilderFactory).as(FilterProjectTransposeRule.Config.class).withOperandFor(Filter.class, filter -> !RexUtil.containsCorrelation(filter.getCondition()), Project.class, project -> true).withCopyFilter(true).withCopyProject(true).toRule()).withFilterAggregateTransposeRule(((FilterAggregateTransposeRule.Config)CoreRules.FILTER_AGGREGATE_TRANSPOSE.config).withRelBuilderFactory(relBuilderFactory).as(FilterAggregateTransposeRule.Config.class).withOperandFor(Filter.class, Aggregate.class).toRule()).withAggregateProjectPullUpConstantsRule(AggregateProjectPullUpConstantsRule.Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).withDescription("AggFilterPullUpConstants").as(AggregateProjectPullUpConstantsRule.Config.class).withOperandFor(Aggregate.class, Filter.class).toRule()).withProjectMergeRule(((ProjectMergeRule.Config)CoreRules.PROJECT_MERGE.config).withRelBuilderFactory(relBuilderFactory).as(ProjectMergeRule.Config.class).toRule()).withRelBuilderFactory(relBuilderFactory).as(Config.class);
        }

        @ImmutableBeans.Property
        public RelOptRule filterProjectTransposeRule();

        public Config withFilterProjectTransposeRule(RelOptRule var1);

        @ImmutableBeans.Property
        public RelOptRule filterAggregateTransposeRule();

        public Config withFilterAggregateTransposeRule(RelOptRule var1);

        @ImmutableBeans.Property
        public RelOptRule aggregateProjectPullUpConstantsRule();

        public Config withAggregateProjectPullUpConstantsRule(RelOptRule var1);

        @ImmutableBeans.Property
        public RelOptRule projectMergeRule();

        public Config withProjectMergeRule(RelOptRule var1);
    }
}

