/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.calcite.shaded.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.flink.calcite.shaded.com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.flink.calcite.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.calcite.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.calcite.shaded.com.fasterxml.jackson.databind.BeanProperty;
import org.apache.flink.calcite.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.flink.calcite.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.calcite.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.calcite.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.flink.calcite.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.calcite.shaded.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import org.apache.flink.calcite.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.apache.flink.calcite.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.apache.flink.calcite.shaded.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import org.apache.flink.calcite.shaded.com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import org.apache.flink.calcite.shaded.com.fasterxml.jackson.databind.ser.std.ToStringSerializer;

@JacksonStdImpl
public final class BooleanSerializer
extends StdScalarSerializer<Object>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    protected final boolean _forPrimitive;

    public BooleanSerializer(boolean forPrimitive) {
        super(forPrimitive ? Boolean.TYPE : Boolean.class, false);
        this._forPrimitive = forPrimitive;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializers, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format = this.findFormatOverrides(serializers, property, this.handledType());
        if (format != null) {
            JsonFormat.Shape shape = format.getShape();
            if (shape.isNumeric()) {
                return new AsNumber(this._forPrimitive);
            }
            if (shape == JsonFormat.Shape.STRING) {
                return new ToStringSerializer((Class<?>)this._handledType);
            }
        }
        return this;
    }

    @Override
    public void serialize(Object value2, JsonGenerator g, SerializerProvider provider) throws IOException {
        g.writeBoolean(Boolean.TRUE.equals(value2));
    }

    @Override
    public final void serializeWithType(Object value2, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        g.writeBoolean(Boolean.TRUE.equals(value2));
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("boolean", !this._forPrimitive);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectBooleanFormat(typeHint);
    }

    static final class AsNumber
    extends StdScalarSerializer<Object>
    implements ContextualSerializer {
        private static final long serialVersionUID = 1L;
        protected final boolean _forPrimitive;

        public AsNumber(boolean forPrimitive) {
            super(forPrimitive ? Boolean.TYPE : Boolean.class, false);
            this._forPrimitive = forPrimitive;
        }

        @Override
        public void serialize(Object value2, JsonGenerator g, SerializerProvider provider) throws IOException {
            g.writeNumber(Boolean.FALSE.equals(value2) ? 0 : 1);
        }

        @Override
        public final void serializeWithType(Object value2, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
            g.writeBoolean(Boolean.TRUE.equals(value2));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            this.visitIntFormat(visitor, typeHint, JsonParser.NumberType.INT);
        }

        @Override
        public JsonSerializer<?> createContextual(SerializerProvider serializers, BeanProperty property) throws JsonMappingException {
            JsonFormat.Shape shape;
            JsonFormat.Value format = this.findFormatOverrides(serializers, property, Boolean.class);
            if (format != null && !(shape = format.getShape()).isNumeric()) {
                return new BooleanSerializer(this._forPrimitive);
            }
            return this;
        }
    }
}

