/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.connectors;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;

@Internal
final class InlineCatalogTable
implements CatalogTable {
    private final ResolvedSchema schema;

    InlineCatalogTable(ResolvedSchema schema) {
        this.schema = schema;
    }

    public Schema getUnresolvedSchema() {
        return Schema.newBuilder().fromResolvedSchema(this.schema).build();
    }

    public Map<String, String> getOptions() {
        throw new TableException("A catalog table that is backed by a DataStream or used for TableResult.collect() cannot be expressed with options and can thus also not be persisted.");
    }

    public String getComment() {
        return "Inline catalog table";
    }

    public CatalogBaseTable copy() {
        return new InlineCatalogTable(this.schema);
    }

    public Optional<String> getDescription() {
        return Optional.of(this.getComment());
    }

    public Optional<String> getDetailedDescription() {
        return Optional.empty();
    }

    public boolean isPartitioned() {
        return false;
    }

    public List<String> getPartitionKeys() {
        return Collections.emptyList();
    }

    public CatalogTable copy(Map<String, String> options) {
        throw new TableException("A catalog table that is backed by a DataStream or used for TableResult.collect() cannot be expressed with options and can thus also not be enriched with hints.");
    }
}

