/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.converter;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlPostfixOperator;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.OrdinalReturnTypeInference;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.expressions.SqlAggFunctionVisitor;
import org.apache.flink.table.planner.expressions.converter.CallExpressionConvertRule;
import org.apache.flink.table.planner.expressions.converter.ExpressionConverter;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

public class OverConvertRule
implements CallExpressionConvertRule {
    @Override
    public Optional<RexNode> convert(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        List children = call.getChildren();
        if (call.getFunctionDefinition() == BuiltInFunctionDefinitions.OVER) {
            FlinkTypeFactory typeFactory = context.getTypeFactory();
            Expression agg = (Expression)children.get(0);
            FunctionDefinition def = ((CallExpression)agg).getFunctionDefinition();
            boolean isDistinct = BuiltInFunctionDefinitions.DISTINCT == def;
            SqlAggFunction aggFunc = (SqlAggFunction)agg.accept((ExpressionVisitor)new SqlAggFunctionVisitor(context.getRelBuilder()));
            RelDataType aggResultType = typeFactory.createFieldTypeFromLogicalType(LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)((ResolvedExpression)agg).getOutputDataType()));
            List<RexNode> aggExprs = agg.getChildren().stream().map(child -> {
                if (isDistinct) {
                    return context.toRexNode((Expression)child.getChildren().get(0));
                }
                return context.toRexNode((Expression)child);
            }).collect(Collectors.toList());
            Expression orderKeyExpr = (Expression)children.get(1);
            HashSet<SqlKind> kinds = new HashSet<SqlKind>();
            RexNode collationRexNode = this.createCollation(context.toRexNode(orderKeyExpr), RelFieldCollation.Direction.ASCENDING, null, kinds);
            ImmutableList<RexFieldCollation> orderKey = ImmutableList.of(new RexFieldCollation(collationRexNode, (Set<SqlKind>)kinds));
            List<RexNode> partitionKeys = children.subList(4, children.size()).stream().map(context::toRexNode).collect(Collectors.toList());
            Expression preceding = (Expression)children.get(2);
            boolean isPhysical = LogicalTypeChecks.hasRoot((LogicalType)LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)((ResolvedExpression)preceding).getOutputDataType()), (LogicalTypeRoot)LogicalTypeRoot.BIGINT);
            Expression following = (Expression)children.get(3);
            RexWindowBound lowerBound = this.createBound(context, preceding, SqlKind.PRECEDING);
            RexWindowBound upperBound = this.createBound(context, following, SqlKind.FOLLOWING);
            return Optional.of(context.getRelBuilder().getRexBuilder().makeOver(aggResultType, aggFunc, aggExprs, partitionKeys, orderKey, lowerBound, upperBound, isPhysical, true, false, isDistinct));
        }
        return Optional.empty();
    }

    private RexNode createCollation(RexNode node, RelFieldCollation.Direction direction, RelFieldCollation.NullDirection nullDirection, Set<SqlKind> kinds) {
        switch (node.getKind()) {
            case DESCENDING: {
                kinds.add(node.getKind());
                return this.createCollation(((RexCall)node).getOperands().get(0), RelFieldCollation.Direction.DESCENDING, nullDirection, kinds);
            }
            case NULLS_FIRST: {
                kinds.add(node.getKind());
                return this.createCollation(((RexCall)node).getOperands().get(0), direction, RelFieldCollation.NullDirection.FIRST, kinds);
            }
            case NULLS_LAST: {
                kinds.add(node.getKind());
                return this.createCollation(((RexCall)node).getOperands().get(0), direction, RelFieldCollation.NullDirection.LAST, kinds);
            }
        }
        if (nullDirection == null) {
            if (FlinkPlannerImpl.defaultNullCollation().last(direction.equals((Object)RelFieldCollation.Direction.DESCENDING))) {
                kinds.add(SqlKind.NULLS_LAST);
            } else {
                kinds.add(SqlKind.NULLS_FIRST);
            }
        }
        return node;
    }

    private RexWindowBound createBound(CallExpressionConvertRule.ConvertContext context, Expression bound, SqlKind sqlKind) {
        if (bound instanceof CallExpression) {
            CallExpression callExpr = (CallExpression)bound;
            FunctionDefinition func = callExpr.getFunctionDefinition();
            if (BuiltInFunctionDefinitions.UNBOUNDED_ROW.equals(func) || BuiltInFunctionDefinitions.UNBOUNDED_RANGE.equals(func)) {
                SqlNode unbounded = sqlKind.equals((Object)SqlKind.PRECEDING) ? SqlWindow.createUnboundedPreceding(SqlParserPos.ZERO) : SqlWindow.createUnboundedFollowing(SqlParserPos.ZERO);
                return RexWindowBound.create(unbounded, null);
            }
            if (BuiltInFunctionDefinitions.CURRENT_ROW.equals(func) || BuiltInFunctionDefinitions.CURRENT_RANGE.equals(func)) {
                SqlNode currentRow2 = SqlWindow.createCurrentRow(SqlParserPos.ZERO);
                return RexWindowBound.create(currentRow2, null);
            }
            throw new IllegalArgumentException("Unexpected expression: " + bound);
        }
        if (bound instanceof ValueLiteralExpression) {
            RelDataType returnType = context.getTypeFactory().createFieldTypeFromLogicalType((LogicalType)new DecimalType(true, 19, 0));
            SqlPostfixOperator sqlOperator = new SqlPostfixOperator(sqlKind.name(), sqlKind, 2, new OrdinalReturnTypeInference(0), null, null);
            SqlNode[] operands = new SqlNode[]{SqlLiteral.createExactNumeric("1", SqlParserPos.ZERO)};
            SqlBasicCall node = new SqlBasicCall(sqlOperator, operands, SqlParserPos.ZERO);
            ValueLiteralExpression literalExpr2 = (ValueLiteralExpression)bound;
            RexNode literalRexNode = literalExpr2.getValueAs(BigDecimal.class).map(v -> context.getRelBuilder().literal(v)).orElse(context.getRelBuilder().literal(ExpressionConverter.extractValue(literalExpr2, Object.class)));
            ArrayList<RexNode> expressions = new ArrayList<RexNode>();
            expressions.add(literalRexNode);
            RexNode rexNode = context.getRelBuilder().getRexBuilder().makeCall(returnType, sqlOperator, expressions);
            return RexWindowBound.create(node, rexNode);
        }
        throw new TableException("Unexpected expression: " + bound);
    }
}

