/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.time.Duration;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.planner.expressions.PlannerWindowReference;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.logical.SessionGroupWindow;
import org.apache.flink.table.planner.plan.logical.SlidingGroupWindow;
import org.apache.flink.table.planner.plan.logical.TumblingGroupWindow;
import org.apache.flink.table.planner.plan.nodes.exec.serde.FlinkDeserializationContext;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;

public class LogicalWindowJsonDeserializer
extends StdDeserializer<LogicalWindow> {
    private static final long serialVersionUID = 1L;

    public LogicalWindowJsonDeserializer() {
        super(LogicalWindow.class);
    }

    public LogicalWindow deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        FlinkDeserializationContext flinkDeserializationContext = (FlinkDeserializationContext)deserializationContext;
        ObjectMapper mapper = flinkDeserializationContext.getObjectMapper();
        JsonNode jsonNode = (JsonNode)jsonParser.readValueAsTree();
        String kind = jsonNode.get("kind").asText().toUpperCase();
        PlannerWindowReference alias2 = (PlannerWindowReference)mapper.readValue(jsonNode.get("alias").toString(), PlannerWindowReference.class);
        FieldReferenceExpression timeField = this.deserializeFieldReferenceExpression(jsonNode.get("timeField"), mapper);
        switch (kind) {
            case "TUMBLING": {
                boolean isTimeTumblingWindow = jsonNode.get("isTimeWindow").asBoolean();
                if (isTimeTumblingWindow) {
                    Duration size = (Duration)mapper.readValue(jsonNode.get("size").toString(), Duration.class);
                    return new TumblingGroupWindow(alias2, timeField, new ValueLiteralExpression((Object)size));
                }
                long size = jsonNode.get("size").asLong();
                return new TumblingGroupWindow(alias2, timeField, new ValueLiteralExpression((Object)size));
            }
            case "SLIDING": {
                boolean isTimeSlidingWindow = jsonNode.get("isTimeWindow").asBoolean();
                if (isTimeSlidingWindow) {
                    Duration size = (Duration)mapper.readValue(jsonNode.get("size").toString(), Duration.class);
                    Duration slide = (Duration)mapper.readValue(jsonNode.get("slide").toString(), Duration.class);
                    return new SlidingGroupWindow(alias2, timeField, new ValueLiteralExpression((Object)size), new ValueLiteralExpression((Object)slide));
                }
                long size = jsonNode.get("size").asLong();
                long slide = jsonNode.get("slide").asLong();
                return new SlidingGroupWindow(alias2, timeField, new ValueLiteralExpression((Object)size), new ValueLiteralExpression((Object)slide));
            }
            case "SESSION": {
                Duration gap = (Duration)mapper.readValue(jsonNode.get("gap").toString(), Duration.class);
                return new SessionGroupWindow(alias2, timeField, new ValueLiteralExpression((Object)gap));
            }
        }
        throw new TableException("Unknown Logical Window:" + jsonNode);
    }

    private FieldReferenceExpression deserializeFieldReferenceExpression(JsonNode input, ObjectMapper mapper) throws JsonProcessingException {
        String name = input.get("fieldName").asText();
        int fieldIndex = input.get("fieldIndex").asInt();
        int inputIndex = input.get("inputIndex").asInt();
        LogicalType type = (LogicalType)mapper.readValue(input.get("fieldType").toString(), LogicalType.class);
        return new FieldReferenceExpression(name, (DataType)new AtomicDataType(type), inputIndex, fieldIndex);
    }
}

