/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.EqualiserCodeGenerator;
import org.apache.flink.table.planner.codegen.agg.AggsHandlerCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalTypeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalTypeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecAggregateBase;
import org.apache.flink.table.planner.plan.utils.AggregateInfoList;
import org.apache.flink.table.planner.plan.utils.AggregateUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.aggregate.MiniBatchGlobalGroupAggFunction;
import org.apache.flink.table.runtime.operators.bundle.KeyedMapBundleOperator;
import org.apache.flink.table.runtime.operators.bundle.MapBundleFunction;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamExecGlobalGroupAggregate
extends StreamExecAggregateBase {
    private static final Logger LOG = LoggerFactory.getLogger(StreamExecGlobalGroupAggregate.class);
    public static final String FIELD_NAME_LOCAL_AGG_INPUT_ROW_TYPE = "localAggInputRowType";
    public static final String FIELD_NAME_INDEX_OF_COUNT_STAR = "indexOfCountStar";
    @JsonProperty(value="grouping")
    private final int[] grouping;
    @JsonProperty(value="aggCalls")
    private final AggregateCall[] aggCalls;
    @JsonProperty(value="aggCallNeedRetractions")
    private final boolean[] aggCallNeedRetractions;
    @JsonProperty(value="localAggInputRowType")
    @JsonSerialize(using=LogicalTypeJsonSerializer.class)
    @JsonDeserialize(using=LogicalTypeJsonDeserializer.class)
    private final RowType localAggInputRowType;
    @JsonProperty(value="generateUpdateBefore")
    private final boolean generateUpdateBefore;
    @JsonProperty(value="needRetraction")
    private final boolean needRetraction;
    @JsonProperty(value="indexOfCountStar")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Integer indexOfCountStar;

    public StreamExecGlobalGroupAggregate(int[] grouping, AggregateCall[] aggCalls, boolean[] aggCallNeedRetractions, RowType localAggInputRowType, boolean generateUpdateBefore, boolean needRetraction, @Nullable Integer indexOfCountStar, InputProperty inputProperty, RowType outputType, String description) {
        this(grouping, aggCalls, aggCallNeedRetractions, localAggInputRowType, generateUpdateBefore, needRetraction, indexOfCountStar, StreamExecGlobalGroupAggregate.getNewNodeId(), Collections.singletonList(inputProperty), outputType, description);
    }

    @JsonCreator
    public StreamExecGlobalGroupAggregate(@JsonProperty(value="grouping") int[] grouping, @JsonProperty(value="aggCalls") AggregateCall[] aggCalls, @JsonProperty(value="aggCallNeedRetractions") boolean[] aggCallNeedRetractions, @JsonProperty(value="localAggInputRowType") RowType localAggInputRowType, @JsonProperty(value="generateUpdateBefore") boolean generateUpdateBefore, @JsonProperty(value="needRetraction") boolean needRetraction, @JsonProperty(value="indexOfCountStar") @Nullable Integer indexOfCountStar, @JsonProperty(value="id") int id, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, inputProperties, (LogicalType)outputType, description);
        this.grouping = (int[])Preconditions.checkNotNull((Object)grouping);
        this.aggCalls = (AggregateCall[])Preconditions.checkNotNull((Object)aggCalls);
        this.aggCallNeedRetractions = (boolean[])Preconditions.checkNotNull((Object)aggCallNeedRetractions);
        Preconditions.checkArgument((aggCalls.length == aggCallNeedRetractions.length ? 1 : 0) != 0);
        this.localAggInputRowType = (RowType)Preconditions.checkNotNull((Object)localAggInputRowType);
        this.generateUpdateBefore = generateUpdateBefore;
        this.needRetraction = needRetraction;
        Preconditions.checkArgument((indexOfCountStar == null || indexOfCountStar >= 0 && needRetraction ? 1 : 0) != 0);
        this.indexOfCountStar = indexOfCountStar;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner) {
        TableConfig tableConfig = planner.getTableConfig();
        if (this.grouping.length > 0 && tableConfig.getMinIdleStateRetentionTime() < 0L) {
            LOG.warn("No state retention interval configured for a query which accumulates state. Please provide a query configuration with valid retention interval to prevent excessive state size. You may specify a retention time of 0 to not clean up the state.");
        }
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputRowType = (RowType)inputEdge.getOutputType();
        AggregateInfoList localAggInfoList = AggregateUtil.transformToStreamAggregateInfoList(this.localAggInputRowType, JavaScalaConversionUtil.toScala(Arrays.asList(this.aggCalls)), this.aggCallNeedRetractions, this.needRetraction, JavaScalaConversionUtil.toScala(Optional.ofNullable(this.indexOfCountStar)), false, true);
        AggregateInfoList globalAggInfoList = AggregateUtil.transformToStreamAggregateInfoList(this.localAggInputRowType, JavaScalaConversionUtil.toScala(Arrays.asList(this.aggCalls)), this.aggCallNeedRetractions, this.needRetraction, JavaScalaConversionUtil.toScala(Optional.ofNullable(this.indexOfCountStar)), true, true);
        GeneratedAggsHandleFunction localAggsHandler = this.generateAggsHandler("LocalGroupAggsHandler", localAggInfoList, this.grouping.length, localAggInfoList.getAccTypes(), tableConfig, planner.getRelBuilder());
        GeneratedAggsHandleFunction globalAggsHandler = this.generateAggsHandler("GlobalGroupAggsHandler", globalAggInfoList, 0, localAggInfoList.getAccTypes(), tableConfig, planner.getRelBuilder());
        int indexOfCountStar = globalAggInfoList.getIndexOfCountStar();
        LogicalType[] globalAccTypes = (LogicalType[])Arrays.stream(globalAggInfoList.getAccTypes()).map(LogicalTypeDataTypeConverter::fromDataTypeToLogicalType).toArray(LogicalType[]::new);
        LogicalType[] globalAggValueTypes = (LogicalType[])Arrays.stream(globalAggInfoList.getActualValueTypes()).map(LogicalTypeDataTypeConverter::fromDataTypeToLogicalType).toArray(LogicalType[]::new);
        GeneratedRecordEqualiser recordEqualiser = new EqualiserCodeGenerator(globalAggValueTypes).generateRecordEqualiser("GroupAggValueEqualiser");
        boolean isMiniBatchEnabled = tableConfig.getConfiguration().getBoolean(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED);
        if (!isMiniBatchEnabled) {
            throw new TableException("Local-Global optimization is only worked in miniBatch mode");
        }
        MiniBatchGlobalGroupAggFunction aggFunction = new MiniBatchGlobalGroupAggFunction(localAggsHandler, globalAggsHandler, recordEqualiser, globalAccTypes, indexOfCountStar, this.generateUpdateBefore, tableConfig.getIdleStateRetention().toMillis());
        KeyedMapBundleOperator operator = new KeyedMapBundleOperator((MapBundleFunction)aggFunction, AggregateUtil.createMiniBatchTrigger(tableConfig));
        OneInputTransformation transform2 = new OneInputTransformation(inputTransform, this.getDescription(), (OneInputStreamOperator)operator, (TypeInformation)InternalTypeInfo.of((LogicalType)this.getOutputType()), inputTransform.getParallelism());
        RowDataKeySelector selector = KeySelectorUtil.getRowDataSelector(this.grouping, (InternalTypeInfo<RowData>)InternalTypeInfo.of((RowType)inputRowType));
        transform2.setStateKeySelector((KeySelector)selector);
        transform2.setStateKeyType((TypeInformation)selector.getProducedType());
        return transform2;
    }

    private GeneratedAggsHandleFunction generateAggsHandler(String name, AggregateInfoList aggInfoList, int mergedAccOffset, DataType[] mergedAccExternalTypes, TableConfig config, RelBuilder relBuilder) {
        AggsHandlerCodeGenerator generator = new AggsHandlerCodeGenerator(new CodeGeneratorContext(config), relBuilder, JavaScalaConversionUtil.toScala(this.localAggInputRowType.getChildren()), true);
        return generator.needMerge(mergedAccOffset, true, mergedAccExternalTypes).generateAggsHandler(name, aggInfoList);
    }
}

