/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.utils;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.transformations.LegacySourceTransformation;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodePlanDumper;

public class ExecNodeUtil {
    public static <T> void setManagedMemoryWeight(Transformation<T> transformation, long memoryBytes) {
        int weightInMebibyte;
        Optional previousWeight;
        if (memoryBytes > 0L && (previousWeight = transformation.declareManagedMemoryUseCaseAtOperatorScope(ManagedMemoryUseCase.OPERATOR, weightInMebibyte = Math.max(1, (int)(memoryBytes >> 20)))).isPresent()) {
            throw new TableException("Managed memory weight has been set, this should not happen.");
        }
    }

    public static <T> OneInputTransformation<T, T> createOneInputTransformation(Transformation<T> input, String name, StreamOperatorFactory<T> operatorFactory, TypeInformation<T> outputType, int parallelism, long memoryBytes) {
        OneInputTransformation transformation = new OneInputTransformation(input, name, operatorFactory, outputType, parallelism);
        ExecNodeUtil.setManagedMemoryWeight(transformation, memoryBytes);
        return transformation;
    }

    public static <T> TwoInputTransformation<T, T, T> createTwoInputTransformation(Transformation<T> input1, Transformation<T> input2, String name, StreamOperatorFactory<T> operatorFactory, TypeInformation<T> outputType, int parallelism, long memoryBytes) {
        TwoInputTransformation transformation = new TwoInputTransformation(input1, input2, name, operatorFactory, outputType, parallelism);
        ExecNodeUtil.setManagedMemoryWeight(transformation, memoryBytes);
        return transformation;
    }

    public static String getMultipleInputDescription(ExecNode<?> rootNode, List<ExecNode<?>> inputNodes, List<InputProperty> inputProperties) {
        boolean hasDiffReadOrder;
        String members = ExecNodePlanDumper.treeToString(rootNode, inputNodes, true).replace("\n", "\\n");
        StringBuilder sb = new StringBuilder();
        sb.append("MultipleInput(");
        List readOrders = inputProperties.stream().map(InputProperty::getPriority).map(Object::toString).collect(Collectors.toList());
        boolean bl = hasDiffReadOrder = readOrders.stream().distinct().count() > 1L;
        if (hasDiffReadOrder) {
            sb.append("readOrder=[").append(String.join((CharSequence)",", readOrders)).append("], ");
        }
        sb.append("members=[\\n").append(members).append("]");
        sb.append(")");
        return sb.toString();
    }

    public static void makeLegacySourceTransformationsBounded(Transformation<?> transformation) {
        if (transformation instanceof LegacySourceTransformation) {
            ((LegacySourceTransformation)transformation).setBoundedness(Boundedness.BOUNDED);
        }
        transformation.getInputs().forEach(ExecNodeUtil::makeLegacySourceTransformationsBounded);
    }
}

