/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.AggContext;
import org.apache.calcite.adapter.enumerable.AggImpState;
import org.apache.calcite.adapter.enumerable.AggImplementor;
import org.apache.calcite.adapter.enumerable.AggregateLambdaFactory;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.enumerable.impl.AggAddContextImpl;
import org.apache.calcite.adapter.enumerable.impl.AggResultContextImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Function0;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.function.Function2;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

public class EnumerableAggregate
extends Aggregate
implements EnumerableRel {
    public EnumerableAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) throws InvalidRelException {
        super(cluster, traitSet, input, groupSet, groupSets, aggCalls);
        assert (this.getConvention() instanceof EnumerableConvention);
        for (AggregateCall aggCall : aggCalls) {
            if (aggCall.isDistinct()) {
                throw new InvalidRelException("distinct aggregation not supported");
            }
            AggImplementor implementor2 = RexImpTable.INSTANCE.get(aggCall.getAggregation(), false);
            if (implementor2 != null) continue;
            throw new InvalidRelException("aggregation " + aggCall.getAggregation() + " not supported");
        }
    }

    @Deprecated
    public EnumerableAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) throws InvalidRelException {
        this(cluster, traitSet, input, groupSet, groupSets, aggCalls);
        EnumerableAggregate.checkIndicator(indicator);
    }

    @Override
    public EnumerableAggregate copy(RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        try {
            return new EnumerableAggregate(this.getCluster(), traitSet, input, groupSet, groupSets, aggCalls);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public EnumerableRel.Result implement(final EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        ParameterExpression key_;
        int i;
        final JavaTypeFactory typeFactory = implementor.getTypeFactory();
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel child = (EnumerableRel)this.getInput();
        EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
        Expression childExp = builder.append("child", result.block);
        PhysType physType = PhysTypeImpl.of(typeFactory, this.getRowType(), pref.preferCustom());
        final PhysType inputPhysType = result.physType;
        ParameterExpression parameter = Expressions.parameter(inputPhysType.getJavaRowType(), "a0");
        PhysType keyPhysType = inputPhysType.project(this.groupSet.asList(), this.getGroupType() != Aggregate.Group.SIMPLE, JavaRowFormat.LIST);
        int groupCount = this.getGroupCount();
        ArrayList<AggImpState> aggs = new ArrayList<AggImpState>(this.aggCalls.size());
        for (Ord call : Ord.zip(this.aggCalls)) {
            aggs.add(new AggImpState(call.i, (AggregateCall)call.e, false));
        }
        ArrayList<Expression> initExpressions = new ArrayList<Expression>();
        BlockBuilder initBlock = new BlockBuilder();
        ArrayList<Type> aggStateTypes = new ArrayList<Type>();
        for (AggImpState agg : aggs) {
            agg.context = new AggContextImpl(agg, typeFactory);
            List<Type> state = agg.implementor.getStateType(agg.context);
            if (state.isEmpty()) {
                agg.state = ImmutableList.of();
                continue;
            }
            aggStateTypes.addAll(state);
            ArrayList<Expression> decls = new ArrayList<Expression>(state.size());
            for (i = 0; i < state.size(); ++i) {
                String aggName = "a" + agg.aggIdx;
                if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
                    aggName = Util.toJavaId(agg.call.getAggregation().getName(), 0).substring("ID$0$".length()) + aggName;
                }
                Type type = state.get(i);
                ParameterExpression pe = Expressions.parameter(type, initBlock.newName(aggName + "s" + i));
                initBlock.add(Expressions.declare(0, pe, null));
                decls.add(pe);
            }
            agg.state = decls;
            initExpressions.addAll(decls);
            agg.implementor.implementReset(agg.context, new AggResultContextImpl(initBlock, agg.call, decls, null, null));
        }
        PhysType accPhysType = PhysTypeImpl.of(typeFactory, typeFactory.createSyntheticType(aggStateTypes));
        this.declareParentAccumulator(initExpressions, initBlock, accPhysType);
        Expression accumulatorInitializer = builder.append("accumulatorInitializer", Expressions.lambda(Function0.class, initBlock.toBlock(), new ParameterExpression[0]));
        final ParameterExpression inParameter = Expressions.parameter(inputPhysType.getJavaRowType(), "in");
        ParameterExpression acc_ = Expressions.parameter(accPhysType.getJavaRowType(), "acc");
        int stateOffset = 0;
        for (i = 0; i < aggs.size(); ++i) {
            BlockBuilder builder2 = new BlockBuilder();
            final AggImpState agg = (AggImpState)aggs.get(i);
            int stateSize = agg.state.size();
            ArrayList<Expression> accumulator = new ArrayList<Expression>(stateSize);
            for (int j2 = 0; j2 < stateSize; ++j2) {
                accumulator.add(accPhysType.fieldReference(acc_, j2 + stateOffset));
            }
            agg.state = accumulator;
            stateOffset += stateSize;
            AggAddContextImpl addContext = new AggAddContextImpl(builder2, accumulator){

                @Override
                public List<RexNode> rexArguments() {
                    List<RelDataTypeField> inputTypes = inputPhysType.getRowType().getFieldList();
                    ArrayList<RexNode> args = new ArrayList<RexNode>();
                    for (int index : agg.call.getArgList()) {
                        args.add(RexInputRef.of(index, inputTypes));
                    }
                    return args;
                }

                @Override
                public RexNode rexFilterArgument() {
                    return agg.call.filterArg < 0 ? null : RexInputRef.of(agg.call.filterArg, inputPhysType.getRowType());
                }

                @Override
                public RexToLixTranslator rowTranslator() {
                    return RexToLixTranslator.forAggregation(typeFactory, this.currentBlock(), new RexToLixTranslator.InputGetterImpl(Collections.singletonList(Pair.of(inParameter, inputPhysType))), implementor.getConformance()).setNullable(this.currentNullables());
                }
            };
            agg.implementor.implementAdd(agg.context, addContext);
            builder2.add(acc_);
            agg.accumulatorAdder = builder.append("accumulatorAdder", Expressions.lambda(Function2.class, builder2.toBlock(), acc_, inParameter));
        }
        ParameterExpression lambdaFactory = Expressions.parameter(AggregateLambdaFactory.class, builder.newName("lambdaFactory"));
        this.implementLambdaFactory(builder, inputPhysType, aggs, accumulatorInitializer, EnumerableAggregate.hasOrderedCall(aggs), lambdaFactory);
        BlockBuilder resultBlock = new BlockBuilder();
        Expressions.FluentList<Expression> results = Expressions.list();
        if (groupCount == 0) {
            key_ = null;
        } else {
            Type keyType = keyPhysType.getJavaRowType();
            key_ = Expressions.parameter(keyType, "key");
            for (int j3 = 0; j3 < groupCount; ++j3) {
                Expression ref = keyPhysType.fieldReference(key_, j3);
                if (this.getGroupType() == Aggregate.Group.SIMPLE) {
                    results.add(ref);
                    continue;
                }
                results.add(Expressions.condition(keyPhysType.fieldReference(key_, groupCount + j3), Expressions.constant(null), Expressions.box(ref)));
            }
        }
        for (AggImpState agg : aggs) {
            results.add(agg.implementor.implementResult(agg.context, new AggResultContextImpl(resultBlock, agg.call, agg.state, key_, keyPhysType)));
        }
        resultBlock.add(physType.record(results));
        if (this.getGroupType() != Aggregate.Group.SIMPLE) {
            ArrayList<Expression> list = new ArrayList<Expression>();
            for (ImmutableBitSet set : this.groupSets) {
                list.add(inputPhysType.generateSelector(parameter, this.groupSet.asList(), set.asList(), keyPhysType.getFormat()));
            }
            Expression keySelectors_ = builder.append("keySelectors", Expressions.call(BuiltInMethod.ARRAYS_AS_LIST.method, list));
            Expression resultSelector = builder.append("resultSelector", Expressions.lambda(Function2.class, resultBlock.toBlock(), key_, acc_));
            builder.add(Expressions.return_(null, Expressions.call(BuiltInMethod.GROUP_BY_MULTIPLE.method, Expressions.list(childExp, keySelectors_, Expressions.call((Expression)lambdaFactory, BuiltInMethod.AGG_LAMBDA_FACTORY_ACC_INITIALIZER.method, new Expression[0]), Expressions.call((Expression)lambdaFactory, BuiltInMethod.AGG_LAMBDA_FACTORY_ACC_ADDER.method, new Expression[0]), Expressions.call((Expression)lambdaFactory, BuiltInMethod.AGG_LAMBDA_FACTORY_ACC_RESULT_SELECTOR.method, resultSelector)).appendIfNotNull(keyPhysType.comparer()))));
        } else if (groupCount == 0) {
            Expression resultSelector = builder.append("resultSelector", Expressions.lambda(Function1.class, resultBlock.toBlock(), acc_));
            builder.add(Expressions.return_(null, Expressions.call(BuiltInMethod.SINGLETON_ENUMERABLE.method, Expressions.call(childExp, BuiltInMethod.AGGREGATE.method, Expressions.call((Expression)Expressions.call((Expression)lambdaFactory, BuiltInMethod.AGG_LAMBDA_FACTORY_ACC_INITIALIZER.method, new Expression[0]), BuiltInMethod.FUNCTION0_APPLY.method, new Expression[0]), Expressions.call((Expression)lambdaFactory, BuiltInMethod.AGG_LAMBDA_FACTORY_ACC_ADDER.method, new Expression[0]), Expressions.call((Expression)lambdaFactory, BuiltInMethod.AGG_LAMBDA_FACTORY_ACC_SINGLE_GROUP_RESULT_SELECTOR.method, resultSelector)))));
        } else if (this.aggCalls.isEmpty() && this.groupSet.equals(ImmutableBitSet.range(child.getRowType().getFieldCount()))) {
            builder.add(Expressions.return_(null, Expressions.call(inputPhysType.convertTo(childExp, physType.getFormat()), BuiltInMethod.DISTINCT.method, Expressions.list().appendIfNotNull(physType.comparer()))));
        } else {
            Expression keySelector_ = builder.append("keySelector", inputPhysType.generateSelector(parameter, this.groupSet.asList(), keyPhysType.getFormat()));
            Expression resultSelector_ = builder.append("resultSelector", Expressions.lambda(Function2.class, resultBlock.toBlock(), key_, acc_));
            builder.add(Expressions.return_(null, Expressions.call(childExp, BuiltInMethod.GROUP_BY2.method, Expressions.list(keySelector_, Expressions.call((Expression)lambdaFactory, BuiltInMethod.AGG_LAMBDA_FACTORY_ACC_INITIALIZER.method, new Expression[0]), Expressions.call((Expression)lambdaFactory, BuiltInMethod.AGG_LAMBDA_FACTORY_ACC_ADDER.method, new Expression[0]), Expressions.call((Expression)lambdaFactory, BuiltInMethod.AGG_LAMBDA_FACTORY_ACC_RESULT_SELECTOR.method, resultSelector_)).appendIfNotNull(keyPhysType.comparer()))));
        }
        return implementor.result(physType, builder.toBlock());
    }

    private static boolean hasOrderedCall(List<AggImpState> aggs) {
        for (AggImpState agg : aggs) {
            if (agg.call.collation.equals(RelCollations.EMPTY)) continue;
            return true;
        }
        return false;
    }

    private void declareParentAccumulator(List<Expression> initExpressions, BlockBuilder initBlock, PhysType accPhysType) {
        if (accPhysType.getJavaRowType() instanceof JavaTypeFactoryImpl.SyntheticRecordType) {
            JavaTypeFactoryImpl.SyntheticRecordType synType = (JavaTypeFactoryImpl.SyntheticRecordType)accPhysType.getJavaRowType();
            ParameterExpression record0_ = Expressions.parameter(accPhysType.getJavaRowType(), "record0");
            initBlock.add(Expressions.declare(0, record0_, null));
            initBlock.add(Expressions.statement(Expressions.assign(record0_, Expressions.new_(accPhysType.getJavaRowType()))));
            List<Types.RecordField> fieldList = synType.getRecordFields();
            for (int i = 0; i < initExpressions.size(); ++i) {
                Expression right = initExpressions.get(i);
                initBlock.add(Expressions.statement(Expressions.assign(Expressions.field((Expression)record0_, fieldList.get(i)), right)));
            }
            initBlock.add(record0_);
        } else {
            initBlock.add(accPhysType.record(initExpressions));
        }
    }

    private void implementLambdaFactory(BlockBuilder builder, PhysType inputPhysType, List<AggImpState> aggs, Expression accumulatorInitializer, boolean hasOrderedCall, ParameterExpression lambdaFactory) {
        if (hasOrderedCall) {
            ParameterExpression pe = Expressions.parameter(List.class, builder.newName("lazyAccumulators"));
            builder.add(Expressions.declare(0, pe, (Expression)Expressions.new_(LinkedList.class)));
            for (AggImpState agg : aggs) {
                if (agg.call.collation.equals(RelCollations.EMPTY)) {
                    builder.add(Expressions.statement(Expressions.call((Expression)pe, BuiltInMethod.COLLECTION_ADD.method, Expressions.new_(BuiltInMethod.BASIC_LAZY_ACCUMULATOR.constructor, agg.accumulatorAdder))));
                    continue;
                }
                Pair<Expression, Expression> pair = inputPhysType.generateCollationKey(agg.call.collation.getFieldCollations());
                builder.add(Expressions.statement(Expressions.call((Expression)pe, BuiltInMethod.COLLECTION_ADD.method, Expressions.new_(BuiltInMethod.SOURCE_SORTER.constructor, agg.accumulatorAdder, (Expression)pair.left, (Expression)pair.right))));
            }
            builder.add(Expressions.declare(0, lambdaFactory, (Expression)Expressions.new_(BuiltInMethod.LAZY_AGGREGATE_LAMBDA_FACTORY.constructor, accumulatorInitializer, pe)));
        } else {
            ParameterExpression pe = Expressions.parameter(List.class, builder.newName("accumulatorAdders"));
            builder.add(Expressions.declare(0, pe, (Expression)Expressions.new_(LinkedList.class)));
            for (AggImpState agg : aggs) {
                builder.add(Expressions.statement(Expressions.call((Expression)pe, BuiltInMethod.COLLECTION_ADD.method, agg.accumulatorAdder)));
            }
            builder.add(Expressions.declare(0, lambdaFactory, (Expression)Expressions.new_(BuiltInMethod.BASIC_AGGREGATE_LAMBDA_FACTORY.constructor, accumulatorInitializer, pe)));
        }
    }

    private class AggContextImpl
    implements AggContext {
        private final AggImpState agg;
        private final JavaTypeFactory typeFactory;

        AggContextImpl(AggImpState agg, JavaTypeFactory typeFactory) {
            this.agg = agg;
            this.typeFactory = typeFactory;
        }

        @Override
        public SqlAggFunction aggregation() {
            return this.agg.call.getAggregation();
        }

        @Override
        public RelDataType returnRelType() {
            return this.agg.call.type;
        }

        @Override
        public Type returnType() {
            return EnumUtils.javaClass(this.typeFactory, this.returnRelType());
        }

        @Override
        public List<? extends RelDataType> parameterRelTypes() {
            return EnumUtils.fieldRowTypes(EnumerableAggregate.this.getInput().getRowType(), null, this.agg.call.getArgList());
        }

        @Override
        public List<? extends Type> parameterTypes() {
            return EnumUtils.fieldTypes(this.typeFactory, this.parameterRelTypes());
        }

        @Override
        public List<ImmutableBitSet> groupSets() {
            return EnumerableAggregate.this.groupSets;
        }

        @Override
        public List<Integer> keyOrdinals() {
            return EnumerableAggregate.this.groupSet.asList();
        }

        @Override
        public List<? extends RelDataType> keyRelTypes() {
            return EnumUtils.fieldRowTypes(EnumerableAggregate.this.getInput().getRowType(), null, EnumerableAggregate.this.groupSet.asList());
        }

        @Override
        public List<? extends Type> keyTypes() {
            return EnumUtils.fieldTypes(this.typeFactory, this.keyRelTypes());
        }
    }
}

