/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RepeatUnion;
import org.apache.calcite.util.BuiltInMethod;

public class EnumerableRepeatUnion
extends RepeatUnion
implements EnumerableRel {
    EnumerableRepeatUnion(RelOptCluster cluster, RelTraitSet traitSet, RelNode seed, RelNode iterative, boolean all, int maxRep) {
        super(cluster, traitSet, seed, iterative, all, maxRep);
    }

    @Override
    public EnumerableRepeatUnion copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.size() == 2);
        return new EnumerableRepeatUnion(this.getCluster(), traitSet, inputs.get(0), inputs.get(1), this.all, this.maxRep);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        if (!this.all) {
            throw new UnsupportedOperationException("Only EnumerableRepeatUnion ALL is supported");
        }
        BlockBuilder builder = new BlockBuilder();
        RelNode seed = this.getSeedRel();
        RelNode iteration = this.getIterativeRel();
        EnumerableRel.Result seedResult = implementor.visitChild(this, 0, (EnumerableRel)seed, pref);
        EnumerableRel.Result iterationResult = implementor.visitChild(this, 1, (EnumerableRel)iteration, pref);
        Expression seedExp = builder.append("seed", seedResult.block);
        Expression iterativeExp = builder.append("iteration", iterationResult.block);
        MethodCallExpression unionExp = Expressions.call(BuiltInMethod.REPEAT_UNION_ALL.method, seedExp, iterativeExp, Expressions.constant(this.maxRep, Integer.TYPE));
        builder.add(unionExp);
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.prefer(seedResult.format));
        return implementor.result(physType, builder.toBlock());
    }
}

