/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.util;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.util.AbstractCursor;

public class ArrayImpl
implements Array {
    private final List<Object> list;
    private final AbstractCursor.ArrayAccessor accessor;

    public ArrayImpl(List<Object> list, AbstractCursor.ArrayAccessor accessor) {
        this.list = list;
        this.accessor = accessor;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.accessor.componentType.getName();
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.accessor.componentType.id;
    }

    @Override
    public Object getArray() throws SQLException {
        return this.getArray(this.list, this.accessor);
    }

    public String toString() {
        Iterator<Object> iterator = this.list.iterator();
        if (!iterator.hasNext()) {
            return "[]";
        }
        StringBuilder buf = new StringBuilder("[");
        while (true) {
            this.accessor.componentSlotGetter.slot = iterator.next();
            try {
                this.append(buf, this.accessor.componentAccessor.getString());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            this.accessor.componentSlotGetter.slot = null;
            if (!iterator.hasNext()) {
                return buf.append("]").toString();
            }
            buf.append(", ");
        }
    }

    private void append(StringBuilder buf, Object o) {
        if (o == null) {
            buf.append("null");
        } else if (o.getClass().isArray()) {
            this.append(buf, AvaticaUtils.primitiveList(o));
        } else {
            buf.append(o);
        }
    }

    protected Object getArray(List<?> list, AbstractCursor.ArrayAccessor arrayAccessor) throws SQLException {
        int i = 0;
        switch (arrayAccessor.componentType.rep) {
            case PRIMITIVE_DOUBLE: {
                double[] doubles = new double[list.size()];
                Iterator<?> iterator = list.iterator();
                while (iterator.hasNext()) {
                    double v = (Double)iterator.next();
                    doubles[i++] = v;
                }
                return doubles;
            }
            case PRIMITIVE_FLOAT: {
                float[] floats = new float[list.size()];
                Iterator<?> iterator = list.iterator();
                while (iterator.hasNext()) {
                    float v = ((Float)iterator.next()).floatValue();
                    floats[i++] = v;
                }
                return floats;
            }
            case PRIMITIVE_INT: {
                int[] ints = new int[list.size()];
                Iterator<?> v = list.iterator();
                while (v.hasNext()) {
                    int v2 = (Integer)v.next();
                    ints[i++] = v2;
                }
                return ints;
            }
            case PRIMITIVE_LONG: {
                long[] longs = new long[list.size()];
                Iterator<?> v2 = list.iterator();
                while (v2.hasNext()) {
                    long v = (Long)v2.next();
                    longs[i++] = v;
                }
                return longs;
            }
            case PRIMITIVE_SHORT: {
                short[] shorts = new short[list.size()];
                Iterator<?> iterator = list.iterator();
                while (iterator.hasNext()) {
                    short v = (Short)iterator.next();
                    shorts[i++] = v;
                }
                return shorts;
            }
            case PRIMITIVE_BOOLEAN: {
                boolean[] booleans = new boolean[list.size()];
                Iterator<?> v = list.iterator();
                while (v.hasNext()) {
                    boolean v3 = (Boolean)v.next();
                    booleans[i++] = v3;
                }
                return booleans;
            }
            case PRIMITIVE_BYTE: {
                byte[] bytes = new byte[list.size()];
                Iterator<?> v3 = list.iterator();
                while (v3.hasNext()) {
                    byte v = (Byte)v3.next();
                    bytes[i++] = v;
                }
                return bytes;
            }
            case PRIMITIVE_CHAR: {
                char[] chars = new char[list.size()];
                Iterator<?> iterator = list.iterator();
                while (iterator.hasNext()) {
                    char v = ((Character)iterator.next()).charValue();
                    chars[i++] = v;
                }
                return chars;
            }
        }
        Object[] objects = list.toArray();
        switch (arrayAccessor.componentType.id) {
            case 2003: {
                AbstractCursor.ArrayAccessor componentAccessor = (AbstractCursor.ArrayAccessor)arrayAccessor.componentAccessor;
                for (i = 0; i < objects.length; ++i) {
                    objects[i] = this.getArrayData(objects[i], componentAccessor);
                }
                break;
            }
        }
        return objects;
    }

    Object getArrayData(Object o, AbstractCursor.ArrayAccessor componentAccessor) throws SQLException {
        if (o instanceof List) {
            return this.getArray((List)o, componentAccessor);
        }
        if (o instanceof ArrayImpl) {
            return (ArrayImpl)o;
        }
        throw new RuntimeException("Unhandled");
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        if (index > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Arrays cannot be longer than 2147483647");
        }
        int startIndex = (int)index - 1;
        if (startIndex < 0 || startIndex > this.list.size()) {
            throw new IllegalArgumentException("Invalid index: " + index + ". Size = " + this.list.size());
        }
        int endIndex = startIndex + count;
        if (endIndex > this.list.size()) {
            throw new IllegalArgumentException("Invalid count provided. Size = " + this.list.size() + ", count = " + count);
        }
        return this.getArray(this.list.subList(startIndex, endIndex), this.accessor);
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.accessor.factory.create(this.accessor.componentType, this.list);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void free() throws SQLException {
    }

    public static boolean equalContents(Array left, Array right) throws SQLException {
        ResultSet leftResultSet = left.getResultSet();
        ResultSet rightResultSet = right.getResultSet();
        while (leftResultSet.next() && rightResultSet.next()) {
            if (Objects.equals(leftResultSet.getObject(1), rightResultSet.getObject(1))) continue;
            return false;
        }
        return !leftResultSet.next() && !rightResultSet.next();
    }

    public static interface Factory {
        public ResultSet create(ColumnMetaData.AvaticaType var1, Iterable<Object> var2) throws SQLException;

        public Array createArray(ColumnMetaData.AvaticaType var1, Iterable<Object> var2);
    }
}

