/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rel2sql;

import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexWindow;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlMatchRecognize;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.SqlSetOperator;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlSumEmptyIsZeroAggFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableSet;
import org.apache.flink.calcite.shaded.com.google.common.collect.Iterables;

public abstract class SqlImplementor {
    public static final SqlParserPos POS = SqlParserPos.QUOTED_ZERO;
    public final SqlDialect dialect;
    protected final Set<String> aliasSet = new LinkedHashSet<String>();
    protected final Map<String, SqlNode> ordinalMap = new HashMap<String, SqlNode>();
    protected final Map<CorrelationId, Context> correlTableMap = new HashMap<CorrelationId, Context>();

    protected SqlImplementor(SqlDialect dialect) {
        this.dialect = Objects.requireNonNull(dialect);
    }

    public abstract Result visitChild(int var1, RelNode var2);

    public void addSelect(List<SqlNode> selectList, SqlNode node, RelDataType rowType) {
        String name = rowType.getFieldNames().get(selectList.size());
        String alias2 = SqlValidatorUtil.getAlias(node, -1);
        if (alias2 == null || !alias2.equals(name)) {
            node = SqlStdOperatorTable.AS.createCall(POS, node, new SqlIdentifier(name, POS));
        }
        selectList.add(node);
    }

    public static boolean isStar(List<RexNode> exps, RelDataType inputRowType, RelDataType projectRowType) {
        assert (exps.size() == projectRowType.getFieldCount());
        int i = 0;
        for (RexNode ref : exps) {
            if (!(ref instanceof RexInputRef)) {
                return false;
            }
            if (((RexInputRef)ref).getIndex() == i++) continue;
            return false;
        }
        return i == inputRowType.getFieldCount() && inputRowType.getFieldNames().equals(projectRowType.getFieldNames());
    }

    public static boolean isStar(RexProgram program) {
        int i = 0;
        for (RexLocalRef ref : program.getProjectList()) {
            if (ref.getIndex() == i++) continue;
            return false;
        }
        return i == program.getInputRowType().getFieldCount();
    }

    public Result setOpToSql(SqlSetOperator operator, RelNode rel) {
        SqlCall node = null;
        for (Ord<RelNode> input : Ord.zip(rel.getInputs())) {
            Result result = this.visitChild(input.i, (RelNode)input.e);
            if (node == null) {
                node = result.asSelect();
                continue;
            }
            node = operator.createCall(POS, node, result.asSelect());
        }
        Expressions.FluentList<Clause> clauses = Expressions.list(Clause.SET_OP);
        return this.result(node, clauses, rel, null);
    }

    public static SqlNode convertConditionToSqlNode(RexNode node, Context leftContext, Context rightContext, int leftFieldCount) {
        if (node.isAlwaysTrue()) {
            return SqlLiteral.createBoolean(true, POS);
        }
        if (node.isAlwaysFalse()) {
            return SqlLiteral.createBoolean(false, POS);
        }
        if (node instanceof RexInputRef) {
            Context joinContext = leftContext.implementor().joinContext(leftContext, rightContext);
            return joinContext.toSql(null, node);
        }
        if (!(node instanceof RexCall)) {
            throw new AssertionError(node);
        }
        switch (node.getKind()) {
            case AND: 
            case OR: {
                List<RexNode> operands = ((RexCall)node).getOperands();
                SqlOperator op = ((RexCall)node).getOperator();
                SqlNode sqlCondition = null;
                for (RexNode operand : operands) {
                    SqlNode x = SqlImplementor.convertConditionToSqlNode(operand, leftContext, rightContext, leftFieldCount);
                    if (sqlCondition == null) {
                        sqlCondition = x;
                        continue;
                    }
                    sqlCondition = op.createCall(POS, sqlCondition, x);
                }
                return sqlCondition;
            }
            case EQUALS: 
            case IS_NOT_DISTINCT_FROM: 
            case NOT_EQUALS: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                node = SqlImplementor.stripCastFromString(node);
                List<RexNode> operands = ((RexCall)node).getOperands();
                SqlOperator op = ((RexCall)node).getOperator();
                if (operands.size() == 2 && operands.get(0) instanceof RexInputRef && operands.get(1) instanceof RexInputRef) {
                    RexInputRef op0 = (RexInputRef)operands.get(0);
                    RexInputRef op1 = (RexInputRef)operands.get(1);
                    if (op0.getIndex() < leftFieldCount && op1.getIndex() >= leftFieldCount) {
                        return op.createCall(POS, leftContext.field(op0.getIndex()), rightContext.field(op1.getIndex() - leftFieldCount));
                    }
                    if (op1.getIndex() < leftFieldCount && op0.getIndex() >= leftFieldCount) {
                        return SqlImplementor.reverseOperatorDirection(op).createCall(POS, leftContext.field(op1.getIndex()), rightContext.field(op0.getIndex() - leftFieldCount));
                    }
                }
                Context joinContext = leftContext.implementor().joinContext(leftContext, rightContext);
                return joinContext.toSql(null, node);
            }
            case IS_NULL: 
            case IS_NOT_NULL: {
                List<RexNode> operands = ((RexCall)node).getOperands();
                if (operands.size() == 1 && operands.get(0) instanceof RexInputRef) {
                    SqlOperator op = ((RexCall)node).getOperator();
                    RexInputRef op0 = (RexInputRef)operands.get(0);
                    if (op0.getIndex() < leftFieldCount) {
                        return op.createCall(POS, leftContext.field(op0.getIndex()));
                    }
                    return op.createCall(POS, rightContext.field(op0.getIndex() - leftFieldCount));
                }
                Context joinContext = leftContext.implementor().joinContext(leftContext, rightContext);
                return joinContext.toSql(null, node);
            }
        }
        throw new AssertionError(node);
    }

    private static RexNode stripCastFromString(RexNode node) {
        switch (node.getKind()) {
            case EQUALS: 
            case IS_NOT_DISTINCT_FROM: 
            case NOT_EQUALS: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                RexCall call = (RexCall)node;
                RexNode o0 = (RexNode)call.operands.get(0);
                RexNode o1 = (RexNode)call.operands.get(1);
                if (o0.getKind() == SqlKind.CAST && o1.getKind() != SqlKind.CAST) {
                    RexNode o0b = ((RexCall)o0).getOperands().get(0);
                    switch (o0b.getType().getSqlTypeName()) {
                        case CHAR: 
                        case VARCHAR: {
                            return call.clone(call.getType(), ImmutableList.of(o0b, o1));
                        }
                    }
                }
                if (o1.getKind() != SqlKind.CAST || o0.getKind() == SqlKind.CAST) break;
                RexNode o1b = ((RexCall)o1).getOperands().get(0);
                switch (o1b.getType().getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        return call.clone(call.getType(), ImmutableList.of(o0, o1b));
                    }
                }
            }
        }
        return node;
    }

    private static SqlOperator reverseOperatorDirection(SqlOperator op) {
        switch (op.kind) {
            case GREATER_THAN: {
                return SqlStdOperatorTable.LESS_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
            }
            case LESS_THAN: {
                return SqlStdOperatorTable.GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
            }
            case EQUALS: 
            case IS_NOT_DISTINCT_FROM: 
            case NOT_EQUALS: {
                return op;
            }
        }
        throw new AssertionError(op);
    }

    public static JoinType joinType(JoinRelType joinType) {
        switch (joinType) {
            case LEFT: {
                return JoinType.LEFT;
            }
            case RIGHT: {
                return JoinType.RIGHT;
            }
            case INNER: {
                return JoinType.INNER;
            }
            case FULL: {
                return JoinType.FULL;
            }
        }
        throw new AssertionError((Object)joinType);
    }

    public Result result(SqlNode node, Collection<Clause> clauses, RelNode rel, Map<String, RelDataType> aliases) {
        assert (aliases == null || aliases.size() < 2 || aliases instanceof LinkedHashMap || aliases instanceof ImmutableMap) : "must use a Map implementation that preserves order";
        String alias2 = SqlValidatorUtil.getAlias(node, -1);
        String alias3 = alias2 != null ? alias2 : "t";
        String alias4 = SqlValidatorUtil.uniquify(alias3, this.aliasSet, SqlValidatorUtil.EXPR_SUGGESTER);
        if (!(aliases == null || aliases.isEmpty() || this.dialect.hasImplicitTableAlias() && aliases.size() <= 1)) {
            return new Result(node, clauses, alias4, rel.getRowType(), aliases);
        }
        String alias5 = alias2 == null || !alias2.equals(alias4) || !this.dialect.hasImplicitTableAlias() ? alias4 : null;
        return new Result(node, clauses, alias5, rel.getRowType(), ImmutableMap.of(alias4, rel.getRowType()));
    }

    public Result result(SqlNode join, Result leftResult, Result rightResult) {
        ImmutableMap.Builder<String, RelDataType> builder = ImmutableMap.builder();
        this.collectAliases(builder, join, Iterables.concat(leftResult.aliases.values(), rightResult.aliases.values()).iterator());
        return new Result(join, Expressions.list(Clause.FROM), null, null, builder.build());
    }

    private void collectAliases(ImmutableMap.Builder<String, RelDataType> builder, SqlNode node, Iterator<RelDataType> aliases) {
        if (node instanceof SqlJoin) {
            SqlJoin join = (SqlJoin)node;
            this.collectAliases(builder, join.getLeft(), aliases);
            this.collectAliases(builder, join.getRight(), aliases);
        } else {
            String alias2 = SqlValidatorUtil.getAlias(node, -1);
            assert (alias2 != null);
            builder.put(alias2, aliases.next());
        }
    }

    SqlSelect wrapSelect(SqlNode node) {
        assert (node instanceof SqlJoin || node instanceof SqlIdentifier || node instanceof SqlMatchRecognize || node instanceof SqlCall && (((SqlCall)node).getOperator() instanceof SqlSetOperator || ((SqlCall)node).getOperator() == SqlStdOperatorTable.AS || ((SqlCall)node).getOperator() == SqlStdOperatorTable.VALUES)) : node;
        return new SqlSelect(POS, SqlNodeList.EMPTY, null, node, null, null, null, SqlNodeList.EMPTY, null, null, null);
    }

    private static int computeFieldCount(Map<String, RelDataType> aliases) {
        int x = 0;
        for (RelDataType type : aliases.values()) {
            x += type.getFieldCount();
        }
        return x;
    }

    public Context aliasContext(Map<String, RelDataType> aliases, boolean qualified) {
        return new AliasContext(this.dialect, aliases, qualified);
    }

    public Context joinContext(Context leftContext, Context rightContext) {
        return new JoinContext(this.dialect, leftContext, rightContext);
    }

    public Context matchRecognizeContext(Context context) {
        return new MatchRecognizeContext(this.dialect, ((AliasContext)context).aliases);
    }

    public static enum Clause {
        FROM,
        WHERE,
        GROUP_BY,
        HAVING,
        SELECT,
        SET_OP,
        ORDER_BY,
        FETCH,
        OFFSET;

    }

    public class Builder {
        private final RelNode rel;
        final List<Clause> clauses;
        final SqlSelect select;
        public final Context context;
        private final Map<String, RelDataType> aliases;

        public Builder(RelNode rel, List<Clause> clauses, SqlSelect select, Context context, Map<String, RelDataType> aliases) {
            this.rel = rel;
            this.clauses = clauses;
            this.select = select;
            this.context = context;
            this.aliases = aliases;
        }

        public void setSelect(SqlNodeList nodeList) {
            this.select.setSelectList(nodeList);
        }

        public void setWhere(SqlNode node) {
            assert (this.clauses.contains((Object)Clause.WHERE));
            this.select.setWhere(node);
        }

        public void setGroupBy(SqlNodeList nodeList) {
            assert (this.clauses.contains((Object)Clause.GROUP_BY));
            this.select.setGroupBy(nodeList);
        }

        public void setHaving(SqlNode node) {
            assert (this.clauses.contains((Object)Clause.HAVING));
            this.select.setHaving(node);
        }

        public void setOrderBy(SqlNodeList nodeList) {
            assert (this.clauses.contains((Object)Clause.ORDER_BY));
            this.select.setOrderBy(nodeList);
        }

        public void setFetch(SqlNode fetch) {
            assert (this.clauses.contains((Object)Clause.FETCH));
            this.select.setFetch(fetch);
        }

        public void setOffset(SqlNode offset) {
            assert (this.clauses.contains((Object)Clause.OFFSET));
            this.select.setOffset(offset);
        }

        public void addOrderItem(List<SqlNode> orderByList, RelFieldCollation field) {
            this.context.addOrderItem(orderByList, field);
        }

        public Result result() {
            return SqlImplementor.this.result(this.select, this.clauses, this.rel, this.aliases);
        }
    }

    public class Result {
        final SqlNode node;
        private final String neededAlias;
        private final RelDataType neededType;
        private final Map<String, RelDataType> aliases;
        final Expressions.FluentList<Clause> clauses;

        public Result(SqlNode node, Collection<Clause> clauses, String neededAlias, RelDataType neededType, Map<String, RelDataType> aliases) {
            this.node = node;
            this.neededAlias = neededAlias;
            this.neededType = neededType;
            this.aliases = aliases;
            this.clauses = Expressions.list(clauses);
        }

        public Builder builder(RelNode rel, Clause ... clauses) {
            Context newContext;
            SqlSelect select;
            Clause maxClause = this.maxClause();
            boolean needNew = false;
            ImmutableSet<Clause> nonWrapSet = ImmutableSet.of(Clause.SELECT);
            for (Clause clause : clauses) {
                if (maxClause.ordinal() <= clause.ordinal() && (maxClause != clause || nonWrapSet.contains((Object)clause))) continue;
                needNew = true;
            }
            if (rel instanceof LogicalAggregate && !SqlImplementor.this.dialect.supportsNestedAggregations() && this.hasNestedAggregations((LogicalAggregate)rel)) {
                needNew = true;
            }
            Expressions.FluentList<Clause> clauseList = Expressions.list();
            if (needNew) {
                select = this.subSelect();
            } else {
                select = this.asSelect();
                clauseList.addAll(this.clauses);
            }
            clauseList.appendAll(clauses);
            final SqlNodeList selectList = select.getSelectList();
            if (selectList != null) {
                newContext = new Context(SqlImplementor.this.dialect, selectList.size()){

                    @Override
                    public SqlNode field(int ordinal) {
                        SqlNode selectItem = selectList.get(ordinal);
                        switch (selectItem.getKind()) {
                            case AS: {
                                return ((SqlCall)selectItem).operand(0);
                            }
                        }
                        return selectItem;
                    }
                };
            } else {
                boolean qualified;
                boolean bl = qualified = !SqlImplementor.this.dialect.hasImplicitTableAlias() || this.aliases.size() > 1;
                if (needNew && this.neededAlias != null && (this.aliases.size() != 1 || !this.aliases.containsKey(this.neededAlias))) {
                    ImmutableMap<String, RelDataType> newAliases = ImmutableMap.of(this.neededAlias, rel.getInput(0).getRowType());
                    newContext = SqlImplementor.this.aliasContext(newAliases, qualified);
                } else {
                    newContext = SqlImplementor.this.aliasContext(this.aliases, qualified);
                }
            }
            return new Builder(rel, clauseList, select, newContext, needNew ? null : this.aliases);
        }

        private boolean hasNestedAggregations(LogicalAggregate rel) {
            SqlNodeList selectList;
            if (this.node instanceof SqlSelect && (selectList = ((SqlSelect)this.node).getSelectList()) != null) {
                HashSet<Integer> aggregatesArgs = new HashSet<Integer>();
                for (AggregateCall aggregateCall : rel.getAggCallList()) {
                    aggregatesArgs.addAll(aggregateCall.getArgList());
                }
                Iterator<AggregateCall> iterator = aggregatesArgs.iterator();
                while (iterator.hasNext()) {
                    int aggregatesArg = (Integer)((Object)iterator.next());
                    if (!(selectList.get(aggregatesArg) instanceof SqlBasicCall)) continue;
                    SqlBasicCall call = (SqlBasicCall)selectList.get(aggregatesArg);
                    for (SqlNode operand : call.getOperands()) {
                        if (!(operand instanceof SqlCall) || !(((SqlCall)operand).getOperator() instanceof SqlAggFunction)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        public Clause maxClause() {
            Clause maxClause = null;
            for (Clause clause : this.clauses) {
                if (maxClause != null && clause.ordinal() <= maxClause.ordinal()) continue;
                maxClause = clause;
            }
            assert (maxClause != null);
            return maxClause;
        }

        public SqlNode asFrom() {
            if (this.neededAlias != null) {
                return SqlStdOperatorTable.AS.createCall(POS, this.node, new SqlIdentifier(this.neededAlias, POS));
            }
            return this.node;
        }

        public SqlSelect subSelect() {
            return SqlImplementor.this.wrapSelect(this.asFrom());
        }

        public SqlSelect asSelect() {
            if (this.node instanceof SqlSelect) {
                return (SqlSelect)this.node;
            }
            if (!SqlImplementor.this.dialect.hasImplicitTableAlias()) {
                return SqlImplementor.this.wrapSelect(this.asFrom());
            }
            return SqlImplementor.this.wrapSelect(this.node);
        }

        public SqlNode asStatement() {
            switch (this.node.getKind()) {
                case UNION: 
                case INTERSECT: 
                case EXCEPT: 
                case INSERT: 
                case UPDATE: 
                case DELETE: 
                case MERGE: {
                    return this.node;
                }
            }
            return this.asSelect();
        }

        public SqlNode asQueryOrValues() {
            switch (this.node.getKind()) {
                case UNION: 
                case INTERSECT: 
                case EXCEPT: 
                case VALUES: {
                    return this.node;
                }
            }
            return this.asSelect();
        }

        public Context qualifiedContext() {
            return SqlImplementor.this.aliasContext(this.aliases, true);
        }

        public Result resetAlias() {
            if (this.neededAlias == null) {
                return this;
            }
            return new Result(this.node, this.clauses, this.neededAlias, this.neededType, ImmutableMap.of(this.neededAlias, this.neededType));
        }
    }

    class JoinContext
    extends BaseContext {
        private final Context leftContext;
        private final Context rightContext;

        private JoinContext(SqlDialect dialect, Context leftContext, Context rightContext) {
            super(dialect, leftContext.fieldCount + rightContext.fieldCount);
            this.leftContext = leftContext;
            this.rightContext = rightContext;
        }

        @Override
        public SqlNode field(int ordinal) {
            if (ordinal < this.leftContext.fieldCount) {
                return this.leftContext.field(ordinal);
            }
            return this.rightContext.field(ordinal - this.leftContext.fieldCount);
        }
    }

    public class AliasContext
    extends BaseContext {
        private final boolean qualified;
        private final Map<String, RelDataType> aliases;

        protected AliasContext(SqlDialect dialect, Map<String, RelDataType> aliases, boolean qualified) {
            super(dialect, SqlImplementor.computeFieldCount(aliases));
            this.aliases = aliases;
            this.qualified = qualified;
        }

        @Override
        public SqlNode field(int ordinal) {
            for (Map.Entry<String, RelDataType> alias2 : this.aliases.entrySet()) {
                List<RelDataTypeField> fields = alias2.getValue().getFieldList();
                if (ordinal < fields.size()) {
                    RelDataTypeField field = fields.get(ordinal);
                    SqlNode mappedSqlNode = SqlImplementor.this.ordinalMap.get(field.getName().toLowerCase(Locale.ROOT));
                    if (mappedSqlNode != null) {
                        return mappedSqlNode;
                    }
                    return new SqlIdentifier(!this.qualified ? ImmutableList.of(field.getName()) : ImmutableList.of(alias2.getKey(), field.getName()), POS);
                }
                ordinal -= fields.size();
            }
            throw new AssertionError((Object)("field ordinal " + ordinal + " out of range " + this.aliases));
        }
    }

    public class MatchRecognizeContext
    extends AliasContext {
        protected MatchRecognizeContext(SqlDialect dialect, Map<String, RelDataType> aliases) {
            super(dialect, aliases, false);
        }

        @Override
        public SqlNode toSql(RexProgram program, RexNode rex) {
            RexLiteral literal;
            if (rex.getKind() == SqlKind.LITERAL && (literal = (RexLiteral)rex).getTypeName().getFamily() == SqlTypeFamily.CHARACTER) {
                return new SqlIdentifier(RexLiteral.stringValue(literal), POS);
            }
            return super.toSql(program, rex);
        }
    }

    protected abstract class BaseContext
    extends Context {
        BaseContext(SqlDialect dialect, int fieldCount) {
            super(dialect, fieldCount);
        }

        @Override
        protected Context getAliasContext(RexCorrelVariable variable) {
            return SqlImplementor.this.correlTableMap.get(variable.id);
        }

        @Override
        public SqlImplementor implementor() {
            return SqlImplementor.this;
        }
    }

    public static class SimpleContext
    extends Context {
        @Nonnull
        private final IntFunction<SqlNode> field;

        public SimpleContext(SqlDialect dialect, IntFunction<SqlNode> field) {
            super(dialect, 0, false);
            this.field = field;
        }

        @Override
        public SqlNode field(int ordinal) {
            return this.field.apply(ordinal);
        }
    }

    public static abstract class Context {
        final SqlDialect dialect;
        final int fieldCount;
        private final boolean ignoreCast;

        protected Context(SqlDialect dialect, int fieldCount) {
            this(dialect, fieldCount, false);
        }

        protected Context(SqlDialect dialect, int fieldCount, boolean ignoreCast) {
            this.dialect = dialect;
            this.fieldCount = fieldCount;
            this.ignoreCast = ignoreCast;
        }

        public abstract SqlNode field(int var1);

        public SqlNode toSql(RexProgram program, RexNode rex) {
            switch (rex.getKind()) {
                case LOCAL_REF: {
                    int index = ((RexLocalRef)rex).getIndex();
                    return this.toSql(program, program.getExprList().get(index));
                }
                case INPUT_REF: {
                    return this.field(((RexInputRef)rex).getIndex());
                }
                case FIELD_ACCESS: {
                    RexFieldAccess access;
                    SqlIdentifier sqlIdentifier;
                    ArrayDeque<RexFieldAccess> accesses = new ArrayDeque<RexFieldAccess>();
                    RexNode referencedExpr = rex;
                    while (referencedExpr.getKind() == SqlKind.FIELD_ACCESS) {
                        accesses.offerLast((RexFieldAccess)referencedExpr);
                        referencedExpr = ((RexFieldAccess)referencedExpr).getReferenceExpr();
                    }
                    switch (referencedExpr.getKind()) {
                        case CORREL_VARIABLE: {
                            RexCorrelVariable variable = (RexCorrelVariable)referencedExpr;
                            Context correlAliasContext = this.getAliasContext(variable);
                            RexFieldAccess lastAccess = (RexFieldAccess)accesses.pollLast();
                            assert (lastAccess != null);
                            sqlIdentifier = (SqlIdentifier)correlAliasContext.field(lastAccess.getField().getIndex());
                            break;
                        }
                        default: {
                            sqlIdentifier = (SqlIdentifier)this.toSql(program, referencedExpr);
                        }
                    }
                    int nameIndex = sqlIdentifier.names.size();
                    while ((access = (RexFieldAccess)accesses.pollLast()) != null) {
                        sqlIdentifier = sqlIdentifier.add(nameIndex++, access.getField().getName(), POS);
                    }
                    return sqlIdentifier;
                }
                case PATTERN_INPUT_REF: {
                    RexPatternFieldRef ref = (RexPatternFieldRef)rex;
                    String pv = ref.getAlpha();
                    SqlNode refNode = this.field(ref.getIndex());
                    SqlIdentifier id = (SqlIdentifier)refNode;
                    if (id.names.size() > 1) {
                        return id.setName(0, pv);
                    }
                    return new SqlIdentifier(ImmutableList.of(pv, id.names.get(0)), POS);
                }
                case LITERAL: {
                    RexLiteral literal = (RexLiteral)rex;
                    if (literal.getTypeName() == SqlTypeName.SYMBOL) {
                        Enum symbol = (Enum)((Object)literal.getValue());
                        return SqlLiteral.createSymbol(symbol, POS);
                    }
                    switch (literal.getTypeName().getFamily()) {
                        case CHARACTER: {
                            return SqlLiteral.createCharString((String)literal.getValue2(), POS);
                        }
                        case NUMERIC: 
                        case EXACT_NUMERIC: {
                            return SqlLiteral.createExactNumeric(literal.getValueAs(BigDecimal.class).toPlainString(), POS);
                        }
                        case APPROXIMATE_NUMERIC: {
                            return SqlLiteral.createApproxNumeric(literal.getValueAs(BigDecimal.class).toPlainString(), POS);
                        }
                        case BOOLEAN: {
                            return SqlLiteral.createBoolean(literal.getValueAs(Boolean.class), POS);
                        }
                        case INTERVAL_YEAR_MONTH: 
                        case INTERVAL_DAY_TIME: {
                            boolean negative = literal.getValueAs(Boolean.class);
                            return SqlLiteral.createInterval(negative ? -1 : 1, literal.getValueAs(String.class), literal.getType().getIntervalQualifier(), POS);
                        }
                        case DATE: {
                            return SqlLiteral.createDate(literal.getValueAs(DateString.class), POS);
                        }
                        case TIME: {
                            return SqlLiteral.createTime(literal.getValueAs(TimeString.class), literal.getType().getPrecision(), POS);
                        }
                        case TIMESTAMP: {
                            return SqlLiteral.createTimestamp(literal.getValueAs(TimestampString.class), literal.getType().getPrecision(), POS);
                        }
                        case ANY: 
                        case NULL: {
                            switch (literal.getTypeName()) {
                                case NULL: {
                                    return SqlLiteral.createNull(POS);
                                }
                            }
                        }
                    }
                    throw new AssertionError((Object)(literal + ": " + (Object)((Object)literal.getTypeName())));
                }
                case CASE: {
                    SqlNode valueNode;
                    RexCall caseCall = (RexCall)rex;
                    List<SqlNode> caseNodeList = this.toSql(program, caseCall.getOperands());
                    Expressions.FluentList whenList = Expressions.list();
                    Expressions.FluentList thenList = Expressions.list();
                    if (caseNodeList.size() % 2 == 0) {
                        valueNode = caseNodeList.get(0);
                        for (int i = 1; i < caseNodeList.size() - 1; i += 2) {
                            whenList.add(caseNodeList.get(i));
                            thenList.add(caseNodeList.get(i + 1));
                        }
                    } else {
                        valueNode = null;
                        for (int i = 0; i < caseNodeList.size() - 1; i += 2) {
                            whenList.add(caseNodeList.get(i));
                            thenList.add(caseNodeList.get(i + 1));
                        }
                    }
                    SqlNode elseNode = caseNodeList.get(caseNodeList.size() - 1);
                    return new SqlCase(POS, valueNode, new SqlNodeList(whenList, POS), new SqlNodeList(thenList, POS), elseNode);
                }
                case DYNAMIC_PARAM: {
                    RexDynamicParam caseParam = (RexDynamicParam)rex;
                    return new SqlDynamicParam(caseParam.getIndex(), POS);
                }
                case IN: {
                    if (rex instanceof RexSubQuery) {
                        SqlNode op0;
                        RexSubQuery subQuery = (RexSubQuery)rex;
                        SqlNode sqlSubQuery = this.implementor().visitChild(0, subQuery.rel).asQueryOrValues();
                        ImmutableList operands = subQuery.operands;
                        if (operands.size() == 1) {
                            op0 = this.toSql(program, (RexNode)operands.get(0));
                        } else {
                            List<SqlNode> cols = this.toSql(program, operands);
                            op0 = new SqlNodeList(cols, POS);
                        }
                        return subQuery.getOperator().createCall(POS, op0, sqlSubQuery);
                    }
                    RexCall call = (RexCall)rex;
                    List<SqlNode> cols = this.toSql(program, call.operands);
                    return call.getOperator().createCall(POS, cols.get(0), new SqlNodeList(cols.subList(1, cols.size()), POS));
                }
                case EXISTS: 
                case SCALAR_QUERY: {
                    RexSubQuery subQuery = (RexSubQuery)rex;
                    SqlNode sqlSubQuery = this.implementor().visitChild(0, subQuery.rel).asQueryOrValues();
                    return subQuery.getOperator().createCall(POS, sqlSubQuery);
                }
                case NOT: {
                    RexNode operand = (RexNode)((RexCall)rex).operands.get(0);
                    SqlNode node = this.toSql(program, operand);
                    switch (operand.getKind()) {
                        case IN: {
                            return SqlStdOperatorTable.NOT_IN.createCall(POS, ((SqlCall)node).getOperandList());
                        }
                        case LIKE: {
                            return SqlStdOperatorTable.NOT_LIKE.createCall(POS, ((SqlCall)node).getOperandList());
                        }
                        case SIMILAR: {
                            return SqlStdOperatorTable.NOT_SIMILAR_TO.createCall(POS, ((SqlCall)node).getOperandList());
                        }
                    }
                    return SqlStdOperatorTable.NOT.createCall(POS, node);
                }
            }
            if (rex instanceof RexOver) {
                return this.toSql(program, (RexOver)rex);
            }
            RexCall call = (RexCall)SqlImplementor.stripCastFromString(rex);
            SqlOperator op = call.getOperator();
            switch (op.getKind()) {
                case SUM0: {
                    op = SqlStdOperatorTable.SUM;
                }
            }
            List<SqlNode> nodeList = this.toSql(program, call.getOperands());
            switch (call.getKind()) {
                case CAST: {
                    if (this.ignoreCast) {
                        assert (nodeList.size() == 1);
                        return nodeList.get(0);
                    }
                    nodeList.add(this.dialect.getCastSpec(call.getType()));
                }
            }
            if (op instanceof SqlBinaryOperator && nodeList.size() > 2) {
                return this.createLeftCall(op, nodeList);
            }
            return op.createCall(new SqlNodeList(nodeList, POS));
        }

        protected Context getAliasContext(RexCorrelVariable variable) {
            throw new UnsupportedOperationException();
        }

        private SqlCall toSql(RexProgram program, RexOver rexOver) {
            RexWindow rexWindow = rexOver.getWindow();
            SqlNodeList partitionList = new SqlNodeList(this.toSql(program, rexWindow.partitionKeys), POS);
            ImmutableList.Builder orderNodes = ImmutableList.builder();
            if (rexWindow.orderKeys != null) {
                for (RexFieldCollation rfc : rexWindow.orderKeys) {
                    orderNodes.add(this.toSql(program, rfc));
                }
            }
            SqlNodeList orderList = new SqlNodeList(orderNodes.build(), POS);
            SqlLiteral isRows = SqlLiteral.createBoolean(rexWindow.isRows(), POS);
            SqlLiteral allowPartial = null;
            SqlAggFunction sqlAggregateFunction = rexOver.getAggOperator();
            SqlNode lowerBound = null;
            SqlNode upperBound = null;
            if (sqlAggregateFunction.allowsFraming()) {
                lowerBound = this.createSqlWindowBound(rexWindow.getLowerBound());
                upperBound = this.createSqlWindowBound(rexWindow.getUpperBound());
            }
            SqlWindow sqlWindow = SqlWindow.create(null, null, partitionList, orderList, isRows, lowerBound, upperBound, allowPartial, POS);
            List<SqlNode> nodeList = this.toSql(program, rexOver.getOperands());
            return this.createOverCall(sqlAggregateFunction, nodeList, sqlWindow);
        }

        private SqlCall createOverCall(SqlAggFunction op, List<SqlNode> operands, SqlWindow window) {
            if (op instanceof SqlSumEmptyIsZeroAggFunction) {
                SqlCall node = this.createOverCall(SqlStdOperatorTable.SUM, operands, window);
                return SqlStdOperatorTable.COALESCE.createCall(POS, node, SqlLiteral.createExactNumeric("0", POS));
            }
            SqlCall aggFunctionCall = op.createCall(POS, operands);
            return SqlStdOperatorTable.OVER.createCall(POS, aggFunctionCall, window);
        }

        private SqlNode toSql(RexProgram program, RexFieldCollation rfc) {
            SqlNode node = this.toSql(program, (RexNode)rfc.left);
            switch (rfc.getDirection()) {
                case DESCENDING: 
                case STRICTLY_DESCENDING: {
                    node = SqlStdOperatorTable.DESC.createCall(POS, node);
                }
            }
            if (rfc.getNullDirection() != this.dialect.defaultNullDirection(rfc.getDirection())) {
                switch (rfc.getNullDirection()) {
                    case FIRST: {
                        node = SqlStdOperatorTable.NULLS_FIRST.createCall(POS, node);
                        break;
                    }
                    case LAST: {
                        node = SqlStdOperatorTable.NULLS_LAST.createCall(POS, node);
                    }
                }
            }
            return node;
        }

        private SqlNode createSqlWindowBound(RexWindowBound rexWindowBound) {
            if (rexWindowBound.isCurrentRow()) {
                return SqlWindow.createCurrentRow(POS);
            }
            if (rexWindowBound.isPreceding()) {
                if (rexWindowBound.isUnbounded()) {
                    return SqlWindow.createUnboundedPreceding(POS);
                }
                SqlNode literal = this.toSql(null, rexWindowBound.getOffset());
                return SqlWindow.createPreceding(literal, POS);
            }
            if (rexWindowBound.isFollowing()) {
                if (rexWindowBound.isUnbounded()) {
                    return SqlWindow.createUnboundedFollowing(POS);
                }
                SqlNode literal = this.toSql(null, rexWindowBound.getOffset());
                return SqlWindow.createFollowing(literal, POS);
            }
            throw new AssertionError((Object)("Unsupported Window bound: " + rexWindowBound));
        }

        private SqlNode createLeftCall(SqlOperator op, List<SqlNode> nodeList) {
            SqlCall node = op.createCall(new SqlNodeList(nodeList.subList(0, 2), POS));
            for (int i = 2; i < nodeList.size(); ++i) {
                node = op.createCall(new SqlNodeList(ImmutableList.of(node, nodeList.get(i)), POS));
            }
            return node;
        }

        private List<SqlNode> toSql(RexProgram program, List<RexNode> operandList) {
            ArrayList<SqlNode> list = new ArrayList<SqlNode>();
            for (RexNode rex : operandList) {
                list.add(this.toSql(program, rex));
            }
            return list;
        }

        public List<SqlNode> fieldList() {
            return new AbstractList<SqlNode>(){

                @Override
                public SqlNode get(int index) {
                    return this.field(index);
                }

                @Override
                public int size() {
                    return fieldCount;
                }
            };
        }

        void addOrderItem(List<SqlNode> orderByList, RelFieldCollation field) {
            if (field.nullDirection != RelFieldCollation.NullDirection.UNSPECIFIED) {
                boolean first = field.nullDirection == RelFieldCollation.NullDirection.FIRST;
                SqlNode nullDirectionNode = this.dialect.emulateNullDirection(this.field(field.getFieldIndex()), first, field.direction.isDescending());
                if (nullDirectionNode != null) {
                    orderByList.add(nullDirectionNode);
                    field = new RelFieldCollation(field.getFieldIndex(), field.getDirection(), RelFieldCollation.NullDirection.UNSPECIFIED);
                }
            }
            orderByList.add(this.toSql(field));
        }

        public SqlNode toSql(AggregateCall aggCall) {
            SqlAggFunction op = aggCall.getAggregation();
            Expressions.FluentList<SqlNode> operandList = Expressions.list();
            for (int arg : aggCall.getArgList()) {
                operandList.add(this.field(arg));
            }
            SqlLiteral qualifier = aggCall.isDistinct() ? SqlSelectKeyword.DISTINCT.symbol(POS) : null;
            SqlNode[] operands = operandList.toArray(new SqlNode[0]);
            Expressions.FluentList<SqlNode> orderByList = Expressions.list();
            for (RelFieldCollation field : aggCall.collation.getFieldCollations()) {
                this.addOrderItem(orderByList, field);
            }
            SqlNodeList orderList = new SqlNodeList(orderByList, POS);
            if (op instanceof SqlSumEmptyIsZeroAggFunction) {
                SqlNode node = this.withOrder(SqlStdOperatorTable.SUM.createCall(qualifier, POS, operands), orderList);
                return SqlStdOperatorTable.COALESCE.createCall(POS, node, SqlLiteral.createExactNumeric("0", POS));
            }
            return this.withOrder(op.createCall(qualifier, POS, operands), orderList);
        }

        private SqlNode withOrder(SqlCall call, SqlNodeList orderList) {
            if (orderList == null || orderList.size() == 0) {
                return call;
            }
            return SqlStdOperatorTable.WITHIN_GROUP.createCall(POS, call, orderList);
        }

        public SqlNode toSql(RelFieldCollation collation) {
            SqlNode node = this.field(collation.getFieldIndex());
            switch (collation.getDirection()) {
                case DESCENDING: 
                case STRICTLY_DESCENDING: {
                    node = SqlStdOperatorTable.DESC.createCall(POS, node);
                }
            }
            if (collation.nullDirection != this.dialect.defaultNullDirection(collation.direction)) {
                switch (collation.nullDirection) {
                    case FIRST: {
                        node = SqlStdOperatorTable.NULLS_FIRST.createCall(POS, node);
                        break;
                    }
                    case LAST: {
                        node = SqlStdOperatorTable.NULLS_LAST.createCall(POS, node);
                    }
                }
            }
            return node;
        }

        public SqlImplementor implementor() {
            throw new UnsupportedOperationException();
        }
    }
}

