/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.List;
import java.util.function.Predicate;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;

public abstract class PruneEmptyRules {
    public static final RelOptRule UNION_INSTANCE = new RelOptRule(RelOptRule.operand(LogicalUnion.class, RelOptRule.unordered(RelOptRule.operandJ(Values.class, null, Values::isEmpty, RelOptRule.none()), new RelOptRuleOperand[0])), "Union"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            LogicalUnion union = (LogicalUnion)call.rel(0);
            List<RelNode> inputs = union.getInputs();
            assert (inputs != null);
            RelBuilder builder = call.builder();
            int nonEmptyInputs = 0;
            for (RelNode input : inputs) {
                if (PruneEmptyRules.isEmpty(input)) continue;
                builder.push(input);
                ++nonEmptyInputs;
            }
            assert (nonEmptyInputs < inputs.size()) : "planner promised us at least one Empty child: " + RelOptUtil.toString(union);
            if (nonEmptyInputs == 0) {
                builder.push(union).empty();
            } else {
                builder.union(union.all, nonEmptyInputs);
                builder.convert(union.getRowType(), true);
            }
            call.transformTo(builder.build());
        }
    };
    public static final RelOptRule MINUS_INSTANCE = new RelOptRule(RelOptRule.operand(LogicalMinus.class, RelOptRule.unordered(RelOptRule.operandJ(Values.class, null, Values::isEmpty, RelOptRule.none()), new RelOptRuleOperand[0])), "Minus"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            LogicalMinus minus = (LogicalMinus)call.rel(0);
            List<RelNode> inputs = minus.getInputs();
            assert (inputs != null);
            int nonEmptyInputs = 0;
            RelBuilder builder = call.builder();
            for (RelNode input : inputs) {
                if (!PruneEmptyRules.isEmpty(input)) {
                    builder.push(input);
                    ++nonEmptyInputs;
                    continue;
                }
                if (nonEmptyInputs != 0) continue;
                break;
            }
            assert (nonEmptyInputs < inputs.size()) : "planner promised us at least one Empty child: " + RelOptUtil.toString(minus);
            if (nonEmptyInputs == 0) {
                builder.push(minus).empty();
            } else {
                builder.minus(minus.all, nonEmptyInputs);
                builder.convert(minus.getRowType(), true);
            }
            call.transformTo(builder.build());
        }
    };
    public static final RelOptRule INTERSECT_INSTANCE = new RelOptRule(RelOptRule.operand(LogicalIntersect.class, RelOptRule.unordered(RelOptRule.operandJ(Values.class, null, Values::isEmpty, RelOptRule.none()), new RelOptRuleOperand[0])), "Intersect"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            LogicalIntersect intersect = (LogicalIntersect)call.rel(0);
            RelBuilder builder = call.builder();
            builder.push(intersect).empty();
            call.transformTo(builder.build());
        }
    };
    public static final RelOptRule PROJECT_INSTANCE = new RemoveEmptySingleRule(Project.class, project -> true, RelFactories.LOGICAL_BUILDER, "PruneEmptyProject");
    public static final RelOptRule FILTER_INSTANCE = new RemoveEmptySingleRule(Filter.class, "PruneEmptyFilter");
    public static final RelOptRule SORT_INSTANCE = new RemoveEmptySingleRule(Sort.class, "PruneEmptySort");
    public static final RelOptRule SORT_FETCH_ZERO_INSTANCE = new RelOptRule(RelOptRule.operand(Sort.class, RelOptRule.any()), "PruneSortLimit0"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Sort sort = (Sort)call.rel(0);
            if (sort.fetch != null && !(sort.fetch instanceof RexDynamicParam) && RexLiteral.intValue(sort.fetch) == 0) {
                call.transformTo(call.builder().push(sort).empty().build());
            }
        }
    };
    public static final RelOptRule AGGREGATE_INSTANCE = new RemoveEmptySingleRule(Aggregate.class, Aggregate::isNotGrandTotal, RelFactories.LOGICAL_BUILDER, "PruneEmptyAggregate");
    public static final RelOptRule JOIN_LEFT_INSTANCE = new RelOptRule(RelOptRule.operand(Join.class, RelOptRule.some(RelOptRule.operandJ(Values.class, null, Values::isEmpty, RelOptRule.none()), RelOptRule.operand(RelNode.class, RelOptRule.any()))), "PruneEmptyJoin(left)"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Join join = (Join)call.rel(0);
            if (join.getJoinType().generatesNullsOnLeft()) {
                return;
            }
            call.transformTo(call.builder().push(join).empty().build());
        }
    };
    public static final RelOptRule JOIN_RIGHT_INSTANCE = new RelOptRule(RelOptRule.operand(Join.class, RelOptRule.some(RelOptRule.operand(RelNode.class, RelOptRule.any()), RelOptRule.operandJ(Values.class, null, Values::isEmpty, RelOptRule.none()))), "PruneEmptyJoin(right)"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Join join = (Join)call.rel(0);
            if (join.getJoinType().generatesNullsOnRight()) {
                return;
            }
            call.transformTo(call.builder().push(join).empty().build());
        }
    };

    private static boolean isEmpty(RelNode node) {
        if (node instanceof Values) {
            return ((Values)node).getTuples().isEmpty();
        }
        if (node instanceof HepRelVertex) {
            return PruneEmptyRules.isEmpty(((HepRelVertex)node).getCurrentRel());
        }
        if (!(node instanceof RelSubset)) {
            return false;
        }
        RelSubset subset = (RelSubset)node;
        for (RelNode rel : subset.getRels()) {
            if (!PruneEmptyRules.isEmpty(rel)) continue;
            return true;
        }
        return false;
    }

    public static class RemoveEmptySingleRule
    extends RelOptRule {
        public <R extends SingleRel> RemoveEmptySingleRule(Class<R> clazz, String description) {
            this(clazz, (R project) -> true, RelFactories.LOGICAL_BUILDER, description);
        }

        public <R extends SingleRel> RemoveEmptySingleRule(Class<R> clazz, Predicate<R> predicate, RelBuilderFactory relBuilderFactory, String description) {
            super(RemoveEmptySingleRule.operandJ(clazz, null, predicate, RemoveEmptySingleRule.operandJ(Values.class, null, Values::isEmpty, RemoveEmptySingleRule.none()), new RelOptRuleOperand[0]), relBuilderFactory, description);
        }

        @Deprecated
        public <R extends SingleRel> RemoveEmptySingleRule(Class<R> clazz, org.apache.flink.calcite.shaded.com.google.common.base.Predicate<R> predicate, RelBuilderFactory relBuilderFactory, String description) {
            this(clazz, predicate::apply, relBuilderFactory, description);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            SingleRel single = (SingleRel)call.rel(0);
            call.transformTo(call.builder().push(single).empty().build());
        }
    }
}

