/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import org.apache.flink.calcite.shaded.com.google.common.collect.Lists;

public class XmlOutput {
    private final PrintWriter out;
    private final Deque<String> tagStack = new ArrayDeque<String>();
    private int indent;
    private int tagsWritten;
    private boolean compact;
    private String indentString = "\t";
    private boolean glob;
    private boolean inTag;
    private boolean alwaysQuoteCData;
    private boolean ignorePcdata;

    private void displayIndent(PrintWriter out, int indent) {
        if (!this.compact) {
            for (int i = 0; i < indent; ++i) {
                out.print(this.indentString);
            }
        }
    }

    public XmlOutput(Writer out) {
        this(new PrintWriter(out, true));
    }

    public XmlOutput(PrintWriter out) {
        this.out = out;
        this.indent = 0;
        this.tagsWritten = 0;
    }

    public void setCompact(boolean compact) {
        this.compact = compact;
    }

    public boolean getCompact() {
        return this.compact;
    }

    public void setIndentString(String indentString) {
        this.indentString = indentString;
    }

    public void setGlob(boolean glob) {
        this.glob = glob;
    }

    public void setAlwaysQuoteCData(boolean alwaysQuoteCData) {
        this.alwaysQuoteCData = alwaysQuoteCData;
    }

    public void setIgnorePcdata(boolean ignorePcdata) {
        this.ignorePcdata = ignorePcdata;
    }

    public boolean getIgnorePcdata() {
        return this.ignorePcdata;
    }

    public void print(String s) {
        this.out.print(s);
    }

    public void beginTag(String tagName, XMLAttrVector attributes) {
        this.beginBeginTag(tagName);
        if (attributes != null) {
            attributes.display(this.out, this.indent);
        }
        this.endBeginTag(tagName);
    }

    public void beginBeginTag(String tagName) {
        if (this.inTag) {
            if (this.compact) {
                this.out.print(">");
            } else {
                this.out.println(">");
            }
            this.inTag = false;
        }
        this.displayIndent(this.out, this.indent);
        this.out.print("<");
        this.out.print(tagName);
    }

    public void endBeginTag(String tagName) {
        if (this.glob) {
            this.inTag = true;
        } else if (this.compact) {
            this.out.print(">");
        } else {
            this.out.println(">");
        }
        this.out.flush();
        this.tagStack.push(tagName);
        ++this.indent;
        ++this.tagsWritten;
    }

    public void attribute(String name, String value) {
        XmlOutput.printAtt(this.out, name, value);
    }

    public void beginNode() {
        if (this.inTag) {
            if (this.compact) {
                this.out.print(">");
            } else {
                this.out.println(">");
            }
            this.inTag = false;
        }
    }

    public void endTag(String tagName) {
        String x = this.tagStack.pop();
        assert (x.equals(tagName));
        --this.indent;
        if (this.inTag) {
            if (this.compact) {
                this.out.print("/>");
            } else {
                this.out.println("/>");
            }
            this.inTag = false;
        } else {
            this.displayIndent(this.out, this.indent);
            this.out.print("</");
            this.out.print(tagName);
            if (this.compact) {
                this.out.print(">");
            } else {
                this.out.println(">");
            }
        }
        this.out.flush();
    }

    public void emptyTag(String tagName, XMLAttrVector attributes) {
        if (this.inTag) {
            if (this.compact) {
                this.out.print(">");
            } else {
                this.out.println(">");
            }
            this.inTag = false;
        }
        this.displayIndent(this.out, this.indent);
        this.out.print("<");
        this.out.print(tagName);
        if (attributes != null) {
            this.out.print(" ");
            attributes.display(this.out, this.indent);
        }
        if (this.compact) {
            this.out.print("/>");
        } else {
            this.out.println("/>");
        }
        this.out.flush();
        ++this.tagsWritten;
    }

    public void cdata(String data) {
        this.cdata(data, false);
    }

    public void cdata(String data, boolean quote) {
        if (this.inTag) {
            if (this.compact) {
                this.out.print(">");
            } else {
                this.out.println(">");
            }
            this.inTag = false;
        }
        if (data == null) {
            data = "";
        }
        boolean specials = false;
        boolean cdataEnd = false;
        if (XmlOutput.stringHasXMLSpecials(data)) {
            specials = true;
            if (data.contains("]]>")) {
                cdataEnd = true;
            }
        }
        this.displayIndent(this.out, this.indent);
        if (quote || this.alwaysQuoteCData) {
            this.out.print("<![CDATA[");
            this.out.print(data);
            this.out.println("]]>");
        } else if (!specials) {
            this.out.print(data);
        } else {
            XmlOutput.stringEncodeXML(data, this.out);
        }
        this.out.flush();
        ++this.tagsWritten;
    }

    public void stringTag(String name, String data) {
        this.beginTag(name, null);
        this.cdata(data);
        this.endTag(name);
    }

    public void content(String content) {
        if (content != null) {
            ++this.indent;
            char[] chars = content.toCharArray();
            int prev = 0;
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] != '\n' && (chars[i] != '\r' || i + 1 >= chars.length || chars[i + 1] != '\n')) continue;
                this.displayIndent(this.out, this.indent);
                this.out.println(content.substring(prev, i));
                if (chars[i] == '\r') {
                    ++i;
                }
                prev = i + 1;
            }
            this.displayIndent(this.out, this.indent);
            this.out.println(content.substring(prev, chars.length));
            --this.indent;
            this.out.flush();
        }
        ++this.tagsWritten;
    }

    public void header() {
        this.out.println("<?xml version=\"1.0\" ?>");
        this.out.flush();
        ++this.tagsWritten;
    }

    public void header(String version) {
        this.out.print("<?xml version=\"");
        this.out.print(version);
        this.out.println("\" ?>");
        this.out.flush();
        ++this.tagsWritten;
    }

    public int numTagsWritten() {
        return this.tagsWritten;
    }

    private static void printAtt(PrintWriter pw, String name, String val) {
        if (val != null) {
            pw.print(" ");
            pw.print(name);
            pw.print("=\"");
            pw.print(XmlOutput.escapeForQuoting(val));
            pw.print("\"");
        }
    }

    private static void stringEncodeXML(String input, PrintWriter out) {
        block3: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    out.print("&#" + c + ";");
                    continue block3;
                }
                default: {
                    out.print(c);
                }
            }
        }
    }

    private static String escapeForQuoting(String val) {
        return StringEscaper.XML_NUMERIC_ESCAPER.escapeString(val);
    }

    private static boolean stringHasXMLSpecials(String input) {
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    return true;
                }
            }
        }
        return false;
    }

    static class XMLAttrVector {
        XMLAttrVector() {
        }

        public void display(PrintWriter out, int indent) {
            throw new UnsupportedOperationException();
        }
    }

    static class StringEscaper
    implements Cloneable {
        private ArrayList<String> translationVector = new ArrayList();
        private String[] translationTable;
        public static final StringEscaper XML_ESCAPER;
        public static final StringEscaper XML_NUMERIC_ESCAPER;
        public static final StringEscaper HTML_ESCAPER;
        public static final StringEscaper URL_ARG_ESCAPER;
        public static final StringEscaper URL_ESCAPER;

        StringEscaper() {
        }

        public void defineEscape(char from, String to) {
            char i = from;
            if (i >= this.translationVector.size()) {
                int count = i + '\u0001' - this.translationVector.size();
                this.translationVector.addAll(Collections.nCopies(count, null));
            }
            this.translationVector.set(i, to);
        }

        public void makeImmutable() {
            this.translationTable = this.translationVector.toArray(new String[0]);
            this.translationVector = null;
        }

        public String escapeString(String s) {
            StringBuilder sb = null;
            int n = s.length();
            for (int i = 0; i < n; ++i) {
                char c = s.charAt(i);
                String escape = c > '\u007f' ? "&#" + Integer.toString(c) + ";" : (c >= this.translationTable.length ? null : this.translationTable[c]);
                if (escape == null) {
                    if (sb == null) continue;
                    sb.append(c);
                    continue;
                }
                if (sb == null) {
                    sb = new StringBuilder(n * 2);
                    sb.append(s, 0, i);
                }
                sb.append(escape);
            }
            if (sb == null) {
                return s;
            }
            return sb.toString();
        }

        protected StringEscaper clone() {
            StringEscaper clone = new StringEscaper();
            if (this.translationVector != null) {
                clone.translationVector = new ArrayList<String>(this.translationVector);
            }
            if (this.translationTable != null) {
                clone.translationTable = (String[])this.translationTable.clone();
            }
            return clone;
        }

        public StringEscaper getMutableClone() {
            StringEscaper clone = this.clone();
            if (clone.translationVector == null) {
                clone.translationVector = Lists.newArrayList(clone.translationTable);
                clone.translationTable = null;
            }
            return clone;
        }

        static {
            HTML_ESCAPER = new StringEscaper();
            HTML_ESCAPER.defineEscape('&', "&amp;");
            HTML_ESCAPER.defineEscape('\"', "&quot;");
            HTML_ESCAPER.defineEscape('\'', "&#39;");
            HTML_ESCAPER.defineEscape('<', "&lt;");
            HTML_ESCAPER.defineEscape('>', "&gt;");
            XML_NUMERIC_ESCAPER = new StringEscaper();
            XML_NUMERIC_ESCAPER.defineEscape('&', "&#38;");
            XML_NUMERIC_ESCAPER.defineEscape('\"', "&#34;");
            XML_NUMERIC_ESCAPER.defineEscape('\'', "&#39;");
            XML_NUMERIC_ESCAPER.defineEscape('<', "&#60;");
            XML_NUMERIC_ESCAPER.defineEscape('>', "&#62;");
            URL_ARG_ESCAPER = new StringEscaper();
            URL_ARG_ESCAPER.defineEscape('?', "%3f");
            URL_ARG_ESCAPER.defineEscape('&', "%26");
            URL_ESCAPER = URL_ARG_ESCAPER.getMutableClone();
            URL_ESCAPER.defineEscape('%', "%%");
            URL_ESCAPER.defineEscape('\"', "%22");
            URL_ESCAPER.defineEscape('\r', "+");
            URL_ESCAPER.defineEscape('\n', "+");
            URL_ESCAPER.defineEscape(' ', "+");
            URL_ESCAPER.defineEscape('#', "%23");
            HTML_ESCAPER.makeImmutable();
            XML_ESCAPER = HTML_ESCAPER;
            XML_NUMERIC_ESCAPER.makeImmutable();
            URL_ARG_ESCAPER.makeImmutable();
            URL_ESCAPER.makeImmutable();
        }
    }
}

