/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.ExtendedSqlNode;
import org.apache.flink.sql.parser.error.SqlParseException;

public class SqlCreateView
extends SqlCreate
implements ExtendedSqlNode {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE_VIEW", SqlKind.CREATE_VIEW);
    private final SqlIdentifier viewName;
    private final SqlNodeList fieldList;
    private final SqlNode query;
    private final SqlCharStringLiteral comment;

    public SqlCreateView(SqlParserPos pos, SqlIdentifier viewName, SqlNodeList fieldList, SqlNode query, boolean replace, SqlCharStringLiteral comment) {
        super(OPERATOR, pos, replace, false);
        this.viewName = viewName;
        this.fieldList = fieldList;
        this.query = query;
        this.comment = comment;
    }

    @Override
    public List<SqlNode> getOperandList() {
        ArrayList<SqlNode> ops = new ArrayList<SqlNode>();
        ops.add(this.viewName);
        ops.add(this.fieldList);
        ops.add(this.query);
        ops.add(SqlLiteral.createBoolean(this.getReplace(), SqlParserPos.ZERO));
        return ops;
    }

    public SqlIdentifier getViewName() {
        return this.viewName;
    }

    public SqlNodeList getFieldList() {
        return this.fieldList;
    }

    public SqlNode getQuery() {
        return this.query;
    }

    public SqlCharStringLiteral getComment() {
        return this.comment;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        if (this.getReplace()) {
            writer.keyword("OR REPLACE");
        }
        writer.keyword("VIEW");
        this.viewName.unparse(writer, leftPrec, rightPrec);
        if (this.fieldList.size() > 0) {
            this.fieldList.unparse(writer, 1, rightPrec);
        }
        if (this.comment != null) {
            writer.newlineAndIndent();
            writer.keyword("COMMENT");
            this.comment.unparse(writer, leftPrec, rightPrec);
        }
        writer.newlineAndIndent();
        writer.keyword("AS");
        writer.newlineAndIndent();
        this.query.unparse(writer, leftPrec, rightPrec);
    }

    private void printIndent(SqlWriter writer) {
        writer.sep(",", false);
        writer.newlineAndIndent();
        writer.print("  ");
    }

    @Override
    public void validate() throws SqlParseException {
    }
}

