/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001B\u0001\u0003\u0001=\u0011aCU8x)&lWMQ8v]\u0012,GMU8xg>3XM\u001d\u0006\u0003\u0007\u0011\t\u0011\"Y4he\u0016<\u0017\r^3\u000b\u0005\u00151\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u000f!\tQ\u0001^1cY\u0016T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001+\t\u0001rc\u0005\u0003\u0001#%\u0012\u0004#\u0002\n\u0014+\r\u001aS\"\u0001\u0002\n\u0005Q\u0011!a\b)s_\u000e,7o\u001d$v]\u000e$\u0018n\u001c8XSRD7\t\\3b]V\u00048\u000b^1uKB\u0011ac\u0006\u0007\u0001\t\u0015A\u0002A1\u0001\u001a\u0005\u0005Y\u0015C\u0001\u000e!!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aG\u0011\n\u0005\tb\"aA!osB\u0011AeJ\u0007\u0002K)\u0011a\u0005B\u0001\u0006if\u0004Xm]\u0005\u0003Q\u0015\u0012Aa\u0011*poB\u0019!&L\u0018\u000e\u0003-R!\u0001\f\u0004\u0002\u000f\r|G-Z4f]&\u0011af\u000b\u0002\t\u0007>l\u0007/\u001b7feB\u0011!\u0003M\u0005\u0003c\t\u0011QcR3oKJ\fG/\u001a3BO\u001e\u0014XmZ1uS>t7\u000f\u0005\u00024m5\tAG\u0003\u00026\r\u0005!Q\u000f^5m\u0013\t9DGA\u0004M_\u001e<\u0017N\\4\t\u0011e\u0002!\u0011!Q\u0001\ni\nqbZ3o\u0003\u001e<'/Z4bi&|gn\u001d\t\u0003UmJ!\u0001P\u0016\u0003;\u001d+g.\u001a:bi\u0016$\u0017iZ4sK\u001e\fG/[8og\u001a+hn\u0019;j_:D\u0001B\u0010\u0001\u0003\u0002\u0003\u0006IaP\u0001\u0015C\u001e<'/Z4bi&|gn\u0015;bi\u0016$\u0016\u0010]3\u0011\u0005\u0001;U\"A!\u000b\u0005\t\u001b\u0015!\u0003;za\u0016,H/\u001b7t\u0015\t!U)\u0001\u0003kCZ\f'B\u0001$\t\u0003\r\t\u0007/[\u0005\u0003\u0011\u0006\u00131BU8x)f\u0004X-\u00138g_\"A!\n\u0001B\u0001B\u0003%1*\u0001\u0007j]B,HOU8x)f\u0004X\r\u0005\u0002%\u0019&\u0011Q*\n\u0002\r\u0007J{w\u000fV=qK&sgm\u001c\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\u0006y\u0001O]3dK\u0012LgnZ(gMN,G\u000f\u0005\u0002\u001c#&\u0011!\u000b\b\u0002\u0005\u0019>tw\r\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003V\u0003)\u0011xn\u001e+j[\u0016LE\r\u001f\t\u00037YK!a\u0016\u000f\u0003\u0007%sG\u000f\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003[\u0003-\tX/\u001a:z\u0007>tg-[4\u0011\u0005mkV\"\u0001/\u000b\u0005\u00193\u0011B\u00010]\u0005E\u0019FO]3b[F+XM]=D_:4\u0017n\u001a\u0005\u0006A\u0002!\t!Y\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f\t\u001cG-\u001a4hQB\u0019!\u0003A\u000b\t\u000bez\u0006\u0019\u0001\u001e\t\u000byz\u0006\u0019A \t\u000b){\u0006\u0019A&\t\u000b={\u0006\u0019\u0001)\t\u000bQ{\u0006\u0019A+\t\u000be{\u0006\u0019\u0001.\t\u0013)\u0004\u0001\u0019!a\u0001\n\u0013Y\u0017AB8viB,H/F\u0001$\u0011%i\u0007\u00011AA\u0002\u0013%a.\u0001\u0006pkR\u0004X\u000f^0%KF$\"a\u001c:\u0011\u0005m\u0001\u0018BA9\u001d\u0005\u0011)f.\u001b;\t\u000fMd\u0017\u0011!a\u0001G\u0005\u0019\u0001\u0010J\u0019\t\rU\u0004\u0001\u0015)\u0003$\u0003\u001dyW\u000f\u001e9vi\u0002B\u0011b\u001e\u0001A\u0002\u0003\u0007I\u0011\u0002=\u0002+1\f7\u000f\u001e+sS\u001e<WM]5oOR\u001b8\u000b^1uKV\t\u0011\u0010E\u0002{\u007fBk\u0011a\u001f\u0006\u0003yv\fQa\u001d;bi\u0016T!A`#\u0002\r\r|W.\\8o\u0013\r\t\ta\u001f\u0002\u000b-\u0006dW/Z*uCR,\u0007bCA\u0003\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000f\t\u0011\u0004\\1tiR\u0013\u0018nZ4fe&tw\rV:Ti\u0006$Xm\u0018\u0013fcR\u0019q.!\u0003\t\u0011M\f\u0019!!AA\u0002eDq!!\u0004\u0001A\u0003&\u00110\u0001\fmCN$HK]5hO\u0016\u0014\u0018N\\4UgN#\u0018\r^3!\u0011)\t\t\u0002\u0001a\u0001\u0002\u0004%I\u0001_\u0001\u000fI\u0006$\u0018mQ8v]R\u001cF/\u0019;f\u0011-\t)\u0002\u0001a\u0001\u0002\u0004%I!a\u0006\u0002%\u0011\fG/Y\"pk:$8\u000b^1uK~#S-\u001d\u000b\u0004_\u0006e\u0001\u0002C:\u0002\u0014\u0005\u0005\t\u0019A=\t\u000f\u0005u\u0001\u0001)Q\u0005s\u0006yA-\u0019;b\u0007>,h\u000e^*uCR,\u0007\u0005C\u0006\u0002\"\u0001\u0001\r\u00111A\u0005\n\u0005\r\u0012\u0001E1dGVlW\u000f\\1u_J\u001cF/\u0019;f+\t\t)\u0003\u0005\u0003{\u007f\u0006\u001d\u0002\u0003BA\u0015\u0003[i!!a\u000b\u000b\u0005\u0019B\u0011\u0002BA\u0018\u0003W\u00111AU8x\u0011-\t\u0019\u0004\u0001a\u0001\u0002\u0004%I!!\u000e\u0002)\u0005\u001c7-^7vY\u0006$xN]*uCR,w\fJ3r)\ry\u0017q\u0007\u0005\ng\u0006E\u0012\u0011!a\u0001\u0003KA\u0001\"a\u000f\u0001A\u0003&\u0011QE\u0001\u0012C\u000e\u001cW/\\;mCR|'o\u0015;bi\u0016\u0004\u0003bCA \u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0003\n\u0011\u0002Z1uCN#\u0018\r^3\u0016\u0005\u0005\r\u0003C\u0002>\u0002FA\u000bI%C\u0002\u0002Hm\u0014\u0001\"T1q'R\fG/\u001a\t\u0007\u0003\u0017\n\t&a\n\u000e\u0005\u00055#bA\u001b\u0002P)\tA)\u0003\u0003\u0002T\u00055#\u0001\u0002'jgRD1\"a\u0016\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002Z\u0005iA-\u0019;b'R\fG/Z0%KF$2a\\A.\u0011%\u0019\u0018QKA\u0001\u0002\u0004\t\u0019\u0005\u0003\u0005\u0002`\u0001\u0001\u000b\u0015BA\"\u0003)!\u0017\r^1Ti\u0006$X\r\t\u0005\f\u0003G\u0002\u0001\u0019!a\u0001\n\u0013\t)'\u0001\u0005gk:\u001cG/[8o+\u0005y\u0003bCA5\u0001\u0001\u0007\t\u0019!C\u0005\u0003W\nABZ;oGRLwN\\0%KF$2a\\A7\u0011!\u0019\u0018qMA\u0001\u0002\u0004y\u0003bBA9\u0001\u0001\u0006KaL\u0001\nMVt7\r^5p]\u0002Bq!!\u001e\u0001\t\u0003\n9(\u0001\u0003pa\u0016tGcA8\u0002z!A\u00111PA:\u0001\u0004\ti(\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0003\u007f\n))\u0004\u0002\u0002\u0002*\u0019\u00111\u0011\u0005\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0013\u0011\t9)!!\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u001d\tY\t\u0001C!\u0003\u001b\u000ba\u0002\u001d:pG\u0016\u001c8/\u00127f[\u0016tG\u000fF\u0004p\u0003\u001f\u000b\u0019*a,\t\u000f\u0005E\u0015\u0011\u0012a\u0001G\u00051\u0011N\u001c9vi\u000eC\u0001\"!&\u0002\n\u0002\u0007\u0011qS\u0001\u0004GRD\b\u0003BAM\u0003W\u0003r!a'\u0002(V\u00193%\u0004\u0002\u0002\u001e*!\u0011qTAQ\u0003%1WO\\2uS>t7OC\u0002G\u0003GS1!!*\t\u0003%\u0019HO]3b[&tw-\u0003\u0003\u0002*\u0006u%\u0001F&fs\u0016$\u0007K]8dKN\u001ch)\u001e8di&|g.\u0003\u0003\u0002.\u0006\u001d&aB\"p]R,\u0007\u0010\u001e\u0005\t\u0003c\u000bI\t1\u0001\u00024\u0006\u0019q.\u001e;\u0011\u000b\u0005U\u0016\u0011X\u0012\u000e\u0005\u0005]&BA\u001b\t\u0013\u0011\tY,a.\u0003\u0013\r{G\u000e\\3di>\u0014\bbBA`\u0001\u0011\u0005\u0013\u0011Y\u0001\b_:$\u0016.\\3s)\u001dy\u00171YAd\u0003\u001fDq!!2\u0002>\u0002\u0007\u0001+A\u0005uS6,7\u000f^1na\"A\u0011QSA_\u0001\u0004\tI\r\u0005\u0003\u0002\u001a\u0006-\u0017\u0002BAg\u0003O\u0013ab\u00148US6,'oQ8oi\u0016DH\u000f\u0003\u0005\u00022\u0006u\u0006\u0019AAZ\u0011\u001d\t\u0019\u000e\u0001C!\u0003+\fQa\u00197pg\u0016$\u0012a\u001c")
public class RowTimeBoundedRowsOver<K>
extends ProcessFunctionWithCleanupState<K, CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final RowTypeInfo aggregationStateType;
    private final CRowTypeInfo inputRowType;
    private final long precedingOffset;
    private final int rowTimeIdx;
    private CRow output;
    private ValueState<Object> lastTriggeringTsState;
    private ValueState<Object> dataCountState;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> dataState;
    private GeneratedAggregations function;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        RowTimeBoundedRowsOver rowTimeBoundedRowsOver = this;
        synchronized (rowTimeBoundedRowsOver) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private CRow output() {
        return this.output;
    }

    private void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Object> lastTriggeringTsState() {
        return this.lastTriggeringTsState;
    }

    private void lastTriggeringTsState_$eq(ValueState<Object> x$1) {
        this.lastTriggeringTsState = x$1;
    }

    private ValueState<Object> dataCountState() {
        return this.dataCountState;
    }

    private void dataCountState_$eq(ValueState<Object> x$1) {
        this.dataCountState = x$1;
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> dataState() {
        return this.dataState;
    }

    private void dataState_$eq(MapState<Object, List<Row>> x$1) {
        this.dataState = x$1;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", " \\n\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.code()}))).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        ValueStateDescriptor lastTriggeringTsDescriptor = new ValueStateDescriptor("lastTriggeringTsState", Long.TYPE);
        this.lastTriggeringTsState_$eq((ValueState<Object>)this.getRuntimeContext().getState(lastTriggeringTsDescriptor));
        ValueStateDescriptor dataCountStateDescriptor = new ValueStateDescriptor("dataCountState", Long.TYPE);
        this.dataCountState_$eq((ValueState<Object>)this.getRuntimeContext().getState(dataCountStateDescriptor));
        ValueStateDescriptor accumulatorStateDescriptor = new ValueStateDescriptor("accumulatorState", (TypeInformation)this.aggregationStateType);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(accumulatorStateDescriptor));
        BasicTypeInfo keyTypeInformation = BasicTypeInfo.LONG_TYPE_INFO;
        ListTypeInfo valueTypeInformation = new ListTypeInfo((TypeInformation)this.inputRowType.rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("dataState", (TypeInformation)keyTypeInformation, (TypeInformation)valueTypeInformation);
        this.dataState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        this.initCleanupTimeState("RowTimeBoundedRowsOverCleanupTime");
    }

    public void processElement(CRow inputC, KeyedProcessFunction.Context ctx, Collector<CRow> out) {
        Row input = inputC.row();
        this.processCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
        long triggeringTs = BoxesRunTime.unboxToLong((Object)input.getField(this.rowTimeIdx));
        long lastTriggeringTs = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
        if (triggeringTs > lastTriggeringTs) {
            List data = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)triggeringTs));
            if (data == null) {
                ArrayList<Row> data2 = new ArrayList<Row>();
                data2.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)triggeringTs), data2);
                ctx.timerService().registerEventTimeTimer(triggeringTs);
            } else {
                data.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)triggeringTs), (Object)data);
            }
        }
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.isProcessingTimeTimer(ctx)) {
            if (this.stateCleaningEnabled()) {
                Iterator keysIt = this.dataState().keys().iterator();
                long lastProcessedTime = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
                boolean noRecordsToProcess = true;
                while (keysIt.hasNext() && noRecordsToProcess) {
                    if (BoxesRunTime.unboxToLong(keysIt.next()) <= lastProcessedTime) continue;
                    noRecordsToProcess = false;
                }
                if (noRecordsToProcess) {
                    this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.dataState(), this.accumulatorState(), this.dataCountState(), this.lastTriggeringTsState()}));
                    this.function().cleanup();
                } else {
                    this.processCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
                }
            }
            return;
        }
        ((TimestampedCollector)out).eraseTimestamp();
        List inputs = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)timestamp));
        if (inputs != null) {
            Row accumulators = (Row)this.accumulatorState().value();
            long dataCount = BoxesRunTime.unboxToLong((Object)this.dataCountState().value());
            List retractList = null;
            long retractTs = Long.MAX_VALUE;
            int retractCnt = 0;
            for (int i = 0; i < inputs.size(); ++i) {
                Row input = (Row)inputs.get(i);
                if (accumulators == null) {
                    accumulators = this.function().createAccumulators();
                }
                Row retractRow = null;
                if (dataCount >= this.precedingOffset) {
                    if (retractList == null) {
                        retractTs = Long.MAX_VALUE;
                        Iterator dataTimestampIt = this.dataState().keys().iterator();
                        while (dataTimestampIt.hasNext()) {
                            long dataTs = BoxesRunTime.unboxToLong(dataTimestampIt.next());
                            if (dataTs >= retractTs) continue;
                            retractTs = dataTs;
                        }
                        retractList = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)retractTs));
                    }
                    retractRow = (Row)retractList.get(retractCnt);
                    if (retractList.size() == ++retractCnt) {
                        this.dataState().remove((Object)BoxesRunTime.boxToLong((long)retractTs));
                        retractList = null;
                        retractCnt = 0;
                    }
                } else {
                    ++dataCount;
                }
                this.function().setForwardedFields(input, this.output().row());
                if (retractRow != null) {
                    this.function().retract(accumulators, retractRow);
                }
                this.function().accumulate(accumulators, input);
                this.function().setAggregationResults(accumulators, this.output().row());
                out.collect((Object)this.output());
            }
            if (this.dataState().contains((Object)BoxesRunTime.boxToLong((long)retractTs)) && retractCnt > 0) {
                retractList.subList(0, retractCnt).clear();
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)retractTs), (Object)retractList);
            }
            this.dataCountState().update((Object)BoxesRunTime.boxToLong((long)dataCount));
            this.accumulatorState().update((Object)accumulators);
        }
        this.lastTriggeringTsState().update((Object)BoxesRunTime.boxToLong((long)timestamp));
        this.processCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
    }

    public void close() {
        this.function().close();
    }

    public RowTimeBoundedRowsOver(GeneratedAggregationsFunction genAggregations, RowTypeInfo aggregationStateType, CRowTypeInfo inputRowType, long precedingOffset, int rowTimeIdx, StreamQueryConfig queryConfig) {
        this.genAggregations = genAggregations;
        this.aggregationStateType = aggregationStateType;
        this.inputRowType = inputRowType;
        this.precedingOffset = precedingOffset;
        this.rowTimeIdx = rowTimeIdx;
        super(queryConfig);
        Compiler$class.$init$(this);
        Logging$class.$init$(this);
        Preconditions.checkNotNull((Object)aggregationStateType);
        Preconditions.checkNotNull((Object)BoxesRunTime.boxToLong((long)precedingOffset));
    }
}

