/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eg!B\u0001\u0003\u0003\u0003y!\u0001\u0006*poRKW.Z+oE>,h\u000eZ3e\u001fZ,'O\u0003\u0002\u0004\t\u0005I\u0011mZ4sK\u001e\fG/\u001a\u0006\u0003\u000b\u0019\tqA];oi&lWM\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005A92\u0003\u0002\u0001\u0012SI\u0002RAE\n\u0016G\rj\u0011AA\u0005\u0003)\t\u0011q\u0004\u0015:pG\u0016\u001c8OR;oGRLwN\\,ji\"\u001cE.Z1okB\u001cF/\u0019;f!\t1r\u0003\u0004\u0001\u0005\u000ba\u0001!\u0019A\r\u0003\u0003-\u000b\"A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u000f9{G\u000f[5oOB\u00111$I\u0005\u0003Eq\u00111!\u00118z!\t!s%D\u0001&\u0015\t1C!A\u0003usB,7/\u0003\u0002)K\t!1IU8x!\rQSfL\u0007\u0002W)\u0011AFB\u0001\bG>$WmZ3o\u0013\tq3F\u0001\u0005D_6\u0004\u0018\u000e\\3s!\t\u0011\u0002'\u0003\u00022\u0005\t)r)\u001a8fe\u0006$X\rZ!hOJ,w-\u0019;j_:\u001c\bCA\u001a7\u001b\u0005!$BA\u001b\u0007\u0003\u0011)H/\u001b7\n\u0005]\"$a\u0002'pO\u001eLgn\u001a\u0005\ts\u0001\u0011\t\u0011)A\u0005u\u0005yq-\u001a8BO\u001e\u0014XmZ1uS>t7\u000f\u0005\u0002+w%\u0011Ah\u000b\u0002\u001e\u000f\u0016tWM]1uK\u0012\fum\u001a:fO\u0006$\u0018n\u001c8t\rVt7\r^5p]\"Aa\b\u0001B\u0001B\u0003%q(\u0001\tj]R,'/\\3eS\u0006$X\rV=qKB\u0019\u0001iR%\u000e\u0003\u0005S!AQ\"\u0002\u0011QL\b/Z5oM>T!\u0001R#\u0002\r\r|W.\\8o\u0015\t1\u0005\"A\u0002ba&L!\u0001S!\u0003\u001fQK\b/Z%oM>\u0014X.\u0019;j_:\u0004\"A\u0013'\u000e\u0003-S!A\n\u0005\n\u00055[%a\u0001*po\"Aq\n\u0001B\u0001B\u0003%\u0001+A\u0005j]B,H\u000fV=qKB\u0019\u0001iR\u0012\t\u0011I\u0003!\u0011!Q\u0001\nM\u000b!B]8x)&lW-\u00133y!\tYB+\u0003\u0002V9\t\u0019\u0011J\u001c;\t\u0011]\u0003!\u0011!Q\u0001\na\u000b1\"];fef\u001cuN\u001c4jOB\u0011\u0011lW\u0007\u00025*\u0011aIB\u0005\u00039j\u0013\u0011c\u0015;sK\u0006l\u0017+^3ss\u000e{gNZ5h\u0011\u0015q\u0006\u0001\"\u0001`\u0003\u0019a\u0014N\\5u}Q1\u0001-\u00192dI\u0016\u00042A\u0005\u0001\u0016\u0011\u0015IT\f1\u0001;\u0011\u0015qT\f1\u0001@\u0011\u0015yU\f1\u0001Q\u0011\u0015\u0011V\f1\u0001T\u0011\u00159V\f1\u0001Y\u0011%9\u0007\u00011AA\u0002\u0013E\u0001.\u0001\u0004pkR\u0004X\u000f^\u000b\u0002G!I!\u000e\u0001a\u0001\u0002\u0004%\tb[\u0001\u000b_V$\b/\u001e;`I\u0015\fHC\u00017p!\tYR.\u0003\u0002o9\t!QK\\5u\u0011\u001d\u0001\u0018.!AA\u0002\r\n1\u0001\u001f\u00132\u0011\u0019\u0011\b\u0001)Q\u0005G\u00059q.\u001e;qkR\u0004\u0003\"\u0003;\u0001\u0001\u0004\u0005\r\u0011\"\u0003v\u0003A\t7mY;nk2\fGo\u001c:Ti\u0006$X-F\u0001w!\r9(0S\u0007\u0002q*\u0011\u0011pQ\u0001\u0006gR\fG/Z\u0005\u0003wb\u0014!BV1mk\u0016\u001cF/\u0019;f\u0011%i\b\u00011AA\u0002\u0013%a0\u0001\u000bbG\u000e,X.\u001e7bi>\u00148\u000b^1uK~#S-\u001d\u000b\u0003Y~Dq\u0001\u001d?\u0002\u0002\u0003\u0007a\u000fC\u0004\u0002\u0004\u0001\u0001\u000b\u0015\u0002<\u0002#\u0005\u001c7-^7vY\u0006$xN]*uCR,\u0007\u0005C\u0006\u0002\b\u0001\u0001\r\u00111A\u0005\n\u0005%\u0011a\u0003:po6\u000b\u0007o\u0015;bi\u0016,\"!a\u0003\u0011\u000f]\fi!!\u0005\u0002\u0018%\u0019\u0011q\u0002=\u0003\u00115\u000b\u0007o\u0015;bi\u0016\u00042aGA\n\u0013\r\t)\u0002\b\u0002\u0005\u0019>tw\rE\u0003\u0002\u001a\u0005\u0005\u0012*\u0004\u0002\u0002\u001c)\u0019Q'!\b\u000b\u0005\u0005}\u0011\u0001\u00026bm\u0006LA!a\t\u0002\u001c\t!A*[:u\u0011-\t9\u0003\u0001a\u0001\u0002\u0004%I!!\u000b\u0002\u001fI|w/T1q'R\fG/Z0%KF$2\u0001\\A\u0016\u0011%\u0001\u0018QEA\u0001\u0002\u0004\tY\u0001\u0003\u0005\u00020\u0001\u0001\u000b\u0015BA\u0006\u00031\u0011xn^'baN#\u0018\r^3!\u0011-\t\u0019\u0004\u0001a\u0001\u0002\u0004%I!!\u000e\u0002!M|'\u000f^3e)&lWm\u001d;b[B\u001cXCAA\u001c!\u0019\tI\"!\u000f\u0002\u0012%!\u00111HA\u000e\u0005)a\u0015N\\6fI2K7\u000f\u001e\u0005\f\u0003\u007f\u0001\u0001\u0019!a\u0001\n\u0013\t\t%\u0001\u000bt_J$X\r\u001a+j[\u0016\u001cH/Y7qg~#S-\u001d\u000b\u0004Y\u0006\r\u0003\"\u00039\u0002>\u0005\u0005\t\u0019AA\u001c\u0011!\t9\u0005\u0001Q!\n\u0005]\u0012!E:peR,G\rV5nKN$\u0018-\u001c9tA!Y\u00111\n\u0001A\u0002\u0003\u0007I\u0011CA'\u0003!1WO\\2uS>tW#A\u0018\t\u0017\u0005E\u0003\u00011AA\u0002\u0013E\u00111K\u0001\rMVt7\r^5p]~#S-\u001d\u000b\u0004Y\u0006U\u0003\u0002\u00039\u0002P\u0005\u0005\t\u0019A\u0018\t\u000f\u0005e\u0003\u0001)Q\u0005_\u0005Ia-\u001e8di&|g\u000e\t\u0005\b\u0003;\u0002A\u0011IA0\u0003\u0011y\u0007/\u001a8\u0015\u00071\f\t\u0007\u0003\u0005\u0002d\u0005m\u0003\u0019AA3\u0003\u0019\u0019wN\u001c4jOB!\u0011qMA7\u001b\t\tIGC\u0002\u0002l!\tQbY8oM&<WO]1uS>t\u0017\u0002BA8\u0003S\u0012QbQ8oM&<WO]1uS>t\u0007bBA:\u0001\u0011\u0005\u0013QO\u0001\u000faJ|7-Z:t\u000b2,W.\u001a8u)\u001da\u0017qOA>\u0003/Cq!!\u001f\u0002r\u0001\u00071%\u0001\u0004j]B,Ho\u0011\u0005\t\u0003{\n\t\b1\u0001\u0002\u0000\u0005\u00191\r\u001e=\u0011\t\u0005\u0005\u00151\u0013\t\b\u0003\u0007\u000by)F\u0012$\u001b\t\t)I\u0003\u0003\u0002\b\u0006%\u0015!\u00034v]\u000e$\u0018n\u001c8t\u0015\r1\u00151\u0012\u0006\u0004\u0003\u001bC\u0011!C:ue\u0016\fW.\u001b8h\u0013\u0011\t\t*!\"\u0003)-+\u00170\u001a3Qe>\u001cWm]:Gk:\u001cG/[8o\u0013\u0011\t)*a$\u0003\u000f\r{g\u000e^3yi\"A\u0011\u0011TA9\u0001\u0004\tY*A\u0002pkR\u0004R!!(\u0002\"\u000ej!!a(\u000b\u0005UB\u0011\u0002BAR\u0003?\u0013\u0011bQ8mY\u0016\u001cGo\u001c:\t\u000f\u0005\u001d\u0006\u0001\"\u0011\u0002*\u00069qN\u001c+j[\u0016\u0014Hc\u00027\u0002,\u0006=\u0016q\u0017\u0005\t\u0003[\u000b)\u000b1\u0001\u0002\u0012\u0005IA/[7fgR\fW\u000e\u001d\u0005\t\u0003{\n)\u000b1\u0001\u00022B!\u0011\u0011QAZ\u0013\u0011\t),a$\u0003\u001d=sG+[7fe\u000e{g\u000e^3yi\"A\u0011\u0011TAS\u0001\u0004\tY\nC\u0004\u0002<\u0002!I!!0\u0002%%t7/\u001a:u)>\u001cvN\u001d;fI2K7\u000f\u001e\u000b\u0004Y\u0006}\u0006\u0002CAa\u0003s\u0003\r!!\u0005\u0002\u001fI,7m\u001c:e)&lWm\u001d;b[BDq!!2\u0001\r\u0003\t9-\u0001\u0011qe>\u001cWm]:FY\u0016lWM\u001c;t/&$\bnU1nKRKW.Z:uC6\u0004Hc\u00027\u0002J\u00065\u0017\u0011\u001b\u0005\t\u0003\u0017\f\u0019\r1\u0001\u0002\u0018\u0005Q1-\u001e:S_^d\u0015n\u001d;\t\u000f\u0005=\u00171\u0019a\u0001\u0013\u0006yA.Y:u\u0003\u000e\u001cW/\\;mCR|'\u000f\u0003\u0005\u0002\u001a\u0006\r\u0007\u0019AAN\u0011\u001d\t)\u000e\u0001C!\u0003/\fQa\u00197pg\u0016$\u0012\u0001\u001c")
public abstract class RowTimeUnboundedOver<K>
extends ProcessFunctionWithCleanupState<K, CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final TypeInformation<Row> intermediateType;
    private final TypeInformation<CRow> inputType;
    private final int rowTimeIdx;
    private CRow output;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> rowMapState;
    private LinkedList<Object> sortedTimestamps;
    private GeneratedAggregations function;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        RowTimeUnboundedOver rowTimeUnboundedOver = this;
        synchronized (rowTimeUnboundedOver) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    public CRow output() {
        return this.output;
    }

    public void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> rowMapState() {
        return this.rowMapState;
    }

    private void rowMapState_$eq(MapState<Object, List<Row>> x$1) {
        this.rowMapState = x$1;
    }

    private LinkedList<Object> sortedTimestamps() {
        return this.sortedTimestamps;
    }

    private void sortedTimestamps_$eq(LinkedList<Object> x$1) {
        this.sortedTimestamps = x$1;
    }

    public GeneratedAggregations function() {
        return this.function;
    }

    public void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", " \\n\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.code()}))).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        this.sortedTimestamps_$eq(new LinkedList<Object>());
        ValueStateDescriptor accDescriptor = new ValueStateDescriptor("accumulatorstate", this.intermediateType);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(accDescriptor));
        ListTypeInfo rowListTypeInfo = new ListTypeInfo((TypeInformation)((CRowTypeInfo)this.inputType).rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("rowmapstate", (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, (TypeInformation)rowListTypeInfo);
        this.rowMapState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        this.initCleanupTimeState("RowTimeUnboundedOverCleanupTime");
    }

    public void processElement(CRow inputC, KeyedProcessFunction.Context ctx, Collector<CRow> out) {
        Row input = inputC.row();
        this.processCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
        long timestamp = BoxesRunTime.unboxToLong((Object)input.getField(this.rowTimeIdx));
        long curWatermark = ctx.timerService().currentWatermark();
        if (timestamp > curWatermark) {
            ctx.timerService().registerEventTimeTimer(curWatermark + 1L);
            ArrayList<Row> rowList = (ArrayList<Row>)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)timestamp));
            if (rowList == null) {
                rowList = new ArrayList<Row>();
            }
            rowList.add(input);
            this.rowMapState().put((Object)BoxesRunTime.boxToLong((long)timestamp), rowList);
        }
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.isProcessingTimeTimer(ctx)) {
            if (this.stateCleaningEnabled()) {
                boolean noRecordsToProcess;
                boolean bl = noRecordsToProcess = !this.rowMapState().keys().iterator().hasNext();
                if (noRecordsToProcess) {
                    this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.rowMapState(), this.accumulatorState()}));
                    this.function().cleanup();
                } else {
                    this.processCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
                }
            }
            return;
        }
        ((TimestampedCollector)out).eraseTimestamp();
        Iterator keyIterator = this.rowMapState().keys().iterator();
        if (keyIterator.hasNext()) {
            long curWatermark = ctx.timerService().currentWatermark();
            boolean existEarlyRecord = false;
            do {
                long recordTime;
                if ((recordTime = BoxesRunTime.unboxToLong(keyIterator.next())) <= curWatermark) {
                    this.insertToSortedList(recordTime);
                    continue;
                }
                existEarlyRecord = true;
            } while (keyIterator.hasNext());
            Row lastAccumulator = (Row)this.accumulatorState().value();
            if (lastAccumulator == null) {
                lastAccumulator = this.function().createAccumulators();
            }
            while (true) {
                if (this.sortedTimestamps().isEmpty()) {
                    this.accumulatorState().update((Object)lastAccumulator);
                    if (!existEarlyRecord) break;
                    ctx.timerService().registerEventTimeTimer(curWatermark + 1L);
                    break;
                }
                long curTimestamp = BoxesRunTime.unboxToLong((Object)this.sortedTimestamps().removeFirst());
                List curRowList = (List)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)curTimestamp));
                this.processElementsWithSameTimestamp(curRowList, lastAccumulator, out);
                this.rowMapState().remove((Object)BoxesRunTime.boxToLong((long)curTimestamp));
            }
        }
        this.processCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
    }

    private void insertToSortedList(long recordTimestamp) {
        ListIterator<Object> listIterator = this.sortedTimestamps().listIterator(this.sortedTimestamps().size());
        boolean bl = true;
        while (listIterator.hasPrevious() && bl) {
            long timestamp = BoxesRunTime.unboxToLong((Object)listIterator.previous());
            if (recordTimestamp < timestamp) continue;
            listIterator.next();
            listIterator.add(BoxesRunTime.boxToLong((long)recordTimestamp));
            bl = false;
        }
        if (bl) {
            this.sortedTimestamps().addFirst(BoxesRunTime.boxToLong((long)recordTimestamp));
        }
    }

    public abstract void processElementsWithSameTimestamp(List<Row> var1, Row var2, Collector<CRow> var3);

    public void close() {
        this.function().close();
    }

    public RowTimeUnboundedOver(GeneratedAggregationsFunction genAggregations, TypeInformation<Row> intermediateType, TypeInformation<CRow> inputType, int rowTimeIdx, StreamQueryConfig queryConfig) {
        this.genAggregations = genAggregations;
        this.intermediateType = intermediateType;
        this.inputType = inputType;
        this.rowTimeIdx = rowTimeIdx;
        super(queryConfig);
        Compiler$class.$init$(this);
        Logging$class.$init$(this);
    }
}

