/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.calcite.FlinkRelBuilder;
import org.apache.flink.table.calcite.FlinkTypeFactory;
import org.apache.flink.table.catalog.QueryOperationCatalogView;
import org.apache.flink.table.plan.stats.FlinkStatistic;

@Internal
public class QueryOperationCatalogViewTable
extends AbstractTable
implements TranslatableTable {
    private final QueryOperationCatalogView catalogView;
    private final RelProtoDataType rowType;

    @Override
    public Statistic getStatistic() {
        return FlinkStatistic.UNKNOWN();
    }

    public static QueryOperationCatalogViewTable createCalciteTable(QueryOperationCatalogView catalogView, TableSchema resolvedSchema) {
        return new QueryOperationCatalogViewTable(catalogView, typeFactory -> {
            FlinkTypeFactory flinkTypeFactory = (FlinkTypeFactory)typeFactory;
            RelDataType relType = flinkTypeFactory.buildLogicalRowType(resolvedSchema);
            Boolean[] nullables = (Boolean[])resolvedSchema.getTableColumns().stream().map(c -> c.getType().getLogicalType().isNullable()).toArray(Boolean[]::new);
            List fields = relType.getFieldList().stream().map(f -> {
                boolean nullable = nullables[f.getIndex()];
                if (nullable != f.getType().isNullable() && !FlinkTypeFactory.isTimeIndicatorType(f.getType())) {
                    return new RelDataTypeFieldImpl(f.getName(), f.getIndex(), flinkTypeFactory.createTypeWithNullability(f.getType(), nullable));
                }
                return f;
            }).collect(Collectors.toList());
            return flinkTypeFactory.createStructType(fields);
        });
    }

    private QueryOperationCatalogViewTable(QueryOperationCatalogView catalogView, RelProtoDataType rowType) {
        this.catalogView = catalogView;
        this.rowType = rowType;
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        FlinkRelBuilder relBuilder = FlinkRelBuilder.of(context.getCluster(), relOptTable.getRelOptSchema());
        RelNode relNode = relBuilder.tableOperation(this.catalogView.getQueryOperation()).build();
        return RelOptUtil.createCastRel(relNode, (RelDataType)this.rowType.apply(relBuilder.getTypeFactory()), false);
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return (RelDataType)this.rowType.apply(typeFactory);
    }
}

