/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.datastream;

import java.io.Serializable;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlMatchRecognize;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.cep.nfa.aftermatch.AfterMatchSkipStrategy;
import org.apache.flink.cep.nfa.aftermatch.SkipPastLastStrategy;
import org.apache.flink.cep.nfa.aftermatch.SkipToElementStrategy;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.cep.pattern.conditions.BooleanConditions;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.codegen.MatchCodeGenerator;
import org.apache.flink.table.plan.logical.MatchRecognize;
import org.apache.flink.table.plan.util.RexDefaultVisitor;
import org.apache.flink.table.runtime.match.IterativeConditionRunner;
import org.apache.flink.types.Row;
import org.apache.flink.util.MathUtils;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.LinkedHashSet;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001B\u0001\u0003\tE\u0011a\u0002U1ui\u0016\u0014hNV5tSR|'O\u0003\u0002\u0004\t\u0005QA-\u0019;bgR\u0014X-Y7\u000b\u0005\u00151\u0011!\u00028pI\u0016\u001c(BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011!\u0002;bE2,'BA\u0006\r\u0003\u00151G.\u001b8l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0004'YAR\"\u0001\u000b\u000b\u0005U1\u0011\u0001B;uS2L!a\u0006\u000b\u0003#I+\u0007\u0010R3gCVdGOV5tSR|'\u000f\u0005\u0003\u001a=\u0001\u0002S\"\u0001\u000e\u000b\u0005ma\u0012a\u00029biR,'O\u001c\u0006\u0003;)\t1aY3q\u0013\ty\"DA\u0004QCR$XM\u001d8\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\rR\u0011!\u0002;za\u0016\u001c\u0018BA\u0013#\u0005\r\u0011vn\u001e\u0005\tO\u0001\u0011\t\u0011)A\u0005Q\u000511m\u001c8gS\u001e\u0004\"!\u000b\u0017\u000e\u0003)R!a\u000b\u0005\u0002\u0007\u0005\u0004\u0018.\u0003\u0002.U\tYA+\u00192mK\u000e{gNZ5h\u0011!y\u0003A!A!\u0002\u0013\u0001\u0014!D5oaV$H+\u001f9f\u0013:4w\u000eE\u00022o\u0001j\u0011A\r\u0006\u0003gQ\n\u0001\u0002^=qK&tgm\u001c\u0006\u0003kY\naaY8n[>t'BA\u0016\u000b\u0013\tA$GA\bUsB,\u0017J\u001c4pe6\fG/[8o\u0011!Q\u0004A!A!\u0002\u0013Y\u0014\u0001\u00047pO&\u001c\u0017\r\\'bi\u000eD\u0007C\u0001\u001f@\u001b\u0005i$B\u0001 \u0007\u0003\u001dawnZ5dC2L!\u0001Q\u001f\u0003\u001d5\u000bGo\u00195SK\u000e|wM\\5{K\")!\t\u0001C\u0001\u0007\u00061A(\u001b8jiz\"B\u0001\u0012$H\u0011B\u0011Q\tA\u0007\u0002\u0005!)q%\u0011a\u0001Q!)q&\u0011a\u0001a!)!(\u0011a\u0001w!I1\u0004\u0001a\u0001\u0002\u0004%IAS\u000b\u00021!IA\n\u0001a\u0001\u0002\u0004%I!T\u0001\fa\u0006$H/\u001a:o?\u0012*\u0017\u000f\u0006\u0002O)B\u0011qJU\u0007\u0002!*\t\u0011+A\u0003tG\u0006d\u0017-\u0003\u0002T!\n!QK\\5u\u0011\u001d)6*!AA\u0002a\t1\u0001\u001f\u00132\u0011%9\u0006\u00011A\u0001B\u0003&\u0001$\u0001\u0005qCR$XM\u001d8!\u0011\u001dI\u0006A1A\u0005\u0002i\u000bQA\\1nKN,\u0012a\u0017\t\u00049\u0006\u001cW\"A/\u000b\u0005y{\u0016aB7vi\u0006\u0014G.\u001a\u0006\u0003AB\u000b!bY8mY\u0016\u001cG/[8o\u0013\t\u0011WLA\u0007MS:\\W\r\u001a%bg\"\u001cV\r\u001e\t\u0003I.t!!Z5\u0011\u0005\u0019\u0004V\"A4\u000b\u0005!\u0004\u0012A\u0002\u001fs_>$h(\u0003\u0002k!\u00061\u0001K]3eK\u001aL!\u0001\\7\u0003\rM#(/\u001b8h\u0015\tQ\u0007\u000b\u0003\u0004p\u0001\u0001\u0006IaW\u0001\u0007]\u0006lWm\u001d\u0011\t\u000bE\u0004A\u0011\t:\u0002\u0019YL7/\u001b;MSR,'/\u00197\u0015\u0005a\u0019\b\"\u0002;q\u0001\u0004)\u0018a\u00027ji\u0016\u0014\u0018\r\u001c\t\u0003mnl\u0011a\u001e\u0006\u0003qf\f1A]3y\u0015\tQH\"A\u0004dC2\u001c\u0017\u000e^3\n\u0005q<(A\u0003*fq2KG/\u001a:bY\")a\u0010\u0001C!\u007f\u0006Ia/[:ji\u000e\u000bG\u000e\u001c\u000b\u00041\u0005\u0005\u0001bBA\u0002{\u0002\u0007\u0011QA\u0001\u0005G\u0006dG\u000eE\u0002w\u0003\u000fI1!!\u0003x\u0005\u001d\u0011V\r_\"bY2Dq!!\u0004\u0001\t\u0003\ny!A\u0005wSNLGOT8eKR\u0019\u0001$!\u0005\t\u0011\u0005M\u00111\u0002a\u0001\u0003+\tqA]3y\u001d>$W\rE\u0002w\u0003/I1!!\u0007x\u0005\u001d\u0011V\r\u001f(pI\u0016Dq!!\b\u0001\t\u0013\ty\"A\u000bue\u0006t7\u000f\\1uKN[\u0017\u000e]*ue\u0006$XmZ=\u0016\u0005\u0005\u0005\u0002\u0003BA\u0012\u0003[i!!!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\u000bC\u001a$XM]7bi\u000eD'bAA\u00169\u0005\u0019aNZ1\n\t\u0005=\u0012Q\u0005\u0002\u0017\u0003\u001a$XM]'bi\u000eD7k[5q'R\u0014\u0018\r^3hs\"9\u00111\u0007\u0001\u0005\n\u0005U\u0012a\u0006;sC:\u001cH.\u0019;f'&tw\r\\3WCJL\u0017M\u00197f)\u0015A\u0012qGA!\u0011!\tI$!\rA\u0002\u0005m\u0012a\u00049sKZLw.^:QCR$XM\u001d8\u0011\t=\u000bi\u0004G\u0005\u0004\u0003\u007f\u0001&AB(qi&|g\u000eC\u0004\u0002D\u0005E\u0002\u0019A2\u0002\u0017A\fG\u000f^3s]:\u000bW.\u001a\u0005\b\u0003\u000f\u0002A\u0011BA%\u0003=\t\u0007\u000f\u001d7z#V\fg\u000e^5gS\u0016\u0014H#\u0003\r\u0002L\u00055\u0013qKA.\u0011\u0019Y\u0012Q\ta\u00011!A\u0011qJA#\u0001\u0004\t\t&\u0001\u0005ti\u0006\u0014HOT;n!\ry\u00151K\u0005\u0004\u0003+\u0002&aA%oi\"A\u0011\u0011LA#\u0001\u0004\t\t&\u0001\u0004f]\u0012tU/\u001c\u0005\t\u0003;\n)\u00051\u0001\u0002`\u00051qM]3fIf\u00042aTA1\u0013\r\t\u0019\u0007\u0015\u0002\b\u0005>|G.Z1o\u0001")
public class PatternVisitor
extends RexDefaultVisitor<Pattern<Row, Row>> {
    private final TableConfig config;
    private final TypeInformation<Row> inputTypeInfo;
    private final MatchRecognize logicalMatch;
    private Pattern<Row, Row> pattern;
    private final LinkedHashSet<String> names;

    private Pattern<Row, Row> pattern() {
        return this.pattern;
    }

    private void pattern_$eq(Pattern<Row, Row> x$1) {
        this.pattern = x$1;
    }

    public LinkedHashSet<String> names() {
        return this.names;
    }

    @Override
    public Pattern<Row, Row> visitLiteral(RexLiteral literal) {
        Pattern pattern;
        String patternName = literal.getValueAs(String.class);
        this.pattern_$eq(this.translateSingleVariable((Option<Pattern<Row, Row>>)Option$.MODULE$.apply(this.pattern()), patternName));
        RexNode patternDefinition = this.logicalMatch.patternDefinitions().get(patternName);
        if (patternDefinition != null) {
            MatchCodeGenerator generator = new MatchCodeGenerator(this.config, this.inputTypeInfo, (Seq<String>)this.names().toSeq(), (Option<String>)new Some((Object)patternName));
            IterativeConditionRunner condition = generator.generateIterativeCondition(patternDefinition);
            pattern = this.pattern().where((IterativeCondition)condition);
        } else {
            pattern = this.pattern().where(BooleanConditions.trueFunction());
        }
        return pattern;
    }

    @Override
    public Pattern<Row, Row> visitCall(RexCall call) {
        Pattern<Row, Row> pattern;
        SqlOperator sqlOperator = call.getOperator();
        SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.PATTERN_CONCAT;
        SqlOperator sqlOperator2 = sqlOperator;
        if (!(sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator2) : sqlOperator2 != null)) {
            RexNode left = (RexNode)call.operands.get(0);
            RexNode right = (RexNode)call.operands.get(1);
            this.pattern_$eq(left.accept(this));
            this.pattern_$eq(right.accept(this));
            pattern = this.pattern();
        } else {
            SqlSpecialOperator sqlSpecialOperator = SqlStdOperatorTable.PATTERN_QUANTIFIER;
            SqlOperator sqlOperator3 = sqlOperator;
            if (!(sqlSpecialOperator != null ? !((Object)sqlSpecialOperator).equals(sqlOperator3) : sqlOperator3 != null)) {
                RexLiteral rexLiteral;
                RexNode rexNode = (RexNode)call.operands.get(0);
                if (!(rexNode instanceof RexLiteral)) {
                    throw new TableException(new StringBuilder(64).append("Expression not supported: ").append(rexNode).append(" Group patterns are ").append("not supported yet.").toString());
                }
                RexLiteral rexLiteral2 = rexLiteral = (RexLiteral)rexNode;
                RexLiteral name = rexLiteral2;
                this.pattern_$eq(name.accept(this));
                int startNum = MathUtils.checkedDownCast((long)Predef$.MODULE$.Long2long(((RexLiteral)call.operands.get(1)).getValueAs(Long.class)));
                int endNum = MathUtils.checkedDownCast((long)Predef$.MODULE$.Long2long(((RexLiteral)call.operands.get(2)).getValueAs(Long.class)));
                boolean isGreedy = !Predef$.MODULE$.Boolean2boolean(((RexLiteral)call.operands.get(3)).getValueAs(Boolean.class));
                pattern = this.applyQuantifier(this.pattern(), startNum, endNum, isGreedy);
            } else {
                SqlBinaryOperator sqlBinaryOperator2 = SqlStdOperatorTable.PATTERN_ALTER;
                SqlOperator sqlOperator4 = sqlOperator;
                if (!(sqlBinaryOperator2 != null ? !((Object)sqlBinaryOperator2).equals(sqlOperator4) : sqlOperator4 != null)) {
                    throw new TableException(new StringBuilder(78).append("Expression not supported: ").append(call).append(". Currently, CEP doesn't support branching patterns.").toString());
                }
                SqlSpecialOperator sqlSpecialOperator2 = SqlStdOperatorTable.PATTERN_PERMUTE;
                SqlOperator sqlOperator5 = sqlOperator;
                if (!(sqlSpecialOperator2 != null ? !((Object)sqlSpecialOperator2).equals(sqlOperator5) : sqlOperator5 != null)) {
                    throw new TableException(new StringBuilder(76).append("Expression not supported: ").append(call).append(". Currently, CEP doesn't support PERMUTE patterns.").toString());
                }
                SqlSpecialOperator sqlSpecialOperator3 = SqlStdOperatorTable.PATTERN_EXCLUDE;
                SqlOperator sqlOperator6 = sqlOperator;
                if (!(sqlSpecialOperator3 != null ? !((Object)sqlSpecialOperator3).equals(sqlOperator6) : sqlOperator6 != null)) {
                    throw new TableException(new StringBuilder(78).append("Expression not supported: ").append(call).append(". Currently, CEP doesn't support '{-' '-}' patterns.").toString());
                }
                throw new MatchError((Object)sqlOperator);
            }
        }
        return pattern;
    }

    @Override
    public Pattern<Row, Row> visitNode(RexNode rexNode) {
        throw new TableException(new StringBuilder(41).append("Unsupported expression within Pattern: [").append(rexNode).append("]").toString());
    }

    private AfterMatchSkipStrategy translateSkipStrategy() {
        SkipToElementStrategy skipToElementStrategy;
        Function0 & Serializable & scala.Serializable getPatternTarget = (Function0 & Serializable & scala.Serializable)() -> ((RexLiteral)((RexCall)$this.logicalMatch.after()).getOperands().get(0)).getValueAs(String.class);
        SqlKind sqlKind = this.logicalMatch.after().getKind();
        if (((Object)((Object)SqlKind.LITERAL)).equals((Object)sqlKind)) {
            SkipPastLastStrategy skipPastLastStrategy;
            SqlMatchRecognize.AfterOption afterOption = ((RexLiteral)this.logicalMatch.after()).getValueAs(SqlMatchRecognize.AfterOption.class);
            if (SqlMatchRecognize.AfterOption.SKIP_PAST_LAST_ROW.equals(afterOption)) {
                skipPastLastStrategy = AfterMatchSkipStrategy.skipPastLastEvent();
            } else if (SqlMatchRecognize.AfterOption.SKIP_TO_NEXT_ROW.equals(afterOption)) {
                skipPastLastStrategy = AfterMatchSkipStrategy.skipToNext();
            } else {
                throw new MatchError((Object)afterOption);
            }
            skipToElementStrategy = skipPastLastStrategy;
        } else if (((Object)((Object)SqlKind.SKIP_TO_FIRST)).equals((Object)sqlKind)) {
            skipToElementStrategy = AfterMatchSkipStrategy.skipToFirst((String)((String)getPatternTarget.apply())).throwExceptionOnMiss();
        } else if (((Object)((Object)SqlKind.SKIP_TO_LAST)).equals((Object)sqlKind)) {
            skipToElementStrategy = AfterMatchSkipStrategy.skipToLast((String)((String)getPatternTarget.apply())).throwExceptionOnMiss();
        } else {
            throw new IllegalStateException(new StringBuilder(33).append("Corrupted query tree. Unexpected ").append(new StringBuilder(26).append(this.logicalMatch.after()).append(" for after match strategy.").toString()).toString());
        }
        return skipToElementStrategy;
    }

    private Pattern<Row, Row> translateSingleVariable(Option<Pattern<Row, Row>> previousPattern, String patternName) {
        Pattern pattern;
        if (this.names().contains((Object)patternName)) {
            throw new TableException("Pattern variables must be unique. That might change in the future.");
        }
        this.names().add((Object)patternName);
        Option<Pattern<Row, Row>> option = previousPattern;
        if (option instanceof Some) {
            Some some = (Some)option;
            Pattern p = (Pattern)some.value();
            pattern = p.next(patternName);
        } else if (None$.MODULE$.equals(option)) {
            pattern = Pattern.begin((String)patternName, (AfterMatchSkipStrategy)this.translateSkipStrategy());
        } else {
            throw new MatchError(option);
        }
        return pattern;
    }

    private Pattern<Row, Row> applyQuantifier(Pattern<Row, Row> pattern, int startNum, int endNum, boolean greedy) {
        Pattern pattern2;
        Pattern newPattern;
        boolean isOptional;
        boolean bl = isOptional = startNum == 0 && endNum == 1;
        Pattern pattern3 = startNum == 0 && endNum == -1 ? pattern.oneOrMore().optional().consecutive() : (startNum == 1 && endNum == -1 ? pattern.oneOrMore().consecutive() : (isOptional ? pattern.optional() : (newPattern = endNum != -1 ? pattern.times(startNum, endNum).consecutive() : pattern.timesOrMore(startNum).consecutive())));
        if (greedy && (isOptional || startNum == endNum)) {
            pattern2 = newPattern;
        } else if (greedy) {
            pattern2 = newPattern.greedy();
        } else {
            if (isOptional) {
                throw new TableException("Reluctant optional variables are not supported yet.");
            }
            pattern2 = newPattern;
        }
        return pattern2;
    }

    public PatternVisitor(TableConfig config, TypeInformation<Row> inputTypeInfo, MatchRecognize logicalMatch) {
        this.config = config;
        this.inputTypeInfo = inputTypeInfo;
        this.logicalMatch = logicalMatch;
        this.names = new LinkedHashSet();
    }
}

