/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules;

import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.plan.nodes.FlinkConventions;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalCalc;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalCorrelate;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalTableFunctionScan;
import org.apache.flink.table.plan.util.CorrelateUtil;
import org.apache.flink.table.plan.util.PythonUtil;
import scala.Option;
import scala.Some;

public abstract class AbstractPythonCorrelateRuleBase
extends ConverterRule {
    public AbstractPythonCorrelateRuleBase(Convention physicalConvention, String description) {
        super(FlinkLogicalCorrelate.class, FlinkConventions.LOGICAL(), physicalConvention, description);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkLogicalCorrelate join = (FlinkLogicalCorrelate)call.rel(0);
        RelNode right = ((RelSubset)join.getRight()).getOriginal();
        if (right instanceof FlinkLogicalTableFunctionScan) {
            return PythonUtil.isPythonCall(((FlinkLogicalTableFunctionScan)right).getCall(), null);
        }
        if (right instanceof FlinkLogicalCalc) {
            FlinkLogicalCalc calc = (FlinkLogicalCalc)right;
            Option<FlinkLogicalTableFunctionScan> scan = CorrelateUtil.getTableFunctionScan(calc);
            return scan.isDefined() && PythonUtil.isPythonCall(((FlinkLogicalTableFunctionScan)scan.get()).getCall(), null);
        }
        return false;
    }

    public static abstract class PythonCorrelateFactoryBase {
        protected final RelNode correlateRel;
        protected final FlinkLogicalCorrelate join;
        protected final RelTraitSet traitSet;
        protected final RelNode convInput;
        protected final RelNode right;

        public PythonCorrelateFactoryBase(RelNode rel, Convention physicalConvention) {
            this.correlateRel = rel;
            this.join = (FlinkLogicalCorrelate)rel;
            this.traitSet = rel.getTraitSet().replace(physicalConvention);
            this.convInput = RelOptRule.convert(this.join.getInput(0), physicalConvention);
            this.right = this.join.getInput(1);
        }

        public RelNode convertToCorrelate() {
            return this.convertToCorrelate(this.right, (Option<RexNode>)Option.empty());
        }

        private RelNode convertToCorrelate(RelNode relNode, Option<RexNode> condition) {
            if (relNode instanceof RelSubset) {
                RelSubset rel = (RelSubset)relNode;
                return this.convertToCorrelate(rel.getRelList().get(0), condition);
            }
            if (relNode instanceof FlinkLogicalCalc) {
                FlinkLogicalCalc calc = (FlinkLogicalCalc)relNode;
                FlinkLogicalTableFunctionScan tableScan = (FlinkLogicalTableFunctionScan)CorrelateUtil.getTableFunctionScan(calc).get();
                FlinkLogicalCalc newCalc = CorrelateUtil.getMergedCalc(calc);
                return this.convertToCorrelate(tableScan, (Option<RexNode>)Some.apply((Object)newCalc.getProgram().expandLocalRef(newCalc.getProgram().getCondition())));
            }
            return this.createPythonCorrelateNode(relNode, condition);
        }

        public abstract RelNode createPythonCorrelateNode(RelNode var1, Option<RexNode> var2);
    }
}

