/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.util.Logging;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ug!B\u0001\u0003\u0003\u0003y!\u0001\u0006*poRKW.Z+oE>,h\u000eZ3e\u001fZ,'O\u0003\u0002\u0004\t\u0005I\u0011mZ4sK\u001e\fG/\u001a\u0006\u0003\u000b\u0019\tqA];oi&lWM\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005A92\u0003\u0002\u0001\u0012SI\u0002RAE\n\u0016G\rj\u0011AA\u0005\u0003)\t\u0011q\u0004\u0015:pG\u0016\u001c8OR;oGRLwN\\,ji\"\u001cE.Z1okB\u001cF/\u0019;f!\t1r\u0003\u0004\u0001\u0005\u000ba\u0001!\u0019A\r\u0003\u0003-\u000b\"A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u000f9{G\u000f[5oOB\u00111$I\u0005\u0003Eq\u00111!\u00118z!\t!s%D\u0001&\u0015\t1C!A\u0003usB,7/\u0003\u0002)K\t!1IU8x!\rQSfL\u0007\u0002W)\u0011AFB\u0001\bG>$WmZ3o\u0013\tq3F\u0001\u0005D_6\u0004\u0018\u000e\\3s!\t\u0011\u0002'\u0003\u00022\u0005\t)r)\u001a8fe\u0006$X\rZ!hOJ,w-\u0019;j_:\u001c\bCA\u001a7\u001b\u0005!$BA\u001b\u0007\u0003\u0011)H/\u001b7\n\u0005]\"$a\u0002'pO\u001eLgn\u001a\u0005\ts\u0001\u0011\t\u0011)A\u0005u\u0005yq-\u001a8BO\u001e\u0014XmZ1uS>t7\u000f\u0005\u0002+w%\u0011Ah\u000b\u0002\u001e\u000f\u0016tWM]1uK\u0012\fum\u001a:fO\u0006$\u0018n\u001c8t\rVt7\r^5p]\"Aa\b\u0001B\u0001B\u0003%q(\u0001\tj]R,'/\\3eS\u0006$X\rV=qKB\u0019\u0001iR%\u000e\u0003\u0005S!AQ\"\u0002\u0011QL\b/Z5oM>T!\u0001R#\u0002\r\r|W.\\8o\u0015\t1\u0005\"A\u0002ba&L!\u0001S!\u0003\u001fQK\b/Z%oM>\u0014X.\u0019;j_:\u0004\"A\u0013'\u000e\u0003-S!A\n\u0005\n\u00055[%a\u0001*po\"Aq\n\u0001B\u0001B\u0003%\u0001+A\u0005j]B,H\u000fV=qKB\u0019\u0001iR\u0012\t\u0011I\u0003!\u0011!Q\u0001\nM\u000b!B]8x)&lW-\u00133y!\tYB+\u0003\u0002V9\t\u0019\u0011J\u001c;\t\u0011]\u0003!\u0011!Q\u0001\na\u000b\u0001#\\5o%\u0016$XM\u001c;j_:$\u0016.\\3\u0011\u0005mI\u0016B\u0001.\u001d\u0005\u0011auN\\4\t\u0011q\u0003!\u0011!Q\u0001\na\u000b\u0001#\\1y%\u0016$XM\u001c;j_:$\u0016.\\3\t\u000by\u0003A\u0011A0\u0002\rqJg.\u001b;?)\u001d\u0001\u0017MY2eK\u001a\u00042A\u0005\u0001\u0016\u0011\u0015IT\f1\u0001;\u0011\u0015qT\f1\u0001@\u0011\u0015yU\f1\u0001Q\u0011\u0015\u0011V\f1\u0001T\u0011\u00159V\f1\u0001Y\u0011\u0015aV\f1\u0001Y\u0011%A\u0007\u00011AA\u0002\u0013E\u0011.\u0001\u0004pkR\u0004X\u000f^\u000b\u0002G!I1\u000e\u0001a\u0001\u0002\u0004%\t\u0002\\\u0001\u000b_V$\b/\u001e;`I\u0015\fHCA7q!\tYb.\u0003\u0002p9\t!QK\\5u\u0011\u001d\t(.!AA\u0002\r\n1\u0001\u001f\u00132\u0011%\u0019\b\u00011A\u0001B\u0003&1%A\u0004pkR\u0004X\u000f\u001e\u0011\t\u0013U\u0004\u0001\u0019!a\u0001\n\u00131\u0018\u0001E1dGVlW\u000f\\1u_J\u001cF/\u0019;f+\u00059\bc\u0001=|\u00136\t\u0011P\u0003\u0002{\u0007\u0006)1\u000f^1uK&\u0011A0\u001f\u0002\u000b-\u0006dW/Z*uCR,\u0007\"\u0003@\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0000\u0003Q\t7mY;nk2\fGo\u001c:Ti\u0006$Xm\u0018\u0013fcR\u0019Q.!\u0001\t\u000fEl\u0018\u0011!a\u0001o\"Q\u0011Q\u0001\u0001A\u0002\u0003\u0005\u000b\u0015B<\u0002#\u0005\u001c7-^7vY\u0006$xN]*uCR,\u0007\u0005C\u0006\u0002\n\u0001\u0001\r\u00111A\u0005\n\u0005-\u0011a\u0003:po6\u000b\u0007o\u0015;bi\u0016,\"!!\u0004\u0011\ra\fy\u0001WA\n\u0013\r\t\t\"\u001f\u0002\t\u001b\u0006\u00048\u000b^1uKB)\u0011QCA\u000f\u00136\u0011\u0011q\u0003\u0006\u0004k\u0005e!BAA\u000e\u0003\u0011Q\u0017M^1\n\t\u0005}\u0011q\u0003\u0002\u0005\u0019&\u001cH\u000fC\u0006\u0002$\u0001\u0001\r\u00111A\u0005\n\u0005\u0015\u0012a\u0004:po6\u000b\u0007o\u0015;bi\u0016|F%Z9\u0015\u00075\f9\u0003C\u0005r\u0003C\t\t\u00111\u0001\u0002\u000e!Y\u00111\u0006\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0007\u00031\u0011xn^'baN#\u0018\r^3!\u0011-\ty\u0003\u0001a\u0001\u0002\u0004%I!!\r\u0002!M|'\u000f^3e)&lWm\u001d;b[B\u001cXCAA\u001a!\u0015\t)\"!\u000eY\u0013\u0011\t9$a\u0006\u0003\u00151Kgn[3e\u0019&\u001cH\u000fC\u0006\u0002<\u0001\u0001\r\u00111A\u0005\n\u0005u\u0012\u0001F:peR,G\rV5nKN$\u0018-\u001c9t?\u0012*\u0017\u000fF\u0002n\u0003\u007fA\u0011\"]A\u001d\u0003\u0003\u0005\r!a\r\t\u0017\u0005\r\u0003\u00011A\u0001B\u0003&\u00111G\u0001\u0012g>\u0014H/\u001a3US6,7\u000f^1naN\u0004\u0003bCA$\u0001\u0001\u0007\t\u0019!C\t\u0003\u0013\n\u0001BZ;oGRLwN\\\u000b\u0002_!Y\u0011Q\n\u0001A\u0002\u0003\u0007I\u0011CA(\u000311WO\\2uS>tw\fJ3r)\ri\u0017\u0011\u000b\u0005\tc\u0006-\u0013\u0011!a\u0001_!Q\u0011Q\u000b\u0001A\u0002\u0003\u0005\u000b\u0015B\u0018\u0002\u0013\u0019,hn\u0019;j_:\u0004\u0003bBA-\u0001\u0011\u0005\u00131L\u0001\u0005_B,g\u000eF\u0002n\u0003;B\u0001\"a\u0018\u0002X\u0001\u0007\u0011\u0011M\u0001\u0007G>tg-[4\u0011\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KR1!a\u001a\t\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&!\u00111NA3\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"9\u0011q\u000e\u0001\u0005B\u0005E\u0014A\u00049s_\u000e,7o]#mK6,g\u000e\u001e\u000b\b[\u0006M\u0014qOAJ\u0011\u001d\t)(!\u001cA\u0002\r\na!\u001b8qkR\u001c\u0005\u0002CA=\u0003[\u0002\r!a\u001f\u0002\u0007\r$\b\u0010\u0005\u0003\u0002~\u0005=\u0005cBA@\u0003\u0017+2eI\u0007\u0003\u0003\u0003SA!a!\u0002\u0006\u0006Ia-\u001e8di&|gn\u001d\u0006\u0004\r\u0006\u001d%bAAE\u0011\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0005\u0003\u001b\u000b\tI\u0001\u000bLKf,G\r\u0015:pG\u0016\u001c8OR;oGRLwN\\\u0005\u0005\u0003#\u000bYIA\u0004D_:$X\r\u001f;\t\u0011\u0005U\u0015Q\u000ea\u0001\u0003/\u000b1a\\;u!\u0015\tI*!($\u001b\t\tYJ\u0003\u00026\u0011%!\u0011qTAN\u0005%\u0019u\u000e\u001c7fGR|'\u000fC\u0004\u0002$\u0002!\t%!*\u0002\u000f=tG+[7feR9Q.a*\u0002,\u0006M\u0006bBAU\u0003C\u0003\r\u0001W\u0001\ni&lWm\u001d;b[BD\u0001\"!\u001f\u0002\"\u0002\u0007\u0011Q\u0016\t\u0005\u0003{\ny+\u0003\u0003\u00022\u0006-%AD(o)&lWM]\"p]R,\u0007\u0010\u001e\u0005\t\u0003+\u000b\t\u000b1\u0001\u0002\u0018\"9\u0011q\u0017\u0001\u0005\n\u0005e\u0016AE5og\u0016\u0014H\u000fV8T_J$X\r\u001a'jgR$2!\\A^\u0011\u001d\ti,!.A\u0002a\u000bqB]3d_J$G+[7fgR\fW\u000e\u001d\u0005\b\u0003\u0003\u0004a\u0011AAb\u0003\u0001\u0002(o\\2fgN,E.Z7f]R\u001cx+\u001b;i'\u0006lW\rV5nKN$\u0018-\u001c9\u0015\u000f5\f)-!3\u0002N\"A\u0011qYA`\u0001\u0004\t\u0019\"\u0001\u0006dkJ\u0014vn\u001e'jgRDq!a3\u0002@\u0002\u0007\u0011*A\bmCN$\u0018iY2v[Vd\u0017\r^8s\u0011!\t)*a0A\u0002\u0005]\u0005bBAi\u0001\u0011\u0005\u00131[\u0001\u0006G2|7/\u001a\u000b\u0002[\u0002")
public abstract class RowTimeUnboundedOver<K>
extends ProcessFunctionWithCleanupState<K, CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final TypeInformation<Row> intermediateType;
    private final TypeInformation<CRow> inputType;
    private final int rowTimeIdx;
    private CRow output;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> rowMapState;
    private LinkedList<Object> sortedTimestamps;
    private GeneratedAggregations function;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler.compile$(this, cl, name, code);
    }

    private Logger LOG$lzycompute() {
        RowTimeUnboundedOver rowTimeUnboundedOver = this;
        synchronized (rowTimeUnboundedOver) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    public CRow output() {
        return this.output;
    }

    public void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> rowMapState() {
        return this.rowMapState;
    }

    private void rowMapState_$eq(MapState<Object, List<Row>> x$1) {
        this.rowMapState = x$1;
    }

    private LinkedList<Object> sortedTimestamps() {
        return this.sortedTimestamps;
    }

    private void sortedTimestamps_$eq(LinkedList<Object> x$1) {
        this.sortedTimestamps = x$1;
    }

    public GeneratedAggregations function() {
        return this.function;
    }

    public void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder(30).append("Compiling AggregateHelper: ").append(this.genAggregations.name()).append(" \n\n").append(new StringBuilder(6).append("Code:\n").append(this.genAggregations.code()).toString()).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        this.sortedTimestamps_$eq(new LinkedList<Object>());
        ValueStateDescriptor accDescriptor = new ValueStateDescriptor("accumulatorstate", this.intermediateType);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(accDescriptor));
        ListTypeInfo rowListTypeInfo = new ListTypeInfo((TypeInformation)((CRowTypeInfo)this.inputType).rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("rowmapstate", (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, (TypeInformation)rowListTypeInfo);
        this.rowMapState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        this.initCleanupTimeState("RowTimeUnboundedOverCleanupTime");
    }

    public void processElement(CRow inputC, KeyedProcessFunction.Context ctx, Collector<CRow> out) {
        block1: {
            Row input = inputC.row();
            this.processCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
            long timestamp = BoxesRunTime.unboxToLong((Object)input.getField(this.rowTimeIdx));
            long curWatermark = ctx.timerService().currentWatermark();
            if (timestamp <= curWatermark) break block1;
            ctx.timerService().registerEventTimeTimer(curWatermark + 1L);
            ArrayList<Row> rowList = (ArrayList<Row>)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)timestamp));
            if (rowList == null) {
                rowList = new ArrayList<Row>();
            }
            rowList.add(input);
            this.rowMapState().put((Object)BoxesRunTime.boxToLong((long)timestamp), rowList);
        }
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.isProcessingTimeTimer(ctx)) {
            if (this.stateCleaningEnabled()) {
                boolean noRecordsToProcess;
                boolean bl = noRecordsToProcess = !this.rowMapState().keys().iterator().hasNext();
                if (noRecordsToProcess) {
                    this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.rowMapState(), this.accumulatorState()}));
                    this.function().cleanup();
                } else {
                    this.processCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
                }
            }
            return;
        }
        ((TimestampedCollector)out).eraseTimestamp();
        Iterator keyIterator = this.rowMapState().keys().iterator();
        if (keyIterator.hasNext()) {
            long curWatermark = ctx.timerService().currentWatermark();
            boolean existEarlyRecord = false;
            do {
                long recordTime;
                if ((recordTime = BoxesRunTime.unboxToLong(keyIterator.next())) <= curWatermark) {
                    this.insertToSortedList(recordTime);
                    continue;
                }
                existEarlyRecord = true;
            } while (keyIterator.hasNext());
            Row lastAccumulator = (Row)this.accumulatorState().value();
            if (lastAccumulator == null) {
                lastAccumulator = this.function().createAccumulators();
            }
            while (!this.sortedTimestamps().isEmpty()) {
                long curTimestamp = BoxesRunTime.unboxToLong((Object)this.sortedTimestamps().removeFirst());
                List curRowList = (List)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)curTimestamp));
                this.processElementsWithSameTimestamp(curRowList, lastAccumulator, out);
                this.rowMapState().remove((Object)BoxesRunTime.boxToLong((long)curTimestamp));
            }
            this.accumulatorState().update((Object)lastAccumulator);
            if (existEarlyRecord) {
                ctx.timerService().registerEventTimeTimer(curWatermark + 1L);
            }
        }
        this.processCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
    }

    private void insertToSortedList(long recordTimestamp) {
        block1: {
            ListIterator<Object> listIterator = this.sortedTimestamps().listIterator(this.sortedTimestamps().size());
            boolean bl = true;
            while (listIterator.hasPrevious() && bl) {
                long timestamp = BoxesRunTime.unboxToLong((Object)listIterator.previous());
                if (recordTimestamp < timestamp) continue;
                listIterator.next();
                listIterator.add(BoxesRunTime.boxToLong((long)recordTimestamp));
                bl = false;
            }
            if (!bl) break block1;
            this.sortedTimestamps().addFirst(BoxesRunTime.boxToLong((long)recordTimestamp));
        }
    }

    public abstract void processElementsWithSameTimestamp(List<Row> var1, Row var2, Collector<CRow> var3);

    public void close() {
        block0: {
            if (this.function() == null) break block0;
            this.function().close();
        }
    }

    public RowTimeUnboundedOver(GeneratedAggregationsFunction genAggregations, TypeInformation<Row> intermediateType, TypeInformation<CRow> inputType, int rowTimeIdx, long minRetentionTime, long maxRetentionTime) {
        this.genAggregations = genAggregations;
        this.intermediateType = intermediateType;
        this.inputType = inputType;
        this.rowTimeIdx = rowTimeIdx;
        super(minRetentionTime, maxRetentionTime);
        Compiler.$init$(this);
        Logging.$init$(this);
    }
}

