/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions;

import java.math.BigDecimal;
import java.util.UUID;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.flink.table.utils.EncodingUtils;
import scala.Predef$;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ScalarFunctions$ {
    public static ScalarFunctions$ MODULE$;

    static {
        new ScalarFunctions$();
    }

    public String concat(String ... args) {
        return this.concat((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args));
    }

    public String concat_ws(String separator, String ... args) {
        return this.concat_ws(separator, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args));
    }

    public double power(double a, BigDecimal b) {
        return StrictMath.pow(a, b.doubleValue());
    }

    public double cosh(BigDecimal x) {
        return Math.cosh(x.doubleValue());
    }

    public String concat(Seq<String> args) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length(); ++i) {
            if (args.apply(i) == null) {
                return null;
            }
            sb.append((String)args.apply(i));
        }
        return sb.toString();
    }

    public String concat_ws(String separator, Seq<String> args) {
        if (separator == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean hasValueAppended = false;
        for (int i = 0; i < args.length(); ++i) {
            if (args.apply(i) == null) continue;
            Object object = hasValueAppended ? sb.append(separator) : BoxedUnit.UNIT;
            sb.append((String)args.apply(i));
            hasValueAppended = true;
        }
        return sb.toString();
    }

    public double log(double x) {
        if (x <= 0.0) {
            throw new IllegalArgumentException(new StringBuilder(35).append("x of 'log(x)' must be > 0, but x = ").append(x).toString());
        }
        return StrictMath.log(x);
    }

    public double exp(double x) {
        if (x <= 0.0) {
            throw new IllegalArgumentException(new StringBuilder(35).append("x of 'exp(x)' must be > 0, but x = ").append(x).toString());
        }
        return StrictMath.exp(x);
    }

    public double tanh(BigDecimal x) {
        return Math.tanh(x.doubleValue());
    }

    public double sinh(BigDecimal x) {
        return Math.sinh(x.doubleValue());
    }

    public double log(double base, double x) {
        if (x <= 0.0) {
            throw new IllegalArgumentException(new StringBuilder(41).append("x of 'log(base, x)' must be > 0, but x = ").append(x).toString());
        }
        if (base <= 1.0) {
            throw new IllegalArgumentException(new StringBuilder(47).append("base of 'log(base, x)' must be > 1, but base = ").append(base).toString());
        }
        return StrictMath.log(x) / StrictMath.log(base);
    }

    public double log2(double x) {
        if (x <= 0.0) {
            throw new IllegalArgumentException(new StringBuilder(36).append("x of 'log2(x)' must be > 0, but x = ").append(x).toString());
        }
        return StrictMath.log(x) / StrictMath.log(2.0);
    }

    public String lpad(String base, Integer len, String pad) {
        int i;
        if (Predef$.MODULE$.Integer2int(len) < 0) {
            return null;
        }
        if (BoxesRunTime.equalsNumObject((Number)len, (Object)BoxesRunTime.boxToInteger((int)0))) {
            return "";
        }
        char[] data = new char[Predef$.MODULE$.Integer2int(len)];
        char[] baseChars = base.toCharArray();
        char[] padChars = pad.toCharArray();
        int pos = Math.max(Predef$.MODULE$.Integer2int(len) - base.length(), 0);
        for (i = 0; i < pos; i += pad.length()) {
            for (int j = 0; j < pad.length() && j < pos - i; ++j) {
                data[i + j] = padChars[j];
            }
        }
        for (i = 0; pos + i < Predef$.MODULE$.Integer2int(len) && i < base.length(); ++i) {
            data[pos + i] = baseChars[i];
        }
        return new String(data);
    }

    public String rpad(String base, Integer len, String pad) {
        int pos;
        if (Predef$.MODULE$.Integer2int(len) < 0) {
            return null;
        }
        if (BoxesRunTime.equalsNumObject((Number)len, (Object)BoxesRunTime.boxToInteger((int)0))) {
            return "";
        }
        char[] data = new char[Predef$.MODULE$.Integer2int(len)];
        char[] baseChars = base.toCharArray();
        char[] padChars = pad.toCharArray();
        for (pos = 0; pos < base.length() && pos < Predef$.MODULE$.Integer2int(len); ++pos) {
            data[pos] = baseChars[pos];
        }
        while (pos < Predef$.MODULE$.Integer2int(len)) {
            for (int i = 0; i < pad.length() && i < Predef$.MODULE$.Integer2int(len) - pos; ++i) {
                data[pos + i] = padChars[i];
            }
            pos += pad.length();
        }
        return new String(data);
    }

    public String regexp_replace(String str, String regex, String replacement) {
        if (str == null || regex == null || replacement == null) {
            return null;
        }
        return str.replaceAll(regex, Matcher.quoteReplacement(replacement));
    }

    public String regexp_extract(String str, String regex, Integer extractIndex) {
        if (str == null || regex == null) {
            return null;
        }
        Matcher m = Pattern.compile(regex).matcher(str);
        if (m.find()) {
            MatchResult mr = m.toMatchResult();
            return mr.group(Predef$.MODULE$.Integer2int(extractIndex));
        }
        return null;
    }

    public String regexp_extract(String str, String regex) {
        return this.regexp_extract(str, regex, Predef$.MODULE$.int2Integer(0));
    }

    public String fromBase64(String base64) {
        return EncodingUtils.decodeBase64ToString((String)base64);
    }

    public String toBase64(String string) {
        return EncodingUtils.encodeStringToBase64((String)string);
    }

    public String hex(long string) {
        return Long.toHexString(string).toUpperCase();
    }

    public String hex(String string) {
        return EncodingUtils.hex((String)string).toUpperCase();
    }

    public String uuid() {
        return UUID.randomUUID().toString();
    }

    public String repeat(String base, int n) {
        return EncodingUtils.repeat((String)base, (int)n);
    }

    public long unixDateCeil(TimeUnitRange range, int date) {
        return this.julianDateFloor(range, date + 2440588, false);
    }

    private int julianDateFloor(TimeUnitRange range, int julian, boolean floor) {
        int j = julian + 32044;
        int g = j / 146097;
        int dg = j % 146097;
        int c = (dg / 36524 + 1) * 3 / 4;
        int dc = dg - c * 36524;
        int b = dc / 1461;
        int db = dc % 1461;
        int a = (db / 365 + 1) * 3 / 4;
        int da = db - a * 365;
        int y = g * 400 + c * 100 + b * 4 + a;
        int m = (da * 5 + 308) / 153 - 2;
        int d = da - (m + 4) * 153 / 5 + 122;
        int year = y - 4800 + (m + 2) / 12;
        int month = (m + 2) % 12 + 1;
        int day = d + 1;
        TimeUnitRange timeUnitRange = range;
        if (((Object)((Object)TimeUnitRange.YEAR)).equals((Object)timeUnitRange)) {
            if (!(floor || month <= 1 && day <= 1)) {
                ++year;
            }
            return DateTimeUtils.ymdToUnixDate(year, 1, 1);
        }
        if (((Object)((Object)TimeUnitRange.MONTH)).equals((Object)timeUnitRange)) {
            if (!floor && day > 1) {
                ++month;
            }
            return DateTimeUtils.ymdToUnixDate(year, month, 1);
        }
        throw new AssertionError((Object)range);
    }

    private ScalarFunctions$() {
        MODULE$ = this;
    }
}

