/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.datastream;

import java.io.Serializable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.calcite.RelTimeIndicatorConverter$;
import org.apache.flink.table.codegen.FunctionCodeGenerator;
import org.apache.flink.table.codegen.FunctionCodeGenerator$;
import org.apache.flink.table.codegen.GeneratedFunction;
import org.apache.flink.table.plan.nodes.datastream.DataStreamCalcBase;
import org.apache.flink.table.plan.nodes.datastream.DataStreamRel;
import org.apache.flink.table.plan.schema.RowSchema;
import org.apache.flink.table.planner.StreamPlanner;
import org.apache.flink.table.runtime.CRowProcessRunner;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo$;
import org.apache.flink.types.Row;
import scala.Function1;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0001\u0003\u0001E\u0011a\u0002R1uCN#(/Z1n\u0007\u0006d7M\u0003\u0002\u0004\t\u0005QA-\u0019;bgR\u0014X-Y7\u000b\u0005\u00151\u0011!\u00028pI\u0016\u001c(BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011!\u0002;bE2,'BA\u0006\r\u0003\u00151G.\u001b8l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011!\u0003R1uCN#(/Z1n\u0007\u0006d7MQ1tK\"Aq\u0003\u0001B\u0001B\u0003%\u0001$A\u0004dYV\u001cH/\u001a:\u0011\u0005eiR\"\u0001\u000e\u000b\u0005\u001dY\"B\u0001\u000f\r\u0003\u001d\u0019\u0017\r\\2ji\u0016L!A\b\u000e\u0003\u001bI+Gn\u00149u\u00072,8\u000f^3s\u0011!\u0001\u0003A!A!\u0002\u0013\t\u0013\u0001\u0003;sC&$8+\u001a;\u0011\u0005e\u0011\u0013BA\u0012\u001b\u0005-\u0011V\r\u001c+sC&$8+\u001a;\t\u0011\u0015\u0002!\u0011!Q\u0001\n\u0019\nQ!\u001b8qkR\u0004\"a\n\u0016\u000e\u0003!R!!K\u000e\u0002\u0007I,G.\u0003\u0002,Q\t9!+\u001a7O_\u0012,\u0007\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\u0002\u0017%t\u0007/\u001e;TG\",W.\u0019\t\u0003_Ij\u0011\u0001\r\u0006\u0003c\u0019\taa]2iK6\f\u0017BA\u001a1\u0005%\u0011vn^*dQ\u0016l\u0017\r\u0003\u00052\u0001\t\u0005\t\u0015!\u0003/\u0011!1\u0004A!A!\u0002\u00139\u0014aC2bY\u000e\u0004&o\\4sC6\u0004\"\u0001O\u001e\u000e\u0003eR!AO\u000e\u0002\u0007I,\u00070\u0003\u0002=s\tQ!+\u001a=Qe><'/Y7\t\u0011y\u0002!\u0011!Q\u0001\n}\nqB];mK\u0012+7o\u0019:jaRLwN\u001c\t\u0003\u0001&s!!Q$\u0011\u0005\t+U\"A\"\u000b\u0005\u0011\u0003\u0012A\u0002\u001fs_>$hHC\u0001G\u0003\u0015\u00198-\u00197b\u0013\tAU)\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0015.\u0013aa\u0015;sS:<'B\u0001%F\u0011\u0015i\u0005\u0001\"\u0001O\u0003\u0019a\u0014N\\5u}QAq\nU)S'R+f\u000b\u0005\u0002\u0014\u0001!)q\u0003\u0014a\u00011!)\u0001\u0005\u0014a\u0001C!)Q\u0005\u0014a\u0001M!)Q\u0006\u0014a\u0001]!)\u0011\u0007\u0014a\u0001]!)a\u0007\u0014a\u0001o!)a\b\u0014a\u0001\u007f!)\u0001\f\u0001C!3\u0006!1m\u001c9z)\u0011Q\u0006-Y2\u0011\u0005msV\"\u0001/\u000b\u0005uC\u0013\u0001B2pe\u0016L!a\u0018/\u0003\t\r\u000bGn\u0019\u0005\u0006A]\u0003\r!\t\u0005\u0006E^\u0003\rAJ\u0001\u0006G\"LG\u000e\u001a\u0005\u0006I^\u0003\raN\u0001\baJ|wM]1n\u0011\u00151\u0007\u0001\"\u0011h\u0003=!(/\u00198tY\u0006$X\rV8QY\u0006tGC\u00015z!\rIw.]\u0007\u0002U*\u00111a\u001b\u0006\u0003Y6\f1!\u00199j\u0015\tq'\"A\u0005tiJ,\u0017-\\5oO&\u0011\u0001O\u001b\u0002\u000b\t\u0006$\u0018m\u0015;sK\u0006l\u0007C\u0001:x\u001b\u0005\u0019(B\u0001;v\u0003\u0015!\u0018\u0010]3t\u0015\t1\b\"A\u0004sk:$\u0018.\\3\n\u0005a\u001c(\u0001B\"S_^DQA_3A\u0002m\fq\u0001\u001d7b]:,'\u000f\u0005\u0002}}6\tQP\u0003\u0002{\u0011%\u0011q0 \u0002\u000e'R\u0014X-Y7QY\u0006tg.\u001a:")
public class DataStreamCalc
extends DataStreamCalcBase {
    private final RelOptCluster cluster;
    private final RowSchema inputSchema;
    private final RowSchema schema;
    private final RexProgram calcProgram;
    private final String ruleDescription;

    @Override
    public Calc copy(RelTraitSet traitSet, RelNode child, RexProgram program) {
        return new DataStreamCalc(this.cluster, traitSet, child, this.inputSchema, this.schema, program, this.ruleDescription);
    }

    @Override
    public DataStream<CRow> translateToPlan(StreamPlanner planner) {
        None$ none$;
        TableConfig config = planner.getConfig();
        DataStream<CRow> inputDataStream = ((DataStreamRel)this.getInput()).translateToPlan(planner);
        if (this.calcProgram.getCondition() != null) {
            RexNode materializedCondition = RelTimeIndicatorConverter$.MODULE$.convertExpression(this.calcProgram.expandLocalRef(this.calcProgram.getCondition()), this.inputSchema.relDataType(), this.cluster.getRexBuilder());
            none$ = new Some((Object)materializedCondition);
        } else {
            none$ = None$.MODULE$;
        }
        None$ condition = none$;
        Buffer projection = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.calcProgram.getProjectList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> $this.calcProgram.expandLocalRef((RexLocalRef)x$1), Buffer$.MODULE$.canBuildFrom());
        FunctionCodeGenerator generator = new FunctionCodeGenerator(config, false, this.inputSchema.typeInfo(), FunctionCodeGenerator$.MODULE$.$lessinit$greater$default$4(), FunctionCodeGenerator$.MODULE$.$lessinit$greater$default$5(), FunctionCodeGenerator$.MODULE$.$lessinit$greater$default$6());
        GeneratedFunction<ProcessFunction, Row> genFunction = this.generateFunction(generator, this.ruleDescription, this.schema, (Seq<RexNode>)projection, (Option<RexNode>)condition, config, ProcessFunction.class);
        int inputParallelism = inputDataStream.getParallelism();
        CRowProcessRunner processFunc = new CRowProcessRunner(genFunction.name(), genFunction.code(), (TypeInformation<CRow>)CRowTypeInfo$.MODULE$.apply(this.schema.typeInfo()));
        return inputDataStream.process((ProcessFunction)processFunc).name(this.calcOpName(this.calcProgram, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)(Function3 & Serializable & scala.Serializable)(expr, inFields, localExprsTable) -> this.getExpressionString((RexNode)expr, (Seq<String>)inFields, (Option<Seq<RexNode>>)localExprsTable))).setParallelism(inputParallelism);
    }

    public DataStreamCalc(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RowSchema inputSchema, RowSchema schema, RexProgram calcProgram, String ruleDescription) {
        this.cluster = cluster;
        this.inputSchema = inputSchema;
        this.schema = schema;
        this.calcProgram = calcProgram;
        this.ruleDescription = ruleDescription;
        super(cluster, traitSet, input, inputSchema, schema, calcProgram, ruleDescription);
    }
}

