/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.Iterator;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.DataSetTimeWindowPropertyCollector;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.util.Logging;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\u0001\u0003\u0001=\u0011Q\u0006R1uCN+G\u000fV;nE2,G+[7f/&tGm\\<BO\u001e\u0014V\rZ;dK\u001e\u0013x.\u001e9Gk:\u001cG/[8o\u0015\t\u0019A!A\u0005bO\u001e\u0014XmZ1uK*\u0011QAB\u0001\beVtG/[7f\u0015\t9\u0001\"A\u0003uC\ndWM\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\t!UA!\u0011\u0003\u0007\u000e\u001b\u001b\u0005\u0011\"BA\n\u0015\u0003%1WO\\2uS>t7O\u0003\u0002\u0016-\u000511m\\7n_:T!a\u0006\u0005\u0002\u0007\u0005\u0004\u0018.\u0003\u0002\u001a%\t9\"+[2i\u000fJ|W\u000f\u001d*fIV\u001cWMR;oGRLwN\u001c\t\u00037yi\u0011\u0001\b\u0006\u0003;!\tQ\u0001^=qKNL!a\b\u000f\u0003\u0007I{w\u000fE\u0002\"I\u0019j\u0011A\t\u0006\u0003G\u0019\tqaY8eK\u001e,g.\u0003\u0002&E\tA1i\\7qS2,'\u000f\u0005\u0002(Q5\t!!\u0003\u0002*\u0005\t)r)\u001a8fe\u0006$X\rZ!hOJ,w-\u0019;j_:\u001c\bCA\u0016/\u001b\u0005a#BA\u0017\u0007\u0003\u0011)H/\u001b7\n\u0005=b#a\u0002'pO\u001eLgn\u001a\u0005\tc\u0001\u0011\t\u0011)A\u0005e\u0005yq-\u001a8BO\u001e\u0014XmZ1uS>t7\u000f\u0005\u0002\"g%\u0011AG\t\u0002\u001e\u000f\u0016tWM]1uK\u0012\fum\u001a:fO\u0006$\u0018n\u001c8t\rVt7\r^5p]\"Aa\u0007\u0001B\u0001B\u0003%q'\u0001\u0006xS:$wn^*ju\u0016\u0004\"\u0001O\u001e\u000e\u0003eR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003ye\u0012A\u0001T8oO\"Aa\b\u0001B\u0001B\u0003%q(\u0001\bxS:$wn^*uCJ$\bk\\:\u0011\u0007a\u0002%)\u0003\u0002Bs\t1q\n\u001d;j_:\u0004\"\u0001O\"\n\u0005\u0011K$aA%oi\"Aa\t\u0001B\u0001B\u0003%q(\u0001\u0007xS:$wn^#oIB{7\u000f\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003@\u0003A9\u0018N\u001c3poJ{w\u000f^5nKB{7\u000f\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003C\u0003YYW-_:B]\u0012\fum\u001a:fO\u0006$Xm]!sSRL\b\"\u0002'\u0001\t\u0003i\u0015A\u0002\u001fj]&$h\bF\u0004O\u001fB\u000b&k\u0015+\u0011\u0005\u001d\u0002\u0001\"B\u0019L\u0001\u0004\u0011\u0004\"\u0002\u001cL\u0001\u00049\u0004\"\u0002 L\u0001\u0004y\u0004\"\u0002$L\u0001\u0004y\u0004\"\u0002%L\u0001\u0004y\u0004\"\u0002&L\u0001\u0004\u0011\u0005\"\u0003,\u0001\u0001\u0004\u0005\r\u0011\"\u0003X\u0003%\u0019w\u000e\u001c7fGR|'/F\u0001Y!\t9\u0013,\u0003\u0002[\u0005\t\u0011C)\u0019;b'\u0016$H+[7f/&tGm\\<Qe>\u0004XM\u001d;z\u0007>dG.Z2u_JD\u0011\u0002\u0018\u0001A\u0002\u0003\u0007I\u0011B/\u0002\u001b\r|G\u000e\\3di>\u0014x\fJ3r)\tq\u0016\r\u0005\u00029?&\u0011\u0001-\u000f\u0002\u0005+:LG\u000fC\u0004c7\u0006\u0005\t\u0019\u0001-\u0002\u0007a$\u0013\u0007C\u0005e\u0001\u0001\u0007\t\u0011)Q\u00051\u0006Q1m\u001c7mK\u000e$xN\u001d\u0011\t\u000f\u0019\u0004\u0001\u0019!C\tO\u0006y\u0011mZ4sK\u001e\fG/\u001a\"vM\u001a,'/F\u0001\u001b\u0011\u001dI\u0007\u00011A\u0005\u0012)\f1#Y4he\u0016<\u0017\r^3Ck\u001a4WM]0%KF$\"AX6\t\u000f\tD\u0017\u0011!a\u00015!1Q\u000e\u0001Q!\ni\t\u0001#Y4he\u0016<\u0017\r^3Ck\u001a4WM\u001d\u0011\t\u0013=\u0004\u0001\u0019!a\u0001\n\u00139\u0017AB8viB,H\u000fC\u0005r\u0001\u0001\u0007\t\u0019!C\u0005e\u0006Qq.\u001e;qkR|F%Z9\u0015\u0005y\u001b\bb\u00022q\u0003\u0003\u0005\rA\u0007\u0005\nk\u0002\u0001\r\u0011!Q!\ni\tqa\\;uaV$\b\u0005C\u0005x\u0001\u0001\u0007\t\u0019!C\tO\u0006a\u0011mY2v[Vd\u0017\r^8sg\"I\u0011\u0010\u0001a\u0001\u0002\u0004%\tB_\u0001\u0011C\u000e\u001cW/\\;mCR|'o]0%KF$\"AX>\t\u000f\tD\u0018\u0011!a\u00015!IQ\u0010\u0001a\u0001\u0002\u0003\u0006KAG\u0001\u000eC\u000e\u001cW/\\;mCR|'o\u001d\u0011\t\u0015}\u0004\u0001\u0019!a\u0001\n#\t\t!\u0001\u0005gk:\u001cG/[8o+\u00051\u0003bCA\u0003\u0001\u0001\u0007\t\u0019!C\t\u0003\u000f\tABZ;oGRLwN\\0%KF$2AXA\u0005\u0011!\u0011\u00171AA\u0001\u0002\u00041\u0003BCA\u0007\u0001\u0001\u0007\t\u0011)Q\u0005M\u0005Ia-\u001e8di&|g\u000e\t\u0005\b\u0003#\u0001A\u0011IA\n\u0003\u0011y\u0007/\u001a8\u0015\u0007y\u000b)\u0002\u0003\u0005\u0002\u0018\u0005=\u0001\u0019AA\r\u0003\u0019\u0019wN\u001c4jOB!\u00111DA\u0011\u001b\t\tiBC\u0002\u0002 !\tQbY8oM&<WO]1uS>t\u0017\u0002BA\u0012\u0003;\u0011QbQ8oM&<WO]1uS>t\u0007bBA\u0014\u0001\u0011\u0005\u0013\u0011F\u0001\u0007e\u0016$WoY3\u0015\u000by\u000bY#a\u0010\t\u0011\u00055\u0012Q\u0005a\u0001\u0003_\tqA]3d_J$7\u000fE\u0003\u00022\u0005m\"$\u0004\u0002\u00024)!\u0011QGA\u001c\u0003\u0011a\u0017M\\4\u000b\u0005\u0005e\u0012\u0001\u00026bm\u0006LA!!\u0010\u00024\tA\u0011\n^3sC\ndW\r\u0003\u0005\u0002B\u0005\u0015\u0002\u0019AA\"\u0003\ryW\u000f\u001e\t\u0006\u0003\u000b\nIEG\u0007\u0003\u0003\u000fR!!\f\u0005\n\t\u0005-\u0013q\t\u0002\n\u0007>dG.Z2u_J\u0004")
public class DataSetTumbleTimeWindowAggReduceGroupFunction
extends RichGroupReduceFunction<Row, Row>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final long windowSize;
    private final Option<Object> windowStartPos;
    private final Option<Object> windowEndPos;
    private final Option<Object> windowRowtimePos;
    private final int keysAndAggregatesArity;
    private DataSetTimeWindowPropertyCollector collector;
    private Row aggregateBuffer;
    private Row output;
    private Row accumulators;
    private GeneratedAggregations function;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler.compile$(this, cl, name, code);
    }

    private Logger LOG$lzycompute() {
        DataSetTumbleTimeWindowAggReduceGroupFunction dataSetTumbleTimeWindowAggReduceGroupFunction = this;
        synchronized (dataSetTumbleTimeWindowAggReduceGroupFunction) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    private DataSetTimeWindowPropertyCollector collector() {
        return this.collector;
    }

    private void collector_$eq(DataSetTimeWindowPropertyCollector x$1) {
        this.collector = x$1;
    }

    public Row aggregateBuffer() {
        return this.aggregateBuffer;
    }

    public void aggregateBuffer_$eq(Row x$1) {
        this.aggregateBuffer = x$1;
    }

    private Row output() {
        return this.output;
    }

    private void output_$eq(Row x$1) {
        this.output = x$1;
    }

    public Row accumulators() {
        return this.accumulators;
    }

    public void accumulators_$eq(Row x$1) {
        this.accumulators = x$1;
    }

    public GeneratedAggregations function() {
        return this.function;
    }

    public void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder(36).append("Compiling AggregateHelper: ").append(this.genAggregations).append(".name \n\n ").append(new StringBuilder(11).append("Code:\n").append(this.genAggregations).append(".code").toString()).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.output_$eq(this.function().createOutputRow());
        this.accumulators_$eq(this.function().createAccumulators());
        this.collector_$eq(new DataSetTimeWindowPropertyCollector(this.windowStartPos, this.windowEndPos, this.windowRowtimePos));
    }

    public void reduce(Iterable<Row> records, Collector<Row> out) {
        Row last = null;
        Iterator<Row> iterator = records.iterator();
        this.function().resetAccumulator(this.accumulators());
        while (iterator.hasNext()) {
            Row record = iterator.next();
            this.function().mergeAccumulatorsPair(this.accumulators(), record);
            last = record;
        }
        this.function().setForwardedFields(last, this.output());
        this.function().setAggregationResults(this.accumulators(), this.output());
        long startTs = BoxesRunTime.unboxToLong((Object)last.getField(this.keysAndAggregatesArity));
        this.collector().wrappedCollector_$eq(out);
        this.collector().windowStart_$eq(startTs);
        this.collector().windowEnd_$eq(startTs + this.windowSize);
        this.collector().collect(this.output());
    }

    public DataSetTumbleTimeWindowAggReduceGroupFunction(GeneratedAggregationsFunction genAggregations, long windowSize, Option<Object> windowStartPos, Option<Object> windowEndPos, Option<Object> windowRowtimePos, int keysAndAggregatesArity) {
        this.genAggregations = genAggregations;
        this.windowSize = windowSize;
        this.windowStartPos = windowStartPos;
        this.windowEndPos = windowEndPos;
        this.windowRowtimePos = windowRowtimePos;
        this.keysAndAggregatesArity = keysAndAggregatesArity;
        Compiler.$init$(this);
        Logging.$init$(this);
        this.aggregateBuffer = new Row(keysAndAggregatesArity + 1);
    }
}

