/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.util.TimestampString;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.table.data.BoxedWrapperRowData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.planner.codegen.CodeGenException;
import org.apache.flink.table.planner.codegen.CodeGenUtils$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.codegen.GeneratedExpression$;
import org.apache.flink.table.planner.codegen.calls.CurrentTimePointCallGen;
import org.apache.flink.table.planner.plan.nodes.exec.spec.SortSpec;
import org.apache.flink.table.planner.plan.utils.SortUtil$;
import org.apache.flink.table.runtime.operators.sort.SortUtil;
import org.apache.flink.table.runtime.typeutils.TypeCheckUtils;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TypeInformationRawType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.util.TimestampStringUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.BigDecimal;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class GenerateUtils$ {
    public static GenerateUtils$ MODULE$;

    static {
        new GenerateUtils$();
    }

    public GeneratedExpression generateCallIfArgsNotNull(CodeGeneratorContext ctx, LogicalType returnType, Seq<GeneratedExpression> operands, boolean resultNullable, Function1<Seq<String>, String> call) {
        return this.generateCallWithStmtIfArgsNotNull(ctx, returnType, operands, resultNullable, (Function1<Seq<String>, Tuple2<String, String>>)(Function1 & Serializable & scala.Serializable)args -> new Tuple2((Object)"", call.apply(args)));
    }

    public boolean generateCallIfArgsNotNull$default$4() {
        return false;
    }

    public GeneratedExpression generateCallWithStmtIfArgsNotNull(CodeGeneratorContext ctx, LogicalType returnType, Seq<GeneratedExpression> operands, boolean resultNullable, Function1<Seq<String>, Tuple2<String, String>> call) {
        String resultTypeTerm = resultNullable ? CodeGenUtils$.MODULE$.boxedTypeTermForType(returnType) : CodeGenUtils$.MODULE$.primitiveTypeTermForType(returnType);
        String nullTerm = ctx.addReusableLocalVariable("boolean", "isNull");
        String resultTerm = ctx.addReusableLocalVariable(resultTypeTerm, "result");
        String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(returnType);
        boolean isResultNullable = resultNullable || TypeCheckUtils.isReference((LogicalType)returnType) && !TypeCheckUtils.isTemporal((LogicalType)returnType);
        String nullTermCode = ctx.nullCheck() && isResultNullable ? new StringBuilder(14).append(nullTerm).append(" = (").append(resultTerm).append(" == null);").toString() : "";
        Tuple2 tuple2 = (Tuple2)call.apply(operands.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.resultTerm(), Seq$.MODULE$.canBuildFrom()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String stmt = (String)tuple2._1();
        String result = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)stmt, (Object)result);
        Tuple2 tuple23 = tuple22;
        String stmt2 = (String)tuple23._1();
        String result2 = (String)tuple23._2();
        String resultCode = ctx.nullCheck() && operands.nonEmpty() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(126).append("\n         |").append(((TraversableOnce)operands.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.code(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n         |").append(nullTerm).append(" = ").append(((TraversableOnce)operands.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.nullTerm(), Seq$.MODULE$.canBuildFrom())).mkString(" || ")).append(";\n         |").append(resultTerm).append(" = ").append(defaultValue).append(";\n         |if (!").append(nullTerm).append(") {\n         |  ").append(stmt2).append("\n         |  ").append(resultTerm).append(" = ").append(result2).append(";\n         |  ").append(nullTermCode).append("\n         |}\n         |").toString())).stripMargin() : (ctx.nullCheck() && operands.isEmpty() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(79).append("\n         |").append(((TraversableOnce)operands.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.code(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n         |").append(nullTerm).append(" = false;\n         |").append(stmt2).append("\n         |").append(resultTerm).append(" = ").append(result2).append(";\n         |").append(nullTermCode).append("\n         |").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(68).append("\n         |").append(nullTerm).append(" = false;\n         |").append(((TraversableOnce)operands.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.code(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n         |").append(stmt2).append("\n         |").append(resultTerm).append(" = ").append(result2).append(";\n         |").toString())).stripMargin());
        return new GeneratedExpression(resultTerm, nullTerm, resultCode, returnType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public boolean generateCallWithStmtIfArgsNotNull$default$4() {
        return false;
    }

    public GeneratedExpression generateStringResultCallIfArgsNotNull(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands, LogicalType returnType, Function1<Seq<String>, String> call) {
        return this.generateCallIfArgsNotNull(ctx, returnType, operands, this.generateCallIfArgsNotNull$default$4(), (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)args -> new StringBuilder(13).append(CodeGenUtils$.MODULE$.BINARY_STRING()).append(".fromString(").append(call.apply(args)).append(")").toString());
    }

    public GeneratedExpression generateStringResultCallWithStmtIfArgsNotNull(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands, LogicalType returnType, Function1<Seq<String>, Tuple2<String, String>> call) {
        return this.generateCallWithStmtIfArgsNotNull(ctx, returnType, operands, this.generateCallWithStmtIfArgsNotNull$default$4(), (Function1<Seq<String>, Tuple2<String, String>>)(Function1 & Serializable & scala.Serializable)args -> {
            Tuple2 tuple2 = (Tuple2)call.apply(args);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String stmt = (String)tuple2._1();
            String result = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)stmt, (Object)result);
            Tuple2 tuple23 = tuple22;
            String stmt2 = (String)tuple23._1();
            String result2 = (String)tuple23._2();
            return new Tuple2((Object)stmt2, (Object)new StringBuilder(13).append(CodeGenUtils$.MODULE$.BINARY_STRING()).append(".fromString(").append(result2).append(")").toString());
        });
    }

    public GeneratedExpression generateCallIfArgsNullable(CodeGeneratorContext ctx, LogicalType returnType, Seq<GeneratedExpression> operands, boolean resultNullable, Function1<Seq<String>, String> call) {
        String resultTypeTerm = resultNullable ? CodeGenUtils$.MODULE$.boxedTypeTermForType(returnType) : CodeGenUtils$.MODULE$.primitiveTypeTermForType(returnType);
        String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(returnType);
        String nullTerm = ctx.addReusableLocalVariable("boolean", "isNull");
        String resultTerm = ctx.addReusableLocalVariable(resultTypeTerm, "result");
        boolean isResultNullable = resultNullable || TypeCheckUtils.isReference((LogicalType)returnType) && !TypeCheckUtils.isTemporal((LogicalType)returnType);
        String nullTermCode = ctx.nullCheck() && isResultNullable ? new StringBuilder(14).append(nullTerm).append(" = (").append(resultTerm).append(" == null);").toString() : new StringBuilder(9).append(nullTerm).append(" = false;").toString();
        Seq parameters = (Seq)operands.map((Function1 & Serializable & scala.Serializable)x -> TypeCheckUtils.isCharacterString((LogicalType)x.resultType()) ? new StringBuilder(16).append("( ").append(x.nullTerm()).append(" ) ? null : (").append(x.resultTerm()).append(")").toString() : x.resultTerm(), Seq$.MODULE$.canBuildFrom());
        String resultCode = ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(92).append("\n         |").append(((TraversableOnce)operands.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.code(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n         |").append(resultTerm).append(" = ").append(call.apply((Object)parameters)).append(";\n         |").append(nullTermCode).append("\n         |if (").append(nullTerm).append(") {\n         |  ").append(resultTerm).append(" = ").append(defaultValue).append(";\n         |}\n       ").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(45).append("\n         |").append(((TraversableOnce)operands.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.code(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n         |").append(resultTerm).append(" = ").append(call.apply((Object)parameters)).append(";\n         |").append(nullTermCode).append("\n       ").toString())).stripMargin();
        return new GeneratedExpression(resultTerm, nullTerm, resultCode, returnType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public boolean generateCallIfArgsNullable$default$4() {
        return false;
    }

    public String generateRecordStatement(LogicalType t, Class<?> clazz, String recordTerm, Option<String> recordWriterTerm, CodeGeneratorContext ctx) {
        String string;
        block7: {
            while (true) {
                boolean bl;
                LogicalTypeRoot logicalTypeRoot;
                block8: {
                    block9: {
                        boolean bl2;
                        boolean bl3;
                        if (bl3 = LogicalTypeRoot.ROW.equals(logicalTypeRoot = t.getTypeRoot()) ? true : LogicalTypeRoot.STRUCTURED_TYPE.equals(logicalTypeRoot)) {
                            Class<?> clazz2 = clazz;
                            Class<BinaryRowData> clazz3 = BinaryRowData.class;
                            if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
                                String writerTerm = (String)recordWriterTerm.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                                    throw new CodeGenException("No writer is specified when writing BinaryRowData record.");
                                });
                                String binaryRowWriter = CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(BinaryRowWriter.class));
                                String typeTerm = clazz.getCanonicalName();
                                ctx.addReusableMember(new StringBuilder(11).append(typeTerm).append(" ").append(recordTerm).append(" = new ").append(typeTerm).append("(").append(LogicalTypeChecks.getFieldCount((LogicalType)t)).append(");").toString());
                                ctx.addReusableMember(new StringBuilder(11).append(binaryRowWriter).append(" ").append(writerTerm).append(" = new ").append(binaryRowWriter).append("(").append(recordTerm).append(");").toString());
                                string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(53).append("\n         |").append(recordTerm).append(" = new ").append(typeTerm).append("(").append(LogicalTypeChecks.getFieldCount((LogicalType)t)).append(");\n         |").append(writerTerm).append(" = new ").append(binaryRowWriter).append("(").append(recordTerm).append(");\n         |").toString())).stripMargin().trim();
                                break block7;
                            }
                        }
                        if (!(bl2 = LogicalTypeRoot.ROW.equals(logicalTypeRoot) ? true : LogicalTypeRoot.STRUCTURED_TYPE.equals(logicalTypeRoot))) break block8;
                        Class<?> clazz4 = clazz;
                        Class<GenericRowData> clazz5 = GenericRowData.class;
                        if (!(clazz4 == null ? clazz5 != null : !clazz4.equals(clazz5))) break block9;
                        Class<?> clazz6 = clazz;
                        Class<BoxedWrapperRowData> clazz7 = BoxedWrapperRowData.class;
                        if (clazz6 != null ? !clazz6.equals(clazz7) : clazz7 != null) break block8;
                    }
                    String typeTerm = clazz.getCanonicalName();
                    ctx.addReusableMember(new StringBuilder(11).append(typeTerm).append(" ").append(recordTerm).append(" = new ").append(typeTerm).append("(").append(LogicalTypeChecks.getFieldCount((LogicalType)t)).append(");").toString());
                    string = new StringBuilder(10).append(recordTerm).append(" = new ").append(typeTerm).append("(").append(LogicalTypeChecks.getFieldCount((LogicalType)t)).append(");").toString();
                    break block7;
                }
                if (bl = LogicalTypeRoot.ROW.equals(logicalTypeRoot) ? true : LogicalTypeRoot.STRUCTURED_TYPE.equals(logicalTypeRoot)) {
                    Class<?> clazz8 = clazz;
                    Class<JoinedRowData> clazz9 = JoinedRowData.class;
                    if (!(clazz8 != null ? !clazz8.equals(clazz9) : clazz9 != null)) {
                        String typeTerm = clazz.getCanonicalName();
                        ctx.addReusableMember(new StringBuilder(11).append(typeTerm).append(" ").append(recordTerm).append(" = new ").append(typeTerm).append("();").toString());
                        string = new StringBuilder(10).append(recordTerm).append(" = new ").append(typeTerm).append("();").toString();
                        break block7;
                    }
                }
                if (!LogicalTypeRoot.DISTINCT_TYPE.equals(logicalTypeRoot)) break;
                t = ((DistinctType)t).getSourceType();
            }
            String typeTerm = CodeGenUtils$.MODULE$.boxedTypeTermForType(t);
            ctx.addReusableMember(new StringBuilder(11).append(typeTerm).append(" ").append(recordTerm).append(" = new ").append(typeTerm).append("();").toString());
            string = new StringBuilder(10).append(recordTerm).append(" = new ").append(typeTerm).append("();").toString();
        }
        return string;
    }

    public Option<String> generateRecordStatement$default$4() {
        return None$.MODULE$;
    }

    public GeneratedExpression generateNullLiteral(LogicalType resultType, boolean nullCheck) {
        if (!nullCheck) {
            throw new CodeGenException("Null literals are not allowed if nullCheck is disabled.");
        }
        String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(resultType);
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(resultType);
        return new GeneratedExpression(new StringBuilder(5).append("((").append(resultTypeTerm).append(") ").append(defaultValue).append(")").toString(), GeneratedExpression$.MODULE$.ALWAYS_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), resultType, (Option<Object>)new Some(null));
    }

    public GeneratedExpression generateNonNullLiteral(LogicalType literalType, String literalCode, Object literalValue) {
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(literalType);
        return new GeneratedExpression(new StringBuilder(5).append("((").append(resultTypeTerm).append(") ").append(literalCode).append(")").toString(), GeneratedExpression$.MODULE$.NEVER_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), literalType, (Option<Object>)new Some(literalValue));
    }

    public GeneratedExpression generateLiteral(CodeGeneratorContext ctx, LogicalType literalType, Object literalValue) {
        GeneratedExpression generatedExpression;
        block25: {
            LogicalTypeRoot logicalTypeRoot;
            while (true) {
                if (literalValue == null) {
                    return this.generateNullLiteral(literalType, ctx.nullCheck());
                }
                logicalTypeRoot = literalType.getTypeRoot();
                boolean bl = LogicalTypeRoot.CHAR.equals(logicalTypeRoot) ? true : LogicalTypeRoot.VARCHAR.equals(logicalTypeRoot);
                if (bl) {
                    String escapedValue = StringEscapeUtils.ESCAPE_JAVA.translate((CharSequence)literalValue.toString());
                    String field = ctx.addReusableStringConstants(escapedValue);
                    generatedExpression = this.generateNonNullLiteral(literalType, field, StringData.fromString((String)escapedValue));
                    break block25;
                }
                if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot)) {
                    generatedExpression = this.generateNonNullLiteral(literalType, literalValue.toString(), literalValue);
                    break block25;
                }
                boolean bl2 = LogicalTypeRoot.BINARY.equals(logicalTypeRoot) ? true : LogicalTypeRoot.VARBINARY.equals(logicalTypeRoot);
                if (bl2) {
                    byte[] bytesVal = ((ByteString)literalValue).getBytes();
                    String fieldTerm = ctx.addReusableObject(bytesVal, "binary", bytesVal.getClass().getCanonicalName());
                    generatedExpression = this.generateNonNullLiteral(literalType, fieldTerm, bytesVal);
                    break block25;
                }
                if (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot)) {
                    DecimalType dt = (DecimalType)literalType;
                    int precision = dt.getPrecision();
                    int scale = dt.getScale();
                    String fieldTerm = CodeGenUtils$.MODULE$.newName("decimal");
                    String decimalClass = CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(DecimalData.class));
                    String fieldDecimal = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(70).append("\n             |").append(decimalClass).append(" ").append(fieldTerm).append(" =\n             |    ").append(CodeGenUtils$.MODULE$.DECIMAL_UTIL()).append(".castFrom(\"").append(literalValue.toString()).append("\", ").append(precision).append(", ").append(scale).append(");\n             |").toString())).stripMargin();
                    ctx.addReusableMember(fieldDecimal);
                    DecimalData value = DecimalData.fromBigDecimal((java.math.BigDecimal)((java.math.BigDecimal)literalValue), (int)precision, (int)scale);
                    generatedExpression = value == null ? this.generateNullLiteral(literalType, ctx.nullCheck()) : this.generateNonNullLiteral(literalType, fieldTerm, value);
                    break block25;
                }
                if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot)) {
                    BigDecimal decimal = package$.MODULE$.BigDecimal().apply((java.math.BigDecimal)literalValue);
                    generatedExpression = this.generateNonNullLiteral(literalType, ((Object)BoxesRunTime.boxToByte((byte)decimal.byteValue())).toString(), BoxesRunTime.boxToByte((byte)decimal.byteValue()));
                    break block25;
                }
                if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot)) {
                    BigDecimal decimal = package$.MODULE$.BigDecimal().apply((java.math.BigDecimal)literalValue);
                    generatedExpression = this.generateNonNullLiteral(literalType, ((Object)BoxesRunTime.boxToShort((short)decimal.shortValue())).toString(), BoxesRunTime.boxToShort((short)decimal.shortValue()));
                    break block25;
                }
                if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot)) {
                    BigDecimal decimal = package$.MODULE$.BigDecimal().apply((java.math.BigDecimal)literalValue);
                    generatedExpression = this.generateNonNullLiteral(literalType, ((Object)BoxesRunTime.boxToInteger((int)decimal.intValue())).toString(), BoxesRunTime.boxToInteger((int)decimal.intValue()));
                    break block25;
                }
                if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot)) {
                    BigDecimal decimal = package$.MODULE$.BigDecimal().apply((java.math.BigDecimal)literalValue);
                    generatedExpression = this.generateNonNullLiteral(literalType, new StringBuilder(1).append(((Object)BoxesRunTime.boxToLong((long)decimal.longValue())).toString()).append("L").toString(), BoxesRunTime.boxToLong((long)decimal.longValue()));
                    break block25;
                }
                if (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) {
                    float floatValue = ((java.math.BigDecimal)literalValue).floatValue();
                    float f = floatValue;
                    GeneratedExpression generatedExpression2 = Float.NEGATIVE_INFINITY == f ? this.generateNonNullLiteral(literalType, "java.lang.Float.NEGATIVE_INFINITY", BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY)) : (Float.POSITIVE_INFINITY == f ? this.generateNonNullLiteral(literalType, "java.lang.Float.POSITIVE_INFINITY", BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY)) : this.generateNonNullLiteral(literalType, new StringBuilder(1).append(((Object)BoxesRunTime.boxToFloat((float)floatValue)).toString()).append("f").toString(), BoxesRunTime.boxToFloat((float)floatValue)));
                    generatedExpression = generatedExpression2;
                    break block25;
                }
                if (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)) {
                    double doubleValue = ((java.math.BigDecimal)literalValue).doubleValue();
                    double d = doubleValue;
                    GeneratedExpression generatedExpression3 = Double.NEGATIVE_INFINITY == d ? this.generateNonNullLiteral(literalType, "java.lang.Double.NEGATIVE_INFINITY", BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY)) : (Double.POSITIVE_INFINITY == d ? this.generateNonNullLiteral(literalType, "java.lang.Double.POSITIVE_INFINITY", BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY)) : this.generateNonNullLiteral(literalType, new StringBuilder(1).append(((Object)BoxesRunTime.boxToDouble((double)doubleValue)).toString()).append("d").toString(), BoxesRunTime.boxToDouble((double)doubleValue)));
                    generatedExpression = generatedExpression3;
                    break block25;
                }
                if (LogicalTypeRoot.DATE.equals(logicalTypeRoot)) {
                    generatedExpression = this.generateNonNullLiteral(literalType, literalValue.toString(), literalValue);
                    break block25;
                }
                if (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
                    generatedExpression = this.generateNonNullLiteral(literalType, literalValue.toString(), literalValue);
                    break block25;
                }
                if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
                    String fieldTerm = CodeGenUtils$.MODULE$.newName("timestamp");
                    LocalDateTime ldt = TimestampStringUtils.toLocalDateTime((TimestampString)literalValue);
                    TimestampData ts = TimestampData.fromLocalDateTime((LocalDateTime)ldt);
                    String fieldTimestamp = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(69).append("\n             |").append(CodeGenUtils$.MODULE$.TIMESTAMP_DATA()).append(" ").append(fieldTerm).append(" =\n             |  ").append(CodeGenUtils$.MODULE$.TIMESTAMP_DATA()).append(".fromEpochMillis(").append(ts.getMillisecond()).append("L, ").append(ts.getNanoOfMillisecond()).append(");\n           ").toString())).stripMargin();
                    ctx.addReusableMember(fieldTimestamp);
                    generatedExpression = this.generateNonNullLiteral(literalType, fieldTerm, ts);
                    break block25;
                }
                if (LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE.equals(logicalTypeRoot)) {
                    throw new UnsupportedOperationException(new StringBuilder(18).append("Unsupported type: ").append(literalType).toString());
                }
                if (LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot)) {
                    String fieldTerm = CodeGenUtils$.MODULE$.newName("timestampWithLocalZone");
                    Instant ins = TimestampStringUtils.toLocalDateTime((TimestampString)literalValue).atOffset(ZoneOffset.UTC).toInstant();
                    TimestampData ts = TimestampData.fromInstant((Instant)ins);
                    String fieldTimestampWithLocalZone = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(69).append("\n             |").append(CodeGenUtils$.MODULE$.TIMESTAMP_DATA()).append(" ").append(fieldTerm).append(" =\n             |  ").append(CodeGenUtils$.MODULE$.TIMESTAMP_DATA()).append(".fromEpochMillis(").append(ts.getMillisecond()).append("L, ").append(ts.getNanoOfMillisecond()).append(");\n           ").toString())).stripMargin();
                    ctx.addReusableMember(fieldTimestampWithLocalZone);
                    generatedExpression = this.generateNonNullLiteral(literalType, fieldTerm, literalValue);
                    break block25;
                }
                if (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot)) {
                    BigDecimal decimal = package$.MODULE$.BigDecimal().apply((java.math.BigDecimal)literalValue);
                    if (!decimal.isValidInt()) {
                        throw new CodeGenException(new StringBuilder(54).append("Decimal '").append(decimal).append("' can not be converted to interval of months.").toString());
                    }
                    generatedExpression = this.generateNonNullLiteral(literalType, ((Object)BoxesRunTime.boxToInteger((int)decimal.intValue())).toString(), BoxesRunTime.boxToInteger((int)decimal.intValue()));
                    break block25;
                }
                if (LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot)) {
                    BigDecimal decimal = package$.MODULE$.BigDecimal().apply((java.math.BigDecimal)literalValue);
                    if (!decimal.isValidLong()) {
                        throw new CodeGenException(new StringBuilder(60).append("Decimal '").append(decimal).append("' can not be converted to interval of milliseconds.").toString());
                    }
                    generatedExpression = this.generateNonNullLiteral(literalType, new StringBuilder(1).append(((Object)BoxesRunTime.boxToLong((long)decimal.longValue())).toString()).append("L").toString(), BoxesRunTime.boxToLong((long)decimal.longValue()));
                    break block25;
                }
                if (!LogicalTypeRoot.DISTINCT_TYPE.equals(logicalTypeRoot)) break;
                literalType = ((DistinctType)literalType).getSourceType();
            }
            if (LogicalTypeRoot.RAW.equals(logicalTypeRoot) && ((TypeInformationRawType)literalType).getTypeInformation().getTypeClass().isAssignableFrom(Enum.class)) {
                generatedExpression = this.generateSymbol((Enum)literalValue);
            } else {
                if (LogicalTypeRoot.SYMBOL.equals(logicalTypeRoot)) {
                    throw new UnsupportedOperationException();
                }
                boolean bl = LogicalTypeRoot.ARRAY.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.MULTISET.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.MAP.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.ROW.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.STRUCTURED_TYPE.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.NULL.equals(logicalTypeRoot) ? true : LogicalTypeRoot.UNRESOLVED.equals(logicalTypeRoot))))));
                if (bl) {
                    throw new CodeGenException(new StringBuilder(20).append("Type not supported: ").append(literalType).toString());
                }
                throw new MatchError((Object)logicalTypeRoot);
            }
        }
        return generatedExpression;
    }

    public GeneratedExpression generateSymbol(Enum<?> enum_) {
        return new GeneratedExpression(CodeGenUtils$.MODULE$.qualifyEnum(enum_), GeneratedExpression$.MODULE$.NEVER_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), (LogicalType)new TypeInformationRawType((TypeInformation)new GenericTypeInfo(enum_.getDeclaringClass())), (Option<Object>)new Some(enum_));
    }

    public GeneratedExpression generateNonNullField(LogicalType fieldType, String fieldTerm) {
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(fieldType);
        return new GeneratedExpression(new StringBuilder(5).append("((").append(resultTypeTerm).append(") ").append(fieldTerm).append(")").toString(), GeneratedExpression$.MODULE$.NEVER_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), fieldType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateProctimeTimestamp(CodeGeneratorContext ctx, String contextTerm) {
        LocalZonedTimestampType resultType = new LocalZonedTimestampType(3);
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType((LogicalType)resultType);
        String resultTerm = ctx.addReusableLocalVariable(resultTypeTerm, "result");
        String resultCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(96).append("\n         |").append(resultTerm).append(" = ").append(CodeGenUtils$.MODULE$.TIMESTAMP_DATA()).append(".fromEpochMillis(\n         |  ").append(contextTerm).append(".timerService().currentProcessingTime());\n         |").toString())).stripMargin().trim();
        return new GeneratedExpression(resultTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), resultCode, (LogicalType)resultType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateCurrentTimestamp(CodeGeneratorContext ctx) {
        return new CurrentTimePointCallGen(true, true).generate(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), (LogicalType)new LocalZonedTimestampType(3));
    }

    public GeneratedExpression generateRowtimeAccess(CodeGeneratorContext ctx, String contextTerm, boolean isTimestampLtz) {
        Object resultType = isTimestampLtz ? new LocalZonedTimestampType(true, TimestampKind.ROWTIME, 3) : new TimestampType(true, TimestampKind.ROWTIME, 3);
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType((LogicalType)resultType);
        Seq<String> seq = ctx.addReusableLocalVariables((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)resultTypeTerm, (Object)"result"), new Tuple2((Object)"boolean", (Object)"isNull"), new Tuple2((Object)"Long", (Object)"timestamp")}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) {
            throw new MatchError(seq);
        }
        String resultTerm = (String)((SeqLike)some.get()).apply(0);
        String nullTerm = (String)((SeqLike)some.get()).apply(1);
        String timestamp = (String)((SeqLike)some.get()).apply(2);
        Tuple3 tuple3 = new Tuple3((Object)resultTerm, (Object)nullTerm, (Object)timestamp);
        Tuple3 tuple32 = tuple3;
        String resultTerm2 = (String)tuple32._1();
        String nullTerm2 = (String)tuple32._2();
        String timestamp2 = (String)tuple32._3();
        String accessCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(368).append("\n         |").append(timestamp2).append(" = ").append(contextTerm).append(".timestamp();\n         |if (").append(timestamp2).append(" == null) {\n         |  throw new RuntimeException(\"Rowtime timestamp is not defined. Please make sure that \" +\n         |    \"a proper TimestampAssigner is defined and the stream environment \" +\n         |    \"uses the EventTime time characteristic.\");\n         |}\n         |").append(resultTerm2).append(" = ").append(CodeGenUtils$.MODULE$.TIMESTAMP_DATA()).append(".fromEpochMillis(").append(timestamp2).append(");\n         |").append(nullTerm2).append(" = false;\n       ").toString())).stripMargin().trim();
        return new GeneratedExpression(resultTerm2, nullTerm2, accessCode, (LogicalType)resultType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateWatermark(CodeGeneratorContext ctx, String contextTerm, LogicalType resultType) {
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(resultType);
        Seq<String> seq = ctx.addReusableLocalVariables((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)resultTypeTerm, (Object)"result"), new Tuple2((Object)"boolean", (Object)"isNull"), new Tuple2((Object)"long", (Object)"currentWatermark")}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) {
            throw new MatchError(seq);
        }
        String resultTerm = (String)((SeqLike)some.get()).apply(0);
        String nullTerm = (String)((SeqLike)some.get()).apply(1);
        String currentWatermarkTerm = (String)((SeqLike)some.get()).apply(2);
        Tuple3 tuple3 = new Tuple3((Object)resultTerm, (Object)nullTerm, (Object)currentWatermarkTerm);
        Tuple3 tuple32 = tuple3;
        String resultTerm2 = (String)tuple32._1();
        String nullTerm2 = (String)tuple32._2();
        String currentWatermarkTerm2 = (String)tuple32._3();
        String code = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(138).append("\n         |").append(currentWatermarkTerm2).append(" = ").append(contextTerm).append(".timerService().currentWatermark();\n         |").append(nullTerm2).append(" = (").append(currentWatermarkTerm2).append(" == java.lang.Long.MIN_VALUE);\n         |").append(resultTerm2).append(" = ").append(CodeGenUtils$.MODULE$.TIMESTAMP_DATA()).append(".fromEpochMillis(").append(currentWatermarkTerm2).append(");\n         |").toString())).stripMargin().trim();
        return new GeneratedExpression(resultTerm2, nullTerm2, code, resultType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateInputAccess(CodeGeneratorContext ctx, LogicalType inputType, String inputTerm, int index, boolean nullableInput, boolean deepCopy) {
        GeneratedExpression generatedExpression;
        Option<GeneratedExpression> option = ctx.getReusableInputUnboxingExprs(inputTerm, index);
        if (option instanceof Some) {
            GeneratedExpression expr;
            Some some = (Some)option;
            generatedExpression = expr = (GeneratedExpression)some.value();
        } else if (None$.MODULE$.equals(option)) {
            GeneratedExpression expr = nullableInput ? this.generateNullableInputFieldAccess(ctx, inputType, inputTerm, index, deepCopy) : this.generateFieldAccess(ctx, inputType, inputTerm, index, deepCopy);
            ctx.addReusableInputUnboxingExprs(inputTerm, index, expr);
            generatedExpression = expr;
        } else {
            throw new MatchError(option);
        }
        GeneratedExpression inputExpr = generatedExpression;
        return new GeneratedExpression(inputExpr.resultTerm(), inputExpr.nullTerm(), "", inputExpr.resultType(), GeneratedExpression$.MODULE$.apply$default$5());
    }

    public boolean generateInputAccess$default$6() {
        return false;
    }

    public GeneratedExpression generateNullableInputFieldAccess(CodeGeneratorContext ctx, LogicalType inputType, String inputTerm, int index, boolean deepCopy) {
        LogicalType fieldType = this.getFieldType$1(inputType, index);
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(fieldType);
        String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(fieldType);
        Seq<String> seq = ctx.addReusableLocalVariables((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)resultTypeTerm, (Object)"result"), new Tuple2((Object)"boolean", (Object)"isNull")}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        String resultTerm = (String)((SeqLike)some.get()).apply(0);
        String nullTerm = (String)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
        Tuple2 tuple22 = tuple2;
        String resultTerm2 = (String)tuple22._1();
        String nullTerm2 = (String)tuple22._2();
        GeneratedExpression fieldAccessExpr = this.generateFieldAccess(ctx, inputType, inputTerm, index, deepCopy);
        String inputCheckCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(130).append("\n         |").append(resultTerm2).append(" = ").append(defaultValue).append(";\n         |").append(nullTerm2).append(" = true;\n         |if (").append(inputTerm).append(" != null) {\n         |  ").append(fieldAccessExpr.code()).append("\n         |  ").append(resultTerm2).append(" = ").append(fieldAccessExpr.resultTerm()).append(";\n         |  ").append(nullTerm2).append(" = ").append(fieldAccessExpr.nullTerm()).append(";\n         |}\n         |").toString())).stripMargin().trim();
        return new GeneratedExpression(resultTerm2, nullTerm2, inputCheckCode, fieldType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public boolean generateNullableInputFieldAccess$default$5() {
        return false;
    }

    public GeneratedExpression generateInputFieldUnboxing(CodeGeneratorContext ctx, LogicalType inputType, String inputTerm, String inputUnboxingTerm) {
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(inputType);
        String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(inputType);
        Seq<String> seq = ctx.addReusableLocalVariables((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)resultTypeTerm, (Object)"result"), new Tuple2((Object)"boolean", (Object)"isNull")}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        String resultTerm = (String)((SeqLike)some.get()).apply(0);
        String nullTerm = (String)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
        Tuple2 tuple22 = tuple2;
        String resultTerm2 = (String)tuple22._1();
        String nullTerm2 = (String)tuple22._2();
        String wrappedCode = ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(97).append("\n         |").append(nullTerm2).append(" = ").append(inputTerm).append(" == null;\n         |").append(resultTerm2).append(" = ").append(defaultValue).append(";\n         |if (!").append(nullTerm2).append(") {\n         |  ").append(resultTerm2).append(" = ").append(inputUnboxingTerm).append(";\n         |}\n         |").toString())).stripMargin().trim() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(26).append("\n         |").append(resultTerm2).append(" = ").append(inputUnboxingTerm).append(";\n         |").toString())).stripMargin().trim();
        return new GeneratedExpression(resultTerm2, nullTerm2, wrappedCode, inputType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateFieldAccess(CodeGeneratorContext ctx, LogicalType inputType, String inputTerm, int index, boolean deepCopy) {
        GeneratedExpression expr = this.generateFieldAccess(ctx, inputType, inputTerm, index);
        return deepCopy ? expr.deepCopy(ctx) : expr;
    }

    public GeneratedExpression generateFieldAccess(CodeGeneratorContext ctx, LogicalType inputType, String inputTerm, int index) {
        GeneratedExpression generatedExpression;
        block3: {
            while (true) {
                LogicalTypeRoot logicalTypeRoot;
                boolean bl;
                if (bl = LogicalTypeRoot.ROW.equals(logicalTypeRoot = inputType.getTypeRoot()) ? true : LogicalTypeRoot.STRUCTURED_TYPE.equals(logicalTypeRoot)) {
                    LogicalType fieldType = (LogicalType)LogicalTypeChecks.getFieldTypes((LogicalType)inputType).get(index);
                    String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(fieldType);
                    String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(fieldType);
                    String readCode = CodeGenUtils$.MODULE$.rowFieldReadAccess(ctx, ((Object)BoxesRunTime.boxToInteger((int)index)).toString(), inputTerm, fieldType);
                    Seq<String> seq = ctx.addReusableLocalVariables((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)resultTypeTerm, (Object)"field"), new Tuple2((Object)"boolean", (Object)"isNull")}));
                    Some some = Seq$.MODULE$.unapplySeq(seq);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                        throw new MatchError(seq);
                    }
                    String fieldTerm = (String)((SeqLike)some.get()).apply(0);
                    String nullTerm = (String)((SeqLike)some.get()).apply(1);
                    Tuple2 tuple2 = new Tuple2((Object)fieldTerm, (Object)nullTerm);
                    Tuple2 tuple22 = tuple2;
                    String fieldTerm2 = (String)tuple22._1();
                    String nullTerm2 = (String)tuple22._2();
                    String inputCode = ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(121).append("\n             |").append(nullTerm2).append(" = ").append(inputTerm).append(".isNullAt(").append(index).append(");\n             |").append(fieldTerm2).append(" = ").append(defaultValue).append(";\n             |if (!").append(nullTerm2).append(") {\n             |  ").append(fieldTerm2).append(" = ").append(readCode).append(";\n             |}\n           ").toString())).stripMargin().trim() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(55).append("\n             |").append(nullTerm2).append(" = false;\n             |").append(fieldTerm2).append(" = ").append(readCode).append(";\n           ").toString())).stripMargin();
                    generatedExpression = new GeneratedExpression(fieldTerm2, nullTerm2, inputCode, fieldType, GeneratedExpression$.MODULE$.apply$default$5());
                    break block3;
                }
                if (!LogicalTypeRoot.DISTINCT_TYPE.equals(logicalTypeRoot)) break;
                inputType = ((DistinctType)inputType).getSourceType();
            }
            String fieldTypeTerm = CodeGenUtils$.MODULE$.boxedTypeTermForType(inputType);
            String inputCode = new StringBuilder(3).append("(").append(fieldTypeTerm).append(") ").append(inputTerm).toString();
            generatedExpression = this.generateInputFieldUnboxing(ctx, inputType, inputCode, inputCode);
        }
        return generatedExpression;
    }

    public String generateCompare(CodeGeneratorContext ctx, LogicalType t, boolean nullsIsLast, String leftTerm, String rightTerm) {
        String string;
        block16: {
            LogicalTypeRoot logicalTypeRoot;
            while (true) {
                boolean bl;
                if (bl = LogicalTypeRoot.CHAR.equals(logicalTypeRoot = t.getTypeRoot()) ? true : (LogicalTypeRoot.VARCHAR.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? true : LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot))))) {
                    string = new StringBuilder(12).append(leftTerm).append(".compareTo(").append(rightTerm).append(")").toString();
                    break block16;
                }
                if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot)) {
                    string = new StringBuilder(24).append("(").append(leftTerm).append(" == ").append(rightTerm).append(" ? 0 : (").append(leftTerm).append(" ? 1 : -1))").toString();
                    break block16;
                }
                boolean bl2 = LogicalTypeRoot.BINARY.equals(logicalTypeRoot) ? true : LogicalTypeRoot.VARBINARY.equals(logicalTypeRoot);
                if (bl2) {
                    String sortUtil = SortUtil.class.getCanonicalName();
                    string = new StringBuilder(18).append(sortUtil).append(".compareBinary(").append(leftTerm).append(", ").append(rightTerm).append(")").toString();
                    break block16;
                }
                boolean bl3 = LogicalTypeRoot.TINYINT.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.DATE.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot) ? true : LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot)))))))));
                if (bl3) {
                    string = new StringBuilder(24).append("(").append(leftTerm).append(" > ").append(rightTerm).append(" ? 1 : ").append(leftTerm).append(" < ").append(rightTerm).append(" ? -1 : 0)").toString();
                    break block16;
                }
                boolean bl4 = LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.MULTISET.equals(logicalTypeRoot) ? true : LogicalTypeRoot.MAP.equals(logicalTypeRoot));
                if (bl4) {
                    throw new UnsupportedOperationException();
                }
                if (LogicalTypeRoot.ARRAY.equals(logicalTypeRoot)) {
                    ArrayType at = (ArrayType)t;
                    String compareFunc = CodeGenUtils$.MODULE$.newName("compareArray");
                    String compareCode = this.generateArrayCompare(ctx, SortUtil$.MODULE$.getNullDefaultOrder(true), at, "a", "b");
                    String funcCode = new StringBuilder(88).append("\n          public int ").append(compareFunc).append("(").append(CodeGenUtils$.MODULE$.ARRAY_DATA()).append(" a, ").append(CodeGenUtils$.MODULE$.ARRAY_DATA()).append(" b) {\n            ").append(compareCode).append("\n            return 0;\n          }\n        ").toString();
                    ctx.addReusableMember(funcCode);
                    string = new StringBuilder(4).append(compareFunc).append("(").append(leftTerm).append(", ").append(rightTerm).append(")").toString();
                    break block16;
                }
                boolean bl5 = LogicalTypeRoot.ROW.equals(logicalTypeRoot) ? true : LogicalTypeRoot.STRUCTURED_TYPE.equals(logicalTypeRoot);
                if (bl5) {
                    int fieldCount = LogicalTypeChecks.getFieldCount((LogicalType)t);
                    String comparisons = this.generateRowCompare(ctx, t, SortUtil$.MODULE$.getAscendingSortSpec((int[])RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), fieldCount).toArray(ClassTag$.MODULE$.Int())), "a", "b");
                    String compareFunc = CodeGenUtils$.MODULE$.newName("compareRow");
                    String funcCode = new StringBuilder(88).append("\n          public int ").append(compareFunc).append("(").append(CodeGenUtils$.MODULE$.ROW_DATA()).append(" a, ").append(CodeGenUtils$.MODULE$.ROW_DATA()).append(" b) {\n            ").append(comparisons).append("\n            return 0;\n          }\n        ").toString();
                    ctx.addReusableMember(funcCode);
                    string = new StringBuilder(4).append(compareFunc).append("(").append(leftTerm).append(", ").append(rightTerm).append(")").toString();
                    break block16;
                }
                if (!LogicalTypeRoot.DISTINCT_TYPE.equals(logicalTypeRoot)) break;
                t = ((DistinctType)t).getSourceType();
            }
            if (LogicalTypeRoot.RAW.equals(logicalTypeRoot)) {
                String string2;
                LogicalType logicalType = t;
                if (logicalType instanceof RawType) {
                    RawType rawType = (RawType)logicalType;
                    Class clazz = rawType.getOriginatingClass();
                    if (!Comparable.class.isAssignableFrom(clazz)) {
                        throw new CodeGenException(new StringBuilder(45).append("Raw type class '").append(clazz).append("' must implement ").append(CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(Comparable.class, ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).append(" to be used ").append(new StringBuilder(32).append("in a comparison of two '").append(rawType.asSummaryString()).append("' types.").toString()).toString());
                    }
                    TypeSerializer serializer = rawType.getTypeSerializer();
                    String serializerTerm = ctx.addReusableObject(serializer, "serializer", ctx.addReusableObject$default$3());
                    string2 = new StringBuilder(16).append("((").append(CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(Comparable.class, ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).append(") ").append(leftTerm).append(".toObject(").append(serializerTerm).append("))").append(new StringBuilder(23).append(".compareTo(").append(rightTerm).append(".toObject(").append(serializerTerm).append("))").toString()).toString();
                } else if (logicalType instanceof TypeInformationRawType) {
                    TypeInformationRawType typeInformationRawType = (TypeInformationRawType)logicalType;
                    TypeSerializer serializer = typeInformationRawType.getTypeInformation().createSerializer(new ExecutionConfig());
                    String ser = ctx.addReusableObject(serializer, "serializer", ctx.addReusableObject$default$3());
                    String comp = ctx.addReusableObject(((AtomicType)typeInformationRawType.getTypeInformation()).createComparator(true, new ExecutionConfig()), "comparator", ctx.addReusableObject$default$3());
                    string2 = new StringBuilder(34).append(comp).append(".compare(").append(leftTerm).append(".toObject(").append(ser).append("), ").append(rightTerm).append(".toObject(").append(ser).append("))").toString();
                } else {
                    throw new MatchError((Object)logicalType);
                }
                string = string2;
            } else {
                boolean bl = LogicalTypeRoot.NULL.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.SYMBOL.equals(logicalTypeRoot) ? true : LogicalTypeRoot.UNRESOLVED.equals(logicalTypeRoot));
                if (bl) {
                    throw new IllegalArgumentException(new StringBuilder(14).append("Illegal type: ").append(t).toString());
                }
                throw new MatchError((Object)logicalTypeRoot);
            }
        }
        return string;
    }

    public String generateArrayCompare(CodeGeneratorContext ctx, boolean nullsIsLast, ArrayType arrayType, String leftTerm, String rightTerm) {
        int nullIsLastRet = nullsIsLast ? 1 : -1;
        LogicalType elementType = arrayType.getElementType();
        String fieldA = CodeGenUtils$.MODULE$.newName("fieldA");
        String isNullA = CodeGenUtils$.MODULE$.newName("isNullA");
        String lengthA = CodeGenUtils$.MODULE$.newName("lengthA");
        String fieldB = CodeGenUtils$.MODULE$.newName("fieldB");
        String isNullB = CodeGenUtils$.MODULE$.newName("isNullB");
        String lengthB = CodeGenUtils$.MODULE$.newName("lengthB");
        String minLength = CodeGenUtils$.MODULE$.newName("minLength");
        String i = CodeGenUtils$.MODULE$.newName("i");
        String comp = CodeGenUtils$.MODULE$.newName("comp");
        String typeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(elementType);
        return new StringBuilder(612).append("\n        int ").append(lengthA).append(" = a.size();\n        int ").append(lengthB).append(" = b.size();\n        int ").append(minLength).append(" = (").append(lengthA).append(" > ").append(lengthB).append(") ? ").append(lengthB).append(" : ").append(lengthA).append(";\n        for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(minLength).append("; ").append(i).append("++) {\n          boolean ").append(isNullA).append(" = a.isNullAt(").append(i).append(");\n          boolean ").append(isNullB).append(" = b.isNullAt(").append(i).append(");\n          if (").append(isNullA).append(" && ").append(isNullB).append(") {\n            // Continue to compare the next element\n          } else if (").append(isNullA).append(") {\n            return ").append(nullIsLastRet).append(";\n          } else if (").append(isNullB).append(") {\n            return ").append(-nullIsLastRet).append(";\n          } else {\n            ").append(typeTerm).append(" ").append(fieldA).append(" = ").append(CodeGenUtils$.MODULE$.rowFieldReadAccess(ctx, i, leftTerm, elementType)).append(";\n            ").append(typeTerm).append(" ").append(fieldB).append(" = ").append(CodeGenUtils$.MODULE$.rowFieldReadAccess(ctx, i, rightTerm, elementType)).append(";\n            int ").append(comp).append(" = ").append(this.generateCompare(ctx, elementType, nullsIsLast, fieldA, fieldB)).append(";\n            if (").append(comp).append(" != 0) {\n              return ").append(comp).append(";\n            }\n          }\n        }\n\n        if (").append(lengthA).append(" < ").append(lengthB).append(") {\n          return -1;\n        } else if (").append(lengthA).append(" > ").append(lengthB).append(") {\n          return 1;\n        }\n      ").toString();
    }

    public String generateRowCompare(CodeGeneratorContext ctx, LogicalType inputType, SortSpec sortSpec, String leftTerm, String rightTerm) {
        List fieldTypes = LogicalTypeChecks.getFieldTypes((LogicalType)inputType);
        ArrayBuffer compares = new ArrayBuffer();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sortSpec.getFieldSpecs())).foreach((Function1 & Serializable & scala.Serializable)fieldSpec -> {
            int index = fieldSpec.getFieldIndex();
            String symbol = fieldSpec.getIsAscendingOrder() ? "" : "-";
            int nullIsLastRet = fieldSpec.getNullIsLast() ? 1 : -1;
            LogicalType t = (LogicalType)fieldTypes.get(index);
            String typeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(t);
            String fieldA = CodeGenUtils$.MODULE$.newName("fieldA");
            String isNullA = CodeGenUtils$.MODULE$.newName("isNullA");
            String fieldB = CodeGenUtils$.MODULE$.newName("fieldB");
            String isNullB = CodeGenUtils$.MODULE$.newName("isNullB");
            String comp = CodeGenUtils$.MODULE$.newName("comp");
            String code = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(426).append("\n           |boolean ").append(isNullA).append(" = ").append(leftTerm).append(".isNullAt(").append(index).append(");\n           |boolean ").append(isNullB).append(" = ").append(rightTerm).append(".isNullAt(").append(index).append(");\n           |if (").append(isNullA).append(" && ").append(isNullB).append(") {\n           |  // Continue to compare the next element\n           |} else if (").append(isNullA).append(") {\n           |  return ").append(nullIsLastRet).append(";\n           |} else if (").append(isNullB).append(") {\n           |  return ").append(-nullIsLastRet).append(";\n           |} else {\n           |  ").append(typeTerm).append(" ").append(fieldA).append(" = ").append(CodeGenUtils$.MODULE$.rowFieldReadAccess(ctx, index, leftTerm, t)).append(";\n           |  ").append(typeTerm).append(" ").append(fieldB).append(" = ").append(CodeGenUtils$.MODULE$.rowFieldReadAccess(ctx, index, rightTerm, t)).append(";\n           |  int ").append(comp).append(" = ").append(MODULE$.generateCompare(ctx, t, fieldSpec.getNullIsLast(), fieldA, fieldB)).append(";\n           |  if (").append(comp).append(" != 0) {\n           |    return ").append(symbol).append(comp).append(";\n           |  }\n           |}\n         ").toString())).stripMargin();
            return compares.$plus$eq((Object)code);
        });
        return compares.mkString();
    }

    private final LogicalType getFieldType$1(LogicalType t, int pos) {
        LogicalType logicalType;
        block2: {
            while (true) {
                LogicalTypeRoot logicalTypeRoot;
                boolean bl;
                if (bl = LogicalTypeRoot.ROW.equals(logicalTypeRoot = t.getTypeRoot()) ? true : LogicalTypeRoot.STRUCTURED_TYPE.equals(logicalTypeRoot)) {
                    logicalType = (LogicalType)t.getChildren().get(pos);
                    break block2;
                }
                if (!LogicalTypeRoot.DISTINCT_TYPE.equals(logicalTypeRoot)) break;
                t = ((DistinctType)t).getSourceType();
            }
            logicalType = t;
        }
        return logicalType;
    }

    private GenerateUtils$() {
        MODULE$ = this;
    }
}

