/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.functions.util.ListCollector;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.planner.codegen.CodeGenUtils$;
import org.apache.flink.table.planner.codegen.ConstantCodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ExprCodeGenerator;
import org.apache.flink.table.planner.codegen.FunctionCodeGenerator$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.runtime.functions.SqlDateTimeUtils;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import scala.Array$;
import scala.Boolean$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConversions$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class PartitionPruner$ {
    public static PartitionPruner$ MODULE$;
    private final LogicalTypeRoot[] supportedPartitionFieldTypes;

    static {
        new PartitionPruner$();
    }

    public LogicalTypeRoot[] supportedPartitionFieldTypes() {
        return this.supportedPartitionFieldTypes;
    }

    public List<Map<String, String>> prunePartitions(TableConfig config, String[] partitionFieldNames, LogicalType[] partitionFieldTypes, List<Map<String, String>> allPartitions, RexNode partitionPredicate) {
        RichMapFunction richMapFunction;
        String x$15;
        Option<String> x$14;
        Option<LogicalType> x$13;
        if (allPartitions.isEmpty() || partitionPredicate.isAlwaysTrue()) {
            return allPartitions;
        }
        RowType inputType = InternalTypeInfo.ofFields((LogicalType[])partitionFieldTypes, (String[])partitionFieldNames).toRowType();
        BooleanType returnType = new BooleanType(false);
        ConstantCodeGeneratorContext ctx = new ConstantCodeGeneratorContext(config);
        String collectorTerm = CodeGenUtils$.MODULE$.DEFAULT_COLLECTOR_TERM();
        ExprCodeGenerator qual$1 = new ExprCodeGenerator(ctx, false);
        RowType x$2 = inputType;
        String x$3 = qual$1.bindInput$default$2();
        Option<int[]> x$4 = qual$1.bindInput$default$3();
        ExprCodeGenerator exprGenerator = qual$1.bindInput((LogicalType)x$2, x$3, x$4);
        GeneratedExpression filterExpression = exprGenerator.generateExpression(partitionPredicate);
        String filterFunctionBody = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(41).append("\n         |").append(filterExpression.code()).append("\n         |return ").append(filterExpression.resultTerm()).append(";\n         |").toString())).stripMargin();
        ConstantCodeGeneratorContext x$5 = ctx;
        String x$6 = "PartitionPruner";
        Class<MapFunction> x$7 = MapFunction.class;
        String x$8 = filterFunctionBody;
        BooleanType x$9 = returnType;
        RowType x$10 = inputType;
        String x$11 = collectorTerm;
        String x$12 = FunctionCodeGenerator$.MODULE$.generateFunction$default$7();
        GeneratedFunction<MapFunction> genFunction = FunctionCodeGenerator$.MODULE$.generateFunction(x$5, x$6, x$7, x$8, (LogicalType)x$9, (LogicalType)x$10, x$12, x$13 = FunctionCodeGenerator$.MODULE$.generateFunction$default$8(), x$14 = FunctionCodeGenerator$.MODULE$.generateFunction$default$9(), x$11, x$15 = FunctionCodeGenerator$.MODULE$.generateFunction$default$11());
        MapFunction function = (MapFunction)genFunction.newInstance(Thread.currentThread().getContextClassLoader());
        MapFunction mapFunction = function;
        if (!(mapFunction instanceof RichMapFunction)) {
            throw new TableException("RichMapFunction[GenericRowData, Boolean] required here");
        }
        RichMapFunction richMapFunction2 = richMapFunction = (RichMapFunction)mapFunction;
        RichMapFunction richMapFunction3 = richMapFunction2;
        ArrayList results = new ArrayList(allPartitions.size());
        ListCollector collector = new ListCollector(results);
        Configuration parameters = config.getConfiguration() != null ? config.getConfiguration() : new Configuration();
        try {
            richMapFunction3.open(parameters);
            JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(allPartitions).foreach((Function1 & Serializable & scala.Serializable)partition -> {
                PartitionPruner$.$anonfun$prunePartitions$1(config, partitionFieldNames, partitionFieldTypes, richMapFunction3, collector, partition);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            richMapFunction3.close();
        }
        return JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)((TraversableLike)((TraversableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(allPartitions).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)PartitionPruner$.$anonfun$prunePartitions$2(results, x0$2)))).map((Function1 & Serializable & scala.Serializable)x$1 -> (Map)x$1._1(), Buffer$.MODULE$.canBuildFrom()));
    }

    private GenericRowData convertPartitionToRow(ZoneId timeZone, String[] partitionFieldNames, LogicalType[] partitionFieldTypes, Map<String, String> partition) {
        GenericRowData row = new GenericRowData(partitionFieldNames.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionFieldNames)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])partitionFieldTypes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            PartitionPruner$.$anonfun$convertPartitionToRow$1(timeZone, partition, row, x0$3);
            return BoxedUnit.UNIT;
        });
        return row;
    }

    private Object convertPartitionFieldValue(ZoneId timeZone, String v, LogicalType t) {
        Object object;
        if (v == null) {
            return null;
        }
        LogicalTypeRoot logicalTypeRoot = t.getTypeRoot();
        boolean bl = LogicalTypeRoot.VARCHAR.equals(logicalTypeRoot) ? true : LogicalTypeRoot.CHAR.equals(logicalTypeRoot);
        if (bl) {
            object = StringData.fromString((String)v);
        } else if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot)) {
            object = Boolean$.MODULE$;
        } else if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot)) {
            object = BoxesRunTime.boxToByte((byte)new StringOps(Predef$.MODULE$.augmentString(v)).toByte());
        } else if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot)) {
            object = BoxesRunTime.boxToShort((short)new StringOps(Predef$.MODULE$.augmentString(v)).toShort());
        } else if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot)) {
            object = BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(v)).toInt());
        } else if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot)) {
            object = BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(v)).toLong());
        } else if (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) {
            object = BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(v)).toFloat());
        } else if (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)) {
            object = BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(v)).toDouble());
        } else if (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot)) {
            DecimalType decimalType = (DecimalType)t;
            object = DecimalDataUtils.castFrom((String)v, (int)decimalType.getPrecision(), (int)decimalType.getScale());
        } else if (LogicalTypeRoot.DATE.equals(logicalTypeRoot)) {
            object = SqlDateTimeUtils.dateStringToUnixDate((String)v);
        } else if (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            object = SqlDateTimeUtils.timeStringToUnixDate((String)v);
        } else if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            object = SqlDateTimeUtils.toTimestampData((String)v);
        } else if (LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot)) {
            object = TimestampData.fromInstant((Instant)SqlDateTimeUtils.toTimestampData((String)v).toLocalDateTime().atZone(timeZone).toInstant());
        } else {
            throw new TableException(new StringBuilder(36).append(t).append(" is not supported in PartitionPruner").toString());
        }
        return object;
    }

    public static final /* synthetic */ void $anonfun$prunePartitions$1(TableConfig config$1, String[] partitionFieldNames$1, LogicalType[] partitionFieldTypes$1, RichMapFunction richMapFunction$1, ListCollector collector$1, Map partition) {
        GenericRowData row = MODULE$.convertPartitionToRow(config$1.getLocalTimeZone(), partitionFieldNames$1, partitionFieldTypes$1, partition);
        collector$1.collect(richMapFunction$1.map((Object)row));
    }

    public static final /* synthetic */ boolean $anonfun$prunePartitions$2(List results$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int index = tuple2._2$mcI$sp();
        boolean bl = BoxesRunTime.unboxToBoolean(results$1.get(index));
        return bl;
    }

    public static final /* synthetic */ void $anonfun$convertPartitionToRow$1(ZoneId timeZone$1, Map partition$1, GenericRowData row$1, Tuple2 x0$3) {
        int index;
        Tuple2 tuple2;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x0$3;
                if (tuple22 == null) break block2;
                tuple2 = (Tuple2)tuple22._1();
                index = tuple22._2$mcI$sp();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        String fieldName = (String)tuple2._1();
        LogicalType fieldType = (LogicalType)tuple2._2();
        Object value = MODULE$.convertPartitionFieldValue(timeZone$1, (String)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(partition$1).apply((Object)fieldName), fieldType);
        row$1.setField(index, value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private PartitionPruner$() {
        MODULE$ = this;
        this.supportedPartitionFieldTypes = (LogicalTypeRoot[])((Object[])new LogicalTypeRoot[]{LogicalTypeRoot.VARCHAR, LogicalTypeRoot.CHAR, LogicalTypeRoot.BOOLEAN, LogicalTypeRoot.TINYINT, LogicalTypeRoot.SMALLINT, LogicalTypeRoot.INTEGER, LogicalTypeRoot.BIGINT, LogicalTypeRoot.FLOAT, LogicalTypeRoot.DOUBLE, LogicalTypeRoot.DECIMAL, LogicalTypeRoot.DATE, LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE});
    }
}

