/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.testcsv;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.formats.testcsv.TestCsvDeserializationSchema;
import org.apache.flink.formats.testcsv.TestCsvSerializationSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.format.FileBasedStatisticsReportableInputFormat;
import org.apache.flink.table.connector.format.ProjectableDecodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.runtime.connector.source.ScanRuntimeProviderContext;
import org.apache.flink.table.types.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCsvFormatFactory
implements DeserializationFormatFactory,
SerializationFormatFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TestCsvFormatFactory.class);
    public static final String IDENTIFIER = "testcsv";

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return new HashSet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return new HashSet();
    }

    public EncodingFormat<SerializationSchema<RowData>> createEncodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        return new EncodingFormat<SerializationSchema<RowData>>(){

            public SerializationSchema<RowData> createRuntimeEncoder(DynamicTableSink.Context context, DataType consumedDataType) {
                DynamicTableSink.DataStructureConverter converter = context.createDataStructureConverter(consumedDataType);
                return new TestCsvSerializationSchema(converter);
            }

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.insertOnly();
            }
        };
    }

    public DecodingFormat<DeserializationSchema<RowData>> createDecodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        return new TestCsvInputFormat();
    }

    private static class TestCsvInputFormat
    implements ProjectableDecodingFormat<DeserializationSchema<RowData>>,
    FileBasedStatisticsReportableInputFormat {
        private TestCsvInputFormat() {
        }

        public DeserializationSchema<RowData> createRuntimeDecoder(DynamicTableSource.Context context, DataType physicalDataType, int[][] projections) {
            DataType projectedPhysicalDataType = Projection.of((int[][])projections).project(physicalDataType);
            return new TestCsvDeserializationSchema(projectedPhysicalDataType, (TypeInformation<RowData>)context.createTypeInformation(projectedPhysicalDataType), DataType.getFieldNames((DataType)physicalDataType), arg_0 -> ((ScanRuntimeProviderContext)ScanRuntimeProviderContext.INSTANCE).createDataStructureConverter(arg_0));
        }

        public ChangelogMode getChangelogMode() {
            return ChangelogMode.insertOnly();
        }

        public TableStats reportStatistics(List<Path> files, DataType producedDataType) {
            int totalSampleLineCnt = 100;
            try {
                long totalFileSize = 0L;
                int sampledRowCnt = 0;
                long sampledRowSize = 0L;
                for (Path file : files) {
                    FileSystem fs = FileSystem.get((URI)file.toUri());
                    FileStatus status = fs.getFileStatus(file);
                    totalFileSize += status.getLen();
                    if (sampledRowCnt >= 100) continue;
                    InputStreamReader isr = new InputStreamReader(Files.newInputStream(new File(file.toUri()).toPath(), new OpenOption[0]));
                    Throwable throwable = null;
                    try {
                        BufferedReader br = new BufferedReader(isr);
                        Throwable throwable2 = null;
                        try {
                            String line;
                            while (sampledRowCnt < 100 && (line = br.readLine()) != null) {
                                ++sampledRowCnt;
                                sampledRowSize += (long)line.getBytes(StandardCharsets.UTF_8).length;
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (br == null) continue;
                            if (throwable2 != null) {
                                try {
                                    br.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            br.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (isr == null) continue;
                        if (throwable != null) {
                            try {
                                isr.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        isr.close();
                    }
                }
                if (sampledRowCnt < 100) {
                    sampledRowSize = totalFileSize;
                }
                if (sampledRowSize == 0L) {
                    return TableStats.UNKNOWN;
                }
                int realSampledLineCnt = Math.min(100, sampledRowCnt);
                long estimatedRowCount = totalFileSize * (long)realSampledLineCnt / sampledRowSize;
                return new TableStats(estimatedRowCount);
            }
            catch (Exception e) {
                LOG.warn("Reporting statistics failed for Csv format: {}", (Object)e.getMessage());
                return TableStats.UNKNOWN;
            }
        }
    }
}

