/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.alias;

import java.util.Collections;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.planner.alias.ClearJoinHintWithInvalidPropagationShuttle;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil;
import org.apache.flink.table.planner.utils.PlannerMocks;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.junit.Before;

public abstract class ClearJoinHintWithInvalidPropagationShuttleTestBase
extends TableTestBase {
    protected final TableTestUtil util = this.getTableTestUtil();
    private final Catalog catalog = new GenericInMemoryCatalog("MockCatalog", "default");
    private final CatalogManager catalogManager = CatalogManagerMocks.preparedCatalogManager().defaultCatalog("builtin", this.catalog).config((ReadableConfig)Configuration.fromMap(Collections.singletonMap(ExecutionOptions.RUNTIME_MODE.key(), this.isBatchMode() ? RuntimeExecutionMode.BATCH.name() : RuntimeExecutionMode.STREAMING.name()))).build();
    private final PlannerMocks plannerMocks = PlannerMocks.newBuilder().withBatchMode(this.isBatchMode()).withCatalogManager(this.catalogManager).build();
    protected final FlinkRelBuilder builder = this.plannerMocks.getPlannerContext().createRelBuilder();

    abstract TableTestUtil getTableTestUtil();

    abstract boolean isBatchMode();

    @Before
    public void before() throws Exception {
        this.util.tableEnv().registerCatalog("testCatalog", this.catalog);
        this.util.tableEnv().executeSql("use catalog testCatalog");
        this.util.tableEnv().executeSql("CREATE TABLE t1 (\n  a BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = '" + this.isBatchMode() + "'\n)");
        this.util.tableEnv().executeSql("CREATE TABLE t2 (\n  a BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = '" + this.isBatchMode() + "'\n)");
        this.util.tableEnv().executeSql("CREATE TABLE t3 (\n  a BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = '" + this.isBatchMode() + "'\n)");
    }

    protected String buildRelPlanWithQueryBlockAlias(RelNode node) {
        return System.lineSeparator() + FlinkRelOptUtil.toString((RelNode)node, (SqlExplainLevel)SqlExplainLevel.EXPPLAN_ATTRIBUTES, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)true);
    }

    protected void verifyRelPlan(RelNode node) {
        String plan = this.buildRelPlanWithQueryBlockAlias(node);
        this.util.assertEqualsOrExpand("beforePropagatingHints", plan, true);
        RelNode rootAfterHintPropagation = RelOptUtil.propagateRelHints((RelNode)node, (boolean)false);
        plan = this.buildRelPlanWithQueryBlockAlias(rootAfterHintPropagation);
        this.util.assertEqualsOrExpand("afterPropagatingHints", plan, true);
        RelNode rootAfterClearingJoinHintWithInvalidPropagation = rootAfterHintPropagation.accept((RelShuttle)new ClearJoinHintWithInvalidPropagationShuttle());
        plan = this.buildRelPlanWithQueryBlockAlias(rootAfterClearingJoinHintWithInvalidPropagation);
        this.util.assertEqualsOrExpand("afterClearingJoinHints", plan, false);
    }
}

