/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.shaded.guava30.com.google.common.collect.ImmutableSet;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.apache.flink.table.types.DataType;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class CatalogConstraintTest {
    private String databaseName = "default_database";
    private TableEnvironment tEnv;
    private Catalog catalog;

    @Before
    public void setup() {
        EnvironmentSettings settings = EnvironmentSettings.newInstance().inBatchMode().build();
        this.tEnv = TableEnvironment.create((EnvironmentSettings)settings);
        this.catalog = this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).orElse(null);
        Assertions.assertThat((Object)this.catalog).isNotNull();
    }

    @Test
    public void testWithPrimaryKey() throws Exception {
        TableSchema tableSchema = TableSchema.builder().fields(new String[]{"a", "b", "c"}, new DataType[]{DataTypes.STRING(), (DataType)DataTypes.BIGINT().notNull(), DataTypes.INT()}).primaryKey(new String[]{"b"}).build();
        Map<String, String> properties = this.buildCatalogTableProperties(tableSchema);
        this.catalog.createTable(new ObjectPath(this.databaseName, "T1"), (CatalogBaseTable)new CatalogTableImpl(tableSchema, properties, ""), false);
        RelNode t1 = TableTestUtil.toRelNode(this.tEnv.sqlQuery("select * from T1"));
        FlinkRelMetadataQuery mq = FlinkRelMetadataQuery.reuseOrCreate((RelMetadataQuery)t1.getCluster().getMetadataQuery());
        Assertions.assertThat((Collection)mq.getUniqueKeys(t1)).isEqualTo((Object)ImmutableSet.of((Object)ImmutableBitSet.of((int[])new int[]{1})));
    }

    @Test
    public void testWithoutPrimaryKey() throws Exception {
        TableSchema tableSchema = TableSchema.builder().fields(new String[]{"a", "b", "c"}, new DataType[]{DataTypes.BIGINT(), DataTypes.STRING(), DataTypes.INT()}).build();
        Map<String, String> properties = this.buildCatalogTableProperties(tableSchema);
        this.catalog.createTable(new ObjectPath(this.databaseName, "T1"), (CatalogBaseTable)new CatalogTableImpl(tableSchema, properties, ""), false);
        RelNode t1 = TableTestUtil.toRelNode(this.tEnv.sqlQuery("select * from T1"));
        FlinkRelMetadataQuery mq = FlinkRelMetadataQuery.reuseOrCreate((RelMetadataQuery)t1.getCluster().getMetadataQuery());
        Assertions.assertThat((Collection)mq.getUniqueKeys(t1)).isEqualTo((Object)ImmutableSet.of());
    }

    private Map<String, String> buildCatalogTableProperties(TableSchema tableSchema) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("connector.type", "filesystem");
        properties.put("connector.property-version", "1");
        properties.put("connector.path", "/path/to/csv");
        properties.put("format.type", "csv");
        properties.put("format.property-version", "1");
        properties.put("format.field-delimiter", ";");
        return properties;
    }
}

