/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.planner.catalog.CatalogTableITCase$;
import org.apache.flink.table.planner.expressions.utils.Func0$;
import org.apache.flink.table.planner.factories.TestValuesCatalog;
import org.apache.flink.table.planner.factories.utils.TestCollectionTableFactory$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.DateTimeTestUtil$;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.types.Row;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.UserClassLoaderJarTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenIterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\t\u0005d\u0001B\u0001\u0003\u0001=\u0011!cQ1uC2|w\rV1cY\u0016LEkQ1tK*\u00111\u0001B\u0001\bG\u0006$\u0018\r\\8h\u0015\t)a!A\u0004qY\u0006tg.\u001a:\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Yi\u0011A\u0005\u0006\u0003'Q\tA!\u001e;jY*\u0011Q\u0003C\u0001\u0005i\u0016\u001cH/\u0003\u0002\u0018%\t\u0001\u0012IY:ue\u0006\u001cG\u000fV3ti\n\u000b7/\u001a\u0005\t3\u0001\u0011\t\u0011)A\u00055\u0005y\u0011n]*ue\u0016\fW.\u001b8h\u001b>$W\r\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBDA\u0004C_>dW-\u00198\t\u000b\u0005\u0002A\u0011\u0001\u0012\u0002\rqJg.\u001b;?)\t\u0019S\u0005\u0005\u0002%\u00015\t!\u0001C\u0003\u001aA\u0001\u0007!\u0004C\u0004(\u0001\t\u0007I\u0011\u0002\u0015\u0002\u0011M,G\u000f^5oON,\u0012!\u000b\t\u0003U5j\u0011a\u000b\u0006\u0003Y\u0019\t1!\u00199j\u0013\tq3FA\nF]ZL'o\u001c8nK:$8+\u001a;uS:<7\u000f\u0003\u00041\u0001\u0001\u0006I!K\u0001\ng\u0016$H/\u001b8hg\u0002BqA\r\u0001C\u0002\u0013%1'\u0001\u0005uC\ndW-\u00128w+\u0005!\u0004C\u0001\u00166\u0013\t14F\u0001\tUC\ndW-\u00128wSJ|g.\\3oi\"1\u0001\b\u0001Q\u0001\nQ\n\u0011\u0002^1cY\u0016,eN\u001e\u0011\t\u000fi\u0002\u0001\u0019!C\u0001w\u0005Yq,\u001a=qK\u000e$X\rZ#y+\u0005a\u0004CA\u001fC\u001b\u0005q$BA A\u0003\u0015\u0011X\u000f\\3t\u0015\t\tE\"A\u0003kk:LG/\u0003\u0002D}\t\tR\t\u001f9fGR,G-\u0012=dKB$\u0018n\u001c8\t\u000f\u0015\u0003\u0001\u0019!C\u0001\r\u0006yq,\u001a=qK\u000e$X\rZ#y?\u0012*\u0017\u000f\u0006\u0002H\u0015B\u00111\u0004S\u0005\u0003\u0013r\u0011A!\u00168ji\"91\nRA\u0001\u0002\u0004a\u0014a\u0001=%c!1Q\n\u0001Q!\nq\nAbX3ya\u0016\u001cG/\u001a3Fq\u0002BQa\u0014\u0001\u0005\u0002m\n!\"\u001a=qK\u000e$X\rZ#yQ\tq\u0015\u000b\u0005\u0002S'6\t\u0001)\u0003\u0002U\u0001\n!!+\u001e7f\u0011\u00151\u0006\u0001\"\u0001X\u0003\u0019\u0011WMZ8sKR\tq\t\u000b\u0002V3B\u0011!KW\u0005\u00037\u0002\u0013aAQ3g_J,\u0007\"B/\u0001\t\u0007q\u0016a\u0003:po>\u0013H-\u001a:j]\u001e,\u0012a\u0018\t\u0004A\"\\gBA1g\u001d\t\u0011W-D\u0001d\u0015\t!g\"\u0001\u0004=e>|GOP\u0005\u0002;%\u0011q\rH\u0001\ba\u0006\u001c7.Y4f\u0013\tI'N\u0001\u0005Pe\u0012,'/\u001b8h\u0015\t9G\u0004\u0005\u0002m_6\tQN\u0003\u0002o\u0011\u0005)A/\u001f9fg&\u0011\u0001/\u001c\u0002\u0004%><\b\"\u0002:\u0001\t\u0003\u0019\u0018!\u0002;p%><HCA6u\u0011\u0015)\u0018\u000f1\u0001w\u0003\u0011\t'oZ:\u0011\u0007m9\u00180\u0003\u0002y9\tQAH]3qK\u0006$X\r\u001a \u0011\u0005mQ\u0018BA>\u001d\u0005\r\te.\u001f\u0005\u0006{\u0002!\tA`\u0001\u0010O\u0016$H+\u00192mK>\u0003H/[8ogR\u0019q0!\b\u0011\u0011\u0005\u0005\u0011\u0011BA\u0007\u0003\u001bi!!a\u0001\u000b\u0007M\t)A\u0003\u0002\u0002\b\u0005!!.\u0019<b\u0013\u0011\tY!a\u0001\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\u0010\u0005]a\u0002BA\t\u0003'\u0001\"A\u0019\u000f\n\u0007\u0005UA$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00033\tYB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003+a\u0002bBA\u0010y\u0002\u0007\u0011QB\u0001\ni\u0006\u0014G.\u001a(b[\u0016Dq!a\t\u0001\t\u0013\t)#A\u0004uKN$X\u000b\u001a4\u0015\u0007\u001d\u000b9\u0003\u0003\u0005\u0002*\u0005\u0005\u0002\u0019AA\u0007\u0003)1WO\\2Qe\u00164\u0017\u000e\u001f\u0005\u0007\u0003[\u0001A\u0011A,\u00023Q,7\u000f^+eM^KG\u000f\u001b$vY2LE-\u001a8uS\u001aLWM\u001d\u0015\u0005\u0003W\t\t\u0004E\u0002S\u0003gI1!!\u000eA\u0005\u0011!Vm\u001d;\t\r\u0005e\u0002\u0001\"\u0001X\u0003M!Xm\u001d;VI\u001a<\u0016\u000e\u001e5ECR\f'-Y:fQ\u0011\t9$!\r\t\r\u0005}\u0002\u0001\"\u0001X\u00039!Xm\u001d;VI\u001a<\u0016\u000e\u001e5O_:DC!!\u0010\u00022!1\u0011Q\t\u0001\u0005\u0002]\u000bq\u0003^3tiV#gmV5uQ^\u0013xN\\4DCR\fGn\\4)\u0011\u0005\r\u0013\u0011GA%\u0003\u0017\n\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0003\u0003\u001b\u00022AKA(\u0013\r\t\tf\u000b\u0002\u0014-\u0006d\u0017\u000eZ1uS>tW\t_2faRLwN\u001c\u0005\u0007\u0003+\u0002A\u0011A,\u00021Q,7\u000f^+eM^KG\u000f[,s_:<G)\u0019;bE\u0006\u001cX\r\u000b\u0005\u0002T\u0005E\u0012\u0011JA&\u0011\u0019\tY\u0006\u0001C\u0001/\u0006qA/Z:u\u0013:\u001cXM\u001d;J]R|\u0007\u0006BA-\u0003cAa!!\u0019\u0001\t\u00039\u0016\u0001\u0007;fgR\u0014V-\u00193Xe&$XmQ:w+NLgn\u001a#E\u0019\"\"\u0011qLA\u0019\u0011\u0019\t9\u0007\u0001C\u0001/\u00069C/Z:u%\u0016\fGm\u0016:ji\u0016\u001c5O^,ji\"$\u0015P\\1nS\u000e$\u0016M\u00197f\u001fB$\u0018n\u001c8tQ\u0011\t)'!\r\t\r\u00055\u0004\u0001\"\u0001X\u0003\u0015\"Xm\u001d;J]N,'\u000f^*pkJ\u001cW\rV1cY\u0016,\u0005\u0010\u001d:fgNLwN\u001c$jK2$7\u000f\u000b\u0003\u0002l\u0005E\u0002BBA:\u0001\u0011\u0005q+A\u001buKN$\u0018J\\:feR\u001cv.\u001e:dKR\u000b'\r\\3FqB\u0014Xm]:j_:4\u0015.\u001a7eg\n+gm\u001c:f%\u00164WM]3oG\u0016\u001c\b\u0006BA9\u0003cAa!!\u001f\u0001\t\u00039\u0016A\t;fgRLen]3siN{WO]2f)\u0006\u0014G.Z,ji\"4UO\\2GS\u0016dG\r\u000b\u0003\u0002x\u0005E\u0002BBA@\u0001\u0011\u0005q+A\u0017uKN$\u0018J\\:feR\u001cv.\u001e:dKR\u000b'\r\\3XSRDWk]3s\t\u00164\u0017N\\3e\rVt7MR5fY\u0012DC!! \u00022!1\u0011Q\u0011\u0001\u0005\u0002]\u000b1\u0005^3ti&s7/\u001a:u'&t7\u000eV1cY\u0016,\u0005\u0010\u001d:fgNLwN\u001c$jK2$7\u000f\u000b\u0003\u0002\u0004\u0006E\u0002BBAF\u0001\u0011\u0005q+\u0001\u0014uKN$\u0018J\\:feR\u001c\u0016N\\6UC\ndWmV5uQVsW.\u0019;dQ\u0016$g)[3mINDC!!#\u00022!1\u0011\u0011\u0013\u0001\u0005\u0002]\u000b!\u0004^3ti&s7/\u001a:u/&$\bNS8j]\u0016$7k\\;sG\u0016DC!a$\u00022!1\u0011q\u0013\u0001\u0005\u0002]\u000bQ\u0004^3ti&s7/\u001a:u/&$\b.Q4he\u0016<\u0017\r^3T_V\u00148-\u001a\u0015\u0005\u0003+\u000b\t\u0004\u0003\u0004\u0002\u001e\u0002!\taV\u00011i\u0016\u001cH\u000fV3na>\u0014\u0018M]=UC\ndW-T1tWB+'/\\1oK:$H+\u00192mK^KG\u000f[*b[\u0016t\u0015-\\3)\t\u0005m\u0015\u0011\u0007\u0005\u0007\u0003G\u0003A\u0011A,\u00023Q,7\u000f\u001e#s_B$\u0016M\u00197f/&$\bNR;mYB\u000bG\u000f\u001b\u0015\u0005\u0003C\u000b\t\u0004\u0003\u0004\u0002*\u0002!\taV\u0001\u001di\u0016\u001cH\u000f\u0012:paR\u000b'\r\\3XSRD\u0007+\u0019:uS\u0006d\u0007+\u0019;iQ\u0011\t9+!\r\t\r\u0005=\u0006\u0001\"\u0001X\u0003q!Xm\u001d;Ee>\u0004H+\u00192mK^KG\u000f[%om\u0006d\u0017\u000e\u001a)bi\"D\u0003\"!,\u00022\u0005%\u00131\n\u0005\u0007\u0003k\u0003A\u0011A,\u0002IQ,7\u000f\u001e#s_B$\u0016M\u00197f/&$\b.\u00138wC2LG\rU1uQ&3W\t_5tiNDC!a-\u00022!1\u00111\u0018\u0001\u0005\u0002]\u000bq\u0005^3ti\u0012\u0013x\u000e\u001d+bE2,7+Y7f\u001d\u0006lWmV5uQR+W\u000e]8sCJLH+\u00192mK\"\"\u0011\u0011XA\u0019\u0011\u0019\t\t\r\u0001C\u0001/\u0006iB/Z:u\tJ|\u0007OV5foN\u000bW.\u001a(b[\u0016<\u0016\u000e\u001e5UC\ndW\r\u000b\u0003\u0002@\u0006E\u0002BBAd\u0001\u0011\u0005q+\u0001\u0015uKN$HI]8q-&,woU1nK:\u000bW.Z,ji\"$\u0016M\u00197f\u0013\u001atu\u000e^#ySN$8\u000f\u000b\u0003\u0002F\u0006E\u0002BBAg\u0001\u0011\u0005q+\u0001\buKN$\u0018\t\u001c;feR\u000b'\r\\3)\t\u0005-\u0017\u0011\u0007\u0005\u0007\u0003'\u0004A\u0011A,\u0002CQ,7\u000f^\"sK\u0006$X\rV1cY\u0016\fe\u000eZ*i_^\u001c%/Z1uKR\u000b'\r\\3)\t\u0005E\u0017\u0011\u0007\u0005\u0007\u00033\u0004A\u0011A,\u0002AQ,7\u000f^\"sK\u0006$XMV5fo\u0006sGm\u00155po\u000e\u0013X-\u0019;f)\u0006\u0014G.\u001a\u0015\u0005\u0003/\f\t\u0004\u0003\u0004\u0002`\u0002!\taV\u0001\u0014i\u0016\u001cH/\u00117uKJ4\u0016.Z<SK:\fW.\u001a\u0015\u0005\u0003;\f\t\u0004\u0003\u0004\u0002f\u0002!\taV\u0001\u0010i\u0016\u001cH/\u00117uKJ4\u0016.Z<Bg\"\"\u00111]A\u0019\u0011\u0019\tY\u000f\u0001C\u0001/\u0006\u0019C/Z:u+N,7)\u0019;bY><\u0017I\u001c3TQ><8)\u001e:sK:$8)\u0019;bY><\u0007\u0006BAu\u0003cAa!!=\u0001\t\u00039\u0016!\n;fgR,6/\u001a#bi\u0006\u0014\u0017m]3B]\u0012\u001c\u0006n\\<DkJ\u0014XM\u001c;ECR\f'-Y:fQ\u0011\ty/!\r\t\r\u0005]\b\u0001\"\u0001X\u0003I!Xm\u001d;De\u0016\fG/\u001a#bi\u0006\u0014\u0017m]3)\t\u0005U\u0018\u0011\u0007\u0005\u0007\u0003{\u0004A\u0011A,\u0002!Q,7\u000f\u001e#s_B$\u0015\r^1cCN,\u0007\u0006BA~\u0003cAaAa\u0001\u0001\t\u00039\u0016!\u0005;fgR\fE\u000e^3s\t\u0006$\u0018MY1tK\"\"!\u0011AA\u0019\u0011\u0019\u0011I\u0001\u0001C\u0001/\u0006\u0001B/Z:u\u0019>\fGMR;oGRLwN\u001c\u0015\u0005\u0005\u000f\t\t\u0004K\u0004\u0001\u0005\u001f\u0011YB!\b\u0011\t\tE!qC\u0007\u0003\u0005'Q1A!\u0006A\u0003\u0019\u0011XO\u001c8fe&!!\u0011\u0004B\n\u0005\u001d\u0011VO\\,ji\"\fQA^1mk\u0016\u001c#Aa\b\u0011\t\t\u0005\"qE\u0007\u0003\u0005GQ1A!\nA\u0003\u001d\u0011XO\u001c8feNLAA!\u000b\u0003$\ti\u0001+\u0019:b[\u0016$XM]5{K\u0012<qA!\f\u0003\u0011\u0003\u0011y#\u0001\nDCR\fGn\\4UC\ndW-\u0013+DCN,\u0007c\u0001\u0013\u00032\u00191\u0011A\u0001E\u0001\u0005g\u0019BA!\r\u00036A\u00191Da\u000e\n\u0007\teBD\u0001\u0004B]f\u0014VM\u001a\u0005\bC\tEB\u0011\u0001B\u001f)\t\u0011y\u0003\u0003\u0005\u0003B\tEB\u0011\u0001B\"\u0003)\u0001\u0018M]1nKR,'o\u001d\u000b\u0003\u0005\u000b\u0002R!!\u0001\u0003HiIAA!\u0013\u0002\u0004\tQ1i\u001c7mK\u000e$\u0018n\u001c8)\u0011\t}\"Q\nB.\u0005;\u0002BAa\u0014\u0003V9!!\u0011\u0005B)\u0013\u0011\u0011\u0019Fa\t\u0002\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u0013\u0011\u00119F!\u0017\u0003\u0015A\u000b'/Y7fi\u0016\u00148O\u0003\u0003\u0003T\t\r\u0012\u0001\u00028b[\u0016\f#Aa\u0018\u0002\u0007m\u0004T\u0010")
public class CatalogTableITCase
extends AbstractTestBase {
    private final boolean isStreamingMode;
    private final EnvironmentSettings settings;
    private final TableEnvironment tableEnv;
    private ExpectedException _expectedEx;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object> parameters() {
        return CatalogTableITCase$.MODULE$.parameters();
    }

    private EnvironmentSettings settings() {
        return this.settings;
    }

    private TableEnvironment tableEnv() {
        return this.tableEnv;
    }

    public ExpectedException _expectedEx() {
        return this._expectedEx;
    }

    public void _expectedEx_$eq(ExpectedException x$1) {
        this._expectedEx = x$1;
    }

    @Rule
    public ExpectedException expectedEx() {
        return this._expectedEx();
    }

    @Before
    public void before() {
        this.tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)BoxesRunTime.boxToInteger((int)1));
        TestCollectionTableFactory$.MODULE$.reset();
        CatalogFunctionImpl func = new CatalogFunctionImpl(JavaUserDefinedScalarFunctions.JavaFunc0.class.getName());
        ((Catalog)this.tableEnv().getCatalog(this.tableEnv().getCurrentCatalog()).get()).createFunction(new ObjectPath(this.tableEnv().getCurrentDatabase(), "myfunc"), (CatalogFunction)func, true);
    }

    public Ordering<Row> rowOrdering() {
        return package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)r -> {
            StringBuilder builder = new StringBuilder();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), r.getArity()).foreach((Function1 & Serializable & scala.Serializable)idx -> builder.append(r.getField(BoxesRunTime.unboxToInt((Object)idx))));
            return builder.toString();
        }, (Ordering)Ordering.String$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public Row toRow(Seq<Object> args) {
        void var2_2;
        Row row = new Row(args.length());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), args.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> row.setField(i, args.apply(i)));
        return var2_2;
    }

    public Map<String, String> getTableOptions(String tableName) {
        return ((Catalog)this.tableEnv().getCatalog(this.tableEnv().getCurrentCatalog()).get()).getTable(new ObjectPath(this.tableEnv().getCurrentDatabase(), tableName)).getOptions();
    }

    private void testUdf(String funcPrefix) {
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(159).append("\n         |create table sinkT(\n         |  a bigint\n         |) with (\n         |  'connector' = 'COLLECTION',\n         |  'is-bounded' = '").append(this.isStreamingMode).append("'\n         |)\n      ").toString())).stripMargin();
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(new java.lang.StringBuilder(50).append("insert into sinkT select ").append(funcPrefix).append("myfunc(cast(1 as bigint))").toString()).await();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L)}))})), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @Test
    public void testUdfWithFullIdentifier() {
        this.testUdf("default_catalog.default_database.");
    }

    @Test
    public void testUdfWithDatabase() {
        this.testUdf("default_database.");
    }

    @Test
    public void testUdfWithNon() {
        this.testUdf("");
    }

    @Test(expected=ValidationException.class)
    public void testUdfWithWrongCatalog() {
        this.testUdf("wrong_catalog.default_database.");
    }

    @Test(expected=ValidationException.class)
    public void testUdfWithWrongDatabase() {
        this.testUdf("default_catalog.wrong_database.");
    }

    @Test
    public void testInsertInto() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2), new BigDecimal("10.001")})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3), new BigDecimal("10.001")})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4), new BigDecimal("10.001")})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2), new BigDecimal("10.001")})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3), new BigDecimal("10.001")})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a int,\n        |  b varchar,\n        |  c int,\n        |  d DECIMAL(10, 3)\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a int,\n        |  b varchar,\n        |  c int,\n        |  d DECIMAL(10, 3)\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select t1.a, t1.b, (t1.a + 1) as c , d from t1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(query).await();
        Assert.assertEquals((Object)sourceData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @Test
    public void testReadWriteCsvUsingDDL() {
        Seq csvRecords = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2.02,Euro,2019-12-12 00:00:01.001001", "1.11,US Dollar,2019-12-12 00:00:02.002001", "50,Yen,2019-12-12 00:00:04.004001", "3.1,Euro,2019-12-12 00:00:05.005001", "5.33,US Dollar,2019-12-12 00:00:06.006001"}));
        String tempFilePath = this.createTempFile("csv-order-test", csvRecords.mkString("#"));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(439).append("\n         |CREATE TABLE T1 (\n         |  price DECIMAL(10, 2),\n         |  currency STRING,\n         |  ts6 TIMESTAMP(6),\n         |  ts AS CAST(ts6 AS TIMESTAMP(3)),\n         |  WATERMARK FOR ts AS ts\n         |) WITH (\n         |  'connector.type' = 'filesystem',\n         |  'connector.path' = '").append(tempFilePath).append("',\n         |  'format.type' = 'csv',\n         |  'format.field-delimiter' = ',',\n         |  'format.line-delimiter' = '#'\n         |)\n     ").toString())).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        String sinkFilePath = this.getTempFilePath("csv-order-sink");
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(361).append("\n         |CREATE TABLE T2 (\n         |  window_end TIMESTAMP(3),\n         |  max_ts TIMESTAMP(6),\n         |  counter BIGINT,\n         |  total_price DECIMAL(10, 2)\n         |) with (\n         |  'connector.type' = 'filesystem',\n         |  'connector.path' = '").append(sinkFilePath).append("',\n         |  'format.type' = 'csv',\n         |  'format.field-delimiter' = ','\n         |)\n      ").toString())).stripMargin();
        this.tableEnv().executeSql(sinkDDL);
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO T2\n        |SELECT\n        |  TUMBLE_END(ts, INTERVAL '5' SECOND),\n        |  MAX(ts6),\n        |  COUNT(*),\n        |  MAX(price)\n        |FROM T1\n        |GROUP BY TUMBLE(ts, INTERVAL '5' SECOND)\n      ")).stripMargin();
        this.tableEnv().executeSql(query).await();
        String expected = "2019-12-12 00:00:05.0,2019-12-12 00:00:04.004001,3,50.00\n2019-12-12 00:00:10.0,2019-12-12 00:00:06.006001,2,5.33\n";
        Assert.assertEquals((Object)expected, (Object)FileUtils.readFileUtf8((File)new File(new URI(sinkFilePath))));
    }

    @Test
    public void testReadWriteCsvWithDynamicTableOptions() {
        Seq csvRecords = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2.02,Euro,2019-12-12 00:00:01.001001", "1.11,US Dollar,2019-12-12 00:00:02.002001", "50,Yen,2019-12-12 00:00:04.004001", "3.1,Euro,2019-12-12 00:00:05.005001", "5.33,US Dollar,2019-12-12 00:00:06.006001"}));
        String tempFilePath = this.createTempFile("csv-order-test", csvRecords.mkString("#"));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(396).append("\n         |CREATE TABLE T1 (\n         |  price DECIMAL(10, 2),\n         |  currency STRING,\n         |  ts6 TIMESTAMP(6),\n         |  ts AS CAST(ts6 AS TIMESTAMP(3)),\n         |  WATERMARK FOR ts AS ts\n         |) WITH (\n         |  'connector.type' = 'filesystem',\n         |  'connector.path' = '").append(tempFilePath).append("',\n         |  'format.type' = 'csv',\n         |  'format.field-delimiter' = ','\n         |)\n     ").toString())).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        String sinkFilePath = this.getTempFilePath("csv-order-sink");
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(317).append("\n         |CREATE TABLE T2 (\n         |  window_end TIMESTAMP(3),\n         |  max_ts TIMESTAMP(6),\n         |  counter BIGINT,\n         |  total_price DECIMAL(10, 2)\n         |) with (\n         |  'connector.type' = 'filesystem',\n         |  'connector.path' = '").append(sinkFilePath).append("',\n         |  'format.type' = 'csv'\n         |)\n      ").toString())).stripMargin();
        this.tableEnv().executeSql(sinkDDL);
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO T2 /*+ OPTIONS('format.field-delimiter' = '|') */\n        |SELECT\n        |  TUMBLE_END(ts, INTERVAL '5' SECOND),\n        |  MAX(ts6),\n        |  COUNT(*),\n        |  MAX(price)\n        |FROM T1 /*+ OPTIONS('format.line-delimiter' = '#') */\n        |GROUP BY TUMBLE(ts, INTERVAL '5' SECOND)\n      ")).stripMargin();
        this.tableEnv().executeSql(query).await();
        String expected = "2019-12-12 00:00:05.0|2019-12-12 00:00:04.004001|3|50.00\n2019-12-12 00:00:10.0|2019-12-12 00:00:06.006001|2|5.33\n";
        Assert.assertEquals((Object)expected, (Object)FileUtils.readFileUtf8((File)new File(new URI(sinkFilePath))));
    }

    @Test
    public void testInsertSourceTableExpressionFields() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000"})), (List)Nil$.MODULE$)))));
        .colon.colon expected = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a int,\n        |  b varchar,\n        |  c as a + 1\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select t1.a, t1.b, t1.c from t1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(query).await();
        Assert.assertEquals((Object)expected.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @Test
    public void testInsertSourceTableExpressionFieldsBeforeReferences() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "2"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000"})), (List)Nil$.MODULE$)))));
        .colon.colon expected = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)101), BoxesRunTime.boxToInteger((int)1), "1000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)102), BoxesRunTime.boxToInteger((int)2), "1"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)103), BoxesRunTime.boxToInteger((int)3), "2000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)102), BoxesRunTime.boxToInteger((int)2), "2"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)102), BoxesRunTime.boxToInteger((int)2), "3000"})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  c as a + 100,\n        |  a int,\n        |  b varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  c int,\n        |  a int,\n        |  b varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select t1.c, t1.a, t1.b from t1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(query).await();
        Assert.assertEquals((Object)expected.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @Test
    public void testInsertSourceTableWithFuncField() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1990-02-10 12:34:56"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "2019-09-10 09:23:41"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2019-09-10 09:23:42"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2019-09-10 09:23:43"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "2019-09-10 09:23:44"})), (List)Nil$.MODULE$)))));
        .colon.colon expected = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1990-02-10 12:34:56", DateTimeTestUtil$.MODULE$.localDateTime("1990-02-10 12:34:56")})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "2019-09-10 09:23:41", DateTimeTestUtil$.MODULE$.localDateTime("2019-09-10 09:23:41")})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2019-09-10 09:23:42", DateTimeTestUtil$.MODULE$.localDateTime("2019-09-10 09:23:42")})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2019-09-10 09:23:43", DateTimeTestUtil$.MODULE$.localDateTime("2019-09-10 09:23:43")})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "2019-09-10 09:23:44", DateTimeTestUtil$.MODULE$.localDateTime("2019-09-10 09:23:44")})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a int,\n        |  b varchar,\n        |  c as to_timestamp(b)\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a int,\n        |  b varchar,\n        |  c timestamp(3)\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select t1.a, t1.b, t1.c from t1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(query).await();
        Assert.assertEquals((Object)expected.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @Test
    public void testInsertSourceTableWithUserDefinedFuncField() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1990-02-10 12:34:56"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "2019-09-10 9:23:41"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2019-09-10 9:23:42"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2019-09-10 9:23:43"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "2019-09-10 9:23:44"})), (List)Nil$.MODULE$)))));
        .colon.colon expected = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1990-02-10 12:34:56", BoxesRunTime.boxToInteger((int)1), "1990-02-10 12:34:56"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "2019-09-10 9:23:41", BoxesRunTime.boxToInteger((int)2), "2019-09-10 9:23:41"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2019-09-10 9:23:42", BoxesRunTime.boxToInteger((int)3), "2019-09-10 9:23:42"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2019-09-10 9:23:43", BoxesRunTime.boxToInteger((int)1), "2019-09-10 9:23:43"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "2019-09-10 9:23:44", BoxesRunTime.boxToInteger((int)2), "2019-09-10 9:23:44"})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        this.tableEnv().registerFunction("my_udf", (ScalarFunction)Func0$.MODULE$);
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a int,\n        |  `time` varchar,\n        |  c as my_udf(a),\n        |  d as `time`\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a int,\n        |  `time` varchar,\n        |  c int not null,\n        |  d varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select t1.a, t1.`time`, t1.c, t1.d from t1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(query).await();
        Assert.assertEquals((Object)expected.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @Test
    public void testInsertSinkTableExpressionFields() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000"})), (List)Nil$.MODULE$)))));
        .colon.colon expected = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a int,\n        |  b varchar,\n        |  c as a + 1\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a int,\n        |  b as c - 1,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select t1.a, t1.c from t1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(query).await();
        Assert.assertEquals((Object)expected.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @Test
    public void testInsertSinkTableWithUnmatchedFields() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2"})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000"})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a int,\n        |  b varchar,\n        |  c as a + 1\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a int,\n        |  b as cast(a as varchar(20)) || cast(c as varchar(20)),\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select t1.a, t1.b from t1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.expectedEx().expect(ValidationException.class);
        this.expectedEx().expectMessage("Incompatible types for sink column 'c' at position 1.");
        this.tableEnv().executeSql(query).await();
    }

    @Test
    public void testInsertWithJoinedSource() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2000), BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3000), BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        .colon.colon expected = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3000), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a int,\n        |  b int,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a int,\n        |  b int,\n        |  c int,\n        |  d int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select a.a, a.b, b.a, b.b\n        |  from t1 a\n        |  join t1 b\n        |  on a.a = b.b\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(query).await();
        Assert.assertEquals((Object)expected.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @Test
    public void testInsertWithAggregateSource() {
        if (this.isStreamingMode) {
            return;
        }
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2000), BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)2000), BoxesRunTime.boxToInteger((int)5)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)3000), BoxesRunTime.boxToInteger((int)6)})), (List)Nil$.MODULE$)))));
        .colon.colon expected = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)1000)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)3000)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), BoxesRunTime.boxToInteger((int)2000)})), (List)Nil$.MODULE$)));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a int,\n        |  b int,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a int,\n        |  b int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select sum(a), t1.b from t1 group by t1.b\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(query).await();
        Assert.assertEquals((Object)expected.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @Test
    public void testTemporaryTableMaskPermanentTableWithSameName() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        String permanentTable = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  d int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String temporaryTable = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TEMPORARY TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int,\n        |  d as c+1\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkTable = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T2(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        .colon.colon permanentData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        .colon.colon temporaryData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)5)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$)))));
        this.tableEnv().executeSql(permanentTable);
        this.tableEnv().executeSql(temporaryTable);
        this.tableEnv().executeSql(sinkTable);
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String query = "SELECT a, b, d FROM T1";
        this.tableEnv().sqlQuery(query).executeInsert("T2").await();
        Assert.assertEquals((Object)temporaryData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
        TestCollectionTableFactory$.MODULE$.reset();
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String dropTemporaryTable = new StringOps(Predef$.MODULE$.augmentString("\n        |DROP TEMPORARY TABLE IF EXISTS T1\n      ")).stripMargin();
        this.tableEnv().executeSql(dropTemporaryTable);
        this.tableEnv().sqlQuery(query).executeInsert("T2").await();
        Assert.assertEquals((Object)permanentData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @Test
    public void testDropTableWithFullPath() {
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String ddl2 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a bigint,\n        |  b bigint\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(ddl1);
        this.tableEnv().executeSql(ddl2);
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2"})));
        this.tableEnv().executeSql("DROP TABLE default_catalog.default_database.t2");
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
    }

    @Test
    public void testDropTableWithPartialPath() {
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        | 'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String ddl2 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a bigint,\n        |  b bigint\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(ddl1);
        this.tableEnv().executeSql(ddl2);
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2"})));
        this.tableEnv().executeSql("DROP TABLE default_database.t2");
        this.tableEnv().executeSql("DROP TABLE t1");
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables())).isEmpty());
    }

    @Test(expected=ValidationException.class)
    public void testDropTableWithInvalidPath() {
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(ddl1);
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
        this.tableEnv().executeSql("DROP TABLE catalog1.database1.t1");
    }

    @Test
    public void testDropTableWithInvalidPathIfExists() {
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(ddl1);
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
        this.tableEnv().executeSql("DROP TABLE IF EXISTS catalog1.database1.t1");
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
    }

    @Test
    public void testDropTableSameNameWithTemporaryTable() {
        String createTable1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String createTable2 = new StringOps(Predef$.MODULE$.augmentString("\n        |create temporary table t1(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(createTable1);
        this.tableEnv().executeSql(createTable2);
        this.expectedEx().expect(ValidationException.class);
        this.expectedEx().expectMessage("Temporary table with identifier '`default_catalog`.`default_database`.`t1`' exists. Drop it first before removing the permanent table.");
        this.tableEnv().executeSql("drop table t1");
    }

    @Test
    public void testDropViewSameNameWithTable() {
        String createTable1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(createTable1);
        this.expectedEx().expect(ValidationException.class);
        this.expectedEx().expectMessage("View with identifier 'default_catalog.default_database.t1' does not exist.");
        this.tableEnv().executeSql("drop view t1");
    }

    @Test
    public void testDropViewSameNameWithTableIfNotExists() {
        String createTable1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(createTable1);
        this.tableEnv().executeSql("drop view if exists t1");
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
    }

    @Test
    public void testAlterTable() {
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a bigint not null,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION',\n        |  'k1' = 'v1'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(ddl1);
        this.tableEnv().executeSql("alter table t1 rename to t2");
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2"})));
        this.tableEnv().executeSql("alter table t2 set ('k1' = 'a', 'k2' = 'b')");
        HashMap<String, String> expectedOptions = new HashMap<String, String>();
        expectedOptions.put("connector", "COLLECTION");
        expectedOptions.put("k1", "a");
        expectedOptions.put("k2", "b");
        Assert.assertEquals(expectedOptions, this.getTableOptions("t2"));
        this.tableEnv().executeSql("alter table t2 reset ('k1')");
        expectedOptions.remove("k1");
        Assert.assertEquals(expectedOptions, this.getTableOptions("t2"));
        String currentCatalog = this.tableEnv().getCurrentCatalog();
        String currentDB = this.tableEnv().getCurrentDatabase();
        this.tableEnv().executeSql("alter table t2 add constraint ct1 primary key(a) not enforced");
        TableSchema tableSchema1 = ((Catalog)this.tableEnv().getCatalog(currentCatalog).get()).getTable(ObjectPath.fromString((String)new java.lang.StringBuilder(3).append(currentDB).append(".t2").toString())).getSchema();
        Predef$.MODULE$.assert(tableSchema1.getPrimaryKey().isPresent());
        Assert.assertEquals((Object)"CONSTRAINT ct1 PRIMARY KEY (a)", (Object)((UniqueConstraint)tableSchema1.getPrimaryKey().get()).asSummaryString());
        this.tableEnv().executeSql("alter table t2 drop constraint ct1");
        TableSchema tableSchema2 = ((Catalog)this.tableEnv().getCatalog(currentCatalog).get()).getTable(ObjectPath.fromString((String)new java.lang.StringBuilder(3).append(currentDB).append(".t2").toString())).getSchema();
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)tableSchema2.getPrimaryKey().isPresent()));
    }

    @Test
    public void testCreateTableAndShowCreateTable() {
        String executedDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create temporary table TBL1 (\n        |  a bigint not null,\n        |  h string,\n        |  g as 2*(a+1),\n        |  b string not null,\n        |  c bigint metadata virtual,\n        |  e row<name string, age int, flag boolean>,\n        |  f as myfunc(a),\n        |  ts1 timestamp(3),\n        |  ts2 timestamp_ltz(3) metadata from 'timestamp',\n        |  `__source__` varchar(255),\n        |  proc as proctime(),\n        |  watermark for ts1 as cast(timestampadd(hour, 8, ts1) as timestamp(3)),\n        |  constraint test_constraint primary key (a, b) not enforced\n        |) comment 'test show create table statement'\n        |partitioned by (b,h)\n        |with (\n        |  'connector' = 'kafka',\n        |  'kafka.topic' = 'log.test'\n        |)\n        |")).stripMargin();
        String expectedDDL = new StringOps(Predef$.MODULE$.augmentString(" |CREATE TEMPORARY TABLE `default_catalog`.`default_database`.`TBL1` (\n        |  `a` BIGINT NOT NULL,\n        |  `h` VARCHAR(2147483647),\n        |  `g` AS 2 * (`a` + 1),\n        |  `b` VARCHAR(2147483647) NOT NULL,\n        |  `c` BIGINT METADATA VIRTUAL,\n        |  `e` ROW<`name` VARCHAR(2147483647), `age` INT, `flag` BOOLEAN>,\n        |  `f` AS `default_catalog`.`default_database`.`myfunc`(`a`),\n        |  `ts1` TIMESTAMP(3),\n        |  `ts2` TIMESTAMP(3) WITH LOCAL TIME ZONE METADATA FROM 'timestamp',\n        |  `__source__` VARCHAR(255),\n        |  `proc` AS PROCTIME(),\n        |  WATERMARK FOR `ts1` AS CAST(TIMESTAMPADD(HOUR, 8, `ts1`) AS TIMESTAMP(3)),\n        |  CONSTRAINT `test_constraint` PRIMARY KEY (`a`, `b`) NOT ENFORCED\n        |) COMMENT 'test show create table statement'\n        |PARTITIONED BY (`b`, `h`)\n        |WITH (\n        |  'connector' = 'kafka',\n        |  'kafka.topic' = 'log.test'\n        |)\n        |")).stripMargin();
        this.tableEnv().executeSql(executedDDL);
        Row row = (Row)this.tableEnv().executeSql("SHOW CREATE TABLE `TBL1`").collect().next();
        Assert.assertEquals((Object)expectedDDL, (Object)row.getField(0));
        this.expectedEx().expect(ValidationException.class);
        this.expectedEx().expectMessage("Could not execute SHOW CREATE TABLE. Table with identifier `default_catalog`.`default_database`.`tmp` does not exist.");
        this.tableEnv().executeSql("SHOW CREATE TABLE `tmp`");
    }

    @Test
    public void testCreateViewAndShowCreateTable() {
        String createTableDDL = new StringOps(Predef$.MODULE$.augmentString(" |create table `source` (\n        |  `id` bigint not null,\n        | `group` string not null,\n        | `score` double\n        |) with (\n        |  'connector' = 'source-only'\n        |)\n        |")).stripMargin();
        String createViewDDL = new StringOps(Predef$.MODULE$.augmentString(" |create view `tmp` as\n        |select `group`, avg(`score`) as avg_score\n        |from `source`\n        |group by `group`\n        |")).stripMargin();
        this.tableEnv().executeSql(createTableDDL);
        this.tableEnv().executeSql(createViewDDL);
        this.expectedEx().expect(TableException.class);
        this.expectedEx().expectMessage("SHOW CREATE TABLE is only supported for tables, but `default_catalog`.`default_database`.`tmp` is a view. Please use SHOW CREATE VIEW instead.");
        this.tableEnv().executeSql("SHOW CREATE TABLE `tmp`");
    }

    @Test
    public void testAlterViewRename() {
        this.tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                          | CREATE TABLE T (\n                          |   id INT\n                          | ) WITH (\n                          |   'connector' = 'source-only'\n                          | )\n                          |")).stripMargin());
        this.tableEnv().executeSql("CREATE VIEW V AS SELECT * FROM T");
        this.tableEnv().executeSql("ALTER VIEW V RENAME TO V2");
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listViews())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"V2"})));
    }

    @Test
    public void testAlterViewAs() {
        this.tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                          | CREATE TABLE T (\n                          |   a INT,\n                          |   b INT\n                          | ) WITH (\n                          |   'connector' = 'source-only'\n                          | )\n                          |")).stripMargin());
        this.tableEnv().executeSql("CREATE VIEW V AS SELECT a FROM T");
        this.tableEnv().executeSql("ALTER VIEW V AS SELECT b FROM T");
        ObjectPath objectPath = new ObjectPath(this.tableEnv().getCurrentDatabase(), "V");
        CatalogView view = (CatalogView)((Catalog)this.tableEnv().getCatalog(this.tableEnv().getCurrentCatalog()).get()).getTable(objectPath);
        Assert.assertEquals((Object)"SELECT `b`\nFROM `T`", (Object)view.getOriginalQuery());
    }

    @Test
    public void testUseCatalogAndShowCurrentCatalog() {
        this.tableEnv().registerCatalog("cat1", (Catalog)new GenericInMemoryCatalog("cat1"));
        this.tableEnv().registerCatalog("cat2", (Catalog)new GenericInMemoryCatalog("cat2"));
        this.tableEnv().executeSql("use catalog cat1");
        Assert.assertEquals((Object)"cat1", (Object)this.tableEnv().getCurrentCatalog());
        this.tableEnv().executeSql("use catalog cat2");
        Assert.assertEquals((Object)"cat2", (Object)this.tableEnv().getCurrentCatalog());
        Assert.assertEquals((Object)"+I[cat2]", (Object)((Row)this.tableEnv().executeSql("show current catalog").collect().next()).toString());
    }

    @Test
    public void testUseDatabaseAndShowCurrentDatabase() {
        GenericInMemoryCatalog catalog = new GenericInMemoryCatalog("cat1");
        this.tableEnv().registerCatalog("cat1", (Catalog)catalog);
        CatalogDatabaseImpl catalogDB1 = new CatalogDatabaseImpl(new HashMap(), "db1");
        CatalogDatabaseImpl catalogDB2 = new CatalogDatabaseImpl(new HashMap(), "db2");
        catalog.createDatabase("db1", (CatalogDatabase)catalogDB1, true);
        catalog.createDatabase("db2", (CatalogDatabase)catalogDB2, true);
        this.tableEnv().executeSql("use cat1.db1");
        Assert.assertEquals((Object)"db1", (Object)this.tableEnv().getCurrentDatabase());
        String currentDatabase = ((Row)this.tableEnv().executeSql("show current database").collect().next()).toString();
        Assert.assertEquals((Object)"+I[db1]", (Object)currentDatabase);
        this.tableEnv().executeSql("use db2");
        Assert.assertEquals((Object)"db2", (Object)this.tableEnv().getCurrentDatabase());
        currentDatabase = ((Row)this.tableEnv().executeSql("show current database").collect().next()).toString();
        Assert.assertEquals((Object)"+I[db2]", (Object)currentDatabase);
    }

    @Test
    public void testCreateDatabase() {
        this.tableEnv().registerCatalog("cat1", (Catalog)new GenericInMemoryCatalog("default"));
        this.tableEnv().registerCatalog("cat2", (Catalog)new GenericInMemoryCatalog("default"));
        this.tableEnv().executeSql("use catalog cat1");
        this.tableEnv().executeSql("create database db1 ");
        this.tableEnv().executeSql("create database if not exists db1 ");
        try {
            this.tableEnv().executeSql("create database db1 ");
            Assert.fail((String)"ValidationException expected");
        }
        catch (ValidationException validationException) {}
        this.tableEnv().executeSql("create database cat2.db1 comment 'test_comment' with ('k1' = 'v1', 'k2' = 'v2')");
        CatalogDatabase database = ((Catalog)this.tableEnv().getCatalog("cat2").get()).getDatabase("db1");
        Assert.assertEquals((Object)"test_comment", (Object)database.getComment());
        Assert.assertEquals((long)2L, (long)database.getProperties().size());
        HashMap<String, String> expectedProperty = new HashMap<String, String>();
        expectedProperty.put("k1", "v1");
        expectedProperty.put("k2", "v2");
        Assert.assertEquals(expectedProperty, (Object)database.getProperties());
    }

    @Test
    public void testDropDatabase() {
        this.tableEnv().registerCatalog("cat1", (Catalog)new GenericInMemoryCatalog("default"));
        this.tableEnv().executeSql("use catalog cat1");
        this.tableEnv().executeSql("create database db1");
        this.tableEnv().executeSql("drop database db1");
        this.tableEnv().executeSql("drop database if exists db1");
        try {
            this.tableEnv().executeSql("drop database db1");
            Assert.fail((String)"ValidationException expected");
        }
        catch (ValidationException validationException) {}
        this.tableEnv().executeSql("create database db1");
        this.tableEnv().executeSql("use db1");
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(ddl1);
        String ddl2 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a bigint,\n        |  b bigint,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(ddl2);
        try {
            this.tableEnv().executeSql("drop database db1");
            Assert.fail((String)"ValidationException expected");
        }
        catch (ValidationException validationException) {}
        this.tableEnv().executeSql("drop database db1 cascade");
    }

    @Test
    public void testAlterDatabase() {
        this.tableEnv().registerCatalog("cat1", (Catalog)new GenericInMemoryCatalog("default"));
        this.tableEnv().executeSql("use catalog cat1");
        this.tableEnv().executeSql("create database db1 comment 'db1_comment' with ('k1' = 'v1')");
        this.tableEnv().executeSql("alter database db1 set ('k1' = 'a', 'k2' = 'b')");
        CatalogDatabase database = ((Catalog)this.tableEnv().getCatalog("cat1").get()).getDatabase("db1");
        Assert.assertEquals((Object)"db1_comment", (Object)database.getComment());
        Assert.assertEquals((long)2L, (long)database.getProperties().size());
        HashMap<String, String> expectedProperty = new HashMap<String, String>();
        expectedProperty.put("k1", "a");
        expectedProperty.put("k2", "b");
        Assert.assertEquals(expectedProperty, (Object)database.getProperties());
    }

    @Test
    public void testLoadFunction() {
        this.tableEnv().registerCatalog("cat2", (Catalog)new TestValuesCatalog("cat2", "default", true));
        this.tableEnv().executeSql("use catalog cat2");
        Random random = new Random();
        String udfClassName = new java.lang.StringBuilder(8).append("LowerUDF").append(random.nextInt(50)).toString();
        String jarPath = UserClassLoaderJarTestUtils.createJarFile((File)AbstractTestBase.TEMPORARY_FOLDER.newFolder(String.format("test-jar-%s", UUID.randomUUID())), (String)"test-classloader-udf.jar", (String)udfClassName, (String)String.format("public class %s extends org.apache.flink.table.functions.ScalarFunction {\n  public String eval(String str) {\n    return str.toLowerCase();\n  }\n}\n", udfClassName)).toURI().toString();
        this.tableEnv().executeSql(new java.lang.StringBuilder(43).append("create function lowerUdf as '").append(udfClassName).append("' using jar '").append(jarPath).append("'").toString());
        TestCollectionTableFactory$.MODULE$.reset();
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)Row.of((Object[])new Object[]{"BoB"}), (List)Nil$.MODULE$)));
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a varchar\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(ddl1);
        Assert.assertEquals((Object)"+I[bob]", (Object)((Row)this.tableEnv().executeSql("select lowerUdf(a) from t1").collect().next()).toString());
    }

    public CatalogTableITCase(boolean isStreamingMode) {
        this.isStreamingMode = isStreamingMode;
        this.settings = isStreamingMode ? EnvironmentSettings.newInstance().inStreamingMode().build() : EnvironmentSettings.newInstance().inBatchMode().build();
        this.tableEnv = TableEnvironmentImpl.create((EnvironmentSettings)this.settings());
        this._expectedEx = ExpectedException.none();
    }
}

