/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.catalog.CatalogViewITCase$;
import org.apache.flink.table.planner.factories.TableFactoryHarness;
import org.apache.flink.table.planner.factories.utils.TestCollectionTableFactory$;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\u0001\u0003\u0001=\u0011\u0011cQ1uC2|wMV5fo&#6)Y:f\u0015\t\u0019A!A\u0004dCR\fGn\\4\u000b\u0005\u00151\u0011a\u00029mC:tWM\u001d\u0006\u0003\u000f!\tQ\u0001^1cY\u0016T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012-5\t!C\u0003\u0002\u0014)\u0005!Q\u000f^5m\u0015\t)\u0002\"\u0001\u0003uKN$\u0018BA\f\u0013\u0005A\t%m\u001d;sC\u000e$H+Z:u\u0005\u0006\u001cX\r\u0003\u0005\u001a\u0001\t\u0005\t\u0015!\u0003\u001b\u0003=I7o\u0015;sK\u0006l\u0017N\\4N_\u0012,\u0007CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006C\u0001!\tAI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\r*\u0003C\u0001\u0013\u0001\u001b\u0005\u0011\u0001\"B\r!\u0001\u0004Q\u0002bB\u0014\u0001\u0005\u0004%I\u0001K\u0001\tg\u0016$H/\u001b8hgV\t\u0011\u0006\u0005\u0002+[5\t1F\u0003\u0002-\r\u0005\u0019\u0011\r]5\n\u00059Z#aE#om&\u0014xN\\7f]R\u001cV\r\u001e;j]\u001e\u001c\bB\u0002\u0019\u0001A\u0003%\u0011&A\u0005tKR$\u0018N\\4tA!9!\u0007\u0001b\u0001\n\u0013\u0019\u0014\u0001\u0003;bE2,WI\u001c<\u0016\u0003Q\u0002\"AK\u001b\n\u0005YZ#\u0001\u0005+bE2,WI\u001c<je>tW.\u001a8u\u0011\u0019A\u0004\u0001)A\u0005i\u0005IA/\u00192mK\u0016sg\u000f\t\u0005\bu\u0001\u0001\r\u0011\"\u0001<\u0003-yV\r\u001f9fGR,G-\u0012=\u0016\u0003q\u0002\"!\u0010\"\u000e\u0003yR!a\u0010!\u0002\u000bI,H.Z:\u000b\u0005\u0005c\u0011!\u00026v]&$\u0018BA\"?\u0005E)\u0005\u0010]3di\u0016$W\t_2faRLwN\u001c\u0005\b\u000b\u0002\u0001\r\u0011\"\u0001G\u0003=yV\r\u001f9fGR,G-\u0012=`I\u0015\fHCA$K!\tY\u0002*\u0003\u0002J9\t!QK\\5u\u0011\u001dYE)!AA\u0002q\n1\u0001\u001f\u00132\u0011\u0019i\u0005\u0001)Q\u0005y\u0005aq,\u001a=qK\u000e$X\rZ#yA!)q\n\u0001C\u0001w\u0005QQ\r\u001f9fGR,G-\u0012=)\u00059\u000b\u0006C\u0001*T\u001b\u0005\u0001\u0015B\u0001+A\u0005\u0011\u0011V\u000f\\3\t\u000bY\u0003A\u0011A,\u0002\r\t,gm\u001c:f)\u00059\u0005FA+Z!\t\u0011&,\u0003\u0002\\\u0001\n1!)\u001a4pe\u0016DQ!\u0018\u0001\u0005\u0004y\u000b1B]8x\u001fJ$WM]5oOV\tq\fE\u0002aQ.t!!\u00194\u000f\u0005\t,W\"A2\u000b\u0005\u0011t\u0011A\u0002\u001fs_>$h(C\u0001\u001e\u0013\t9G$A\u0004qC\u000e\\\u0017mZ3\n\u0005%T'\u0001C(sI\u0016\u0014\u0018N\\4\u000b\u0005\u001dd\u0002C\u00017p\u001b\u0005i'B\u00018\t\u0003\u0015!\u0018\u0010]3t\u0013\t\u0001XNA\u0002S_^DQA\u001d\u0001\u0005\u0002M\fQ\u0001^8S_^$\"a\u001b;\t\u000bU\f\b\u0019\u0001<\u0002\t\u0005\u0014xm\u001d\t\u00047]L\u0018B\u0001=\u001d\u0005)a$/\u001a9fCR,GM\u0010\t\u00037iL!a\u001f\u000f\u0003\u0007\u0005s\u0017\u0010C\u0003~\u0001\u0011\u0005q+\u0001\u0010uKN$8I]3bi\u00164\u0016.Z<JM:{G/\u0012=jgR\u001cHk^5dK\"\u0012Ap \t\u0004%\u0006\u0005\u0011bAA\u0002\u0001\n!A+Z:u\u0011\u0019\t9\u0001\u0001C\u0001/\u0006IC/Z:u\u0007J,\u0017\r^3WS\u0016<x+\u001b;i_V$h)[3mI2K7\u000f^!oI^KG\u000f[*uCJD3!!\u0002\u0000\u0011\u0019\ti\u0001\u0001C\u0001/\u00069B/Z:u\u0007J,\u0017\r^3UK6\u0004xN]1ssZKWm\u001e\u0015\u0004\u0003\u0017y\bBBA\n\u0001\u0011\u0005q+\u0001\u0018uKN$H+Z7q_J\f'/\u001f,jK^l\u0015m]6QKJl\u0017M\\3oiZKWm^,ji\"\u001c\u0016-\\3OC6,\u0007fAA\t\u007f\"9\u0011\u0011\u0004\u0001\u0005\n\u0005m\u0011\u0001\u00062vS2$G+\u00192mK\u0012+7o\u0019:jaR|'\u000f\u0006\u0002\u0002\u001eA\u0019!&a\b\n\u0007\u0005\u00052FA\bUC\ndW\rR3tGJL\u0007\u000f^8s\u0011\u0019\t)\u0003\u0001C\u0001/\u00069C/Z:u'\"|wo\u0011:fCR,\u0017+^3ss>\u0003XM]1uS>t7)\u0019;bY><g+[3xQ\r\t\u0019c \u0005\u0007\u0003W\u0001A\u0011A,\u00027Q,7\u000f^*i_^\u001c%/Z1uKR+W\u000e]8sCJLh+[3xQ\r\tIc \u0005\u0007\u0003c\u0001A\u0011A,\u00023Q,7\u000f^*i_^\u001c%/Z1uK\u000e\u000bG/\u00197pOZKWm\u001e\u0015\u0004\u0003_y\bBBA\u001c\u0001\u0011\u0005q+A\u0013uKN$8\u000b[8x\u0007J,\u0017\r^3WS\u0016<x+\u001b;i\u0019\u00164GOS8j]\u001e\u0013x.\u001e9Cs\"\u001a\u0011QG@\t\r\u0005u\u0002\u0001\"\u0001X\u0003\t\"Xm\u001d;TQ><8I]3bi\u00164\u0016.Z<XSRDW\u000b\u0012$PkR,'OS8j]\"\u001a\u00111H@\t\r\u0005\r\u0003\u0001\"\u0001X\u0003}!Xm\u001d;TQ><8I]3bi\u00164\u0016.Z<XSRD\u0017J\u001c8fe*{\u0017N\u001c\u0015\u0004\u0003\u0003z\bf\u0002\u0001\u0002J\u0005U\u0013q\u000b\t\u0005\u0003\u0017\n\t&\u0004\u0002\u0002N)\u0019\u0011q\n!\u0002\rI,hN\\3s\u0013\u0011\t\u0019&!\u0014\u0003\u000fI+hnV5uQ\u0006)a/\u00197vK\u000e\u0012\u0011\u0011\f\t\u0005\u00037\n\t'\u0004\u0002\u0002^)\u0019\u0011q\f!\u0002\u000fI,hN\\3sg&!\u00111MA/\u00055\u0001\u0016M]1nKR,'/\u001b>fI\u001e9\u0011q\r\u0002\t\u0002\u0005%\u0014!E\"bi\u0006dwn\u001a,jK^LEkQ1tKB\u0019A%a\u001b\u0007\r\u0005\u0011\u0001\u0012AA7'\u0011\tY'a\u001c\u0011\u0007m\t\t(C\u0002\u0002tq\u0011a!\u00118z%\u00164\u0007bB\u0011\u0002l\u0011\u0005\u0011q\u000f\u000b\u0003\u0003SB\u0001\"a\u001f\u0002l\u0011\u0005\u0011QP\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cHCAA@!\u0015\t\t)!#\u001b\u001b\t\t\u0019IC\u0002\u0014\u0003\u000bS!!a\"\u0002\t)\fg/Y\u0005\u0005\u0003\u0017\u000b\u0019I\u0001\u0006D_2dWm\u0019;j_:D\u0003\"!\u001f\u0002\u0010\u0006u\u0015q\u0014\t\u0005\u0003#\u000b9J\u0004\u0003\u0002\\\u0005M\u0015\u0002BAK\u0003;\nQ\u0002U1sC6,G/\u001a:ju\u0016$\u0017\u0002BAM\u00037\u0013!\u0002U1sC6,G/\u001a:t\u0015\u0011\t)*!\u0018\u0002\t9\fW.Z\u0011\u0003\u0003C\u000b1a\u001f\u0019~\u0001")
public class CatalogViewITCase
extends AbstractTestBase {
    private final EnvironmentSettings settings;
    private final TableEnvironment tableEnv;
    private ExpectedException _expectedEx;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object> parameters() {
        return CatalogViewITCase$.MODULE$.parameters();
    }

    private EnvironmentSettings settings() {
        return this.settings;
    }

    private TableEnvironment tableEnv() {
        return this.tableEnv;
    }

    public ExpectedException _expectedEx() {
        return this._expectedEx;
    }

    public void _expectedEx_$eq(ExpectedException x$1) {
        this._expectedEx = x$1;
    }

    @Rule
    public ExpectedException expectedEx() {
        return this._expectedEx();
    }

    @Before
    public void before() {
        this.tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)BoxesRunTime.boxToInteger((int)1));
        TestCollectionTableFactory$.MODULE$.reset();
    }

    public Ordering<Row> rowOrdering() {
        return package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)r -> {
            StringBuilder builder = new StringBuilder();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), r.getArity()).foreach((Function1 & Serializable & scala.Serializable)idx -> builder.append(r.getField(BoxesRunTime.unboxToInt((Object)idx))));
            return builder.toString();
        }, (Ordering)Ordering.String$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public Row toRow(Seq<Object> args) {
        void var2_2;
        Row row = new Row(args.length());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), args.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> row.setField(i, args.apply(i)));
        return var2_2;
    }

    @Test
    public void testCreateViewIfNotExistsTwice() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T2(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String viewWith3ColumnDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW IF NOT EXISTS T3(d, e, f) AS SELECT a, b, c FROM T1\n      ")).stripMargin();
        String viewWith2ColumnDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW IF NOT EXISTS T3(d, e) AS SELECT a, b FROM T1\n      ")).stripMargin();
        String query = "SELECT d, e, f FROM T3";
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(viewWith3ColumnDDL);
        this.tableEnv().executeSql(viewWith2ColumnDDL);
        this.tableEnv().sqlQuery(query).executeInsert("T2").await();
        Assert.assertEquals((Object)sourceData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @Test
    public void testCreateViewWithoutFieldListAndWithStar() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T2(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String viewDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW IF NOT EXISTS T3 AS SELECT * FROM T1\n      ")).stripMargin();
        String query = "SELECT * FROM T3";
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(viewDDL);
        this.tableEnv().sqlQuery(query).executeInsert("T2").await();
        Assert.assertEquals((Object)sourceData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @Test
    public void testCreateTemporaryView() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T2(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String viewDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TEMPORARY VIEW T3(d, e, f) AS SELECT a, b, c FROM T1\n      ")).stripMargin();
        String query = "SELECT d, e, f FROM T3";
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(viewDDL);
        this.tableEnv().sqlQuery(query).executeInsert("T2").await();
        Assert.assertEquals((Object)sourceData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    @Test
    public void testTemporaryViewMaskPermanentViewWithSameName() {
        .colon.colon sourceData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T2(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String permanentView = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW IF NOT EXISTS T3 AS SELECT a, b, c FROM T1\n      ")).stripMargin();
        .colon.colon permanentViewData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
        String temporaryView = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TEMPORARY VIEW IF NOT EXISTS T3 AS SELECT a, b, c+1 FROM T1\n      ")).stripMargin();
        .colon.colon temporaryViewData = new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1000", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "1", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "2000", BoxesRunTime.boxToInteger((int)5)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)this.toRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "3000", BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$)))));
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(permanentView);
        this.tableEnv().executeSql(temporaryView);
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String query = "SELECT * FROM T3";
        this.tableEnv().sqlQuery(query).executeInsert("T2").await();
        Assert.assertEquals((Object)temporaryViewData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
        TestCollectionTableFactory$.MODULE$.reset();
        TestCollectionTableFactory$.MODULE$.initData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)sourceData));
        String dropTemporaryView = new StringOps(Predef$.MODULE$.augmentString("\n        |DROP TEMPORARY VIEW IF EXISTS T3\n      ")).stripMargin();
        this.tableEnv().executeSql(dropTemporaryView);
        this.tableEnv().sqlQuery(query).executeInsert("T2").await();
        Assert.assertEquals((Object)permanentViewData.sorted(this.rowOrdering()), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestCollectionTableFactory$.MODULE$.RESULT()).sorted(this.rowOrdering()));
    }

    /*
     * WARNING - void declaration
     */
    private TableDescriptor buildTableDescriptor() {
        void var1_1;
        TableDescriptor tableDescriptor = TableFactoryHarness.newBuilder().boundedScanSource().schema(Schema.newBuilder().column("a", (AbstractDataType)DataTypes.INT()).column("b", (AbstractDataType)DataTypes.STRING()).column("c", (AbstractDataType)DataTypes.INT()).build()).sink().build();
        return var1_1;
    }

    @Test
    public void testShowCreateQueryOperationCatalogView() {
        Table table = this.tableEnv().from(this.buildTableDescriptor());
        this._expectedEx().expect(TableException.class);
        this._expectedEx().expectMessage("SHOW CREATE VIEW is not supported for views registered by Table API.");
        this.tableEnv().createTemporaryView("QueryOperationCatalogView", table);
        this.tableEnv().executeSql("show create view QueryOperationCatalogView");
    }

    @Test
    public void testShowCreateTemporaryView() {
        this.tableEnv().createTable("T1", this.buildTableDescriptor());
        String tView1DDL = "CREATE TEMPORARY VIEW t_v1 AS SELECT a, b, c FROM T1";
        this.tableEnv().executeSql(tView1DDL);
        java.util.List tView1ShowCreateResult = CollectionUtil.iteratorToList((Iterator)this.tableEnv().executeSql("show create view t_v1").collect());
        Assert.assertEquals((Object)tView1ShowCreateResult, (Object)Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{new StringOps(Predef$.MODULE$.augmentString("CREATE TEMPORARY VIEW `default_catalog`.`default_database`.`t_v1`(`a`, `b`, `c`) as\n             |SELECT `T1`.`a`, `T1`.`b`, `T1`.`c`\n             |FROM `default_catalog`.`default_database`.`T1`")).stripMargin()})}));
        String tView2DDL = "CREATE TEMPORARY VIEW t_v2(d, e, f) AS SELECT a, b, c FROM T1";
        this.tableEnv().executeSql(tView2DDL);
        java.util.List tView2ShowCreateResult = CollectionUtil.iteratorToList((Iterator)this.tableEnv().executeSql("show create view t_v2").collect());
        Assert.assertEquals((Object)tView2ShowCreateResult, (Object)Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{new StringOps(Predef$.MODULE$.augmentString("CREATE TEMPORARY VIEW `default_catalog`.`default_database`.`t_v2`(`d`, `e`, `f`) as\n             |SELECT `T1`.`a`, `T1`.`b`, `T1`.`c`\n             |FROM `default_catalog`.`default_database`.`T1`")).stripMargin()})}));
    }

    @Test
    public void testShowCreateCatalogView() {
        this.tableEnv().createTable("T1", this.buildTableDescriptor());
        String view1DDL = "CREATE VIEW v1 AS SELECT a, b, c FROM T1";
        this.tableEnv().executeSql(view1DDL);
        java.util.List view1ShowCreateResult = CollectionUtil.iteratorToList((Iterator)this.tableEnv().executeSql("show create view v1").collect());
        Assert.assertEquals((Object)view1ShowCreateResult, (Object)Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{new StringOps(Predef$.MODULE$.augmentString("CREATE VIEW `default_catalog`.`default_database`.`v1`(`a`, `b`, `c`) as\n             |SELECT `T1`.`a`, `T1`.`b`, `T1`.`c`\n             |FROM `default_catalog`.`default_database`.`T1`")).stripMargin()})}));
        String view2DDL = "CREATE VIEW v2(x, y, z) AS SELECT a, b, c FROM T1";
        this.tableEnv().executeSql(view2DDL);
        java.util.List view2ShowCreateResult = CollectionUtil.iteratorToList((Iterator)this.tableEnv().executeSql("show create view v2").collect());
        Assert.assertEquals((Object)view2ShowCreateResult, (Object)Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{new StringOps(Predef$.MODULE$.augmentString("CREATE VIEW `default_catalog`.`default_database`.`v2`(`x`, `y`, `z`) as\n             |SELECT `T1`.`a`, `T1`.`b`, `T1`.`c`\n             |FROM `default_catalog`.`default_database`.`T1`")).stripMargin()})}));
    }

    @Test
    public void testShowCreateViewWithLeftJoinGroupBy() {
        this.tableEnv().createTable("t1", this.buildTableDescriptor());
        this.tableEnv().createTable("t2", this.buildTableDescriptor());
        String viewWithLeftJoinGroupByDDL = new StringOps(Predef$.MODULE$.augmentString("create view viewLeftJoinGroupBy as\n         |select max(t1.a) max_value\n         |from t1 left join t2 on t1.c=t2.c")).stripMargin();
        this.tableEnv().executeSql(viewWithLeftJoinGroupByDDL);
        java.util.List showCreateLeftJoinGroupByViewResult = CollectionUtil.iteratorToList((Iterator)this.tableEnv().executeSql("show create view viewLeftJoinGroupBy").collect());
        Assert.assertEquals((Object)showCreateLeftJoinGroupByViewResult, (Object)Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{new StringOps(Predef$.MODULE$.augmentString("CREATE VIEW `default_catalog`.`default_database`.`viewLeftJoinGroupBy`(`max_value`) as\n             |SELECT MAX(`t1`.`a`) AS `max_value`\n             |FROM `default_catalog`.`default_database`.`t1`\n             |LEFT JOIN `default_catalog`.`default_database`.`t2` ON `t1`.`c` = `t2`.`c`")).stripMargin()})}));
    }

    @Test
    public void testShowCreateViewWithUDFOuterJoin() {
        this.tableEnv().createTable("t1", this.buildTableDescriptor());
        this.tableEnv().createTable("t2", this.buildTableDescriptor());
        this.tableEnv().createTemporarySystemFunction("udfEqualsOne", (UserDefinedFunction)new ScalarFunction(null){

            public int eval() {
                return 1;
            }
        });
        String viewWithCrossJoinDDL = new StringOps(Predef$.MODULE$.augmentString("create view viewWithCrossJoin as\n         |select udfEqualsOne() a, t1.a a1, t2.b b2 from t1 cross join t2")).stripMargin();
        this.tableEnv().executeSql(viewWithCrossJoinDDL);
        java.util.List showCreateCrossJoinViewResult = CollectionUtil.iteratorToList((Iterator)this.tableEnv().executeSql("show create view viewWithCrossJoin").collect());
        Assert.assertEquals((Object)showCreateCrossJoinViewResult, (Object)Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{new StringOps(Predef$.MODULE$.augmentString("CREATE VIEW `default_catalog`.`default_database`.`viewWithCrossJoin`(`a`, `a1`, `b2`) as\n             |SELECT `udfEqualsOne`() AS `a`, `t1`.`a` AS `a1`, `t2`.`b` AS `b2`\n             |FROM `default_catalog`.`default_database`.`t1`\n             |CROSS JOIN `default_catalog`.`default_database`.`t2`")).stripMargin()})}));
    }

    @Test
    public void testShowCreateViewWithInnerJoin() {
        this.tableEnv().createTable("t1", this.buildTableDescriptor());
        this.tableEnv().createTable("t2", this.buildTableDescriptor());
        String viewWithInnerJoinDDL = new StringOps(Predef$.MODULE$.augmentString("create view innerJoinView as\n         |select t1.a a1, t2.b b2\n         |from t1 inner join t2\n         |on t1.c=t2.c")).stripMargin();
        this.tableEnv().executeSql(viewWithInnerJoinDDL);
        java.util.List showCreateInnerJoinViewResult = CollectionUtil.iteratorToList((Iterator)this.tableEnv().executeSql("show create view innerJoinView").collect());
        Assert.assertEquals((Object)showCreateInnerJoinViewResult, (Object)Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{new StringOps(Predef$.MODULE$.augmentString("CREATE VIEW `default_catalog`.`default_database`.`innerJoinView`(`a1`, `b2`) as\n             |SELECT `t1`.`a` AS `a1`, `t2`.`b` AS `b2`\n             |FROM `default_catalog`.`default_database`.`t1`\n             |INNER JOIN `default_catalog`.`default_database`.`t2` ON `t1`.`c` = `t2`.`c`")).stripMargin()})}));
    }

    public CatalogViewITCase(boolean isStreamingMode) {
        this.settings = isStreamingMode ? EnvironmentSettings.newInstance().inStreamingMode().build() : EnvironmentSettings.newInstance().inBatchMode().build();
        this.tableEnv = TableEnvironmentImpl.create((EnvironmentSettings)this.settings());
        this._expectedEx = ExpectedException.none();
    }
}

