/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen.agg;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.agg.AggTestBase;
import org.apache.flink.table.planner.codegen.agg.AggsHandlerCodeGenerator;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.dataview.StateDataViewStore;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u001d4A!\u0001\u0002\u0001#\ta\u0012iZ4t\u0011\u0006tG\r\\3s\u0007>$WmR3oKJ\fGo\u001c:UKN$(BA\u0002\u0005\u0003\r\twm\u001a\u0006\u0003\u000b\u0019\tqaY8eK\u001e,gN\u0003\u0002\b\u0011\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0005\u000b\u0003\u0015!\u0018M\u00197f\u0015\tYA\"A\u0003gY&t7N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0003\u0001I\u0001\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003\u0017\u0005;w\rV3ti\n\u000b7/\u001a\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"a\u0005\u0001\t\u000bm\u0001A\u0011\u0001\u000f\u0002\u000fQ,7\u000f^!wOR\tQ\u0004\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0003V]&$\bF\u0001\u000e%!\t)\u0003&D\u0001'\u0015\t9c\"A\u0003kk:LG/\u0003\u0002*M\t!A+Z:u\u0011\u0015Y\u0003\u0001\"\u0001\u001d\u0003I!Xm\u001d;Bm\u001e<\u0016\u000e\u001e5SKR\u0014\u0018m\u0019;)\u0005)\"\u0003\"\u0002\u0018\u0001\t\u0003a\u0012\u0001\u0005;fgR\feoZ,ji\"lUM]4fQ\tiC\u0005C\u00032\u0001\u0011%!'\u0001\u0002kYR\u00111g\u000f\t\u0003iej\u0011!\u000e\u0006\u0003m]\nA\u0001\\1oO*\t\u0001(\u0001\u0003kCZ\f\u0017B\u0001\u001e6\u0005\u0011auN\\4\t\u000bq\u0002\u0004\u0019A\u001f\u0002\u00031\u0004\"A\b \n\u0005iz\u0002\"\u0002!\u0001\t\u0013\t\u0015A\u00016e)\t\u0011U\t\u0005\u00025\u0007&\u0011A)\u000e\u0002\u0007\t>,(\r\\3\t\u000bqz\u0004\u0019\u0001$\u0011\u0005y9\u0015B\u0001# \u0011\u0015I\u0005\u0001\"\u0003K\u0003\tQG\u000fF\u0002L#N\u0003\"\u0001T(\u000e\u00035S!A\u0014\u0005\u0002\t\u0011\fG/Y\u0005\u0003!6\u0013abR3oKJL7MU8x\t\u0006$\u0018\rC\u0003S\u0011\u0002\u0007Q(\u0001\u0002mc!)A\u000b\u0013a\u0001{\u0005\u0011AN\r\u0005\u0006-\u0002!IaV\u0001\u000bO\u0016$\b*\u00198eY\u0016\u0014Hc\u0001-aKB\u0011\u0011LX\u0007\u00025*\u00111\fX\u0001\nO\u0016tWM]1uK\u0012T!!\u0018\u0005\u0002\u000fI,h\u000e^5nK&\u0011qL\u0017\u0002\u0013\u0003\u001e<7\u000fS1oI2,g)\u001e8di&|g\u000eC\u0003b+\u0002\u0007!-A\u0006oK\u0016$'+\u001a;sC\u000e$\bC\u0001\u0010d\u0013\t!wDA\u0004C_>dW-\u00198\t\u000b\u0019,\u0006\u0019\u00012\u0002\u00139,W\rZ'fe\u001e,\u0007")
public class AggsHandlerCodeGeneratorTest
extends AggTestBase {
    @Test
    public void testAvg() {
        AggsHandleFunction handler = this.getHandler(false, false);
        handler.resetAccumulators();
        handler.accumulate((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(5L), this.jd(5.3), this.jl(2L)}));
        handler.accumulate((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(6L), this.jd(6.5), this.jl(3L)}));
        handler.accumulate((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(7L), this.jd(7.1), this.jl(4L)}));
        RowData ret = handler.getValue();
        Assert.assertEquals((float)6.0f, (float)ret.getLong(0), (float)0.0f);
        Assert.assertEquals((double)6.3, (double)ret.getDouble(1), (double)0.0);
        Assert.assertEquals((float)3.0f, (float)ret.getLong(2), (float)0.0f);
    }

    @Test
    public void testAvgWithRetract() {
        AggsHandleFunction handler = this.getHandler(true, false);
        handler.resetAccumulators();
        handler.accumulate((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(5L), this.jd(5.3), this.jl(2L)}));
        handler.accumulate((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(6L), this.jd(6.3), this.jl(3L)}));
        handler.accumulate((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(7L), this.jd(7.4), this.jl(4L)}));
        handler.retract((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(9L), this.jd(5.5), this.jl(5L)}));
        RowData ret = handler.getValue();
        Assert.assertEquals((float)4.0f, (float)ret.getLong(0), (float)0.0f);
        Assert.assertEquals((double)6.75, (double)ret.getDouble(1), (double)0.0);
        Assert.assertEquals((float)2.0f, (float)ret.getLong(2), (float)0.0f);
    }

    @Test
    public void testAvgWithMerge() {
        AggsHandleFunction handler = this.getHandler(false, true);
        handler.resetAccumulators();
        handler.merge((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(50L), this.jl(2L), this.jd(5.0), this.jl(2L), this.jt(50L, 2L)}));
        handler.merge((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(40L), this.jl(2L), this.jd(4.0), this.jl(2L), this.jt(40L, 2L)}));
        handler.merge((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(43L), this.jl(1L), this.jd(4.0), this.jl(1L), this.jt(43L, 1L)}));
        RowData ret = handler.getValue();
        Assert.assertEquals((float)26.0f, (float)ret.getLong(0), (float)0.0f);
        Assert.assertEquals((double)2.6, (double)ret.getDouble(1), (double)0.0);
        Assert.assertEquals((float)26.0f, (float)ret.getLong(2), (float)0.0f);
    }

    private Long jl(long l) {
        return new Long(l);
    }

    private Double jd(double l) {
        return new Double(l);
    }

    private GenericRowData jt(long l1, long l2) {
        return GenericRowData.of((Object[])new Object[]{this.jl(l1), this.jl(l2)});
    }

    private AggsHandleFunction getHandler(boolean needRetract, boolean needMerge) {
        AggsHandlerCodeGenerator generator = new AggsHandlerCodeGenerator(this.ctx(), this.relBuilder(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.inputTypes()), true);
        Object object = needRetract ? generator.needRetract() : BoxedUnit.UNIT;
        Object object2 = needMerge ? generator.needMerge(1, true, (DataType[])((Object[])new DataType[]{DataTypes.BIGINT(), DataTypes.BIGINT(), DataTypes.DOUBLE(), DataTypes.BIGINT(), TypeConversions.fromLegacyInfoToDataType(this.imperativeAggFunc().getAccumulatorType())})) : BoxedUnit.UNIT;
        AggsHandleFunction handler = (AggsHandleFunction)generator.needAccumulate().generateAggsHandler("Test", this.aggInfoList()).newInstance(this.classLoader());
        handler.open((StateDataViewStore)new PerKeyStateDataViewStore(this.context().getRuntimeContext()));
        return handler;
    }

    public AggsHandlerCodeGeneratorTest() {
        super(false);
    }
}

