/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.planner.expressions.DateDiffFun$;
import org.apache.flink.table.planner.expressions.TimeDiffFun$;
import org.apache.flink.table.planner.expressions.utils.ExpressionTestBase;
import org.apache.flink.table.planner.utils.InternalConfigOptions;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001\u001f\t)bj\u001c8EKR,'/\\5oSN$\u0018n\u0019+fgR\u001c(BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011a\u00029mC:tWM\u001d\u0006\u0003\u000f!\tQ\u0001^1cY\u0016T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012)5\t!C\u0003\u0002\u0014\u0005\u0005)Q\u000f^5mg&\u0011QC\u0005\u0002\u0013\u000bb\u0004(/Z:tS>tG+Z:u\u0005\u0006\u001cX\rC\u0003\u0018\u0001\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011!\u0004A\u0007\u0002\u0005!)A\u0004\u0001C\u0001;\u0005\tC/Z:u)\u0016l\u0007o\u001c:bY\u001a+hn\u0019;j_:\u001c\u0018J\\*ue\u0016\fW.T8eKR\ta\u0004\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0003V]&$\bFA\u000e&!\t1\u0013&D\u0001(\u0015\tAC\"A\u0003kk:LG/\u0003\u0002+O\t!A+Z:u\u0011\u0015a\u0003\u0001\"\u0001\u001e\u0003\u0001\"Xm\u001d;UK6\u0004xN]1m\rVt7\r^5p]NLeNQ1uG\"lu\u000eZ3)\u0005-*\u0003\"B\u0018\u0001\t\u0003i\u0012a\u000b;fgR\u001cUO\u001d:f]R\u0014vn\u001e+j[\u0016\u001cH/Y7q\rVt7\r^5p]NLeNQ1uG\"lu\u000eZ3)\u00059*\u0003\"\u0002\u001a\u0001\t\u0003i\u0012A\u0007;fgR$V-\u001c9pe\u0006dg)\u001e8di&|gn]%o+R\u001b\u0005FA\u0019&\u0011\u0015)\u0004\u0001\"\u0001\u001e\u0003}!Xm\u001d;UK6\u0004xN]1m\rVt7\r^5p]NLen\u00155b]\u001eD\u0017-\u001b\u0015\u0003i\u0015BQ\u0001\u000f\u0001\u0005\ne\nQ\u0003^3tiR+W\u000e]8sC2$\u0016.\\3ti\u0006l\u0007\u000f\u0006\u0002\u001fu!)1h\u000ea\u0001y\u00051!p\u001c8f\u0013\u0012\u0004\"!\u0010\"\u000e\u0003yR!a\u0010!\u0002\tQLW.\u001a\u0006\u0002\u0003\u0006!!.\u0019<b\u0013\t\u0019eH\u0001\u0004[_:,\u0017\n\u001a\u0005\u0006\u000b\u0002!\t!H\u0001\ti\u0016\u001cH/V+J\t\"\u0012A)\n\u0005\u0006\u0011\u0002!\t!H\u0001\ti\u0016\u001cHOU1oI\"\u0012q)\n\u0005\u0006\u0017\u0002!\t\u0005T\u0001\ti\u0016\u001cH\u000fR1uCV\tQ\n\u0005\u0002O#6\tqJ\u0003\u0002Q\u0011\u0005)A/\u001f9fg&\u0011!k\u0014\u0002\u0004%><\b\"\u0002+\u0001\t\u0003*\u0016\u0001\u0003;za\u0016LeNZ8\u0016\u0003Y\u0003\"aV/\u000e\u0003aS!!\u0017.\u0002\u0013QL\b/Z;uS2\u001c(BA!\\\u0015\ta\u0006\"A\u0002ba&L!A\u0018-\u0003\u0017I{w\u000fV=qK&sgm\u001c\u0005\u0006A\u0002!\t%Y\u0001\nMVt7\r^5p]N,\u0012A\u0019\t\u0005G*l\u0007O\u0004\u0002eQB\u0011Q\rI\u0007\u0002M*\u0011qMD\u0001\u0007yI|w\u000e\u001e \n\u0005%\u0004\u0013A\u0002)sK\u0012,g-\u0003\u0002lY\n\u0019Q*\u00199\u000b\u0005%\u0004\u0003CA2o\u0013\tyGN\u0001\u0004TiJLgn\u001a\t\u0003cNl\u0011A\u001d\u0006\u0003A\u001aI!\u0001\u001e:\u0003\u001dM\u001b\u0017\r\\1s\rVt7\r^5p]\u0002")
public class NonDeterministicTests
extends ExpressionTestBase {
    @Test
    public void testTemporalFunctionsInStreamMode() {
        GeneratedFunction<MapFunction<RowData, BinaryRowData>> temporalFunctions = this.getCodeGenFunctions((List<String>)new .colon.colon((Object)"CURRENT_DATE", (List)new .colon.colon((Object)"CURRENT_TIME", (List)new .colon.colon((Object)"CURRENT_TIMESTAMP", (List)new .colon.colon((Object)"CURRENT_ROW_TIMESTAMP()", (List)new .colon.colon((Object)"NOW()", (List)new .colon.colon((Object)"LOCALTIME", (List)new .colon.colon((Object)"LOCALTIMESTAMP", (List)Nil$.MODULE$))))))));
        List<String> round1 = this.evaluateFunctionResult(temporalFunctions);
        Thread.sleep(1000L);
        List<String> round2 = this.evaluateFunctionResult(temporalFunctions);
        Assert.assertEquals((long)round1.size(), (long)round2.size());
        ((List)((IterableLike)round1.zip(round2, List$.MODULE$.canBuildFrom())).zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            NonDeterministicTests.$anonfun$testTemporalFunctionsInStreamMode$1(x0$1);
            return BoxedUnit.UNIT;
        });
        int currentTimeStampIndex = 2;
        int currentRowTimestampIndex = 3;
        Assert.assertEquals((Object)round1.apply(currentTimeStampIndex), (Object)round1.apply(currentRowTimestampIndex));
        Assert.assertEquals((Object)round2.apply(currentTimeStampIndex), (Object)round2.apply(currentRowTimestampIndex));
    }

    @Test
    public void testTemporalFunctionsInBatchMode() {
        ZoneId zoneId = ZoneId.of("Asia/Shanghai");
        this.tableConfig().setLocalTimeZone(zoneId);
        this.tableConfig().set(ExecutionOptions.RUNTIME_MODE, (Object)RuntimeExecutionMode.BATCH);
        this.tableConfig().set(InternalConfigOptions.TABLE_QUERY_START_EPOCH_TIME, (Object)BoxesRunTime.boxToLong((long)1123L));
        this.tableConfig().set(InternalConfigOptions.TABLE_QUERY_START_LOCAL_TIME, (Object)BoxesRunTime.boxToLong((long)(1123L + (long)TimeZone.getTimeZone(zoneId).getOffset(1123L))));
        GeneratedFunction<MapFunction<RowData, BinaryRowData>> temporalFunctions = this.getCodeGenFunctions((List<String>)new .colon.colon((Object)"CURRENT_DATE", (List)new .colon.colon((Object)"CURRENT_TIME", (List)new .colon.colon((Object)"CURRENT_TIMESTAMP", (List)new .colon.colon((Object)"NOW()", (List)new .colon.colon((Object)"LOCALTIME", (List)new .colon.colon((Object)"LOCALTIMESTAMP", (List)Nil$.MODULE$)))))));
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01", "08:00:01", "1970-01-01 08:00:01.123", "1970-01-01 08:00:01.123", "08:00:01", "1970-01-01 08:00:01.123"}));
        List<String> result = this.evaluateFunctionResult(temporalFunctions);
        Assert.assertEquals((Object)expected.toList().sorted((Ordering)Ordering.String$.MODULE$), (Object)result.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCurrentRowTimestampFunctionsInBatchMode() {
        this.tableConfig().set(ExecutionOptions.RUNTIME_MODE, (Object)RuntimeExecutionMode.BATCH);
        GeneratedFunction<MapFunction<RowData, BinaryRowData>> temporalFunctions = this.getCodeGenFunctions((List<String>)new .colon.colon((Object)"CURRENT_ROW_TIMESTAMP()", (List)Nil$.MODULE$));
        List<String> round1 = this.evaluateFunctionResult(temporalFunctions);
        Thread.sleep(1000L);
        List<String> round2 = this.evaluateFunctionResult(temporalFunctions);
        Assert.assertEquals((long)round1.size(), (long)round2.size());
        ((List)round1.zip(round2, List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            NonDeterministicTests.$anonfun$testCurrentRowTimestampFunctionsInBatchMode$1(x0$2);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testTemporalFunctionsInUTC() {
        this.testTemporalTimestamp(ZoneId.of("UTC"));
    }

    @Test
    public void testTemporalFunctionsInShanghai() {
        this.testTemporalTimestamp(ZoneId.of("Asia/Shanghai"));
    }

    private void testTemporalTimestamp(ZoneId zoneId) {
        this.tableConfig().setLocalTimeZone(zoneId);
        LocalDateTime localDateTime = LocalDateTime.now(zoneId);
        String formattedLocalTime = localDateTime.toLocalTime().format(DateTimeFormatter.ofPattern("HH:mm:ss"));
        String formattedLocalDateTime = localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        String formattedCurrentDate = localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        String formattedCurrentTime = localDateTime.toLocalTime().format(DateTimeFormatter.ofPattern("HH:mm:ss"));
        String formattedCurrentTimestamp = localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        this.testSqlApi(new StringBuilder(37).append("TIME_SUB(LOCALTIME, TIME '").append(formattedLocalTime).append("') <= 60000").toString(), "TRUE");
        this.testSqlApi(new StringBuilder(57).append("TIMESTAMPDIFF(SECOND, TIMESTAMP '").append(formattedLocalDateTime).append("', LOCALTIMESTAMP) <= 60").toString(), "TRUE");
        this.testSqlApi(new StringBuilder(36).append("DATE_SUB(CURRENT_DATE, DATE '").append(formattedCurrentDate).append("') >= 0").toString(), "TRUE");
        this.testSqlApi(new StringBuilder(40).append("TIME_SUB(CURRENT_TIME, TIME '").append(formattedCurrentTime).append("') <= 60000").toString(), "TRUE");
        this.testSqlApi(new StringBuilder(48).append("TIMESTAMPDIFF(SECOND, ").append(this.timestampLtz(formattedCurrentTimestamp)).append(", CURRENT_TIMESTAMP) <= 60").toString(), "TRUE");
        this.testSqlApi(new StringBuilder(36).append("TIMESTAMPDIFF(SECOND, ").append(this.timestampLtz(formattedCurrentTimestamp)).append(", NOW()) <= 60").toString(), "TRUE");
        this.testSqlApi(new StringBuilder(22).append("TIMESTAMPDIFF(SECOND, ").append(new StringBuilder(32).append(this.timestampLtz(formattedCurrentTimestamp)).append(", CURRENT_ROW_TIMESTAMP()) <= 60").toString()).toString(), "TRUE");
    }

    @Test
    public void testUUID() {
        this.testAllApis((Expression)package$.MODULE$.WithOperations(package$.MODULE$.uuid()).charLength(), "CHARACTER_LENGTH(UUID())", "36");
    }

    @Test
    public void testRand() {
        this.testSqlApi("RAND() <> RAND() or RAND() = RAND()", "TRUE");
        this.testSqlApi("RAND(1) <> RAND(1) or RAND(1) = RAND(1)", "TRUE");
        this.testSqlApi("RAND_INTEGER(10) <> RAND_INTEGER(10) or RAND_INTEGER(10) = RAND_INTEGER(10)", "TRUE");
    }

    @Override
    public Row testData() {
        return new Row(0);
    }

    @Override
    public RowTypeInfo typeInfo() {
        return new RowTypeInfo(new TypeInformation[0]);
    }

    @Override
    public Map<String, ScalarFunction> functions() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TIME_SUB"), (Object)TimeDiffFun$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DATE_SUB"), (Object)DateDiffFun$.MODULE$)}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$testTemporalFunctionsInStreamMode$1(Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Tuple2 tuple22 = (Tuple2)tuple2._1();
        int index = tuple2._2$mcI$sp();
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        String result1 = (String)tuple22._1();
        String result2 = (String)tuple22._2();
        if (result1 == null) throw new MatchError((Object)tuple2);
        String string = result1;
        if (result2 == null) throw new MatchError((Object)tuple2);
        String string2 = result2;
        int n = index;
        if (n == 0) {
            Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString(string)).$less$eq((Object)string2));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString(string)).$less((Object)string2));
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$testCurrentRowTimestampFunctionsInBatchMode$1(Tuple2 x0$2) {
        String string;
        String result2;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x0$2;
                if (tuple2 == null) break block2;
                String result1 = (String)tuple2._1();
                result2 = (String)tuple2._2();
                if (result1 == null) break block2;
                string = result1;
                if (result2 != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        String string2 = result2;
        Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString(string)).$less((Object)string2));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }
}

