/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.converter;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.TimePointUnit;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.planner.expressions.converter.ExpressionConverter;
import org.apache.flink.table.planner.utils.PlannerMocks;
import org.apache.flink.table.types.DataType;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ExpressionConverterTest {
    private final PlannerContext plannerContext = PlannerMocks.create().getPlannerContext();
    private final ExpressionConverter converter = new ExpressionConverter((RelBuilder)this.plannerContext.createRelBuilder());

    @Test
    public void testLiteral() {
        RexNode rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)1));
        Assertions.assertThat((int)((Integer)((RexLiteral)rex).getValueAs(Integer.class))).isEqualTo(1);
        Assertions.assertThat((Comparable)rex.getType().getSqlTypeName()).isEqualTo((Object)SqlTypeName.TINYINT);
        rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)1));
        Assertions.assertThat((int)((Integer)((RexLiteral)rex).getValueAs(Integer.class))).isEqualTo(1);
        Assertions.assertThat((Comparable)rex.getType().getSqlTypeName()).isEqualTo((Object)SqlTypeName.SMALLINT);
        rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)1));
        Assertions.assertThat((int)((Integer)((RexLiteral)rex).getValueAs(Integer.class))).isEqualTo(1);
        Assertions.assertThat((Comparable)rex.getType().getSqlTypeName()).isEqualTo((Object)SqlTypeName.INTEGER);
    }

    @Test
    public void testCharLiteral() {
        RexNode rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)"ABC", (DataType)((DataType)DataTypes.CHAR((int)4).notNull())));
        Assertions.assertThat((String)((String)((RexLiteral)rex).getValueAs(String.class))).isEqualTo("ABC ");
        Assertions.assertThat((Comparable)rex.getType().getSqlTypeName()).isEqualTo((Object)SqlTypeName.CHAR);
        Assertions.assertThat((int)rex.getType().getPrecision()).isEqualTo(4);
    }

    @Test
    public void testVarCharLiteral() {
        RexNode rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)"ABC", (DataType)((DataType)DataTypes.STRING().notNull())));
        Assertions.assertThat((String)((String)((RexLiteral)rex).getValueAs(String.class))).isEqualTo("ABC");
        Assertions.assertThat((Comparable)rex.getType().getSqlTypeName()).isEqualTo((Object)SqlTypeName.VARCHAR);
        Assertions.assertThat((int)rex.getType().getPrecision()).isEqualTo(Integer.MAX_VALUE);
    }

    @Test
    public void testBinaryLiteral() {
        RexNode rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)new byte[]{1, 2, 3}, (DataType)((DataType)DataTypes.BINARY((int)4).notNull())));
        Assertions.assertThat((byte[])((byte[])((RexLiteral)rex).getValueAs(byte[].class))).isEqualTo((Object)new byte[]{1, 2, 3, 0});
        Assertions.assertThat((Comparable)rex.getType().getSqlTypeName()).isEqualTo((Object)SqlTypeName.BINARY);
        Assertions.assertThat((int)rex.getType().getPrecision()).isEqualTo(4);
    }

    @Test
    public void testTimestampLiteral() {
        RexNode rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)LocalDateTime.parse("2012-12-12T12:12:12.12345"), (DataType)((DataType)DataTypes.TIMESTAMP((int)3).notNull())));
        Assertions.assertThat((Comparable)((Comparable)((RexLiteral)rex).getValueAs(TimestampString.class))).isEqualTo((Object)new TimestampString("2012-12-12 12:12:12.123"));
        Assertions.assertThat((Comparable)rex.getType().getSqlTypeName()).isEqualTo((Object)SqlTypeName.TIMESTAMP);
        Assertions.assertThat((int)rex.getType().getPrecision()).isEqualTo(3);
    }

    @Test
    public void testTimestampWithLocalZoneLiteral() {
        RexNode rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)Instant.ofEpochMilli(100L), (DataType)((DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).notNull())));
        Assertions.assertThat((Comparable)((Comparable)((RexLiteral)rex).getValueAs(TimestampString.class))).isEqualTo((Object)TimestampString.fromMillisSinceEpoch((long)100L));
        Assertions.assertThat((Comparable)rex.getType().getSqlTypeName()).isEqualTo((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
        Assertions.assertThat((int)rex.getType().getPrecision()).isEqualTo(3);
    }

    @Test
    public void testTimeLiteral() {
        RexNode rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)LocalTime.parse("12:12:12.12345"), (DataType)((DataType)DataTypes.TIME((int)2).notNull())));
        Assertions.assertThat((Comparable)((Comparable)((RexLiteral)rex).getValueAs(TimeString.class))).isEqualTo((Object)new TimeString("12:12:12.12"));
        Assertions.assertThat((Comparable)rex.getType().getSqlTypeName()).isEqualTo((Object)SqlTypeName.TIME);
        Assertions.assertThat((int)rex.getType().getPrecision()).isEqualTo(2);
    }

    @Test
    public void testTimeLiteralBiggerPrecision() {
        RexNode rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)LocalTime.parse("12:12:12.12345"), (DataType)((DataType)DataTypes.TIME((int)5).notNull())));
        Assertions.assertThat((Comparable)((Comparable)((RexLiteral)rex).getValueAs(TimeString.class))).isEqualTo((Object)new TimeString("12:12:12.123"));
        Assertions.assertThat((Comparable)rex.getType().getSqlTypeName()).isEqualTo((Object)SqlTypeName.TIME);
        Assertions.assertThat((int)rex.getType().getPrecision()).isEqualTo(3);
    }

    @Test
    public void testDateLiteral() {
        RexNode rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)LocalDate.parse("2012-12-12"), (DataType)((DataType)DataTypes.DATE().notNull())));
        Assertions.assertThat((Comparable)((Comparable)((RexLiteral)rex).getValueAs(DateString.class))).isEqualTo((Object)new DateString("2012-12-12"));
        Assertions.assertThat((Comparable)rex.getType().getSqlTypeName()).isEqualTo((Object)SqlTypeName.DATE);
    }

    @Test
    public void testIntervalDayTime() {
        Duration value = Duration.ofDays(3L).plusMillis(21L);
        RexNode rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)value));
        Assertions.assertThat((BigDecimal)((BigDecimal)((RexLiteral)rex).getValueAs(BigDecimal.class))).isEqualTo((Object)BigDecimal.valueOf(value.toMillis()));
        Assertions.assertThat((Comparable)rex.getType().getSqlTypeName()).isEqualTo((Object)SqlTypeName.INTERVAL_DAY_SECOND);
        Assertions.assertThat((int)rex.getType().getPrecision()).isEqualTo(2);
        Assertions.assertThat((int)rex.getType().getScale()).isEqualTo(6);
    }

    @Test
    public void testIntervalYearMonth() {
        Period value = Period.of(999, 3, 1);
        RexNode rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)value));
        Assertions.assertThat((BigDecimal)((BigDecimal)((RexLiteral)rex).getValueAs(BigDecimal.class))).isEqualTo((Object)BigDecimal.valueOf(value.toTotalMonths()));
        Assertions.assertThat((Comparable)rex.getType().getSqlTypeName()).isEqualTo((Object)SqlTypeName.INTERVAL_YEAR_MONTH);
        Assertions.assertThat((int)rex.getType().getPrecision()).isEqualTo(2);
    }

    @Test
    public void testDecimalLiteral() {
        BigDecimal value = new BigDecimal("12345678.999");
        RexNode rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)value));
        Assertions.assertThat((BigDecimal)((BigDecimal)((RexLiteral)rex).getValueAs(BigDecimal.class))).isEqualTo((Object)value);
        Assertions.assertThat((Comparable)rex.getType().getSqlTypeName()).isEqualTo((Object)SqlTypeName.DECIMAL);
        Assertions.assertThat((int)rex.getType().getPrecision()).isEqualTo(11);
        Assertions.assertThat((int)rex.getType().getScale()).isEqualTo(3);
    }

    @Test
    public void testSymbolLiteral() {
        RexNode rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)TimePointUnit.MICROSECOND));
        Assertions.assertThat((Comparable)((Comparable)((RexLiteral)rex).getValueAs(TimeUnit.class))).isEqualTo((Object)TimeUnit.MICROSECOND);
        Assertions.assertThat((Comparable)rex.getType().getSqlTypeName()).isEqualTo((Object)SqlTypeName.SYMBOL);
    }
}

