/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IteratorAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@Execution(value=ExecutionMode.CONCURRENT)
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@ExtendWith(value={MiniClusterExtension.class})
abstract class BuiltInFunctionTestBase {
    BuiltInFunctionTestBase() {
    }

    Configuration getConfiguration() {
        return new Configuration();
    }

    abstract Stream<TestSetSpec> getTestSetSpecs();

    private Stream<TestCase> getTestCases() {
        return this.getTestSetSpecs().flatMap(testSpec -> testSpec.getTestCases(this.getConfiguration()));
    }

    @ParameterizedTest
    @MethodSource(value={"getTestCases"})
    final void test(TestCase testCase) throws Throwable {
        testCase.execute();
    }

    static List<DataType> createDataTypes(DataTypeFactory dataTypeFactory, List<AbstractDataType<?>> dataTypes) {
        return dataTypes.stream().map(arg_0 -> ((DataTypeFactory)dataTypeFactory).createDataType(arg_0)).collect(Collectors.toList());
    }

    public static ResultSpec resultSpec(Expression tableApiExpression, String sqlExpression, Object result, AbstractDataType<?> dataType) {
        return BuiltInFunctionTestBase.resultSpec(tableApiExpression, sqlExpression, result, dataType, dataType);
    }

    public static ResultSpec resultSpec(Expression tableApiExpression, String sqlExpression, Object result, AbstractDataType<?> tableApiDataType, AbstractDataType<?> sqlQueryDataType) {
        return new ResultSpec(tableApiExpression, sqlExpression, result, tableApiDataType, sqlQueryDataType);
    }

    static class ResultSpec {
        final Expression tableApiExpression;
        final String sqlExpression;
        final Object result;
        final AbstractDataType<?> tableApiDataType;
        final AbstractDataType<?> sqlDataType;

        private ResultSpec(Expression tableApiExpression, String sqlExpression, Object result, AbstractDataType<?> tableApiDataType, AbstractDataType<?> sqlQueryDataType) {
            this.tableApiExpression = tableApiExpression;
            this.sqlExpression = sqlExpression;
            this.result = result;
            this.tableApiDataType = tableApiDataType;
            this.sqlDataType = sqlQueryDataType;
        }
    }

    private static class SqlErrorTestItem
    extends ErrorTestItem<String> {
        private SqlErrorTestItem(String expression, Class<? extends Throwable> errorClass, String errorMessage, boolean expectedDuringValidation) {
            super(expression, errorClass, errorMessage, expectedDuringValidation);
        }

        @Override
        Table query(TableEnvironment env, Table inputTable) {
            return env.sqlQuery("SELECT " + (String)this.expression + " FROM " + inputTable);
        }

        public String toString() {
            return "[SQL] " + (String)this.expression;
        }
    }

    private static class SqlResultTestItem
    extends ResultTestItem<String> {
        SqlResultTestItem(String sqlExpression, List<Object> result, List<AbstractDataType<?>> dataType) {
            super(sqlExpression, result, dataType);
        }

        @Override
        Table query(TableEnvironment env, Table inputTable) {
            return env.sqlQuery("SELECT " + (String)this.expression + " FROM " + inputTable);
        }

        public String toString() {
            return "[SQL] " + (String)this.expression;
        }
    }

    private static class TableApiErrorTestItem
    extends ErrorTestItem<Expression> {
        TableApiErrorTestItem(Expression expression, Class<? extends Throwable> errorClass, String errorMessage, boolean expectedDuringValidation) {
            super(expression, errorClass, errorMessage, expectedDuringValidation);
        }

        @Override
        Table query(TableEnvironment env, Table inputTable) {
            return inputTable.select(new Expression[]{(Expression)this.expression});
        }

        public String toString() {
            return "[API] " + ((Expression)this.expression).asSummaryString();
        }
    }

    private static class TableApiResultTestItem
    extends ResultTestItem<List<Expression>> {
        TableApiResultTestItem(List<Expression> expressions, List<Object> results, List<AbstractDataType<?>> dataTypes) {
            super(expressions, results, dataTypes);
        }

        @Override
        Table query(TableEnvironment env, Table inputTable) {
            return inputTable.select(((List)this.expression).toArray(new Expression[0]));
        }

        public String toString() {
            return "[API] " + ((List)this.expression).stream().map(Expression::asSummaryString).collect(Collectors.joining(", "));
        }
    }

    private static abstract class ErrorTestItem<T>
    implements TestItem {
        final T expression;
        final Class<? extends Throwable> errorClass;
        final String errorMessage;
        final boolean expectedDuringValidation;

        ErrorTestItem(T expression, Class<? extends Throwable> errorClass, String errorMessage, boolean expectedDuringValidation) {
            Preconditions.checkState((errorClass != null || errorMessage != null ? 1 : 0) != 0);
            this.expression = expression;
            this.errorClass = errorClass;
            this.errorMessage = errorMessage;
            this.expectedDuringValidation = expectedDuringValidation;
        }

        abstract Table query(TableEnvironment var1, Table var2);

        Consumer<? super Throwable> errorMatcher() {
            if (this.errorClass != null && this.errorMessage != null) {
                return FlinkAssertions.anyCauseMatches(this.errorClass, (String)this.errorMessage);
            }
            if (this.errorMessage != null) {
                return FlinkAssertions.anyCauseMatches((String)this.errorMessage);
            }
            return FlinkAssertions.anyCauseMatches(this.errorClass);
        }

        @Override
        public void test(TableEnvironmentInternal env, Table inputTable) {
            AtomicReference tableResult = new AtomicReference();
            Throwable t = Assertions.catchThrowable(() -> tableResult.set(this.query((TableEnvironment)env, inputTable).execute()));
            if (this.expectedDuringValidation) {
                ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThat((Throwable)t).as("Expected a validation exception", new Object[0])).isNotNull()).satisfies(new Consumer[]{this.errorMatcher()});
                return;
            }
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)t).as("Error while validating the query", new Object[0])).isNull();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((TableResult)tableResult.get()).await()).isNotNull()).satisfies(new Consumer[]{this.errorMatcher()});
        }
    }

    private static abstract class ResultTestItem<T>
    implements TestItem {
        final T expression;
        final List<Object> results;
        final List<AbstractDataType<?>> dataTypes;

        ResultTestItem(T expression, List<Object> results, List<AbstractDataType<?>> dataTypes) {
            this.expression = expression;
            this.results = results;
            this.dataTypes = dataTypes;
        }

        abstract Table query(TableEnvironment var1, Table var2);

        @Override
        public void test(TableEnvironmentInternal env, Table inputTable) throws Exception {
            Table resultTable = this.query((TableEnvironment)env, inputTable);
            List<DataType> expectedDataTypes = BuiltInFunctionTestBase.createDataTypes(env.getCatalogManager().getDataTypeFactory(), this.dataTypes);
            TableResult result = resultTable.execute();
            try (CloseableIterator iterator = result.collect();){
                Assertions.assertThat((Iterator)iterator).hasNext();
                Row row = (Row)iterator.next();
                ((IteratorAssert)Assertions.assertThat((Iterator)iterator).as("No more rows expected.", new Object[0])).isExhausted();
                for (int i = 0; i < row.getArity(); ++i) {
                    ((ObjectAssert)Assertions.assertThat((Object)((DataType)result.getResolvedSchema().getColumnDataTypes().get(i)).getLogicalType()).as("Logical type for spec [%d] of test [%s] doesn't match.", new Object[]{i, this})).isEqualTo((Object)expectedDataTypes.get(i).getLogicalType());
                    ((ObjectAssert)Assertions.assertThat((Object)Row.of((Object[])new Object[]{row.getField(i)})).as("Result for spec [%d] of test [%s] doesn't match.", new Object[]{i, this})).isEqualTo((Object)Row.of((Object[])new Object[]{this.results.get(i)}));
                }
            }
        }
    }

    private static interface TestItem {
        public void test(TableEnvironmentInternal var1, Table var2) throws Exception;
    }

    static class TestSetSpec {
        @Nullable
        private final BuiltInFunctionDefinition definition;
        @Nullable
        private final String description;
        private final List<Class<? extends UserDefinedFunction>> functions;
        private final List<TestItem> testItems;
        private Object[] fieldData;
        @Nullable
        private AbstractDataType<?>[] fieldDataTypes;

        private TestSetSpec(BuiltInFunctionDefinition definition, @Nullable String description) {
            this.definition = definition;
            this.description = description;
            this.functions = new ArrayList<Class<? extends UserDefinedFunction>>();
            this.testItems = new ArrayList<TestItem>();
        }

        static TestSetSpec forFunction(BuiltInFunctionDefinition definition) {
            return TestSetSpec.forFunction(definition, null);
        }

        static TestSetSpec forFunction(BuiltInFunctionDefinition definition, String description) {
            return new TestSetSpec((BuiltInFunctionDefinition)Preconditions.checkNotNull((Object)definition), description);
        }

        static TestSetSpec forExpression(String description) {
            return new TestSetSpec(null, (String)Preconditions.checkNotNull((Object)description));
        }

        TestSetSpec onFieldsWithData(Object ... fieldData) {
            this.fieldData = fieldData;
            return this;
        }

        TestSetSpec andDataTypes(AbstractDataType<?> ... fieldDataType) {
            this.fieldDataTypes = fieldDataType;
            return this;
        }

        TestSetSpec withFunction(Class<? extends UserDefinedFunction> functionClass) {
            this.functions.add(functionClass);
            return this;
        }

        TestSetSpec testTableApiResult(Expression expression, Object result, AbstractDataType<?> dataType) {
            return this.testTableApiResult(Collections.singletonList(expression), Collections.singletonList(result), Collections.singletonList(dataType));
        }

        TestSetSpec testTableApiResult(List<Expression> expression, List<Object> result, List<AbstractDataType<?>> dataType) {
            this.testItems.add(new TableApiResultTestItem(expression, result, dataType));
            return this;
        }

        TestSetSpec testTableApiValidationError(Expression expression, String errorMessage) {
            this.testItems.add(new TableApiErrorTestItem(expression, ValidationException.class, errorMessage, true));
            return this;
        }

        TestSetSpec testTableApiRuntimeError(Expression expression, String errorMessage) {
            this.testItems.add(new TableApiErrorTestItem(expression, Throwable.class, errorMessage, false));
            return this;
        }

        TestSetSpec testTableApiRuntimeError(Expression expression, Class<? extends Throwable> exceptionError) {
            this.testItems.add(new TableApiErrorTestItem(expression, exceptionError, null, false));
            return this;
        }

        TestSetSpec testSqlResult(String expression, Object result, AbstractDataType<?> dataType) {
            return this.testSqlResult(expression, Collections.singletonList(result), Collections.singletonList(dataType));
        }

        TestSetSpec testSqlResult(String expression, List<Object> result, List<AbstractDataType<?>> dataType) {
            this.testItems.add(new SqlResultTestItem(expression, result, dataType));
            return this;
        }

        TestSetSpec testSqlValidationError(String expression, String errorMessage) {
            this.testItems.add(new SqlErrorTestItem(expression, ValidationException.class, errorMessage, true));
            return this;
        }

        TestSetSpec testSqlRuntimeError(String expression, String errorMessage) {
            this.testItems.add(new SqlErrorTestItem(expression, Throwable.class, errorMessage, false));
            return this;
        }

        TestSetSpec testSqlRuntimeError(String expression, Class<? extends Throwable> exceptionError) {
            this.testItems.add(new SqlErrorTestItem(expression, exceptionError, null, false));
            return this;
        }

        TestSetSpec testResult(Expression expression, String sqlExpression, Object result, AbstractDataType<?> dataType) {
            return this.testResult(expression, sqlExpression, result, dataType, dataType);
        }

        TestSetSpec testResult(ResultSpec ... resultSpecs) {
            int cols = resultSpecs.length;
            ArrayList<Expression> expressions = new ArrayList<Expression>(cols);
            ArrayList<String> sqlExpressions = new ArrayList<String>(cols);
            ArrayList<Object> results = new ArrayList<Object>(cols);
            ArrayList tableApiDataTypes = new ArrayList(cols);
            ArrayList sqlDataTypes = new ArrayList(cols);
            for (ResultSpec resultSpec : resultSpecs) {
                expressions.add(resultSpec.tableApiExpression);
                sqlExpressions.add(resultSpec.sqlExpression);
                results.add(resultSpec.result);
                tableApiDataTypes.add(resultSpec.tableApiDataType);
                sqlDataTypes.add(resultSpec.sqlDataType);
            }
            return this.testResult(expressions, sqlExpressions, results, tableApiDataTypes, sqlDataTypes);
        }

        TestSetSpec testResult(Expression expression, String sqlExpression, Object result, AbstractDataType<?> tableApiDataType, AbstractDataType<?> sqlDataType) {
            return this.testResult(Collections.singletonList(expression), Collections.singletonList(sqlExpression), Collections.singletonList(result), Collections.singletonList(tableApiDataType), Collections.singletonList(sqlDataType));
        }

        TestSetSpec testResult(List<Expression> expression, List<String> sqlExpression, List<Object> result, List<AbstractDataType<?>> tableApiDataType, List<AbstractDataType<?>> sqlDataType) {
            this.testItems.add(new TableApiResultTestItem(expression, result, tableApiDataType));
            this.testItems.add(new SqlResultTestItem(String.join((CharSequence)",", sqlExpression), result, sqlDataType));
            return this;
        }

        Stream<TestCase> getTestCases(Configuration configuration) {
            return this.testItems.stream().map(testItem -> this.getTestCase(configuration, (TestItem)testItem));
        }

        private TestCase getTestCase(Configuration configuration, TestItem testItem) {
            return new TestCase(testItem.toString(), () -> {
                Table inputTable;
                TableEnvironmentInternal env = (TableEnvironmentInternal)TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.newInstance().build());
                env.getConfig().addConfiguration(configuration);
                this.functions.forEach(f -> env.createTemporarySystemFunction(f.getSimpleName(), f));
                if (this.fieldDataTypes == null) {
                    inputTable = env.fromValues(new Object[]{Row.of((Object[])this.fieldData)});
                } else {
                    DataTypes.UnresolvedField[] fields = (DataTypes.UnresolvedField[])IntStream.range(0, this.fieldDataTypes.length).mapToObj(i -> DataTypes.FIELD((String)("f" + i), this.fieldDataTypes[i])).toArray(DataTypes.UnresolvedField[]::new);
                    inputTable = env.fromValues((AbstractDataType)DataTypes.ROW((DataTypes.AbstractField[])fields), new Object[]{Row.of((Object[])this.fieldData)});
                }
                testItem.test(env, inputTable);
            });
        }

        public String toString() {
            return (this.definition != null ? this.definition.getName() : "Expression") + (this.description != null ? " : " + this.description : "");
        }
    }

    static class TestCase
    implements Executable {
        private final String name;
        private final Executable executable;

        TestCase(String name, Executable executable) {
            this.name = name;
            this.executable = executable;
        }

        public void execute() throws Throwable {
            this.executable.execute();
        }

        public String toString() {
            return this.name;
        }
    }
}

