/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.planner.functions.aggfunctions.AggFunctionTestBase;
import org.apache.flink.table.runtime.functions.aggregate.BatchApproxCountDistinctAggFunctions;
import org.apache.flink.table.runtime.functions.aggregate.hyperloglog.HllBuffer;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.TimestampType;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public class BatchApproxCountDistinctAggFunctionTest {

    public static abstract class NumberApproxCountDistinctAggFunctionTestBase<T>
    extends ApproxCountDistinctAggFunctionTestBase<T> {
        protected abstract T getValue(String var1);

        @Override
        protected List<List<T>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(this.getValue("1"), this.getValue("1"), this.getValue("1")), Arrays.asList(this.getValue("1"), this.getValue("2"), this.getValue("3")), Arrays.asList(null, null, null, null, null, null), Arrays.asList(null, this.getValue("10")));
        }

        @Override
        protected List<Long> getExpectedResults() {
            return Arrays.asList(1L, 3L, 0L, 1L);
        }
    }

    public static class StringApproxCountDistinctAggFunctionTest
    extends ApproxCountDistinctAggFunctionTestBase<StringData> {
        @Override
        protected List<List<StringData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(StringData.fromString((String)"abc"), StringData.fromString((String)"def"), StringData.fromString((String)"ghi"), null, StringData.fromString((String)"jkl"), null, StringData.fromString((String)"zzz")), Arrays.asList(null, null), Arrays.asList(null, StringData.fromString((String)"a")), Arrays.asList(StringData.fromString((String)"x"), null, StringData.fromString((String)"x")));
        }

        @Override
        protected List<Long> getExpectedResults() {
            return Arrays.asList(5L, 0L, 1L, 1L);
        }

        @Override
        protected AggregateFunction<Long, HllBuffer> getAggregator() {
            return new BatchApproxCountDistinctAggFunctions.StringApproxCountDistinctAggFunction();
        }
    }

    public static class TimestampLtzApproxCountDistinctAggFunctionTest
    extends ApproxCountDistinctAggFunctionTestBase<TimestampData> {
        @Override
        protected List<List<TimestampData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(TimestampData.fromEpochMillis((long)0L), TimestampData.fromEpochMillis((long)1000L), TimestampData.fromEpochMillis((long)100L), null, TimestampData.fromEpochMillis((long)10L)), Arrays.asList(null, null, null, null, null), Arrays.asList(null, TimestampData.fromEpochMillis((long)1L), TimestampData.fromEpochMillis((long)1L)));
        }

        @Override
        protected List<Long> getExpectedResults() {
            return Arrays.asList(4L, 0L, 1L);
        }

        @Override
        protected AggregateFunction<Long, HllBuffer> getAggregator() {
            return new BatchApproxCountDistinctAggFunctions.TimestampLtzApproxCountDistinctAggFunction(new LocalZonedTimestampType(6));
        }
    }

    public static class TimestampApproxCountDistinctAggFunctionTest
    extends ApproxCountDistinctAggFunctionTestBase<TimestampData> {
        @Override
        protected List<List<TimestampData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(TimestampData.fromEpochMillis((long)0L), TimestampData.fromEpochMillis((long)1000L), TimestampData.fromEpochMillis((long)100L), null, TimestampData.fromEpochMillis((long)10L)), Arrays.asList(null, null, null, null, null), Arrays.asList(null, TimestampData.fromEpochMillis((long)1L), TimestampData.fromEpochMillis((long)1L)));
        }

        @Override
        protected List<Long> getExpectedResults() {
            return Arrays.asList(4L, 0L, 1L);
        }

        @Override
        protected AggregateFunction<Long, HllBuffer> getAggregator() {
            return new BatchApproxCountDistinctAggFunctions.TimestampApproxCountDistinctAggFunction(new TimestampType(3));
        }
    }

    public static class TimeApproxCountDistinctAggFunctionTest
    extends NumberApproxCountDistinctAggFunctionTestBase<Integer> {
        @Override
        protected AggregateFunction<Long, HllBuffer> getAggregator() {
            return new BatchApproxCountDistinctAggFunctions.TimeApproxCountDistinctAggFunction();
        }

        @Override
        protected Integer getValue(String v) {
            return Integer.valueOf(v);
        }
    }

    public static class DateApproxCountDistinctAggFunctionTest
    extends NumberApproxCountDistinctAggFunctionTestBase<Integer> {
        @Override
        protected AggregateFunction<Long, HllBuffer> getAggregator() {
            return new BatchApproxCountDistinctAggFunctions.DateApproxCountDistinctAggFunction();
        }

        @Override
        protected Integer getValue(String v) {
            return Integer.valueOf(v);
        }
    }

    public static abstract class Decimal12ApproxCountDistinctAggFunctionTest
    extends DecimalApproxCountDistinctAggFunctionTestBase {
        public Decimal12ApproxCountDistinctAggFunctionTest() {
            super(12, 6);
        }
    }

    public static abstract class Decimal20ApproxCountDistinctAggFunctionTest
    extends DecimalApproxCountDistinctAggFunctionTestBase {
        public Decimal20ApproxCountDistinctAggFunctionTest() {
            super(20, 6);
        }
    }

    public static abstract class DecimalApproxCountDistinctAggFunctionTestBase
    extends ApproxCountDistinctAggFunctionTestBase<DecimalData> {
        private final int precision;
        private final int scale;

        public DecimalApproxCountDistinctAggFunctionTestBase(int precision, int scale) {
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        protected List<List<DecimalData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(DecimalDataUtils.castFrom((String)"1", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"1000.000001", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"-1", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"-999.998999", (int)this.precision, (int)this.scale), null, DecimalDataUtils.castFrom((String)"0", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"-999.999", (int)this.precision, (int)this.scale), null, DecimalDataUtils.castFrom((String)"999.999", (int)this.precision, (int)this.scale)), Arrays.asList(null, null, null, null, null), Arrays.asList(null, DecimalDataUtils.castFrom((String)"0", (int)this.precision, (int)this.scale)));
        }

        @Override
        protected List<Long> getExpectedResults() {
            return Arrays.asList(7L, 0L, 1L);
        }

        @Override
        protected AggregateFunction<Long, HllBuffer> getAggregator() {
            return new BatchApproxCountDistinctAggFunctions.DecimalApproxCountDistinctAggFunction(new DecimalType(this.precision, this.scale));
        }
    }

    public static class DoubleApproxCountDistinctAggFunctionTest
    extends ApproxCountDistinctAggFunctionTestBase<Double> {
        @Override
        protected List<List<Double>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(1.0, 1.0, 1.0), Arrays.asList(1.0, 2.0, 3.0), Arrays.asList(0.0, -0.0), Arrays.asList(Double.NaN, 1.1, 2.2), Arrays.asList(null, null, null, null, null, null), Arrays.asList(null, 10.0));
        }

        @Override
        protected List<Long> getExpectedResults() {
            return Arrays.asList(1L, 3L, 1L, 3L, 0L, 1L);
        }

        @Override
        protected AggregateFunction<Long, HllBuffer> getAggregator() {
            return new BatchApproxCountDistinctAggFunctions.DoubleApproxCountDistinctAggFunction();
        }
    }

    public static class FloatApproxCountDistinctAggFunctionTest
    extends ApproxCountDistinctAggFunctionTestBase<Float> {
        @Override
        protected List<List<Float>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)), Arrays.asList(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)), Arrays.asList(Float.valueOf(0.0f), Float.valueOf(-0.0f)), Arrays.asList(Float.valueOf(Float.NaN), Float.valueOf(1.1f), Float.valueOf(2.2f)), Arrays.asList(null, null, null, null, null, null), Arrays.asList(null, Float.valueOf(10.0f)));
        }

        @Override
        protected List<Long> getExpectedResults() {
            return Arrays.asList(1L, 3L, 1L, 3L, 0L, 1L);
        }

        @Override
        protected AggregateFunction<Long, HllBuffer> getAggregator() {
            return new BatchApproxCountDistinctAggFunctions.FloatApproxCountDistinctAggFunction();
        }
    }

    public static class LongApproxCountDistinctAggFunctionTest
    extends NumberApproxCountDistinctAggFunctionTestBase<Long> {
        @Override
        protected AggregateFunction<Long, HllBuffer> getAggregator() {
            return new BatchApproxCountDistinctAggFunctions.LongApproxCountDistinctAggFunction();
        }

        @Override
        protected Long getValue(String v) {
            return Long.valueOf(v);
        }
    }

    public static class IntegerApproxCountDistinctAggFunctionTest
    extends NumberApproxCountDistinctAggFunctionTestBase<Integer> {
        @Override
        protected AggregateFunction<Long, HllBuffer> getAggregator() {
            return new BatchApproxCountDistinctAggFunctions.IntApproxCountDistinctAggFunction();
        }

        @Override
        protected Integer getValue(String v) {
            return Integer.valueOf(v);
        }
    }

    public static class ShortApproxCountDistinctAggFunctionTest
    extends NumberApproxCountDistinctAggFunctionTestBase<Short> {
        @Override
        protected AggregateFunction<Long, HllBuffer> getAggregator() {
            return new BatchApproxCountDistinctAggFunctions.ShortApproxCountDistinctAggFunction();
        }

        @Override
        protected Short getValue(String v) {
            return Short.valueOf(v);
        }
    }

    public static class ByteApproxCountDistinctAggFunctionTest
    extends NumberApproxCountDistinctAggFunctionTestBase<Byte> {
        @Override
        protected AggregateFunction<Long, HllBuffer> getAggregator() {
            return new BatchApproxCountDistinctAggFunctions.ByteApproxCountDistinctAggFunction();
        }

        @Override
        protected Byte getValue(String v) {
            return Byte.valueOf(v);
        }
    }

    public static abstract class ApproxCountDistinctAggFunctionTestBase<IN>
    extends AggFunctionTestBase<IN, Long, HllBuffer> {
        @Override
        protected Class<?> getAccClass() {
            return HllBuffer.class;
        }
    }
}

